/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evidently.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.evidently.model.EvidentlyResponse;
import software.amazon.awssdk.services.evidently.model.PutProjectEventsResultEntry;
import software.amazon.awssdk.services.evidently.model.PutProjectEventsResultEntryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutProjectEventsResponse
extends EvidentlyResponse
implements ToCopyableBuilder<Builder, PutProjectEventsResponse> {
    private static final SdkField<List<PutProjectEventsResultEntry>> EVENT_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("eventResults").getter(PutProjectEventsResponse.getter(PutProjectEventsResponse::eventResults)).setter(PutProjectEventsResponse.setter(Builder::eventResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventResults").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PutProjectEventsResultEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> FAILED_EVENT_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("failedEventCount").getter(PutProjectEventsResponse.getter(PutProjectEventsResponse::failedEventCount)).setter(PutProjectEventsResponse.setter(Builder::failedEventCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedEventCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_RESULTS_FIELD, FAILED_EVENT_COUNT_FIELD));
    private final List<PutProjectEventsResultEntry> eventResults;
    private final Integer failedEventCount;

    private PutProjectEventsResponse(BuilderImpl builder) {
        super(builder);
        this.eventResults = builder.eventResults;
        this.failedEventCount = builder.failedEventCount;
    }

    public final boolean hasEventResults() {
        return this.eventResults != null && !(this.eventResults instanceof SdkAutoConstructList);
    }

    public final List<PutProjectEventsResultEntry> eventResults() {
        return this.eventResults;
    }

    public final Integer failedEventCount() {
        return this.failedEventCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventResults() ? this.eventResults() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.failedEventCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutProjectEventsResponse)) {
            return false;
        }
        PutProjectEventsResponse other = (PutProjectEventsResponse)((Object)obj);
        return this.hasEventResults() == other.hasEventResults() && Objects.equals(this.eventResults(), other.eventResults()) && Objects.equals(this.failedEventCount(), other.failedEventCount());
    }

    public final String toString() {
        return ToString.builder((String)"PutProjectEventsResponse").add("EventResults", this.hasEventResults() ? this.eventResults() : null).add("FailedEventCount", (Object)this.failedEventCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eventResults": {
                return Optional.ofNullable(clazz.cast(this.eventResults()));
            }
            case "failedEventCount": {
                return Optional.ofNullable(clazz.cast(this.failedEventCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutProjectEventsResponse, T> g) {
        return obj -> g.apply((PutProjectEventsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EvidentlyResponse.BuilderImpl
    implements Builder {
        private List<PutProjectEventsResultEntry> eventResults = DefaultSdkAutoConstructList.getInstance();
        private Integer failedEventCount;

        private BuilderImpl() {
        }

        private BuilderImpl(PutProjectEventsResponse model) {
            super(model);
            this.eventResults(model.eventResults);
            this.failedEventCount(model.failedEventCount);
        }

        public final List<PutProjectEventsResultEntry.Builder> getEventResults() {
            List<PutProjectEventsResultEntry.Builder> result = PutProjectEventsResultEntryListCopier.copyToBuilder(this.eventResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEventResults(Collection<PutProjectEventsResultEntry.BuilderImpl> eventResults) {
            this.eventResults = PutProjectEventsResultEntryListCopier.copyFromBuilder(eventResults);
        }

        @Override
        public final Builder eventResults(Collection<PutProjectEventsResultEntry> eventResults) {
            this.eventResults = PutProjectEventsResultEntryListCopier.copy(eventResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventResults(PutProjectEventsResultEntry ... eventResults) {
            this.eventResults(Arrays.asList(eventResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventResults(Consumer<PutProjectEventsResultEntry.Builder> ... eventResults) {
            this.eventResults(Stream.of(eventResults).map(c -> (PutProjectEventsResultEntry)((PutProjectEventsResultEntry.Builder)PutProjectEventsResultEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getFailedEventCount() {
            return this.failedEventCount;
        }

        public final void setFailedEventCount(Integer failedEventCount) {
            this.failedEventCount = failedEventCount;
        }

        @Override
        public final Builder failedEventCount(Integer failedEventCount) {
            this.failedEventCount = failedEventCount;
            return this;
        }

        @Override
        public PutProjectEventsResponse build() {
            return new PutProjectEventsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EvidentlyResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutProjectEventsResponse> {
        public Builder eventResults(Collection<PutProjectEventsResultEntry> var1);

        public Builder eventResults(PutProjectEventsResultEntry ... var1);

        public Builder eventResults(Consumer<PutProjectEventsResultEntry.Builder> ... var1);

        public Builder failedEventCount(Integer var1);
    }
}

