/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.evidently.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This is a structure that defines the configuration of how your application integrates with AppConfig to run
 * client-side evaluation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProjectAppConfigResource implements SdkPojo, Serializable,
        ToCopyableBuilder<ProjectAppConfigResource.Builder, ProjectAppConfigResource> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationId").getter(getter(ProjectAppConfigResource::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationId").build()).build();

    private static final SdkField<String> CONFIGURATION_PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("configurationProfileId").getter(getter(ProjectAppConfigResource::configurationProfileId))
            .setter(setter(Builder::configurationProfileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationProfileId").build())
            .build();

    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentId").getter(getter(ProjectAppConfigResource::environmentId))
            .setter(setter(Builder::environmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            CONFIGURATION_PROFILE_ID_FIELD, ENVIRONMENT_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String applicationId;

    private final String configurationProfileId;

    private final String environmentId;

    private ProjectAppConfigResource(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.configurationProfileId = builder.configurationProfileId;
        this.environmentId = builder.environmentId;
    }

    /**
     * <p>
     * The ID of the AppConfig application to use for client-side evaluation.
     * </p>
     * 
     * @return The ID of the AppConfig application to use for client-side evaluation.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The ID of the AppConfig profile to use for client-side evaluation.
     * </p>
     * 
     * @return The ID of the AppConfig profile to use for client-side evaluation.
     */
    public final String configurationProfileId() {
        return configurationProfileId;
    }

    /**
     * <p>
     * The ID of the AppConfig environment to use for client-side evaluation. This must be an environment that is within
     * the application that you specify for <code>applicationId</code>.
     * </p>
     * 
     * @return The ID of the AppConfig environment to use for client-side evaluation. This must be an environment that
     *         is within the application that you specify for <code>applicationId</code>.
     */
    public final String environmentId() {
        return environmentId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(configurationProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(environmentId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProjectAppConfigResource)) {
            return false;
        }
        ProjectAppConfigResource other = (ProjectAppConfigResource) obj;
        return Objects.equals(applicationId(), other.applicationId())
                && Objects.equals(configurationProfileId(), other.configurationProfileId())
                && Objects.equals(environmentId(), other.environmentId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProjectAppConfigResource").add("ApplicationId", applicationId())
                .add("ConfigurationProfileId", configurationProfileId()).add("EnvironmentId", environmentId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "configurationProfileId":
            return Optional.ofNullable(clazz.cast(configurationProfileId()));
        case "environmentId":
            return Optional.ofNullable(clazz.cast(environmentId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProjectAppConfigResource, T> g) {
        return obj -> g.apply((ProjectAppConfigResource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProjectAppConfigResource> {
        /**
         * <p>
         * The ID of the AppConfig application to use for client-side evaluation.
         * </p>
         * 
         * @param applicationId
         *        The ID of the AppConfig application to use for client-side evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The ID of the AppConfig profile to use for client-side evaluation.
         * </p>
         * 
         * @param configurationProfileId
         *        The ID of the AppConfig profile to use for client-side evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationProfileId(String configurationProfileId);

        /**
         * <p>
         * The ID of the AppConfig environment to use for client-side evaluation. This must be an environment that is
         * within the application that you specify for <code>applicationId</code>.
         * </p>
         * 
         * @param environmentId
         *        The ID of the AppConfig environment to use for client-side evaluation. This must be an environment
         *        that is within the application that you specify for <code>applicationId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentId(String environmentId);
    }

    static final class BuilderImpl implements Builder {
        private String applicationId;

        private String configurationProfileId;

        private String environmentId;

        private BuilderImpl() {
        }

        private BuilderImpl(ProjectAppConfigResource model) {
            applicationId(model.applicationId);
            configurationProfileId(model.configurationProfileId);
            environmentId(model.environmentId);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getConfigurationProfileId() {
            return configurationProfileId;
        }

        public final void setConfigurationProfileId(String configurationProfileId) {
            this.configurationProfileId = configurationProfileId;
        }

        @Override
        public final Builder configurationProfileId(String configurationProfileId) {
            this.configurationProfileId = configurationProfileId;
            return this;
        }

        public final String getEnvironmentId() {
            return environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        @Override
        public ProjectAppConfigResource build() {
            return new ProjectAppConfigResource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
