/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.evidently.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.JsonValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This structure contains information about one audience <i>segment</i>. You can use segments in your experiments and
 * launches to narrow the user sessions used for experiment or launch to only the user sessions that match one or more
 * criteria.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Segment implements SdkPojo, Serializable, ToCopyableBuilder<Segment.Builder, Segment> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(Segment::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdTime").getter(getter(Segment::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTime").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(Segment::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Long> EXPERIMENT_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("experimentCount").getter(getter(Segment::experimentCount)).setter(setter(Builder::experimentCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("experimentCount").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedTime").getter(getter(Segment::lastUpdatedTime)).setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTime").build()).build();

    private static final SdkField<Long> LAUNCH_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("launchCount").getter(getter(Segment::launchCount)).setter(setter(Builder::launchCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchCount").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(Segment::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> PATTERN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("pattern")
            .getter(getter(Segment::pattern))
            .setter(setter(Builder::pattern))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pattern").build(),
                    JsonValueTrait.create()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(Segment::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATED_TIME_FIELD,
            DESCRIPTION_FIELD, EXPERIMENT_COUNT_FIELD, LAST_UPDATED_TIME_FIELD, LAUNCH_COUNT_FIELD, NAME_FIELD, PATTERN_FIELD,
            TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final Instant createdTime;

    private final String description;

    private final Long experimentCount;

    private final Instant lastUpdatedTime;

    private final Long launchCount;

    private final String name;

    private final String pattern;

    private final Map<String, String> tags;

    private Segment(BuilderImpl builder) {
        this.arn = builder.arn;
        this.createdTime = builder.createdTime;
        this.description = builder.description;
        this.experimentCount = builder.experimentCount;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.launchCount = builder.launchCount;
        this.name = builder.name;
        this.pattern = builder.pattern;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ARN of the segment.
     * </p>
     * 
     * @return The ARN of the segment.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The date and time that this segment was created.
     * </p>
     * 
     * @return The date and time that this segment was created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The customer-created description for this segment.
     * </p>
     * 
     * @return The customer-created description for this segment.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The number of experiments that this segment is used in. This count includes all current experiments, not just
     * those that are currently running.
     * </p>
     * 
     * @return The number of experiments that this segment is used in. This count includes all current experiments, not
     *         just those that are currently running.
     */
    public final Long experimentCount() {
        return experimentCount;
    }

    /**
     * <p>
     * The date and time that this segment was most recently updated.
     * </p>
     * 
     * @return The date and time that this segment was most recently updated.
     */
    public final Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * <p>
     * The number of launches that this segment is used in. This count includes all current launches, not just those
     * that are currently running.
     * </p>
     * 
     * @return The number of launches that this segment is used in. This count includes all current launches, not just
     *         those that are currently running.
     */
    public final Long launchCount() {
        return launchCount;
    }

    /**
     * <p>
     * The name of the segment.
     * </p>
     * 
     * @return The name of the segment.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The pattern that defines the attributes to use to evalute whether a user session will be in the segment. For more
     * information about the pattern syntax, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Evidently-segments.html">Segment
     * rule pattern syntax</a>.
     * </p>
     * 
     * @return The pattern that defines the attributes to use to evalute whether a user session will be in the segment.
     *         For more information about the pattern syntax, see <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Evidently-segments.html"
     *         >Segment rule pattern syntax</a>.
     */
    public final String pattern() {
        return pattern;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The list of tag keys and values associated with this launch.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The list of tag keys and values associated with this launch.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(experimentCount());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(launchCount());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(pattern());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Segment)) {
            return false;
        }
        Segment other = (Segment) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(description(), other.description())
                && Objects.equals(experimentCount(), other.experimentCount())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime())
                && Objects.equals(launchCount(), other.launchCount()) && Objects.equals(name(), other.name())
                && Objects.equals(pattern(), other.pattern()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Segment").add("Arn", arn()).add("CreatedTime", createdTime()).add("Description", description())
                .add("ExperimentCount", experimentCount()).add("LastUpdatedTime", lastUpdatedTime())
                .add("LaunchCount", launchCount()).add("Name", name()).add("Pattern", pattern())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "createdTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "experimentCount":
            return Optional.ofNullable(clazz.cast(experimentCount()));
        case "lastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "launchCount":
            return Optional.ofNullable(clazz.cast(launchCount()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "pattern":
            return Optional.ofNullable(clazz.cast(pattern()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Segment, T> g) {
        return obj -> g.apply((Segment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Segment> {
        /**
         * <p>
         * The ARN of the segment.
         * </p>
         * 
         * @param arn
         *        The ARN of the segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The date and time that this segment was created.
         * </p>
         * 
         * @param createdTime
         *        The date and time that this segment was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The customer-created description for this segment.
         * </p>
         * 
         * @param description
         *        The customer-created description for this segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The number of experiments that this segment is used in. This count includes all current experiments, not just
         * those that are currently running.
         * </p>
         * 
         * @param experimentCount
         *        The number of experiments that this segment is used in. This count includes all current experiments,
         *        not just those that are currently running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder experimentCount(Long experimentCount);

        /**
         * <p>
         * The date and time that this segment was most recently updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The date and time that this segment was most recently updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);

        /**
         * <p>
         * The number of launches that this segment is used in. This count includes all current launches, not just those
         * that are currently running.
         * </p>
         * 
         * @param launchCount
         *        The number of launches that this segment is used in. This count includes all current launches, not
         *        just those that are currently running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchCount(Long launchCount);

        /**
         * <p>
         * The name of the segment.
         * </p>
         * 
         * @param name
         *        The name of the segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The pattern that defines the attributes to use to evalute whether a user session will be in the segment. For
         * more information about the pattern syntax, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Evidently-segments.html"
         * >Segment rule pattern syntax</a>.
         * </p>
         * 
         * @param pattern
         *        The pattern that defines the attributes to use to evalute whether a user session will be in the
         *        segment. For more information about the pattern syntax, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Evidently-segments.html"
         *        >Segment rule pattern syntax</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pattern(String pattern);

        /**
         * <p>
         * The list of tag keys and values associated with this launch.
         * </p>
         * 
         * @param tags
         *        The list of tag keys and values associated with this launch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private Instant createdTime;

        private String description;

        private Long experimentCount;

        private Instant lastUpdatedTime;

        private Long launchCount;

        private String name;

        private String pattern;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Segment model) {
            arn(model.arn);
            createdTime(model.createdTime);
            description(model.description);
            experimentCount(model.experimentCount);
            lastUpdatedTime(model.lastUpdatedTime);
            launchCount(model.launchCount);
            name(model.name);
            pattern(model.pattern);
            tags(model.tags);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Long getExperimentCount() {
            return experimentCount;
        }

        public final void setExperimentCount(Long experimentCount) {
            this.experimentCount = experimentCount;
        }

        @Override
        public final Builder experimentCount(Long experimentCount) {
            this.experimentCount = experimentCount;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final Long getLaunchCount() {
            return launchCount;
        }

        public final void setLaunchCount(Long launchCount) {
            this.launchCount = launchCount;
        }

        @Override
        public final Builder launchCount(Long launchCount) {
            this.launchCount = launchCount;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPattern() {
            return pattern;
        }

        public final void setPattern(String pattern) {
            this.pattern = pattern;
        }

        @Override
        public final Builder pattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Segment build() {
            return new Segment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
