/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.evidently.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains the configuration of which variation to use as the "control" version. The "control" version
 * is used for comparison with other variations. This structure also specifies how much experiment traffic is allocated
 * to each variation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OnlineAbDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<OnlineAbDefinition.Builder, OnlineAbDefinition> {
    private static final SdkField<String> CONTROL_TREATMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("controlTreatmentName").getter(getter(OnlineAbDefinition::controlTreatmentName))
            .setter(setter(Builder::controlTreatmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controlTreatmentName").build())
            .build();

    private static final SdkField<Map<String, Long>> TREATMENT_WEIGHTS_FIELD = SdkField
            .<Map<String, Long>> builder(MarshallingType.MAP)
            .memberName("treatmentWeights")
            .getter(getter(OnlineAbDefinition::treatmentWeights))
            .setter(setter(Builder::treatmentWeights))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("treatmentWeights").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Long> builder(MarshallingType.LONG)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTROL_TREATMENT_NAME_FIELD,
            TREATMENT_WEIGHTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String controlTreatmentName;

    private final Map<String, Long> treatmentWeights;

    private OnlineAbDefinition(BuilderImpl builder) {
        this.controlTreatmentName = builder.controlTreatmentName;
        this.treatmentWeights = builder.treatmentWeights;
    }

    /**
     * <p>
     * The name of the variation that is the default variation that the other variations are compared to.
     * </p>
     * 
     * @return The name of the variation that is the default variation that the other variations are compared to.
     */
    public final String controlTreatmentName() {
        return controlTreatmentName;
    }

    /**
     * For responses, this returns true if the service returned a value for the TreatmentWeights property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTreatmentWeights() {
        return treatmentWeights != null && !(treatmentWeights instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A set of key-value pairs. The keys are variation names, and the values are the portion of experiment traffic to
     * be assigned to that variation. The traffic portion is specified in thousandths of a percent, so 20,000 for a
     * variation would allocate 20% of the experiment traffic to that variation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTreatmentWeights} method.
     * </p>
     * 
     * @return A set of key-value pairs. The keys are variation names, and the values are the portion of experiment
     *         traffic to be assigned to that variation. The traffic portion is specified in thousandths of a percent,
     *         so 20,000 for a variation would allocate 20% of the experiment traffic to that variation.
     */
    public final Map<String, Long> treatmentWeights() {
        return treatmentWeights;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(controlTreatmentName());
        hashCode = 31 * hashCode + Objects.hashCode(hasTreatmentWeights() ? treatmentWeights() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OnlineAbDefinition)) {
            return false;
        }
        OnlineAbDefinition other = (OnlineAbDefinition) obj;
        return Objects.equals(controlTreatmentName(), other.controlTreatmentName())
                && hasTreatmentWeights() == other.hasTreatmentWeights()
                && Objects.equals(treatmentWeights(), other.treatmentWeights());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OnlineAbDefinition").add("ControlTreatmentName", controlTreatmentName())
                .add("TreatmentWeights", hasTreatmentWeights() ? treatmentWeights() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "controlTreatmentName":
            return Optional.ofNullable(clazz.cast(controlTreatmentName()));
        case "treatmentWeights":
            return Optional.ofNullable(clazz.cast(treatmentWeights()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OnlineAbDefinition, T> g) {
        return obj -> g.apply((OnlineAbDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OnlineAbDefinition> {
        /**
         * <p>
         * The name of the variation that is the default variation that the other variations are compared to.
         * </p>
         * 
         * @param controlTreatmentName
         *        The name of the variation that is the default variation that the other variations are compared to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlTreatmentName(String controlTreatmentName);

        /**
         * <p>
         * A set of key-value pairs. The keys are variation names, and the values are the portion of experiment traffic
         * to be assigned to that variation. The traffic portion is specified in thousandths of a percent, so 20,000 for
         * a variation would allocate 20% of the experiment traffic to that variation.
         * </p>
         * 
         * @param treatmentWeights
         *        A set of key-value pairs. The keys are variation names, and the values are the portion of experiment
         *        traffic to be assigned to that variation. The traffic portion is specified in thousandths of a
         *        percent, so 20,000 for a variation would allocate 20% of the experiment traffic to that variation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder treatmentWeights(Map<String, Long> treatmentWeights);
    }

    static final class BuilderImpl implements Builder {
        private String controlTreatmentName;

        private Map<String, Long> treatmentWeights = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OnlineAbDefinition model) {
            controlTreatmentName(model.controlTreatmentName);
            treatmentWeights(model.treatmentWeights);
        }

        public final String getControlTreatmentName() {
            return controlTreatmentName;
        }

        public final void setControlTreatmentName(String controlTreatmentName) {
            this.controlTreatmentName = controlTreatmentName;
        }

        @Override
        public final Builder controlTreatmentName(String controlTreatmentName) {
            this.controlTreatmentName = controlTreatmentName;
            return this;
        }

        public final Map<String, Long> getTreatmentWeights() {
            if (treatmentWeights instanceof SdkAutoConstructMap) {
                return null;
            }
            return treatmentWeights;
        }

        public final void setTreatmentWeights(Map<String, Long> treatmentWeights) {
            this.treatmentWeights = TreatmentToWeightMapCopier.copy(treatmentWeights);
        }

        @Override
        public final Builder treatmentWeights(Map<String, Long> treatmentWeights) {
            this.treatmentWeights = TreatmentToWeightMapCopier.copy(treatmentWeights);
            return this;
        }

        @Override
        public OnlineAbDefinition build() {
            return new OnlineAbDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
