/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evidently.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FeatureEvaluationStrategy {
    ALL_RULES("ALL_RULES"),
    DEFAULT_VARIATION("DEFAULT_VARIATION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FeatureEvaluationStrategy> VALUE_MAP;
    private final String value;

    private FeatureEvaluationStrategy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FeatureEvaluationStrategy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FeatureEvaluationStrategy> knownValues() {
        EnumSet<FeatureEvaluationStrategy> knownValues = EnumSet.allOf(FeatureEvaluationStrategy.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FeatureEvaluationStrategy.class, FeatureEvaluationStrategy::toString);
    }
}

