/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.evidently.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSegmentResponse extends EvidentlyResponse implements
        ToCopyableBuilder<CreateSegmentResponse.Builder, CreateSegmentResponse> {
    private static final SdkField<Segment> SEGMENT_FIELD = SdkField.<Segment> builder(MarshallingType.SDK_POJO)
            .memberName("segment").getter(getter(CreateSegmentResponse::segment)).setter(setter(Builder::segment))
            .constructor(Segment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segment").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEGMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Segment segment;

    private CreateSegmentResponse(BuilderImpl builder) {
        super(builder);
        this.segment = builder.segment;
    }

    /**
     * <p>
     * A structure that contains the complete information about the segment that was just created.
     * </p>
     * 
     * @return A structure that contains the complete information about the segment that was just created.
     */
    public final Segment segment() {
        return segment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(segment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSegmentResponse)) {
            return false;
        }
        CreateSegmentResponse other = (CreateSegmentResponse) obj;
        return Objects.equals(segment(), other.segment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSegmentResponse").add("Segment", segment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "segment":
            return Optional.ofNullable(clazz.cast(segment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("segment", SEGMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateSegmentResponse, T> g) {
        return obj -> g.apply((CreateSegmentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EvidentlyResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateSegmentResponse> {
        /**
         * <p>
         * A structure that contains the complete information about the segment that was just created.
         * </p>
         * 
         * @param segment
         *        A structure that contains the complete information about the segment that was just created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segment(Segment segment);

        /**
         * <p>
         * A structure that contains the complete information about the segment that was just created.
         * </p>
         * This is a convenience method that creates an instance of the {@link Segment.Builder} avoiding the need to
         * create one manually via {@link Segment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Segment.Builder#build()} is called immediately and its result is
         * passed to {@link #segment(Segment)}.
         * 
         * @param segment
         *        a consumer that will call methods on {@link Segment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #segment(Segment)
         */
        default Builder segment(Consumer<Segment.Builder> segment) {
            return segment(Segment.builder().applyMutation(segment).build());
        }
    }

    static final class BuilderImpl extends EvidentlyResponse.BuilderImpl implements Builder {
        private Segment segment;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSegmentResponse model) {
            super(model);
            segment(model.segment);
        }

        public final Segment.Builder getSegment() {
            return segment != null ? segment.toBuilder() : null;
        }

        public final void setSegment(Segment.BuilderImpl segment) {
            this.segment = segment != null ? segment.build() : null;
        }

        @Override
        public final Builder segment(Segment segment) {
            this.segment = segment;
            return this;
        }

        @Override
        public CreateSegmentResponse build() {
            return new CreateSegmentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
