/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.evidently.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.JsonValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains results of an experiment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExperimentReport implements SdkPojo, Serializable,
        ToCopyableBuilder<ExperimentReport.Builder, ExperimentReport> {
    private static final SdkField<String> CONTENT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("content")
            .getter(getter(ExperimentReport::content))
            .setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build(),
                    JsonValueTrait.create()).build();

    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("metricName").getter(getter(ExperimentReport::metricName)).setter(setter(Builder::metricName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricName").build()).build();

    private static final SdkField<String> REPORT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("reportName").getter(getter(ExperimentReport::reportNameAsString)).setter(setter(Builder::reportName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportName").build()).build();

    private static final SdkField<String> TREATMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("treatmentName").getter(getter(ExperimentReport::treatmentName)).setter(setter(Builder::treatmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("treatmentName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_FIELD,
            METRIC_NAME_FIELD, REPORT_NAME_FIELD, TREATMENT_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String content;

    private final String metricName;

    private final String reportName;

    private final String treatmentName;

    private ExperimentReport(BuilderImpl builder) {
        this.content = builder.content;
        this.metricName = builder.metricName;
        this.reportName = builder.reportName;
        this.treatmentName = builder.treatmentName;
    }

    /**
     * <p>
     * The content of the report.
     * </p>
     * 
     * @return The content of the report.
     */
    public final String content() {
        return content;
    }

    /**
     * <p>
     * The name of the metric that is analyzed in this experiment report.
     * </p>
     * 
     * @return The name of the metric that is analyzed in this experiment report.
     */
    public final String metricName() {
        return metricName;
    }

    /**
     * <p>
     * The type of analysis used for this report.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reportName} will
     * return {@link ExperimentReportName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #reportNameAsString}.
     * </p>
     * 
     * @return The type of analysis used for this report.
     * @see ExperimentReportName
     */
    public final ExperimentReportName reportName() {
        return ExperimentReportName.fromValue(reportName);
    }

    /**
     * <p>
     * The type of analysis used for this report.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reportName} will
     * return {@link ExperimentReportName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #reportNameAsString}.
     * </p>
     * 
     * @return The type of analysis used for this report.
     * @see ExperimentReportName
     */
    public final String reportNameAsString() {
        return reportName;
    }

    /**
     * <p>
     * The name of the variation that this report pertains to.
     * </p>
     * 
     * @return The name of the variation that this report pertains to.
     */
    public final String treatmentName() {
        return treatmentName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(metricName());
        hashCode = 31 * hashCode + Objects.hashCode(reportNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(treatmentName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExperimentReport)) {
            return false;
        }
        ExperimentReport other = (ExperimentReport) obj;
        return Objects.equals(content(), other.content()) && Objects.equals(metricName(), other.metricName())
                && Objects.equals(reportNameAsString(), other.reportNameAsString())
                && Objects.equals(treatmentName(), other.treatmentName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExperimentReport").add("Content", content()).add("MetricName", metricName())
                .add("ReportName", reportNameAsString()).add("TreatmentName", treatmentName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "content":
            return Optional.ofNullable(clazz.cast(content()));
        case "metricName":
            return Optional.ofNullable(clazz.cast(metricName()));
        case "reportName":
            return Optional.ofNullable(clazz.cast(reportNameAsString()));
        case "treatmentName":
            return Optional.ofNullable(clazz.cast(treatmentName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("content", CONTENT_FIELD);
        map.put("metricName", METRIC_NAME_FIELD);
        map.put("reportName", REPORT_NAME_FIELD);
        map.put("treatmentName", TREATMENT_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExperimentReport, T> g) {
        return obj -> g.apply((ExperimentReport) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExperimentReport> {
        /**
         * <p>
         * The content of the report.
         * </p>
         * 
         * @param content
         *        The content of the report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(String content);

        /**
         * <p>
         * The name of the metric that is analyzed in this experiment report.
         * </p>
         * 
         * @param metricName
         *        The name of the metric that is analyzed in this experiment report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricName(String metricName);

        /**
         * <p>
         * The type of analysis used for this report.
         * </p>
         * 
         * @param reportName
         *        The type of analysis used for this report.
         * @see ExperimentReportName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExperimentReportName
         */
        Builder reportName(String reportName);

        /**
         * <p>
         * The type of analysis used for this report.
         * </p>
         * 
         * @param reportName
         *        The type of analysis used for this report.
         * @see ExperimentReportName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExperimentReportName
         */
        Builder reportName(ExperimentReportName reportName);

        /**
         * <p>
         * The name of the variation that this report pertains to.
         * </p>
         * 
         * @param treatmentName
         *        The name of the variation that this report pertains to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder treatmentName(String treatmentName);
    }

    static final class BuilderImpl implements Builder {
        private String content;

        private String metricName;

        private String reportName;

        private String treatmentName;

        private BuilderImpl() {
        }

        private BuilderImpl(ExperimentReport model) {
            content(model.content);
            metricName(model.metricName);
            reportName(model.reportName);
            treatmentName(model.treatmentName);
        }

        public final String getContent() {
            return content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final String getMetricName() {
            return metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final String getReportName() {
            return reportName;
        }

        public final void setReportName(String reportName) {
            this.reportName = reportName;
        }

        @Override
        public final Builder reportName(String reportName) {
            this.reportName = reportName;
            return this;
        }

        @Override
        public final Builder reportName(ExperimentReportName reportName) {
            this.reportName(reportName == null ? null : reportName.toString());
            return this;
        }

        public final String getTreatmentName() {
            return treatmentName;
        }

        public final void setTreatmentName(String treatmentName) {
            this.treatmentName = treatmentName;
        }

        @Override
        public final Builder treatmentName(String treatmentName) {
            this.treatmentName = treatmentName;
            return this;
        }

        @Override
        public ExperimentReport build() {
            return new ExperimentReport(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
