/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.evidently.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains experiment results for one metric that is monitored in the experiment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExperimentResultsData implements SdkPojo, Serializable,
        ToCopyableBuilder<ExperimentResultsData.Builder, ExperimentResultsData> {
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("metricName").getter(getter(ExperimentResultsData::metricName)).setter(setter(Builder::metricName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricName").build()).build();

    private static final SdkField<String> RESULT_STAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resultStat").getter(getter(ExperimentResultsData::resultStatAsString))
            .setter(setter(Builder::resultStat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resultStat").build()).build();

    private static final SdkField<String> TREATMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("treatmentName").getter(getter(ExperimentResultsData::treatmentName))
            .setter(setter(Builder::treatmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("treatmentName").build()).build();

    private static final SdkField<List<Double>> VALUES_FIELD = SdkField
            .<List<Double>> builder(MarshallingType.LIST)
            .memberName("values")
            .getter(getter(ExperimentResultsData::values))
            .setter(setter(Builder::values))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("values").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Double> builder(MarshallingType.DOUBLE)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_NAME_FIELD,
            RESULT_STAT_FIELD, TREATMENT_NAME_FIELD, VALUES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String metricName;

    private final String resultStat;

    private final String treatmentName;

    private final List<Double> values;

    private ExperimentResultsData(BuilderImpl builder) {
        this.metricName = builder.metricName;
        this.resultStat = builder.resultStat;
        this.treatmentName = builder.treatmentName;
        this.values = builder.values;
    }

    /**
     * <p>
     * The name of the metric.
     * </p>
     * 
     * @return The name of the metric.
     */
    public final String metricName() {
        return metricName;
    }

    /**
     * <p>
     * The experiment statistic that these results pertain to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resultStat} will
     * return {@link ExperimentResultResponseType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #resultStatAsString}.
     * </p>
     * 
     * @return The experiment statistic that these results pertain to.
     * @see ExperimentResultResponseType
     */
    public final ExperimentResultResponseType resultStat() {
        return ExperimentResultResponseType.fromValue(resultStat);
    }

    /**
     * <p>
     * The experiment statistic that these results pertain to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resultStat} will
     * return {@link ExperimentResultResponseType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #resultStatAsString}.
     * </p>
     * 
     * @return The experiment statistic that these results pertain to.
     * @see ExperimentResultResponseType
     */
    public final String resultStatAsString() {
        return resultStat;
    }

    /**
     * <p>
     * The treatment, or variation, that returned the <code>values</code> in this structure.
     * </p>
     * 
     * @return The treatment, or variation, that returned the <code>values</code> in this structure.
     */
    public final String treatmentName() {
        return treatmentName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Values property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasValues() {
        return values != null && !(values instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The values for the <code>metricName</code> that were recorded in the experiment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValues} method.
     * </p>
     * 
     * @return The values for the <code>metricName</code> that were recorded in the experiment.
     */
    public final List<Double> values() {
        return values;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(metricName());
        hashCode = 31 * hashCode + Objects.hashCode(resultStatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(treatmentName());
        hashCode = 31 * hashCode + Objects.hashCode(hasValues() ? values() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExperimentResultsData)) {
            return false;
        }
        ExperimentResultsData other = (ExperimentResultsData) obj;
        return Objects.equals(metricName(), other.metricName())
                && Objects.equals(resultStatAsString(), other.resultStatAsString())
                && Objects.equals(treatmentName(), other.treatmentName()) && hasValues() == other.hasValues()
                && Objects.equals(values(), other.values());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExperimentResultsData").add("MetricName", metricName()).add("ResultStat", resultStatAsString())
                .add("TreatmentName", treatmentName()).add("Values", hasValues() ? values() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "metricName":
            return Optional.ofNullable(clazz.cast(metricName()));
        case "resultStat":
            return Optional.ofNullable(clazz.cast(resultStatAsString()));
        case "treatmentName":
            return Optional.ofNullable(clazz.cast(treatmentName()));
        case "values":
            return Optional.ofNullable(clazz.cast(values()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("metricName", METRIC_NAME_FIELD);
        map.put("resultStat", RESULT_STAT_FIELD);
        map.put("treatmentName", TREATMENT_NAME_FIELD);
        map.put("values", VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExperimentResultsData, T> g) {
        return obj -> g.apply((ExperimentResultsData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExperimentResultsData> {
        /**
         * <p>
         * The name of the metric.
         * </p>
         * 
         * @param metricName
         *        The name of the metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricName(String metricName);

        /**
         * <p>
         * The experiment statistic that these results pertain to.
         * </p>
         * 
         * @param resultStat
         *        The experiment statistic that these results pertain to.
         * @see ExperimentResultResponseType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExperimentResultResponseType
         */
        Builder resultStat(String resultStat);

        /**
         * <p>
         * The experiment statistic that these results pertain to.
         * </p>
         * 
         * @param resultStat
         *        The experiment statistic that these results pertain to.
         * @see ExperimentResultResponseType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExperimentResultResponseType
         */
        Builder resultStat(ExperimentResultResponseType resultStat);

        /**
         * <p>
         * The treatment, or variation, that returned the <code>values</code> in this structure.
         * </p>
         * 
         * @param treatmentName
         *        The treatment, or variation, that returned the <code>values</code> in this structure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder treatmentName(String treatmentName);

        /**
         * <p>
         * The values for the <code>metricName</code> that were recorded in the experiment.
         * </p>
         * 
         * @param values
         *        The values for the <code>metricName</code> that were recorded in the experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<Double> values);

        /**
         * <p>
         * The values for the <code>metricName</code> that were recorded in the experiment.
         * </p>
         * 
         * @param values
         *        The values for the <code>metricName</code> that were recorded in the experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Double... values);
    }

    static final class BuilderImpl implements Builder {
        private String metricName;

        private String resultStat;

        private String treatmentName;

        private List<Double> values = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ExperimentResultsData model) {
            metricName(model.metricName);
            resultStat(model.resultStat);
            treatmentName(model.treatmentName);
            values(model.values);
        }

        public final String getMetricName() {
            return metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final String getResultStat() {
            return resultStat;
        }

        public final void setResultStat(String resultStat) {
            this.resultStat = resultStat;
        }

        @Override
        public final Builder resultStat(String resultStat) {
            this.resultStat = resultStat;
            return this;
        }

        @Override
        public final Builder resultStat(ExperimentResultResponseType resultStat) {
            this.resultStat(resultStat == null ? null : resultStat.toString());
            return this;
        }

        public final String getTreatmentName() {
            return treatmentName;
        }

        public final void setTreatmentName(String treatmentName) {
            this.treatmentName = treatmentName;
        }

        @Override
        public final Builder treatmentName(String treatmentName) {
            this.treatmentName = treatmentName;
            return this;
        }

        public final Collection<Double> getValues() {
            if (values instanceof SdkAutoConstructList) {
                return null;
            }
            return values;
        }

        public final void setValues(Collection<Double> values) {
            this.values = DoubleValueListCopier.copy(values);
        }

        @Override
        public final Builder values(Collection<Double> values) {
            this.values = DoubleValueListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(Double... values) {
            values(Arrays.asList(values));
            return this;
        }

        @Override
        public ExperimentResultsData build() {
            return new ExperimentResultsData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
