/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.evidently.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFeaturesResponse extends EvidentlyResponse implements
        ToCopyableBuilder<ListFeaturesResponse.Builder, ListFeaturesResponse> {
    private static final SdkField<List<FeatureSummary>> FEATURES_FIELD = SdkField
            .<List<FeatureSummary>> builder(MarshallingType.LIST)
            .memberName("features")
            .getter(getter(ListFeaturesResponse::features))
            .setter(setter(Builder::features))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("features").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FeatureSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(FeatureSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListFeaturesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FEATURES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<FeatureSummary> features;

    private final String nextToken;

    private ListFeaturesResponse(BuilderImpl builder) {
        super(builder);
        this.features = builder.features;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Features property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFeatures() {
        return features != null && !(features instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of structures that contain the configuration details of the features in the specified project.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFeatures} method.
     * </p>
     * 
     * @return An array of structures that contain the configuration details of the features in the specified project.
     */
    public final List<FeatureSummary> features() {
        return features;
    }

    /**
     * <p>
     * The token to use in a subsequent <code>ListFeatures</code> operation to return the next set of results.
     * </p>
     * 
     * @return The token to use in a subsequent <code>ListFeatures</code> operation to return the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFeatures() ? features() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFeaturesResponse)) {
            return false;
        }
        ListFeaturesResponse other = (ListFeaturesResponse) obj;
        return hasFeatures() == other.hasFeatures() && Objects.equals(features(), other.features())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListFeaturesResponse").add("Features", hasFeatures() ? features() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "features":
            return Optional.ofNullable(clazz.cast(features()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("features", FEATURES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListFeaturesResponse, T> g) {
        return obj -> g.apply((ListFeaturesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EvidentlyResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListFeaturesResponse> {
        /**
         * <p>
         * An array of structures that contain the configuration details of the features in the specified project.
         * </p>
         * 
         * @param features
         *        An array of structures that contain the configuration details of the features in the specified
         *        project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder features(Collection<FeatureSummary> features);

        /**
         * <p>
         * An array of structures that contain the configuration details of the features in the specified project.
         * </p>
         * 
         * @param features
         *        An array of structures that contain the configuration details of the features in the specified
         *        project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder features(FeatureSummary... features);

        /**
         * <p>
         * An array of structures that contain the configuration details of the features in the specified project.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.evidently.model.FeatureSummary.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.evidently.model.FeatureSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.evidently.model.FeatureSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #features(List<FeatureSummary>)}.
         * 
         * @param features
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.evidently.model.FeatureSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #features(java.util.Collection<FeatureSummary>)
         */
        Builder features(Consumer<FeatureSummary.Builder>... features);

        /**
         * <p>
         * The token to use in a subsequent <code>ListFeatures</code> operation to return the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token to use in a subsequent <code>ListFeatures</code> operation to return the next set of
         *        results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends EvidentlyResponse.BuilderImpl implements Builder {
        private List<FeatureSummary> features = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFeaturesResponse model) {
            super(model);
            features(model.features);
            nextToken(model.nextToken);
        }

        public final List<FeatureSummary.Builder> getFeatures() {
            List<FeatureSummary.Builder> result = FeatureSummariesListCopier.copyToBuilder(this.features);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFeatures(Collection<FeatureSummary.BuilderImpl> features) {
            this.features = FeatureSummariesListCopier.copyFromBuilder(features);
        }

        @Override
        public final Builder features(Collection<FeatureSummary> features) {
            this.features = FeatureSummariesListCopier.copy(features);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder features(FeatureSummary... features) {
            features(Arrays.asList(features));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder features(Consumer<FeatureSummary.Builder>... features) {
            features(Stream.of(features).map(c -> FeatureSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListFeaturesResponse build() {
            return new ListFeaturesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
