/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.evidently.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains information about one experiment or launch that uses the specified segment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RefResource implements SdkPojo, Serializable, ToCopyableBuilder<RefResource.Builder, RefResource> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(RefResource::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> END_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("endTime").getter(getter(RefResource::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()).build();

    private static final SdkField<String> LAST_UPDATED_ON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastUpdatedOn").getter(getter(RefResource::lastUpdatedOn)).setter(setter(Builder::lastUpdatedOn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedOn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(RefResource::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> START_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("startTime").getter(getter(RefResource::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(RefResource::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(RefResource::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, END_TIME_FIELD,
            LAST_UPDATED_ON_FIELD, NAME_FIELD, START_TIME_FIELD, STATUS_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String endTime;

    private final String lastUpdatedOn;

    private final String name;

    private final String startTime;

    private final String status;

    private final String type;

    private RefResource(BuilderImpl builder) {
        this.arn = builder.arn;
        this.endTime = builder.endTime;
        this.lastUpdatedOn = builder.lastUpdatedOn;
        this.name = builder.name;
        this.startTime = builder.startTime;
        this.status = builder.status;
        this.type = builder.type;
    }

    /**
     * <p>
     * The ARN of the experiment or launch.
     * </p>
     * 
     * @return The ARN of the experiment or launch.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The day and time that this experiment or launch ended.
     * </p>
     * 
     * @return The day and time that this experiment or launch ended.
     */
    public final String endTime() {
        return endTime;
    }

    /**
     * <p>
     * The day and time that this experiment or launch was most recently updated.
     * </p>
     * 
     * @return The day and time that this experiment or launch was most recently updated.
     */
    public final String lastUpdatedOn() {
        return lastUpdatedOn;
    }

    /**
     * <p>
     * The name of the experiment or launch.
     * </p>
     * 
     * @return The name of the experiment or launch.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The day and time that this experiment or launch started.
     * </p>
     * 
     * @return The day and time that this experiment or launch started.
     */
    public final String startTime() {
        return startTime;
    }

    /**
     * <p>
     * The status of the experiment or launch.
     * </p>
     * 
     * @return The status of the experiment or launch.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * Specifies whether the resource that this structure contains information about is an experiment or a launch.
     * </p>
     * 
     * @return Specifies whether the resource that this structure contains information about is an experiment or a
     *         launch.
     */
    public final String type() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedOn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RefResource)) {
            return false;
        }
        RefResource other = (RefResource) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(lastUpdatedOn(), other.lastUpdatedOn()) && Objects.equals(name(), other.name())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(status(), other.status())
                && Objects.equals(type(), other.type());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RefResource").add("Arn", arn()).add("EndTime", endTime()).add("LastUpdatedOn", lastUpdatedOn())
                .add("Name", name()).add("StartTime", startTime()).add("Status", status()).add("Type", type()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "lastUpdatedOn":
            return Optional.ofNullable(clazz.cast(lastUpdatedOn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "type":
            return Optional.ofNullable(clazz.cast(type()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("lastUpdatedOn", LAST_UPDATED_ON_FIELD);
        map.put("name", NAME_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RefResource, T> g) {
        return obj -> g.apply((RefResource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RefResource> {
        /**
         * <p>
         * The ARN of the experiment or launch.
         * </p>
         * 
         * @param arn
         *        The ARN of the experiment or launch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The day and time that this experiment or launch ended.
         * </p>
         * 
         * @param endTime
         *        The day and time that this experiment or launch ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(String endTime);

        /**
         * <p>
         * The day and time that this experiment or launch was most recently updated.
         * </p>
         * 
         * @param lastUpdatedOn
         *        The day and time that this experiment or launch was most recently updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedOn(String lastUpdatedOn);

        /**
         * <p>
         * The name of the experiment or launch.
         * </p>
         * 
         * @param name
         *        The name of the experiment or launch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The day and time that this experiment or launch started.
         * </p>
         * 
         * @param startTime
         *        The day and time that this experiment or launch started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(String startTime);

        /**
         * <p>
         * The status of the experiment or launch.
         * </p>
         * 
         * @param status
         *        The status of the experiment or launch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * Specifies whether the resource that this structure contains information about is an experiment or a launch.
         * </p>
         * 
         * @param type
         *        Specifies whether the resource that this structure contains information about is an experiment or a
         *        launch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String endTime;

        private String lastUpdatedOn;

        private String name;

        private String startTime;

        private String status;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(RefResource model) {
            arn(model.arn);
            endTime(model.endTime);
            lastUpdatedOn(model.lastUpdatedOn);
            name(model.name);
            startTime(model.startTime);
            status(model.status);
            type(model.type);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getEndTime() {
            return endTime;
        }

        public final void setEndTime(String endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(String endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getLastUpdatedOn() {
            return lastUpdatedOn;
        }

        public final void setLastUpdatedOn(String lastUpdatedOn) {
            this.lastUpdatedOn = lastUpdatedOn;
        }

        @Override
        public final Builder lastUpdatedOn(String lastUpdatedOn) {
            this.lastUpdatedOn = lastUpdatedOn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStartTime() {
            return startTime;
        }

        public final void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public RefResource build() {
            return new RefResource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
