/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.evidently.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.JsonValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluateFeatureRequest extends EvidentlyRequest implements
        ToCopyableBuilder<EvaluateFeatureRequest.Builder, EvaluateFeatureRequest> {
    private static final SdkField<String> ENTITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entityId").getter(getter(EvaluateFeatureRequest::entityId)).setter(setter(Builder::entityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityId").build()).build();

    private static final SdkField<String> EVALUATION_CONTEXT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("evaluationContext")
            .getter(getter(EvaluateFeatureRequest::evaluationContext))
            .setter(setter(Builder::evaluationContext))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluationContext").build(),
                    JsonValueTrait.create()).build();

    private static final SdkField<String> FEATURE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("feature")
            .getter(getter(EvaluateFeatureRequest::feature)).setter(setter(Builder::feature))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("feature").build()).build();

    private static final SdkField<String> PROJECT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("project")
            .getter(getter(EvaluateFeatureRequest::project)).setter(setter(Builder::project))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("project").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_ID_FIELD,
            EVALUATION_CONTEXT_FIELD, FEATURE_FIELD, PROJECT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String entityId;

    private final String evaluationContext;

    private final String feature;

    private final String project;

    private EvaluateFeatureRequest(BuilderImpl builder) {
        super(builder);
        this.entityId = builder.entityId;
        this.evaluationContext = builder.evaluationContext;
        this.feature = builder.feature;
        this.project = builder.project;
    }

    /**
     * <p>
     * An internal ID that represents a unique user of the application. This <code>entityID</code> is checked against
     * any override rules assigned for this feature.
     * </p>
     * 
     * @return An internal ID that represents a unique user of the application. This <code>entityID</code> is checked
     *         against any override rules assigned for this feature.
     */
    public final String entityId() {
        return entityId;
    }

    /**
     * <p>
     * A JSON object of attributes that you can optionally pass in as part of the evaluation event sent to Evidently
     * from the user session. Evidently can use this value to match user sessions with defined audience segments. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Evidently-segments.html">Use
     * segments to focus your audience</a>.
     * </p>
     * <p>
     * If you include this parameter, the value must be a JSON object. A JSON array is not supported.
     * </p>
     * 
     * @return A JSON object of attributes that you can optionally pass in as part of the evaluation event sent to
     *         Evidently from the user session. Evidently can use this value to match user sessions with defined
     *         audience segments. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Evidently-segments.html">Use
     *         segments to focus your audience</a>.</p>
     *         <p>
     *         If you include this parameter, the value must be a JSON object. A JSON array is not supported.
     */
    public final String evaluationContext() {
        return evaluationContext;
    }

    /**
     * <p>
     * The name of the feature being evaluated.
     * </p>
     * 
     * @return The name of the feature being evaluated.
     */
    public final String feature() {
        return feature;
    }

    /**
     * <p>
     * The name or ARN of the project that contains this feature.
     * </p>
     * 
     * @return The name or ARN of the project that contains this feature.
     */
    public final String project() {
        return project;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(entityId());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationContext());
        hashCode = 31 * hashCode + Objects.hashCode(feature());
        hashCode = 31 * hashCode + Objects.hashCode(project());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluateFeatureRequest)) {
            return false;
        }
        EvaluateFeatureRequest other = (EvaluateFeatureRequest) obj;
        return Objects.equals(entityId(), other.entityId()) && Objects.equals(evaluationContext(), other.evaluationContext())
                && Objects.equals(feature(), other.feature()) && Objects.equals(project(), other.project());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluateFeatureRequest").add("EntityId", entityId())
                .add("EvaluationContext", evaluationContext()).add("Feature", feature()).add("Project", project()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "entityId":
            return Optional.ofNullable(clazz.cast(entityId()));
        case "evaluationContext":
            return Optional.ofNullable(clazz.cast(evaluationContext()));
        case "feature":
            return Optional.ofNullable(clazz.cast(feature()));
        case "project":
            return Optional.ofNullable(clazz.cast(project()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("entityId", ENTITY_ID_FIELD);
        map.put("evaluationContext", EVALUATION_CONTEXT_FIELD);
        map.put("feature", FEATURE_FIELD);
        map.put("project", PROJECT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluateFeatureRequest, T> g) {
        return obj -> g.apply((EvaluateFeatureRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EvidentlyRequest.Builder, SdkPojo, CopyableBuilder<Builder, EvaluateFeatureRequest> {
        /**
         * <p>
         * An internal ID that represents a unique user of the application. This <code>entityID</code> is checked
         * against any override rules assigned for this feature.
         * </p>
         * 
         * @param entityId
         *        An internal ID that represents a unique user of the application. This <code>entityID</code> is checked
         *        against any override rules assigned for this feature.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityId(String entityId);

        /**
         * <p>
         * A JSON object of attributes that you can optionally pass in as part of the evaluation event sent to Evidently
         * from the user session. Evidently can use this value to match user sessions with defined audience segments.
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Evidently-segments.html">Use
         * segments to focus your audience</a>.
         * </p>
         * <p>
         * If you include this parameter, the value must be a JSON object. A JSON array is not supported.
         * </p>
         * 
         * @param evaluationContext
         *        A JSON object of attributes that you can optionally pass in as part of the evaluation event sent to
         *        Evidently from the user session. Evidently can use this value to match user sessions with defined
         *        audience segments. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Evidently-segments.html"
         *        >Use segments to focus your audience</a>.</p>
         *        <p>
         *        If you include this parameter, the value must be a JSON object. A JSON array is not supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationContext(String evaluationContext);

        /**
         * <p>
         * The name of the feature being evaluated.
         * </p>
         * 
         * @param feature
         *        The name of the feature being evaluated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder feature(String feature);

        /**
         * <p>
         * The name or ARN of the project that contains this feature.
         * </p>
         * 
         * @param project
         *        The name or ARN of the project that contains this feature.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder project(String project);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EvidentlyRequest.BuilderImpl implements Builder {
        private String entityId;

        private String evaluationContext;

        private String feature;

        private String project;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluateFeatureRequest model) {
            super(model);
            entityId(model.entityId);
            evaluationContext(model.evaluationContext);
            feature(model.feature);
            project(model.project);
        }

        public final String getEntityId() {
            return entityId;
        }

        public final void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        @Override
        public final Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public final String getEvaluationContext() {
            return evaluationContext;
        }

        public final void setEvaluationContext(String evaluationContext) {
            this.evaluationContext = evaluationContext;
        }

        @Override
        public final Builder evaluationContext(String evaluationContext) {
            this.evaluationContext = evaluationContext;
            return this;
        }

        public final String getFeature() {
            return feature;
        }

        public final void setFeature(String feature) {
            this.feature = feature;
        }

        @Override
        public final Builder feature(String feature) {
            this.feature = feature;
            return this;
        }

        public final String getProject() {
            return project;
        }

        public final void setProject(String project) {
            this.project = project;
        }

        @Override
        public final Builder project(String project) {
            this.project = project;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public EvaluateFeatureRequest build() {
            return new EvaluateFeatureRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
