/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.evidently.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartExperimentResponse extends EvidentlyResponse implements
        ToCopyableBuilder<StartExperimentResponse.Builder, StartExperimentResponse> {
    private static final SdkField<Instant> STARTED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startedTime").getter(getter(StartExperimentResponse::startedTime)).setter(setter(Builder::startedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STARTED_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Instant startedTime;

    private StartExperimentResponse(BuilderImpl builder) {
        super(builder);
        this.startedTime = builder.startedTime;
    }

    /**
     * <p>
     * A timestamp that indicates when the experiment started.
     * </p>
     * 
     * @return A timestamp that indicates when the experiment started.
     */
    public final Instant startedTime() {
        return startedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(startedTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartExperimentResponse)) {
            return false;
        }
        StartExperimentResponse other = (StartExperimentResponse) obj;
        return Objects.equals(startedTime(), other.startedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartExperimentResponse").add("StartedTime", startedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "startedTime":
            return Optional.ofNullable(clazz.cast(startedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("startedTime", STARTED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartExperimentResponse, T> g) {
        return obj -> g.apply((StartExperimentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EvidentlyResponse.Builder, SdkPojo, CopyableBuilder<Builder, StartExperimentResponse> {
        /**
         * <p>
         * A timestamp that indicates when the experiment started.
         * </p>
         * 
         * @param startedTime
         *        A timestamp that indicates when the experiment started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedTime(Instant startedTime);
    }

    static final class BuilderImpl extends EvidentlyResponse.BuilderImpl implements Builder {
        private Instant startedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(StartExperimentResponse model) {
            super(model);
            startedTime(model.startedTime);
        }

        public final Instant getStartedTime() {
            return startedTime;
        }

        public final void setStartedTime(Instant startedTime) {
            this.startedTime = startedTime;
        }

        @Override
        public final Builder startedTime(Instant startedTime) {
            this.startedTime = startedTime;
            return this;
        }

        @Override
        public StartExperimentResponse build() {
            return new StartExperimentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
