/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.evidently.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateExperimentRequest extends EvidentlyRequest implements
        ToCopyableBuilder<UpdateExperimentRequest.Builder, UpdateExperimentRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateExperimentRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> EXPERIMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("experiment").getter(getter(UpdateExperimentRequest::experiment)).setter(setter(Builder::experiment))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("experiment").build()).build();

    private static final SdkField<List<MetricGoalConfig>> METRIC_GOALS_FIELD = SdkField
            .<List<MetricGoalConfig>> builder(MarshallingType.LIST)
            .memberName("metricGoals")
            .getter(getter(UpdateExperimentRequest::metricGoals))
            .setter(setter(Builder::metricGoals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricGoals").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetricGoalConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetricGoalConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<OnlineAbConfig> ONLINE_AB_CONFIG_FIELD = SdkField
            .<OnlineAbConfig> builder(MarshallingType.SDK_POJO).memberName("onlineAbConfig")
            .getter(getter(UpdateExperimentRequest::onlineAbConfig)).setter(setter(Builder::onlineAbConfig))
            .constructor(OnlineAbConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("onlineAbConfig").build()).build();

    private static final SdkField<String> PROJECT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("project")
            .getter(getter(UpdateExperimentRequest::project)).setter(setter(Builder::project))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("project").build()).build();

    private static final SdkField<String> RANDOMIZATION_SALT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("randomizationSalt").getter(getter(UpdateExperimentRequest::randomizationSalt))
            .setter(setter(Builder::randomizationSalt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("randomizationSalt").build()).build();

    private static final SdkField<Boolean> REMOVE_SEGMENT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("removeSegment").getter(getter(UpdateExperimentRequest::removeSegment))
            .setter(setter(Builder::removeSegment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("removeSegment").build()).build();

    private static final SdkField<Long> SAMPLING_RATE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("samplingRate").getter(getter(UpdateExperimentRequest::samplingRate))
            .setter(setter(Builder::samplingRate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("samplingRate").build()).build();

    private static final SdkField<String> SEGMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("segment")
            .getter(getter(UpdateExperimentRequest::segment)).setter(setter(Builder::segment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segment").build()).build();

    private static final SdkField<List<TreatmentConfig>> TREATMENTS_FIELD = SdkField
            .<List<TreatmentConfig>> builder(MarshallingType.LIST)
            .memberName("treatments")
            .getter(getter(UpdateExperimentRequest::treatments))
            .setter(setter(Builder::treatments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("treatments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TreatmentConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(TreatmentConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            EXPERIMENT_FIELD, METRIC_GOALS_FIELD, ONLINE_AB_CONFIG_FIELD, PROJECT_FIELD, RANDOMIZATION_SALT_FIELD,
            REMOVE_SEGMENT_FIELD, SAMPLING_RATE_FIELD, SEGMENT_FIELD, TREATMENTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String description;

    private final String experiment;

    private final List<MetricGoalConfig> metricGoals;

    private final OnlineAbConfig onlineAbConfig;

    private final String project;

    private final String randomizationSalt;

    private final Boolean removeSegment;

    private final Long samplingRate;

    private final String segment;

    private final List<TreatmentConfig> treatments;

    private UpdateExperimentRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.experiment = builder.experiment;
        this.metricGoals = builder.metricGoals;
        this.onlineAbConfig = builder.onlineAbConfig;
        this.project = builder.project;
        this.randomizationSalt = builder.randomizationSalt;
        this.removeSegment = builder.removeSegment;
        this.samplingRate = builder.samplingRate;
        this.segment = builder.segment;
        this.treatments = builder.treatments;
    }

    /**
     * <p>
     * An optional description of the experiment.
     * </p>
     * 
     * @return An optional description of the experiment.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The name of the experiment to update.
     * </p>
     * 
     * @return The name of the experiment to update.
     */
    public final String experiment() {
        return experiment;
    }

    /**
     * For responses, this returns true if the service returned a value for the MetricGoals property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMetricGoals() {
        return metricGoals != null && !(metricGoals instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of structures that defines the metrics used for the experiment, and whether a higher or lower value for
     * each metric is the goal.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetricGoals} method.
     * </p>
     * 
     * @return An array of structures that defines the metrics used for the experiment, and whether a higher or lower
     *         value for each metric is the goal.
     */
    public final List<MetricGoalConfig> metricGoals() {
        return metricGoals;
    }

    /**
     * <p>
     * A structure that contains the configuration of which variation o use as the "control" version. The "control"
     * version is used for comparison with other variations. This structure also specifies how much experiment traffic
     * is allocated to each variation.
     * </p>
     * 
     * @return A structure that contains the configuration of which variation o use as the "control" version. The
     *         "control" version is used for comparison with other variations. This structure also specifies how much
     *         experiment traffic is allocated to each variation.
     */
    public final OnlineAbConfig onlineAbConfig() {
        return onlineAbConfig;
    }

    /**
     * <p>
     * The name or ARN of the project that contains the experiment that you want to update.
     * </p>
     * 
     * @return The name or ARN of the project that contains the experiment that you want to update.
     */
    public final String project() {
        return project;
    }

    /**
     * <p>
     * When Evidently assigns a particular user session to an experiment, it must use a randomization ID to determine
     * which variation the user session is served. This randomization ID is a combination of the entity ID and
     * <code>randomizationSalt</code>. If you omit <code>randomizationSalt</code>, Evidently uses the experiment name as
     * the <code>randomizationSalt</code>.
     * </p>
     * 
     * @return When Evidently assigns a particular user session to an experiment, it must use a randomization ID to
     *         determine which variation the user session is served. This randomization ID is a combination of the
     *         entity ID and <code>randomizationSalt</code>. If you omit <code>randomizationSalt</code>, Evidently uses
     *         the experiment name as the <code>randomizationSalt</code>.
     */
    public final String randomizationSalt() {
        return randomizationSalt;
    }

    /**
     * <p>
     * Removes a segment from being used in an experiment. You can't use this parameter if the experiment is currently
     * running.
     * </p>
     * 
     * @return Removes a segment from being used in an experiment. You can't use this parameter if the experiment is
     *         currently running.
     */
    public final Boolean removeSegment() {
        return removeSegment;
    }

    /**
     * <p>
     * The portion of the available audience that you want to allocate to this experiment, in thousandths of a percent.
     * The available audience is the total audience minus the audience that you have allocated to overrides or current
     * launches of this feature.
     * </p>
     * <p>
     * This is represented in thousandths of a percent. For example, specify 20,000 to allocate 20% of the available
     * audience.
     * </p>
     * 
     * @return The portion of the available audience that you want to allocate to this experiment, in thousandths of a
     *         percent. The available audience is the total audience minus the audience that you have allocated to
     *         overrides or current launches of this feature.</p>
     *         <p>
     *         This is represented in thousandths of a percent. For example, specify 20,000 to allocate 20% of the
     *         available audience.
     */
    public final Long samplingRate() {
        return samplingRate;
    }

    /**
     * <p>
     * Adds an audience <i>segment</i> to an experiment. When a segment is used in an experiment, only user sessions
     * that match the segment pattern are used in the experiment. You can't use this parameter if the experiment is
     * currently running.
     * </p>
     * 
     * @return Adds an audience <i>segment</i> to an experiment. When a segment is used in an experiment, only user
     *         sessions that match the segment pattern are used in the experiment. You can't use this parameter if the
     *         experiment is currently running.
     */
    public final String segment() {
        return segment;
    }

    /**
     * For responses, this returns true if the service returned a value for the Treatments property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTreatments() {
        return treatments != null && !(treatments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of structures that define the variations being tested in the experiment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTreatments} method.
     * </p>
     * 
     * @return An array of structures that define the variations being tested in the experiment.
     */
    public final List<TreatmentConfig> treatments() {
        return treatments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(experiment());
        hashCode = 31 * hashCode + Objects.hashCode(hasMetricGoals() ? metricGoals() : null);
        hashCode = 31 * hashCode + Objects.hashCode(onlineAbConfig());
        hashCode = 31 * hashCode + Objects.hashCode(project());
        hashCode = 31 * hashCode + Objects.hashCode(randomizationSalt());
        hashCode = 31 * hashCode + Objects.hashCode(removeSegment());
        hashCode = 31 * hashCode + Objects.hashCode(samplingRate());
        hashCode = 31 * hashCode + Objects.hashCode(segment());
        hashCode = 31 * hashCode + Objects.hashCode(hasTreatments() ? treatments() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateExperimentRequest)) {
            return false;
        }
        UpdateExperimentRequest other = (UpdateExperimentRequest) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(experiment(), other.experiment())
                && hasMetricGoals() == other.hasMetricGoals() && Objects.equals(metricGoals(), other.metricGoals())
                && Objects.equals(onlineAbConfig(), other.onlineAbConfig()) && Objects.equals(project(), other.project())
                && Objects.equals(randomizationSalt(), other.randomizationSalt())
                && Objects.equals(removeSegment(), other.removeSegment()) && Objects.equals(samplingRate(), other.samplingRate())
                && Objects.equals(segment(), other.segment()) && hasTreatments() == other.hasTreatments()
                && Objects.equals(treatments(), other.treatments());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateExperimentRequest").add("Description", description()).add("Experiment", experiment())
                .add("MetricGoals", hasMetricGoals() ? metricGoals() : null).add("OnlineAbConfig", onlineAbConfig())
                .add("Project", project()).add("RandomizationSalt", randomizationSalt()).add("RemoveSegment", removeSegment())
                .add("SamplingRate", samplingRate()).add("Segment", segment())
                .add("Treatments", hasTreatments() ? treatments() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "experiment":
            return Optional.ofNullable(clazz.cast(experiment()));
        case "metricGoals":
            return Optional.ofNullable(clazz.cast(metricGoals()));
        case "onlineAbConfig":
            return Optional.ofNullable(clazz.cast(onlineAbConfig()));
        case "project":
            return Optional.ofNullable(clazz.cast(project()));
        case "randomizationSalt":
            return Optional.ofNullable(clazz.cast(randomizationSalt()));
        case "removeSegment":
            return Optional.ofNullable(clazz.cast(removeSegment()));
        case "samplingRate":
            return Optional.ofNullable(clazz.cast(samplingRate()));
        case "segment":
            return Optional.ofNullable(clazz.cast(segment()));
        case "treatments":
            return Optional.ofNullable(clazz.cast(treatments()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("description", DESCRIPTION_FIELD);
        map.put("experiment", EXPERIMENT_FIELD);
        map.put("metricGoals", METRIC_GOALS_FIELD);
        map.put("onlineAbConfig", ONLINE_AB_CONFIG_FIELD);
        map.put("project", PROJECT_FIELD);
        map.put("randomizationSalt", RANDOMIZATION_SALT_FIELD);
        map.put("removeSegment", REMOVE_SEGMENT_FIELD);
        map.put("samplingRate", SAMPLING_RATE_FIELD);
        map.put("segment", SEGMENT_FIELD);
        map.put("treatments", TREATMENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateExperimentRequest, T> g) {
        return obj -> g.apply((UpdateExperimentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EvidentlyRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateExperimentRequest> {
        /**
         * <p>
         * An optional description of the experiment.
         * </p>
         * 
         * @param description
         *        An optional description of the experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name of the experiment to update.
         * </p>
         * 
         * @param experiment
         *        The name of the experiment to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder experiment(String experiment);

        /**
         * <p>
         * An array of structures that defines the metrics used for the experiment, and whether a higher or lower value
         * for each metric is the goal.
         * </p>
         * 
         * @param metricGoals
         *        An array of structures that defines the metrics used for the experiment, and whether a higher or lower
         *        value for each metric is the goal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricGoals(Collection<MetricGoalConfig> metricGoals);

        /**
         * <p>
         * An array of structures that defines the metrics used for the experiment, and whether a higher or lower value
         * for each metric is the goal.
         * </p>
         * 
         * @param metricGoals
         *        An array of structures that defines the metrics used for the experiment, and whether a higher or lower
         *        value for each metric is the goal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricGoals(MetricGoalConfig... metricGoals);

        /**
         * <p>
         * An array of structures that defines the metrics used for the experiment, and whether a higher or lower value
         * for each metric is the goal.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.evidently.model.MetricGoalConfig.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.evidently.model.MetricGoalConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.evidently.model.MetricGoalConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #metricGoals(List<MetricGoalConfig>)}.
         * 
         * @param metricGoals
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.evidently.model.MetricGoalConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricGoals(java.util.Collection<MetricGoalConfig>)
         */
        Builder metricGoals(Consumer<MetricGoalConfig.Builder>... metricGoals);

        /**
         * <p>
         * A structure that contains the configuration of which variation o use as the "control" version. The "control"
         * version is used for comparison with other variations. This structure also specifies how much experiment
         * traffic is allocated to each variation.
         * </p>
         * 
         * @param onlineAbConfig
         *        A structure that contains the configuration of which variation o use as the "control" version. The
         *        "control" version is used for comparison with other variations. This structure also specifies how much
         *        experiment traffic is allocated to each variation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onlineAbConfig(OnlineAbConfig onlineAbConfig);

        /**
         * <p>
         * A structure that contains the configuration of which variation o use as the "control" version. The "control"
         * version is used for comparison with other variations. This structure also specifies how much experiment
         * traffic is allocated to each variation.
         * </p>
         * This is a convenience method that creates an instance of the {@link OnlineAbConfig.Builder} avoiding the need
         * to create one manually via {@link OnlineAbConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OnlineAbConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #onlineAbConfig(OnlineAbConfig)}.
         * 
         * @param onlineAbConfig
         *        a consumer that will call methods on {@link OnlineAbConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #onlineAbConfig(OnlineAbConfig)
         */
        default Builder onlineAbConfig(Consumer<OnlineAbConfig.Builder> onlineAbConfig) {
            return onlineAbConfig(OnlineAbConfig.builder().applyMutation(onlineAbConfig).build());
        }

        /**
         * <p>
         * The name or ARN of the project that contains the experiment that you want to update.
         * </p>
         * 
         * @param project
         *        The name or ARN of the project that contains the experiment that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder project(String project);

        /**
         * <p>
         * When Evidently assigns a particular user session to an experiment, it must use a randomization ID to
         * determine which variation the user session is served. This randomization ID is a combination of the entity ID
         * and <code>randomizationSalt</code>. If you omit <code>randomizationSalt</code>, Evidently uses the experiment
         * name as the <code>randomizationSalt</code>.
         * </p>
         * 
         * @param randomizationSalt
         *        When Evidently assigns a particular user session to an experiment, it must use a randomization ID to
         *        determine which variation the user session is served. This randomization ID is a combination of the
         *        entity ID and <code>randomizationSalt</code>. If you omit <code>randomizationSalt</code>, Evidently
         *        uses the experiment name as the <code>randomizationSalt</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder randomizationSalt(String randomizationSalt);

        /**
         * <p>
         * Removes a segment from being used in an experiment. You can't use this parameter if the experiment is
         * currently running.
         * </p>
         * 
         * @param removeSegment
         *        Removes a segment from being used in an experiment. You can't use this parameter if the experiment is
         *        currently running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeSegment(Boolean removeSegment);

        /**
         * <p>
         * The portion of the available audience that you want to allocate to this experiment, in thousandths of a
         * percent. The available audience is the total audience minus the audience that you have allocated to overrides
         * or current launches of this feature.
         * </p>
         * <p>
         * This is represented in thousandths of a percent. For example, specify 20,000 to allocate 20% of the available
         * audience.
         * </p>
         * 
         * @param samplingRate
         *        The portion of the available audience that you want to allocate to this experiment, in thousandths of
         *        a percent. The available audience is the total audience minus the audience that you have allocated to
         *        overrides or current launches of this feature.</p>
         *        <p>
         *        This is represented in thousandths of a percent. For example, specify 20,000 to allocate 20% of the
         *        available audience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder samplingRate(Long samplingRate);

        /**
         * <p>
         * Adds an audience <i>segment</i> to an experiment. When a segment is used in an experiment, only user sessions
         * that match the segment pattern are used in the experiment. You can't use this parameter if the experiment is
         * currently running.
         * </p>
         * 
         * @param segment
         *        Adds an audience <i>segment</i> to an experiment. When a segment is used in an experiment, only user
         *        sessions that match the segment pattern are used in the experiment. You can't use this parameter if
         *        the experiment is currently running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segment(String segment);

        /**
         * <p>
         * An array of structures that define the variations being tested in the experiment.
         * </p>
         * 
         * @param treatments
         *        An array of structures that define the variations being tested in the experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder treatments(Collection<TreatmentConfig> treatments);

        /**
         * <p>
         * An array of structures that define the variations being tested in the experiment.
         * </p>
         * 
         * @param treatments
         *        An array of structures that define the variations being tested in the experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder treatments(TreatmentConfig... treatments);

        /**
         * <p>
         * An array of structures that define the variations being tested in the experiment.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.evidently.model.TreatmentConfig.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.evidently.model.TreatmentConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.evidently.model.TreatmentConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #treatments(List<TreatmentConfig>)}.
         * 
         * @param treatments
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.evidently.model.TreatmentConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #treatments(java.util.Collection<TreatmentConfig>)
         */
        Builder treatments(Consumer<TreatmentConfig.Builder>... treatments);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EvidentlyRequest.BuilderImpl implements Builder {
        private String description;

        private String experiment;

        private List<MetricGoalConfig> metricGoals = DefaultSdkAutoConstructList.getInstance();

        private OnlineAbConfig onlineAbConfig;

        private String project;

        private String randomizationSalt;

        private Boolean removeSegment;

        private Long samplingRate;

        private String segment;

        private List<TreatmentConfig> treatments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateExperimentRequest model) {
            super(model);
            description(model.description);
            experiment(model.experiment);
            metricGoals(model.metricGoals);
            onlineAbConfig(model.onlineAbConfig);
            project(model.project);
            randomizationSalt(model.randomizationSalt);
            removeSegment(model.removeSegment);
            samplingRate(model.samplingRate);
            segment(model.segment);
            treatments(model.treatments);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getExperiment() {
            return experiment;
        }

        public final void setExperiment(String experiment) {
            this.experiment = experiment;
        }

        @Override
        public final Builder experiment(String experiment) {
            this.experiment = experiment;
            return this;
        }

        public final List<MetricGoalConfig.Builder> getMetricGoals() {
            List<MetricGoalConfig.Builder> result = MetricGoalConfigListCopier.copyToBuilder(this.metricGoals);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricGoals(Collection<MetricGoalConfig.BuilderImpl> metricGoals) {
            this.metricGoals = MetricGoalConfigListCopier.copyFromBuilder(metricGoals);
        }

        @Override
        public final Builder metricGoals(Collection<MetricGoalConfig> metricGoals) {
            this.metricGoals = MetricGoalConfigListCopier.copy(metricGoals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricGoals(MetricGoalConfig... metricGoals) {
            metricGoals(Arrays.asList(metricGoals));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricGoals(Consumer<MetricGoalConfig.Builder>... metricGoals) {
            metricGoals(Stream.of(metricGoals).map(c -> MetricGoalConfig.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final OnlineAbConfig.Builder getOnlineAbConfig() {
            return onlineAbConfig != null ? onlineAbConfig.toBuilder() : null;
        }

        public final void setOnlineAbConfig(OnlineAbConfig.BuilderImpl onlineAbConfig) {
            this.onlineAbConfig = onlineAbConfig != null ? onlineAbConfig.build() : null;
        }

        @Override
        public final Builder onlineAbConfig(OnlineAbConfig onlineAbConfig) {
            this.onlineAbConfig = onlineAbConfig;
            return this;
        }

        public final String getProject() {
            return project;
        }

        public final void setProject(String project) {
            this.project = project;
        }

        @Override
        public final Builder project(String project) {
            this.project = project;
            return this;
        }

        public final String getRandomizationSalt() {
            return randomizationSalt;
        }

        public final void setRandomizationSalt(String randomizationSalt) {
            this.randomizationSalt = randomizationSalt;
        }

        @Override
        public final Builder randomizationSalt(String randomizationSalt) {
            this.randomizationSalt = randomizationSalt;
            return this;
        }

        public final Boolean getRemoveSegment() {
            return removeSegment;
        }

        public final void setRemoveSegment(Boolean removeSegment) {
            this.removeSegment = removeSegment;
        }

        @Override
        public final Builder removeSegment(Boolean removeSegment) {
            this.removeSegment = removeSegment;
            return this;
        }

        public final Long getSamplingRate() {
            return samplingRate;
        }

        public final void setSamplingRate(Long samplingRate) {
            this.samplingRate = samplingRate;
        }

        @Override
        public final Builder samplingRate(Long samplingRate) {
            this.samplingRate = samplingRate;
            return this;
        }

        public final String getSegment() {
            return segment;
        }

        public final void setSegment(String segment) {
            this.segment = segment;
        }

        @Override
        public final Builder segment(String segment) {
            this.segment = segment;
            return this;
        }

        public final List<TreatmentConfig.Builder> getTreatments() {
            List<TreatmentConfig.Builder> result = TreatmentConfigListCopier.copyToBuilder(this.treatments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTreatments(Collection<TreatmentConfig.BuilderImpl> treatments) {
            this.treatments = TreatmentConfigListCopier.copyFromBuilder(treatments);
        }

        @Override
        public final Builder treatments(Collection<TreatmentConfig> treatments) {
            this.treatments = TreatmentConfigListCopier.copy(treatments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder treatments(TreatmentConfig... treatments) {
            treatments(Arrays.asList(treatments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder treatments(Consumer<TreatmentConfig.Builder>... treatments) {
            treatments(Stream.of(treatments).map(c -> TreatmentConfig.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateExperimentRequest build() {
            return new UpdateExperimentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
