/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.evidently.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateFeatureRequest extends EvidentlyRequest implements
        ToCopyableBuilder<CreateFeatureRequest.Builder, CreateFeatureRequest> {
    private static final SdkField<String> DEFAULT_VARIATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("defaultVariation").getter(getter(CreateFeatureRequest::defaultVariation))
            .setter(setter(Builder::defaultVariation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultVariation").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateFeatureRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Map<String, String>> ENTITY_OVERRIDES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("entityOverrides")
            .getter(getter(CreateFeatureRequest::entityOverrides))
            .setter(setter(Builder::entityOverrides))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityOverrides").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> EVALUATION_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("evaluationStrategy").getter(getter(CreateFeatureRequest::evaluationStrategyAsString))
            .setter(setter(Builder::evaluationStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluationStrategy").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateFeatureRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> PROJECT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("project")
            .getter(getter(CreateFeatureRequest::project)).setter(setter(Builder::project))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("project").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateFeatureRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<VariationConfig>> VARIATIONS_FIELD = SdkField
            .<List<VariationConfig>> builder(MarshallingType.LIST)
            .memberName("variations")
            .getter(getter(CreateFeatureRequest::variations))
            .setter(setter(Builder::variations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VariationConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(VariationConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_VARIATION_FIELD,
            DESCRIPTION_FIELD, ENTITY_OVERRIDES_FIELD, EVALUATION_STRATEGY_FIELD, NAME_FIELD, PROJECT_FIELD, TAGS_FIELD,
            VARIATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String defaultVariation;

    private final String description;

    private final Map<String, String> entityOverrides;

    private final String evaluationStrategy;

    private final String name;

    private final String project;

    private final Map<String, String> tags;

    private final List<VariationConfig> variations;

    private CreateFeatureRequest(BuilderImpl builder) {
        super(builder);
        this.defaultVariation = builder.defaultVariation;
        this.description = builder.description;
        this.entityOverrides = builder.entityOverrides;
        this.evaluationStrategy = builder.evaluationStrategy;
        this.name = builder.name;
        this.project = builder.project;
        this.tags = builder.tags;
        this.variations = builder.variations;
    }

    /**
     * <p>
     * The name of the variation to use as the default variation. The default variation is served to users who are not
     * allocated to any ongoing launches or experiments of this feature.
     * </p>
     * <p>
     * This variation must also be listed in the <code>variations</code> structure.
     * </p>
     * <p>
     * If you omit <code>defaultVariation</code>, the first variation listed in the <code>variations</code> structure is
     * used as the default variation.
     * </p>
     * 
     * @return The name of the variation to use as the default variation. The default variation is served to users who
     *         are not allocated to any ongoing launches or experiments of this feature.</p>
     *         <p>
     *         This variation must also be listed in the <code>variations</code> structure.
     *         </p>
     *         <p>
     *         If you omit <code>defaultVariation</code>, the first variation listed in the <code>variations</code>
     *         structure is used as the default variation.
     */
    public final String defaultVariation() {
        return defaultVariation;
    }

    /**
     * <p>
     * An optional description of the feature.
     * </p>
     * 
     * @return An optional description of the feature.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the EntityOverrides property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEntityOverrides() {
        return entityOverrides != null && !(entityOverrides instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Specify users that should always be served a specific variation of a feature. Each user is specified by a
     * key-value pair . For each key, specify a user by entering their user ID, account ID, or some other identifier.
     * For the value, specify the name of the variation that they are to be served.
     * </p>
     * <p>
     * This parameter is limited to 2500 overrides or a total of 40KB. The 40KB limit includes an overhead of 6 bytes
     * per override.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEntityOverrides} method.
     * </p>
     * 
     * @return Specify users that should always be served a specific variation of a feature. Each user is specified by a
     *         key-value pair . For each key, specify a user by entering their user ID, account ID, or some other
     *         identifier. For the value, specify the name of the variation that they are to be served.</p>
     *         <p>
     *         This parameter is limited to 2500 overrides or a total of 40KB. The 40KB limit includes an overhead of 6
     *         bytes per override.
     */
    public final Map<String, String> entityOverrides() {
        return entityOverrides;
    }

    /**
     * <p>
     * Specify <code>ALL_RULES</code> to activate the traffic allocation specified by any ongoing launches or
     * experiments. Specify <code>DEFAULT_VARIATION</code> to serve the default variation to all users instead.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #evaluationStrategy} will return {@link FeatureEvaluationStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #evaluationStrategyAsString}.
     * </p>
     * 
     * @return Specify <code>ALL_RULES</code> to activate the traffic allocation specified by any ongoing launches or
     *         experiments. Specify <code>DEFAULT_VARIATION</code> to serve the default variation to all users instead.
     * @see FeatureEvaluationStrategy
     */
    public final FeatureEvaluationStrategy evaluationStrategy() {
        return FeatureEvaluationStrategy.fromValue(evaluationStrategy);
    }

    /**
     * <p>
     * Specify <code>ALL_RULES</code> to activate the traffic allocation specified by any ongoing launches or
     * experiments. Specify <code>DEFAULT_VARIATION</code> to serve the default variation to all users instead.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #evaluationStrategy} will return {@link FeatureEvaluationStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #evaluationStrategyAsString}.
     * </p>
     * 
     * @return Specify <code>ALL_RULES</code> to activate the traffic allocation specified by any ongoing launches or
     *         experiments. Specify <code>DEFAULT_VARIATION</code> to serve the default variation to all users instead.
     * @see FeatureEvaluationStrategy
     */
    public final String evaluationStrategyAsString() {
        return evaluationStrategy;
    }

    /**
     * <p>
     * The name for the new feature.
     * </p>
     * 
     * @return The name for the new feature.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The name or ARN of the project that is to contain the new feature.
     * </p>
     * 
     * @return The name or ARN of the project that is to contain the new feature.
     */
    public final String project() {
        return project;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Assigns one or more tags (key-value pairs) to the feature.
     * </p>
     * <p>
     * Tags can help you organize and categorize your resources. You can also use them to scope user permissions by
     * granting a user permission to access or change only resources with certain tag values.
     * </p>
     * <p>
     * Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of
     * characters.
     * </p>
     * <p>
     * You can associate as many as 50 tags with a feature.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon
     * Web Services resources</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Assigns one or more tags (key-value pairs) to the feature.</p>
     *         <p>
     *         Tags can help you organize and categorize your resources. You can also use them to scope user permissions
     *         by granting a user permission to access or change only resources with certain tag values.
     *         </p>
     *         <p>
     *         Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of
     *         characters.
     *         </p>
     *         <p>
     *         You can associate as many as 50 tags with a feature.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
     *         resources</a>.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the Variations property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasVariations() {
        return variations != null && !(variations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of structures that contain the configuration of the feature's different variations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVariations} method.
     * </p>
     * 
     * @return An array of structures that contain the configuration of the feature's different variations.
     */
    public final List<VariationConfig> variations() {
        return variations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(defaultVariation());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasEntityOverrides() ? entityOverrides() : null);
        hashCode = 31 * hashCode + Objects.hashCode(evaluationStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(project());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasVariations() ? variations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFeatureRequest)) {
            return false;
        }
        CreateFeatureRequest other = (CreateFeatureRequest) obj;
        return Objects.equals(defaultVariation(), other.defaultVariation()) && Objects.equals(description(), other.description())
                && hasEntityOverrides() == other.hasEntityOverrides()
                && Objects.equals(entityOverrides(), other.entityOverrides())
                && Objects.equals(evaluationStrategyAsString(), other.evaluationStrategyAsString())
                && Objects.equals(name(), other.name()) && Objects.equals(project(), other.project())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && hasVariations() == other.hasVariations() && Objects.equals(variations(), other.variations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateFeatureRequest").add("DefaultVariation", defaultVariation())
                .add("Description", description()).add("EntityOverrides", hasEntityOverrides() ? entityOverrides() : null)
                .add("EvaluationStrategy", evaluationStrategyAsString()).add("Name", name()).add("Project", project())
                .add("Tags", hasTags() ? tags() : null).add("Variations", hasVariations() ? variations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "defaultVariation":
            return Optional.ofNullable(clazz.cast(defaultVariation()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "entityOverrides":
            return Optional.ofNullable(clazz.cast(entityOverrides()));
        case "evaluationStrategy":
            return Optional.ofNullable(clazz.cast(evaluationStrategyAsString()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "project":
            return Optional.ofNullable(clazz.cast(project()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "variations":
            return Optional.ofNullable(clazz.cast(variations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("defaultVariation", DEFAULT_VARIATION_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("entityOverrides", ENTITY_OVERRIDES_FIELD);
        map.put("evaluationStrategy", EVALUATION_STRATEGY_FIELD);
        map.put("name", NAME_FIELD);
        map.put("project", PROJECT_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("variations", VARIATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateFeatureRequest, T> g) {
        return obj -> g.apply((CreateFeatureRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EvidentlyRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateFeatureRequest> {
        /**
         * <p>
         * The name of the variation to use as the default variation. The default variation is served to users who are
         * not allocated to any ongoing launches or experiments of this feature.
         * </p>
         * <p>
         * This variation must also be listed in the <code>variations</code> structure.
         * </p>
         * <p>
         * If you omit <code>defaultVariation</code>, the first variation listed in the <code>variations</code>
         * structure is used as the default variation.
         * </p>
         * 
         * @param defaultVariation
         *        The name of the variation to use as the default variation. The default variation is served to users
         *        who are not allocated to any ongoing launches or experiments of this feature.</p>
         *        <p>
         *        This variation must also be listed in the <code>variations</code> structure.
         *        </p>
         *        <p>
         *        If you omit <code>defaultVariation</code>, the first variation listed in the <code>variations</code>
         *        structure is used as the default variation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultVariation(String defaultVariation);

        /**
         * <p>
         * An optional description of the feature.
         * </p>
         * 
         * @param description
         *        An optional description of the feature.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Specify users that should always be served a specific variation of a feature. Each user is specified by a
         * key-value pair . For each key, specify a user by entering their user ID, account ID, or some other
         * identifier. For the value, specify the name of the variation that they are to be served.
         * </p>
         * <p>
         * This parameter is limited to 2500 overrides or a total of 40KB. The 40KB limit includes an overhead of 6
         * bytes per override.
         * </p>
         * 
         * @param entityOverrides
         *        Specify users that should always be served a specific variation of a feature. Each user is specified
         *        by a key-value pair . For each key, specify a user by entering their user ID, account ID, or some
         *        other identifier. For the value, specify the name of the variation that they are to be served.</p>
         *        <p>
         *        This parameter is limited to 2500 overrides or a total of 40KB. The 40KB limit includes an overhead of
         *        6 bytes per override.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityOverrides(Map<String, String> entityOverrides);

        /**
         * <p>
         * Specify <code>ALL_RULES</code> to activate the traffic allocation specified by any ongoing launches or
         * experiments. Specify <code>DEFAULT_VARIATION</code> to serve the default variation to all users instead.
         * </p>
         * 
         * @param evaluationStrategy
         *        Specify <code>ALL_RULES</code> to activate the traffic allocation specified by any ongoing launches or
         *        experiments. Specify <code>DEFAULT_VARIATION</code> to serve the default variation to all users
         *        instead.
         * @see FeatureEvaluationStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FeatureEvaluationStrategy
         */
        Builder evaluationStrategy(String evaluationStrategy);

        /**
         * <p>
         * Specify <code>ALL_RULES</code> to activate the traffic allocation specified by any ongoing launches or
         * experiments. Specify <code>DEFAULT_VARIATION</code> to serve the default variation to all users instead.
         * </p>
         * 
         * @param evaluationStrategy
         *        Specify <code>ALL_RULES</code> to activate the traffic allocation specified by any ongoing launches or
         *        experiments. Specify <code>DEFAULT_VARIATION</code> to serve the default variation to all users
         *        instead.
         * @see FeatureEvaluationStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FeatureEvaluationStrategy
         */
        Builder evaluationStrategy(FeatureEvaluationStrategy evaluationStrategy);

        /**
         * <p>
         * The name for the new feature.
         * </p>
         * 
         * @param name
         *        The name for the new feature.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The name or ARN of the project that is to contain the new feature.
         * </p>
         * 
         * @param project
         *        The name or ARN of the project that is to contain the new feature.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder project(String project);

        /**
         * <p>
         * Assigns one or more tags (key-value pairs) to the feature.
         * </p>
         * <p>
         * Tags can help you organize and categorize your resources. You can also use them to scope user permissions by
         * granting a user permission to access or change only resources with certain tag values.
         * </p>
         * <p>
         * Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of
         * characters.
         * </p>
         * <p>
         * You can associate as many as 50 tags with a feature.
         * </p>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging
         * Amazon Web Services resources</a>.
         * </p>
         * 
         * @param tags
         *        Assigns one or more tags (key-value pairs) to the feature.</p>
         *        <p>
         *        Tags can help you organize and categorize your resources. You can also use them to scope user
         *        permissions by granting a user permission to access or change only resources with certain tag values.
         *        </p>
         *        <p>
         *        Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of
         *        characters.
         *        </p>
         *        <p>
         *        You can associate as many as 50 tags with a feature.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         *        resources</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * An array of structures that contain the configuration of the feature's different variations.
         * </p>
         * 
         * @param variations
         *        An array of structures that contain the configuration of the feature's different variations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder variations(Collection<VariationConfig> variations);

        /**
         * <p>
         * An array of structures that contain the configuration of the feature's different variations.
         * </p>
         * 
         * @param variations
         *        An array of structures that contain the configuration of the feature's different variations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder variations(VariationConfig... variations);

        /**
         * <p>
         * An array of structures that contain the configuration of the feature's different variations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.evidently.model.VariationConfig.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.evidently.model.VariationConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.evidently.model.VariationConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #variations(List<VariationConfig>)}.
         * 
         * @param variations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.evidently.model.VariationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #variations(java.util.Collection<VariationConfig>)
         */
        Builder variations(Consumer<VariationConfig.Builder>... variations);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EvidentlyRequest.BuilderImpl implements Builder {
        private String defaultVariation;

        private String description;

        private Map<String, String> entityOverrides = DefaultSdkAutoConstructMap.getInstance();

        private String evaluationStrategy;

        private String name;

        private String project;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private List<VariationConfig> variations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFeatureRequest model) {
            super(model);
            defaultVariation(model.defaultVariation);
            description(model.description);
            entityOverrides(model.entityOverrides);
            evaluationStrategy(model.evaluationStrategy);
            name(model.name);
            project(model.project);
            tags(model.tags);
            variations(model.variations);
        }

        public final String getDefaultVariation() {
            return defaultVariation;
        }

        public final void setDefaultVariation(String defaultVariation) {
            this.defaultVariation = defaultVariation;
        }

        @Override
        public final Builder defaultVariation(String defaultVariation) {
            this.defaultVariation = defaultVariation;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, String> getEntityOverrides() {
            if (entityOverrides instanceof SdkAutoConstructMap) {
                return null;
            }
            return entityOverrides;
        }

        public final void setEntityOverrides(Map<String, String> entityOverrides) {
            this.entityOverrides = EntityOverrideMapCopier.copy(entityOverrides);
        }

        @Override
        public final Builder entityOverrides(Map<String, String> entityOverrides) {
            this.entityOverrides = EntityOverrideMapCopier.copy(entityOverrides);
            return this;
        }

        public final String getEvaluationStrategy() {
            return evaluationStrategy;
        }

        public final void setEvaluationStrategy(String evaluationStrategy) {
            this.evaluationStrategy = evaluationStrategy;
        }

        @Override
        public final Builder evaluationStrategy(String evaluationStrategy) {
            this.evaluationStrategy = evaluationStrategy;
            return this;
        }

        @Override
        public final Builder evaluationStrategy(FeatureEvaluationStrategy evaluationStrategy) {
            this.evaluationStrategy(evaluationStrategy == null ? null : evaluationStrategy.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getProject() {
            return project;
        }

        public final void setProject(String project) {
            this.project = project;
        }

        @Override
        public final Builder project(String project) {
            this.project = project;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final List<VariationConfig.Builder> getVariations() {
            List<VariationConfig.Builder> result = VariationConfigsListCopier.copyToBuilder(this.variations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVariations(Collection<VariationConfig.BuilderImpl> variations) {
            this.variations = VariationConfigsListCopier.copyFromBuilder(variations);
        }

        @Override
        public final Builder variations(Collection<VariationConfig> variations) {
            this.variations = VariationConfigsListCopier.copy(variations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variations(VariationConfig... variations) {
            variations(Arrays.asList(variations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variations(Consumer<VariationConfig.Builder>... variations) {
            variations(Stream.of(variations).map(c -> VariationConfig.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFeatureRequest build() {
            return new CreateFeatureRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
