/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.evidently.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateProjectRequest extends EvidentlyRequest implements
        ToCopyableBuilder<CreateProjectRequest.Builder, CreateProjectRequest> {
    private static final SdkField<ProjectAppConfigResourceConfig> APP_CONFIG_RESOURCE_FIELD = SdkField
            .<ProjectAppConfigResourceConfig> builder(MarshallingType.SDK_POJO).memberName("appConfigResource")
            .getter(getter(CreateProjectRequest::appConfigResource)).setter(setter(Builder::appConfigResource))
            .constructor(ProjectAppConfigResourceConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appConfigResource").build()).build();

    private static final SdkField<ProjectDataDeliveryConfig> DATA_DELIVERY_FIELD = SdkField
            .<ProjectDataDeliveryConfig> builder(MarshallingType.SDK_POJO).memberName("dataDelivery")
            .getter(getter(CreateProjectRequest::dataDelivery)).setter(setter(Builder::dataDelivery))
            .constructor(ProjectDataDeliveryConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataDelivery").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateProjectRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateProjectRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateProjectRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_CONFIG_RESOURCE_FIELD,
            DATA_DELIVERY_FIELD, DESCRIPTION_FIELD, NAME_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ProjectAppConfigResourceConfig appConfigResource;

    private final ProjectDataDeliveryConfig dataDelivery;

    private final String description;

    private final String name;

    private final Map<String, String> tags;

    private CreateProjectRequest(BuilderImpl builder) {
        super(builder);
        this.appConfigResource = builder.appConfigResource;
        this.dataDelivery = builder.dataDelivery;
        this.description = builder.description;
        this.name = builder.name;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Use this parameter if the project will use <i>client-side evaluation powered by AppConfig</i>. Client-side
     * evaluation allows your application to assign variations to user sessions locally instead of by calling the <a
     * href
     * ="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_EvaluateFeature.html">EvaluateFeature
     * </a> operation. This mitigates the latency and availability risks that come with an API call. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Evidently-client-side-evaluation.html"
     * > Client-side evaluation - powered by AppConfig.</a>
     * </p>
     * <p>
     * This parameter is a structure that contains information about the AppConfig application and environment that will
     * be used as for client-side evaluation.
     * </p>
     * <p>
     * To create a project that uses client-side evaluation, you must have the
     * <code>evidently:ExportProjectAsConfiguration</code> permission.
     * </p>
     * 
     * @return Use this parameter if the project will use <i>client-side evaluation powered by AppConfig</i>.
     *         Client-side evaluation allows your application to assign variations to user sessions locally instead of
     *         by calling the <a
     *         href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_EvaluateFeature.html"
     *         >EvaluateFeature</a> operation. This mitigates the latency and availability risks that come with an API
     *         call. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Evidently-client-side-evaluation.html"
     *         > Client-side evaluation - powered by AppConfig.</a> </p>
     *         <p>
     *         This parameter is a structure that contains information about the AppConfig application and environment
     *         that will be used as for client-side evaluation.
     *         </p>
     *         <p>
     *         To create a project that uses client-side evaluation, you must have the
     *         <code>evidently:ExportProjectAsConfiguration</code> permission.
     */
    public final ProjectAppConfigResourceConfig appConfigResource() {
        return appConfigResource;
    }

    /**
     * <p>
     * A structure that contains information about where Evidently is to store evaluation events for longer term
     * storage, if you choose to do so. If you choose not to store these events, Evidently deletes them after using them
     * to produce metrics and other experiment results that you can view.
     * </p>
     * 
     * @return A structure that contains information about where Evidently is to store evaluation events for longer term
     *         storage, if you choose to do so. If you choose not to store these events, Evidently deletes them after
     *         using them to produce metrics and other experiment results that you can view.
     */
    public final ProjectDataDeliveryConfig dataDelivery() {
        return dataDelivery;
    }

    /**
     * <p>
     * An optional description of the project.
     * </p>
     * 
     * @return An optional description of the project.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The name for the project.
     * </p>
     * 
     * @return The name for the project.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Assigns one or more tags (key-value pairs) to the project.
     * </p>
     * <p>
     * Tags can help you organize and categorize your resources. You can also use them to scope user permissions by
     * granting a user permission to access or change only resources with certain tag values.
     * </p>
     * <p>
     * Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of
     * characters.
     * </p>
     * <p>
     * You can associate as many as 50 tags with a project.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon
     * Web Services resources</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Assigns one or more tags (key-value pairs) to the project.</p>
     *         <p>
     *         Tags can help you organize and categorize your resources. You can also use them to scope user permissions
     *         by granting a user permission to access or change only resources with certain tag values.
     *         </p>
     *         <p>
     *         Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of
     *         characters.
     *         </p>
     *         <p>
     *         You can associate as many as 50 tags with a project.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
     *         resources</a>.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appConfigResource());
        hashCode = 31 * hashCode + Objects.hashCode(dataDelivery());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProjectRequest)) {
            return false;
        }
        CreateProjectRequest other = (CreateProjectRequest) obj;
        return Objects.equals(appConfigResource(), other.appConfigResource())
                && Objects.equals(dataDelivery(), other.dataDelivery()) && Objects.equals(description(), other.description())
                && Objects.equals(name(), other.name()) && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateProjectRequest").add("AppConfigResource", appConfigResource())
                .add("DataDelivery", dataDelivery()).add("Description", description()).add("Name", name())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appConfigResource":
            return Optional.ofNullable(clazz.cast(appConfigResource()));
        case "dataDelivery":
            return Optional.ofNullable(clazz.cast(dataDelivery()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("appConfigResource", APP_CONFIG_RESOURCE_FIELD);
        map.put("dataDelivery", DATA_DELIVERY_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("name", NAME_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateProjectRequest, T> g) {
        return obj -> g.apply((CreateProjectRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EvidentlyRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateProjectRequest> {
        /**
         * <p>
         * Use this parameter if the project will use <i>client-side evaluation powered by AppConfig</i>. Client-side
         * evaluation allows your application to assign variations to user sessions locally instead of by calling the <a
         * href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_EvaluateFeature.html">
         * EvaluateFeature</a> operation. This mitigates the latency and availability risks that come with an API call.
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Evidently-client-side-evaluation.html"
         * > Client-side evaluation - powered by AppConfig.</a>
         * </p>
         * <p>
         * This parameter is a structure that contains information about the AppConfig application and environment that
         * will be used as for client-side evaluation.
         * </p>
         * <p>
         * To create a project that uses client-side evaluation, you must have the
         * <code>evidently:ExportProjectAsConfiguration</code> permission.
         * </p>
         * 
         * @param appConfigResource
         *        Use this parameter if the project will use <i>client-side evaluation powered by AppConfig</i>.
         *        Client-side evaluation allows your application to assign variations to user sessions locally instead
         *        of by calling the <a
         *        href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_EvaluateFeature.html"
         *        >EvaluateFeature</a> operation. This mitigates the latency and availability risks that come with an
         *        API call. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Evidently-client-side-evaluation.html"
         *        > Client-side evaluation - powered by AppConfig.</a> </p>
         *        <p>
         *        This parameter is a structure that contains information about the AppConfig application and
         *        environment that will be used as for client-side evaluation.
         *        </p>
         *        <p>
         *        To create a project that uses client-side evaluation, you must have the
         *        <code>evidently:ExportProjectAsConfiguration</code> permission.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appConfigResource(ProjectAppConfigResourceConfig appConfigResource);

        /**
         * <p>
         * Use this parameter if the project will use <i>client-side evaluation powered by AppConfig</i>. Client-side
         * evaluation allows your application to assign variations to user sessions locally instead of by calling the <a
         * href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_EvaluateFeature.html">
         * EvaluateFeature</a> operation. This mitigates the latency and availability risks that come with an API call.
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Evidently-client-side-evaluation.html"
         * > Client-side evaluation - powered by AppConfig.</a>
         * </p>
         * <p>
         * This parameter is a structure that contains information about the AppConfig application and environment that
         * will be used as for client-side evaluation.
         * </p>
         * <p>
         * To create a project that uses client-side evaluation, you must have the
         * <code>evidently:ExportProjectAsConfiguration</code> permission.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProjectAppConfigResourceConfig.Builder}
         * avoiding the need to create one manually via {@link ProjectAppConfigResourceConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProjectAppConfigResourceConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #appConfigResource(ProjectAppConfigResourceConfig)}.
         * 
         * @param appConfigResource
         *        a consumer that will call methods on {@link ProjectAppConfigResourceConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #appConfigResource(ProjectAppConfigResourceConfig)
         */
        default Builder appConfigResource(Consumer<ProjectAppConfigResourceConfig.Builder> appConfigResource) {
            return appConfigResource(ProjectAppConfigResourceConfig.builder().applyMutation(appConfigResource).build());
        }

        /**
         * <p>
         * A structure that contains information about where Evidently is to store evaluation events for longer term
         * storage, if you choose to do so. If you choose not to store these events, Evidently deletes them after using
         * them to produce metrics and other experiment results that you can view.
         * </p>
         * 
         * @param dataDelivery
         *        A structure that contains information about where Evidently is to store evaluation events for longer
         *        term storage, if you choose to do so. If you choose not to store these events, Evidently deletes them
         *        after using them to produce metrics and other experiment results that you can view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataDelivery(ProjectDataDeliveryConfig dataDelivery);

        /**
         * <p>
         * A structure that contains information about where Evidently is to store evaluation events for longer term
         * storage, if you choose to do so. If you choose not to store these events, Evidently deletes them after using
         * them to produce metrics and other experiment results that you can view.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProjectDataDeliveryConfig.Builder}
         * avoiding the need to create one manually via {@link ProjectDataDeliveryConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProjectDataDeliveryConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #dataDelivery(ProjectDataDeliveryConfig)}.
         * 
         * @param dataDelivery
         *        a consumer that will call methods on {@link ProjectDataDeliveryConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataDelivery(ProjectDataDeliveryConfig)
         */
        default Builder dataDelivery(Consumer<ProjectDataDeliveryConfig.Builder> dataDelivery) {
            return dataDelivery(ProjectDataDeliveryConfig.builder().applyMutation(dataDelivery).build());
        }

        /**
         * <p>
         * An optional description of the project.
         * </p>
         * 
         * @param description
         *        An optional description of the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name for the project.
         * </p>
         * 
         * @param name
         *        The name for the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Assigns one or more tags (key-value pairs) to the project.
         * </p>
         * <p>
         * Tags can help you organize and categorize your resources. You can also use them to scope user permissions by
         * granting a user permission to access or change only resources with certain tag values.
         * </p>
         * <p>
         * Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of
         * characters.
         * </p>
         * <p>
         * You can associate as many as 50 tags with a project.
         * </p>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging
         * Amazon Web Services resources</a>.
         * </p>
         * 
         * @param tags
         *        Assigns one or more tags (key-value pairs) to the project.</p>
         *        <p>
         *        Tags can help you organize and categorize your resources. You can also use them to scope user
         *        permissions by granting a user permission to access or change only resources with certain tag values.
         *        </p>
         *        <p>
         *        Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of
         *        characters.
         *        </p>
         *        <p>
         *        You can associate as many as 50 tags with a project.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         *        resources</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EvidentlyRequest.BuilderImpl implements Builder {
        private ProjectAppConfigResourceConfig appConfigResource;

        private ProjectDataDeliveryConfig dataDelivery;

        private String description;

        private String name;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProjectRequest model) {
            super(model);
            appConfigResource(model.appConfigResource);
            dataDelivery(model.dataDelivery);
            description(model.description);
            name(model.name);
            tags(model.tags);
        }

        public final ProjectAppConfigResourceConfig.Builder getAppConfigResource() {
            return appConfigResource != null ? appConfigResource.toBuilder() : null;
        }

        public final void setAppConfigResource(ProjectAppConfigResourceConfig.BuilderImpl appConfigResource) {
            this.appConfigResource = appConfigResource != null ? appConfigResource.build() : null;
        }

        @Override
        public final Builder appConfigResource(ProjectAppConfigResourceConfig appConfigResource) {
            this.appConfigResource = appConfigResource;
            return this;
        }

        public final ProjectDataDeliveryConfig.Builder getDataDelivery() {
            return dataDelivery != null ? dataDelivery.toBuilder() : null;
        }

        public final void setDataDelivery(ProjectDataDeliveryConfig.BuilderImpl dataDelivery) {
            this.dataDelivery = dataDelivery != null ? dataDelivery.build() : null;
        }

        @Override
        public final Builder dataDelivery(ProjectDataDeliveryConfig dataDelivery) {
            this.dataDelivery = dataDelivery;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateProjectRequest build() {
            return new CreateProjectRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
