/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.evidently.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.JsonValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This structure assigns a feature variation to one user session.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluationRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<EvaluationRequest.Builder, EvaluationRequest> {
    private static final SdkField<String> ENTITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entityId").getter(getter(EvaluationRequest::entityId)).setter(setter(Builder::entityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityId").build()).build();

    private static final SdkField<String> EVALUATION_CONTEXT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("evaluationContext")
            .getter(getter(EvaluationRequest::evaluationContext))
            .setter(setter(Builder::evaluationContext))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluationContext").build(),
                    JsonValueTrait.create()).build();

    private static final SdkField<String> FEATURE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("feature")
            .getter(getter(EvaluationRequest::feature)).setter(setter(Builder::feature))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("feature").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_ID_FIELD,
            EVALUATION_CONTEXT_FIELD, FEATURE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String entityId;

    private final String evaluationContext;

    private final String feature;

    private EvaluationRequest(BuilderImpl builder) {
        this.entityId = builder.entityId;
        this.evaluationContext = builder.evaluationContext;
        this.feature = builder.feature;
    }

    /**
     * <p>
     * An internal ID that represents a unique user session of the application. This <code>entityID</code> is checked
     * against any override rules assigned for this feature.
     * </p>
     * 
     * @return An internal ID that represents a unique user session of the application. This <code>entityID</code> is
     *         checked against any override rules assigned for this feature.
     */
    public final String entityId() {
        return entityId;
    }

    /**
     * <p>
     * A JSON block of attributes that you can optionally pass in. This JSON block is included in the evaluation events
     * sent to Evidently from the user session.
     * </p>
     * 
     * @return A JSON block of attributes that you can optionally pass in. This JSON block is included in the evaluation
     *         events sent to Evidently from the user session.
     */
    public final String evaluationContext() {
        return evaluationContext;
    }

    /**
     * <p>
     * The name of the feature being evaluated.
     * </p>
     * 
     * @return The name of the feature being evaluated.
     */
    public final String feature() {
        return feature;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(entityId());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationContext());
        hashCode = 31 * hashCode + Objects.hashCode(feature());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationRequest)) {
            return false;
        }
        EvaluationRequest other = (EvaluationRequest) obj;
        return Objects.equals(entityId(), other.entityId()) && Objects.equals(evaluationContext(), other.evaluationContext())
                && Objects.equals(feature(), other.feature());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluationRequest").add("EntityId", entityId()).add("EvaluationContext", evaluationContext())
                .add("Feature", feature()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "entityId":
            return Optional.ofNullable(clazz.cast(entityId()));
        case "evaluationContext":
            return Optional.ofNullable(clazz.cast(evaluationContext()));
        case "feature":
            return Optional.ofNullable(clazz.cast(feature()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("entityId", ENTITY_ID_FIELD);
        map.put("evaluationContext", EVALUATION_CONTEXT_FIELD);
        map.put("feature", FEATURE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationRequest, T> g) {
        return obj -> g.apply((EvaluationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluationRequest> {
        /**
         * <p>
         * An internal ID that represents a unique user session of the application. This <code>entityID</code> is
         * checked against any override rules assigned for this feature.
         * </p>
         * 
         * @param entityId
         *        An internal ID that represents a unique user session of the application. This <code>entityID</code> is
         *        checked against any override rules assigned for this feature.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityId(String entityId);

        /**
         * <p>
         * A JSON block of attributes that you can optionally pass in. This JSON block is included in the evaluation
         * events sent to Evidently from the user session.
         * </p>
         * 
         * @param evaluationContext
         *        A JSON block of attributes that you can optionally pass in. This JSON block is included in the
         *        evaluation events sent to Evidently from the user session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationContext(String evaluationContext);

        /**
         * <p>
         * The name of the feature being evaluated.
         * </p>
         * 
         * @param feature
         *        The name of the feature being evaluated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder feature(String feature);
    }

    static final class BuilderImpl implements Builder {
        private String entityId;

        private String evaluationContext;

        private String feature;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationRequest model) {
            entityId(model.entityId);
            evaluationContext(model.evaluationContext);
            feature(model.feature);
        }

        public final String getEntityId() {
            return entityId;
        }

        public final void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        @Override
        public final Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public final String getEvaluationContext() {
            return evaluationContext;
        }

        public final void setEvaluationContext(String evaluationContext) {
            this.evaluationContext = evaluationContext;
        }

        @Override
        public final Builder evaluationContext(String evaluationContext) {
            this.evaluationContext = evaluationContext;
            return this;
        }

        public final String getFeature() {
            return feature;
        }

        public final void setFeature(String feature) {
            this.feature = feature;
        }

        @Override
        public final Builder feature(String feature) {
            this.feature = feature;
            return this;
        }

        @Override
        public EvaluationRequest build() {
            return new EvaluationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
