/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.evidently.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetExperimentResponse extends EvidentlyResponse implements
        ToCopyableBuilder<GetExperimentResponse.Builder, GetExperimentResponse> {
    private static final SdkField<Experiment> EXPERIMENT_FIELD = SdkField.<Experiment> builder(MarshallingType.SDK_POJO)
            .memberName("experiment").getter(getter(GetExperimentResponse::experiment)).setter(setter(Builder::experiment))
            .constructor(Experiment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("experiment").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPERIMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Experiment experiment;

    private GetExperimentResponse(BuilderImpl builder) {
        super(builder);
        this.experiment = builder.experiment;
    }

    /**
     * <p>
     * A structure containing the configuration details of the experiment.
     * </p>
     * 
     * @return A structure containing the configuration details of the experiment.
     */
    public final Experiment experiment() {
        return experiment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(experiment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetExperimentResponse)) {
            return false;
        }
        GetExperimentResponse other = (GetExperimentResponse) obj;
        return Objects.equals(experiment(), other.experiment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetExperimentResponse").add("Experiment", experiment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "experiment":
            return Optional.ofNullable(clazz.cast(experiment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("experiment", EXPERIMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetExperimentResponse, T> g) {
        return obj -> g.apply((GetExperimentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EvidentlyResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetExperimentResponse> {
        /**
         * <p>
         * A structure containing the configuration details of the experiment.
         * </p>
         * 
         * @param experiment
         *        A structure containing the configuration details of the experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder experiment(Experiment experiment);

        /**
         * <p>
         * A structure containing the configuration details of the experiment.
         * </p>
         * This is a convenience method that creates an instance of the {@link Experiment.Builder} avoiding the need to
         * create one manually via {@link Experiment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Experiment.Builder#build()} is called immediately and its result
         * is passed to {@link #experiment(Experiment)}.
         * 
         * @param experiment
         *        a consumer that will call methods on {@link Experiment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #experiment(Experiment)
         */
        default Builder experiment(Consumer<Experiment.Builder> experiment) {
            return experiment(Experiment.builder().applyMutation(experiment).build());
        }
    }

    static final class BuilderImpl extends EvidentlyResponse.BuilderImpl implements Builder {
        private Experiment experiment;

        private BuilderImpl() {
        }

        private BuilderImpl(GetExperimentResponse model) {
            super(model);
            experiment(model.experiment);
        }

        public final Experiment.Builder getExperiment() {
            return experiment != null ? experiment.toBuilder() : null;
        }

        public final void setExperiment(Experiment.BuilderImpl experiment) {
            this.experiment = experiment != null ? experiment.build() : null;
        }

        @Override
        public final Builder experiment(Experiment experiment) {
            this.experiment = experiment;
            return this;
        }

        @Override
        public GetExperimentResponse build() {
            return new GetExperimentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
