/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.evidently.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.JsonValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This structure defines a metric that is being used to evaluate the variations during a launch or experiment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetricDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<MetricDefinition.Builder, MetricDefinition> {
    private static final SdkField<String> ENTITY_ID_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entityIdKey").getter(getter(MetricDefinition::entityIdKey)).setter(setter(Builder::entityIdKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityIdKey").build()).build();

    private static final SdkField<String> EVENT_PATTERN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("eventPattern")
            .getter(getter(MetricDefinition::eventPattern))
            .setter(setter(Builder::eventPattern))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventPattern").build(),
                    JsonValueTrait.create()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(MetricDefinition::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> UNIT_LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("unitLabel").getter(getter(MetricDefinition::unitLabel)).setter(setter(Builder::unitLabel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unitLabel").build()).build();

    private static final SdkField<String> VALUE_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("valueKey").getter(getter(MetricDefinition::valueKey)).setter(setter(Builder::valueKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("valueKey").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_ID_KEY_FIELD,
            EVENT_PATTERN_FIELD, NAME_FIELD, UNIT_LABEL_FIELD, VALUE_KEY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String entityIdKey;

    private final String eventPattern;

    private final String name;

    private final String unitLabel;

    private final String valueKey;

    private MetricDefinition(BuilderImpl builder) {
        this.entityIdKey = builder.entityIdKey;
        this.eventPattern = builder.eventPattern;
        this.name = builder.name;
        this.unitLabel = builder.unitLabel;
        this.valueKey = builder.valueKey;
    }

    /**
     * <p>
     * The entity, such as a user or session, that does an action that causes a metric value to be recorded.
     * </p>
     * 
     * @return The entity, such as a user or session, that does an action that causes a metric value to be recorded.
     */
    public final String entityIdKey() {
        return entityIdKey;
    }

    /**
     * <p>
     * The EventBridge event pattern that defines how the metric is recorded.
     * </p>
     * <p>
     * For more information about EventBridge event patterns, see <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-event-patterns.html">Amazon EventBridge event
     * patterns</a>.
     * </p>
     * 
     * @return The EventBridge event pattern that defines how the metric is recorded.</p>
     *         <p>
     *         For more information about EventBridge event patterns, see <a
     *         href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-event-patterns.html">Amazon EventBridge
     *         event patterns</a>.
     */
    public final String eventPattern() {
        return eventPattern;
    }

    /**
     * <p>
     * The name of the metric.
     * </p>
     * 
     * @return The name of the metric.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The label for the units that the metric is measuring.
     * </p>
     * 
     * @return The label for the units that the metric is measuring.
     */
    public final String unitLabel() {
        return unitLabel;
    }

    /**
     * <p>
     * The value that is tracked to produce the metric.
     * </p>
     * 
     * @return The value that is tracked to produce the metric.
     */
    public final String valueKey() {
        return valueKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(entityIdKey());
        hashCode = 31 * hashCode + Objects.hashCode(eventPattern());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(unitLabel());
        hashCode = 31 * hashCode + Objects.hashCode(valueKey());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricDefinition)) {
            return false;
        }
        MetricDefinition other = (MetricDefinition) obj;
        return Objects.equals(entityIdKey(), other.entityIdKey()) && Objects.equals(eventPattern(), other.eventPattern())
                && Objects.equals(name(), other.name()) && Objects.equals(unitLabel(), other.unitLabel())
                && Objects.equals(valueKey(), other.valueKey());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetricDefinition").add("EntityIdKey", entityIdKey()).add("EventPattern", eventPattern())
                .add("Name", name()).add("UnitLabel", unitLabel()).add("ValueKey", valueKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "entityIdKey":
            return Optional.ofNullable(clazz.cast(entityIdKey()));
        case "eventPattern":
            return Optional.ofNullable(clazz.cast(eventPattern()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "unitLabel":
            return Optional.ofNullable(clazz.cast(unitLabel()));
        case "valueKey":
            return Optional.ofNullable(clazz.cast(valueKey()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("entityIdKey", ENTITY_ID_KEY_FIELD);
        map.put("eventPattern", EVENT_PATTERN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("unitLabel", UNIT_LABEL_FIELD);
        map.put("valueKey", VALUE_KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetricDefinition, T> g) {
        return obj -> g.apply((MetricDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetricDefinition> {
        /**
         * <p>
         * The entity, such as a user or session, that does an action that causes a metric value to be recorded.
         * </p>
         * 
         * @param entityIdKey
         *        The entity, such as a user or session, that does an action that causes a metric value to be recorded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityIdKey(String entityIdKey);

        /**
         * <p>
         * The EventBridge event pattern that defines how the metric is recorded.
         * </p>
         * <p>
         * For more information about EventBridge event patterns, see <a
         * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-event-patterns.html">Amazon EventBridge
         * event patterns</a>.
         * </p>
         * 
         * @param eventPattern
         *        The EventBridge event pattern that defines how the metric is recorded.</p>
         *        <p>
         *        For more information about EventBridge event patterns, see <a
         *        href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-event-patterns.html">Amazon
         *        EventBridge event patterns</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventPattern(String eventPattern);

        /**
         * <p>
         * The name of the metric.
         * </p>
         * 
         * @param name
         *        The name of the metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The label for the units that the metric is measuring.
         * </p>
         * 
         * @param unitLabel
         *        The label for the units that the metric is measuring.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unitLabel(String unitLabel);

        /**
         * <p>
         * The value that is tracked to produce the metric.
         * </p>
         * 
         * @param valueKey
         *        The value that is tracked to produce the metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valueKey(String valueKey);
    }

    static final class BuilderImpl implements Builder {
        private String entityIdKey;

        private String eventPattern;

        private String name;

        private String unitLabel;

        private String valueKey;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricDefinition model) {
            entityIdKey(model.entityIdKey);
            eventPattern(model.eventPattern);
            name(model.name);
            unitLabel(model.unitLabel);
            valueKey(model.valueKey);
        }

        public final String getEntityIdKey() {
            return entityIdKey;
        }

        public final void setEntityIdKey(String entityIdKey) {
            this.entityIdKey = entityIdKey;
        }

        @Override
        public final Builder entityIdKey(String entityIdKey) {
            this.entityIdKey = entityIdKey;
            return this;
        }

        public final String getEventPattern() {
            return eventPattern;
        }

        public final void setEventPattern(String eventPattern) {
            this.eventPattern = eventPattern;
        }

        @Override
        public final Builder eventPattern(String eventPattern) {
            this.eventPattern = eventPattern;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getUnitLabel() {
            return unitLabel;
        }

        public final void setUnitLabel(String unitLabel) {
            this.unitLabel = unitLabel;
        }

        @Override
        public final Builder unitLabel(String unitLabel) {
            this.unitLabel = unitLabel;
            return this;
        }

        public final String getValueKey() {
            return valueKey;
        }

        public final void setValueKey(String valueKey) {
            this.valueKey = valueKey;
        }

        @Override
        public final Builder valueKey(String valueKey) {
            this.valueKey = valueKey;
            return this;
        }

        @Override
        public MetricDefinition build() {
            return new MetricDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
