/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.evidently.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StopExperimentRequest extends EvidentlyRequest implements
        ToCopyableBuilder<StopExperimentRequest.Builder, StopExperimentRequest> {
    private static final SdkField<String> DESIRED_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("desiredState").getter(getter(StopExperimentRequest::desiredStateAsString))
            .setter(setter(Builder::desiredState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desiredState").build()).build();

    private static final SdkField<String> EXPERIMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("experiment").getter(getter(StopExperimentRequest::experiment)).setter(setter(Builder::experiment))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("experiment").build()).build();

    private static final SdkField<String> PROJECT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("project")
            .getter(getter(StopExperimentRequest::project)).setter(setter(Builder::project))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("project").build()).build();

    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("reason")
            .getter(getter(StopExperimentRequest::reason)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESIRED_STATE_FIELD,
            EXPERIMENT_FIELD, PROJECT_FIELD, REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String desiredState;

    private final String experiment;

    private final String project;

    private final String reason;

    private StopExperimentRequest(BuilderImpl builder) {
        super(builder);
        this.desiredState = builder.desiredState;
        this.experiment = builder.experiment;
        this.project = builder.project;
        this.reason = builder.reason;
    }

    /**
     * <p>
     * Specify whether the experiment is to be considered <code>COMPLETED</code> or <code>CANCELLED</code> after it
     * stops.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #desiredState} will
     * return {@link ExperimentStopDesiredState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #desiredStateAsString}.
     * </p>
     * 
     * @return Specify whether the experiment is to be considered <code>COMPLETED</code> or <code>CANCELLED</code> after
     *         it stops.
     * @see ExperimentStopDesiredState
     */
    public final ExperimentStopDesiredState desiredState() {
        return ExperimentStopDesiredState.fromValue(desiredState);
    }

    /**
     * <p>
     * Specify whether the experiment is to be considered <code>COMPLETED</code> or <code>CANCELLED</code> after it
     * stops.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #desiredState} will
     * return {@link ExperimentStopDesiredState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #desiredStateAsString}.
     * </p>
     * 
     * @return Specify whether the experiment is to be considered <code>COMPLETED</code> or <code>CANCELLED</code> after
     *         it stops.
     * @see ExperimentStopDesiredState
     */
    public final String desiredStateAsString() {
        return desiredState;
    }

    /**
     * <p>
     * The name of the experiment to stop.
     * </p>
     * 
     * @return The name of the experiment to stop.
     */
    public final String experiment() {
        return experiment;
    }

    /**
     * <p>
     * The name or ARN of the project that contains the experiment to stop.
     * </p>
     * 
     * @return The name or ARN of the project that contains the experiment to stop.
     */
    public final String project() {
        return project;
    }

    /**
     * <p>
     * A string that describes why you are stopping the experiment.
     * </p>
     * 
     * @return A string that describes why you are stopping the experiment.
     */
    public final String reason() {
        return reason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(desiredStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(experiment());
        hashCode = 31 * hashCode + Objects.hashCode(project());
        hashCode = 31 * hashCode + Objects.hashCode(reason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopExperimentRequest)) {
            return false;
        }
        StopExperimentRequest other = (StopExperimentRequest) obj;
        return Objects.equals(desiredStateAsString(), other.desiredStateAsString())
                && Objects.equals(experiment(), other.experiment()) && Objects.equals(project(), other.project())
                && Objects.equals(reason(), other.reason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StopExperimentRequest").add("DesiredState", desiredStateAsString())
                .add("Experiment", experiment()).add("Project", project()).add("Reason", reason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "desiredState":
            return Optional.ofNullable(clazz.cast(desiredStateAsString()));
        case "experiment":
            return Optional.ofNullable(clazz.cast(experiment()));
        case "project":
            return Optional.ofNullable(clazz.cast(project()));
        case "reason":
            return Optional.ofNullable(clazz.cast(reason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("desiredState", DESIRED_STATE_FIELD);
        map.put("experiment", EXPERIMENT_FIELD);
        map.put("project", PROJECT_FIELD);
        map.put("reason", REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StopExperimentRequest, T> g) {
        return obj -> g.apply((StopExperimentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EvidentlyRequest.Builder, SdkPojo, CopyableBuilder<Builder, StopExperimentRequest> {
        /**
         * <p>
         * Specify whether the experiment is to be considered <code>COMPLETED</code> or <code>CANCELLED</code> after it
         * stops.
         * </p>
         * 
         * @param desiredState
         *        Specify whether the experiment is to be considered <code>COMPLETED</code> or <code>CANCELLED</code>
         *        after it stops.
         * @see ExperimentStopDesiredState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExperimentStopDesiredState
         */
        Builder desiredState(String desiredState);

        /**
         * <p>
         * Specify whether the experiment is to be considered <code>COMPLETED</code> or <code>CANCELLED</code> after it
         * stops.
         * </p>
         * 
         * @param desiredState
         *        Specify whether the experiment is to be considered <code>COMPLETED</code> or <code>CANCELLED</code>
         *        after it stops.
         * @see ExperimentStopDesiredState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExperimentStopDesiredState
         */
        Builder desiredState(ExperimentStopDesiredState desiredState);

        /**
         * <p>
         * The name of the experiment to stop.
         * </p>
         * 
         * @param experiment
         *        The name of the experiment to stop.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder experiment(String experiment);

        /**
         * <p>
         * The name or ARN of the project that contains the experiment to stop.
         * </p>
         * 
         * @param project
         *        The name or ARN of the project that contains the experiment to stop.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder project(String project);

        /**
         * <p>
         * A string that describes why you are stopping the experiment.
         * </p>
         * 
         * @param reason
         *        A string that describes why you are stopping the experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reason(String reason);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EvidentlyRequest.BuilderImpl implements Builder {
        private String desiredState;

        private String experiment;

        private String project;

        private String reason;

        private BuilderImpl() {
        }

        private BuilderImpl(StopExperimentRequest model) {
            super(model);
            desiredState(model.desiredState);
            experiment(model.experiment);
            project(model.project);
            reason(model.reason);
        }

        public final String getDesiredState() {
            return desiredState;
        }

        public final void setDesiredState(String desiredState) {
            this.desiredState = desiredState;
        }

        @Override
        public final Builder desiredState(String desiredState) {
            this.desiredState = desiredState;
            return this;
        }

        @Override
        public final Builder desiredState(ExperimentStopDesiredState desiredState) {
            this.desiredState(desiredState == null ? null : desiredState.toString());
            return this;
        }

        public final String getExperiment() {
            return experiment;
        }

        public final void setExperiment(String experiment) {
            this.experiment = experiment;
        }

        @Override
        public final Builder experiment(String experiment) {
            this.experiment = experiment;
            return this;
        }

        public final String getProject() {
            return project;
        }

        public final void setProject(String project) {
            this.project = project;
        }

        @Override
        public final Builder project(String project) {
            this.project = project;
            return this;
        }

        public final String getReason() {
            return reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StopExperimentRequest build() {
            return new StopExperimentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
