/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.evidently.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that defines one treatment in an experiment. A treatment is a variation of the feature that you are
 * including in the experiment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TreatmentConfig implements SdkPojo, Serializable, ToCopyableBuilder<TreatmentConfig.Builder, TreatmentConfig> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(TreatmentConfig::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> FEATURE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("feature")
            .getter(getter(TreatmentConfig::feature)).setter(setter(Builder::feature))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("feature").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(TreatmentConfig::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> VARIATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("variation").getter(getter(TreatmentConfig::variation)).setter(setter(Builder::variation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            FEATURE_FIELD, NAME_FIELD, VARIATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String description;

    private final String feature;

    private final String name;

    private final String variation;

    private TreatmentConfig(BuilderImpl builder) {
        this.description = builder.description;
        this.feature = builder.feature;
        this.name = builder.name;
        this.variation = builder.variation;
    }

    /**
     * <p>
     * A description for this treatment.
     * </p>
     * 
     * @return A description for this treatment.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The feature that this experiment is testing.
     * </p>
     * 
     * @return The feature that this experiment is testing.
     */
    public final String feature() {
        return feature;
    }

    /**
     * <p>
     * A name for this treatment.
     * </p>
     * 
     * @return A name for this treatment.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The name of the variation to use as this treatment in the experiment.
     * </p>
     * 
     * @return The name of the variation to use as this treatment in the experiment.
     */
    public final String variation() {
        return variation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(feature());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(variation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TreatmentConfig)) {
            return false;
        }
        TreatmentConfig other = (TreatmentConfig) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(feature(), other.feature())
                && Objects.equals(name(), other.name()) && Objects.equals(variation(), other.variation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TreatmentConfig").add("Description", description()).add("Feature", feature())
                .add("Name", name()).add("Variation", variation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "feature":
            return Optional.ofNullable(clazz.cast(feature()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "variation":
            return Optional.ofNullable(clazz.cast(variation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("description", DESCRIPTION_FIELD);
        map.put("feature", FEATURE_FIELD);
        map.put("name", NAME_FIELD);
        map.put("variation", VARIATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TreatmentConfig, T> g) {
        return obj -> g.apply((TreatmentConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TreatmentConfig> {
        /**
         * <p>
         * A description for this treatment.
         * </p>
         * 
         * @param description
         *        A description for this treatment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The feature that this experiment is testing.
         * </p>
         * 
         * @param feature
         *        The feature that this experiment is testing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder feature(String feature);

        /**
         * <p>
         * A name for this treatment.
         * </p>
         * 
         * @param name
         *        A name for this treatment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The name of the variation to use as this treatment in the experiment.
         * </p>
         * 
         * @param variation
         *        The name of the variation to use as this treatment in the experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder variation(String variation);
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private String feature;

        private String name;

        private String variation;

        private BuilderImpl() {
        }

        private BuilderImpl(TreatmentConfig model) {
            description(model.description);
            feature(model.feature);
            name(model.name);
            variation(model.variation);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getFeature() {
            return feature;
        }

        public final void setFeature(String feature) {
            this.feature = feature;
        }

        @Override
        public final Builder feature(String feature) {
            this.feature = feature;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getVariation() {
            return variation;
        }

        public final void setVariation(String variation) {
            this.variation = variation;
        }

        @Override
        public final Builder variation(String variation) {
            this.variation = variation;
            return this;
        }

        @Override
        public TreatmentConfig build() {
            return new TreatmentConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
