/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.evs.model.EnvironmentSummary;
import software.amazon.awssdk.services.evs.model.EnvironmentSummaryListCopier;
import software.amazon.awssdk.services.evs.model.EvsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEnvironmentsResponse
extends EvsResponse
implements ToCopyableBuilder<Builder, ListEnvironmentsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListEnvironmentsResponse.getter(ListEnvironmentsResponse::nextToken)).setter(ListEnvironmentsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<EnvironmentSummary>> ENVIRONMENT_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("environmentSummaries").getter(ListEnvironmentsResponse.getter(ListEnvironmentsResponse::environmentSummaries)).setter(ListEnvironmentsResponse.setter(Builder::environmentSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EnvironmentSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, ENVIRONMENT_SUMMARIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListEnvironmentsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<EnvironmentSummary> environmentSummaries;

    private ListEnvironmentsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.environmentSummaries = builder.environmentSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasEnvironmentSummaries() {
        return this.environmentSummaries != null && !(this.environmentSummaries instanceof SdkAutoConstructList);
    }

    public final List<EnvironmentSummary> environmentSummaries() {
        return this.environmentSummaries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnvironmentSummaries() ? this.environmentSummaries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEnvironmentsResponse)) {
            return false;
        }
        ListEnvironmentsResponse other = (ListEnvironmentsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasEnvironmentSummaries() == other.hasEnvironmentSummaries() && Objects.equals(this.environmentSummaries(), other.environmentSummaries());
    }

    public final String toString() {
        return ToString.builder((String)"ListEnvironmentsResponse").add("NextToken", (Object)this.nextToken()).add("EnvironmentSummaries", this.hasEnvironmentSummaries() ? this.environmentSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "environmentSummaries": {
                return Optional.ofNullable(clazz.cast(this.environmentSummaries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("environmentSummaries", ENVIRONMENT_SUMMARIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListEnvironmentsResponse, T> g) {
        return obj -> g.apply((ListEnvironmentsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EvsResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<EnvironmentSummary> environmentSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListEnvironmentsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.environmentSummaries(model.environmentSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<EnvironmentSummary.Builder> getEnvironmentSummaries() {
            List<EnvironmentSummary.Builder> result = EnvironmentSummaryListCopier.copyToBuilder(this.environmentSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEnvironmentSummaries(Collection<EnvironmentSummary.BuilderImpl> environmentSummaries) {
            this.environmentSummaries = EnvironmentSummaryListCopier.copyFromBuilder(environmentSummaries);
        }

        @Override
        public final Builder environmentSummaries(Collection<EnvironmentSummary> environmentSummaries) {
            this.environmentSummaries = EnvironmentSummaryListCopier.copy(environmentSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentSummaries(EnvironmentSummary ... environmentSummaries) {
            this.environmentSummaries(Arrays.asList(environmentSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentSummaries(Consumer<EnvironmentSummary.Builder> ... environmentSummaries) {
            this.environmentSummaries(Stream.of(environmentSummaries).map(c -> (EnvironmentSummary)((EnvironmentSummary.Builder)EnvironmentSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListEnvironmentsResponse build() {
            return new ListEnvironmentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends EvsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEnvironmentsResponse> {
        public Builder nextToken(String var1);

        public Builder environmentSummaries(Collection<EnvironmentSummary> var1);

        public Builder environmentSummaries(EnvironmentSummary ... var1);

        public Builder environmentSummaries(Consumer<EnvironmentSummary.Builder> ... var1);
    }
}

