/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.evs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEnvironmentHostsResponse extends EvsResponse implements
        ToCopyableBuilder<ListEnvironmentHostsResponse.Builder, ListEnvironmentHostsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListEnvironmentHostsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<Host>> ENVIRONMENT_HOSTS_FIELD = SdkField
            .<List<Host>> builder(MarshallingType.LIST)
            .memberName("environmentHosts")
            .getter(getter(ListEnvironmentHostsResponse::environmentHosts))
            .setter(setter(Builder::environmentHosts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentHosts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Host> builder(MarshallingType.SDK_POJO)
                                            .constructor(Host::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            ENVIRONMENT_HOSTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<Host> environmentHosts;

    private ListEnvironmentHostsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.environmentHosts = builder.environmentHosts;
    }

    /**
     * <p>
     * A unique pagination token for next page results. Make the call again using this token to retrieve the next page.
     * </p>
     * 
     * @return A unique pagination token for next page results. Make the call again using this token to retrieve the
     *         next page.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the EnvironmentHosts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEnvironmentHosts() {
        return environmentHosts != null && !(environmentHosts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of hosts in the environment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnvironmentHosts} method.
     * </p>
     * 
     * @return A list of hosts in the environment.
     */
    public final List<Host> environmentHosts() {
        return environmentHosts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasEnvironmentHosts() ? environmentHosts() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEnvironmentHostsResponse)) {
            return false;
        }
        ListEnvironmentHostsResponse other = (ListEnvironmentHostsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasEnvironmentHosts() == other.hasEnvironmentHosts()
                && Objects.equals(environmentHosts(), other.environmentHosts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListEnvironmentHostsResponse").add("NextToken", nextToken())
                .add("EnvironmentHosts", hasEnvironmentHosts() ? environmentHosts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "environmentHosts":
            return Optional.ofNullable(clazz.cast(environmentHosts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("environmentHosts", ENVIRONMENT_HOSTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListEnvironmentHostsResponse, T> g) {
        return obj -> g.apply((ListEnvironmentHostsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EvsResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListEnvironmentHostsResponse> {
        /**
         * <p>
         * A unique pagination token for next page results. Make the call again using this token to retrieve the next
         * page.
         * </p>
         * 
         * @param nextToken
         *        A unique pagination token for next page results. Make the call again using this token to retrieve the
         *        next page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of hosts in the environment.
         * </p>
         * 
         * @param environmentHosts
         *        A list of hosts in the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentHosts(Collection<Host> environmentHosts);

        /**
         * <p>
         * A list of hosts in the environment.
         * </p>
         * 
         * @param environmentHosts
         *        A list of hosts in the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentHosts(Host... environmentHosts);

        /**
         * <p>
         * A list of hosts in the environment.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.evs.model.Host.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.evs.model.Host#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.evs.model.Host.Builder#build()}
         * is called immediately and its result is passed to {@link #environmentHosts(List<Host>)}.
         * 
         * @param environmentHosts
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.evs.model.Host.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #environmentHosts(java.util.Collection<Host>)
         */
        Builder environmentHosts(Consumer<Host.Builder>... environmentHosts);
    }

    static final class BuilderImpl extends EvsResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<Host> environmentHosts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListEnvironmentHostsResponse model) {
            super(model);
            nextToken(model.nextToken);
            environmentHosts(model.environmentHosts);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<Host.Builder> getEnvironmentHosts() {
            List<Host.Builder> result = HostListCopier.copyToBuilder(this.environmentHosts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEnvironmentHosts(Collection<Host.BuilderImpl> environmentHosts) {
            this.environmentHosts = HostListCopier.copyFromBuilder(environmentHosts);
        }

        @Override
        public final Builder environmentHosts(Collection<Host> environmentHosts) {
            this.environmentHosts = HostListCopier.copy(environmentHosts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentHosts(Host... environmentHosts) {
            environmentHosts(Arrays.asList(environmentHosts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentHosts(Consumer<Host.Builder>... environmentHosts) {
            environmentHosts(Stream.of(environmentHosts).map(c -> Host.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListEnvironmentHostsResponse build() {
            return new ListEnvironmentHostsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
