/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.evs.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The VLANs that Amazon EVS creates during environment creation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Vlan implements SdkPojo, Serializable, ToCopyableBuilder<Vlan.Builder, Vlan> {
    private static final SdkField<Integer> VLAN_ID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("vlanId").getter(getter(Vlan::vlanId)).setter(setter(Builder::vlanId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vlanId").build()).build();

    private static final SdkField<String> CIDR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("cidr")
            .getter(getter(Vlan::cidr)).setter(setter(Builder::cidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cidr").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("availabilityZone").getter(getter(Vlan::availabilityZone)).setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()).build();

    private static final SdkField<String> FUNCTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("functionName").getter(getter(Vlan::functionName)).setter(setter(Builder::functionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("functionName").build()).build();

    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("subnetId").getter(getter(Vlan::subnetId)).setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnetId").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(Vlan::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("modifiedAt").getter(getter(Vlan::modifiedAt)).setter(setter(Builder::modifiedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifiedAt").build()).build();

    private static final SdkField<String> VLAN_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vlanState").getter(getter(Vlan::vlanStateAsString)).setter(setter(Builder::vlanState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vlanState").build()).build();

    private static final SdkField<String> STATE_DETAILS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stateDetails").getter(getter(Vlan::stateDetails)).setter(setter(Builder::stateDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VLAN_ID_FIELD, CIDR_FIELD,
            AVAILABILITY_ZONE_FIELD, FUNCTION_NAME_FIELD, SUBNET_ID_FIELD, CREATED_AT_FIELD, MODIFIED_AT_FIELD, VLAN_STATE_FIELD,
            STATE_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer vlanId;

    private final String cidr;

    private final String availabilityZone;

    private final String functionName;

    private final String subnetId;

    private final Instant createdAt;

    private final Instant modifiedAt;

    private final String vlanState;

    private final String stateDetails;

    private Vlan(BuilderImpl builder) {
        this.vlanId = builder.vlanId;
        this.cidr = builder.cidr;
        this.availabilityZone = builder.availabilityZone;
        this.functionName = builder.functionName;
        this.subnetId = builder.subnetId;
        this.createdAt = builder.createdAt;
        this.modifiedAt = builder.modifiedAt;
        this.vlanState = builder.vlanState;
        this.stateDetails = builder.stateDetails;
    }

    /**
     * <p>
     * The unique ID of the VLAN.
     * </p>
     * 
     * @return The unique ID of the VLAN.
     */
    public final Integer vlanId() {
        return vlanId;
    }

    /**
     * <p>
     * The CIDR block of the VLAN. Amazon EVS VLAN subnets have a minimum CIDR block size of /28 and a maximum size of
     * /24.
     * </p>
     * 
     * @return The CIDR block of the VLAN. Amazon EVS VLAN subnets have a minimum CIDR block size of /28 and a maximum
     *         size of /24.
     */
    public final String cidr() {
        return cidr;
    }

    /**
     * <p>
     * The availability zone of the VLAN.
     * </p>
     * 
     * @return The availability zone of the VLAN.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The VMware VCF traffic type that is carried over the VLAN. For example, a VLAN with a <code>functionName</code>
     * of <code>hcx</code> is being used to carry VMware HCX traffic.
     * </p>
     * 
     * @return The VMware VCF traffic type that is carried over the VLAN. For example, a VLAN with a
     *         <code>functionName</code> of <code>hcx</code> is being used to carry VMware HCX traffic.
     */
    public final String functionName() {
        return functionName;
    }

    /**
     * <p>
     * The unique ID of the VLAN subnet.
     * </p>
     * 
     * @return The unique ID of the VLAN subnet.
     */
    public final String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * The date and time that the VLAN was created.
     * </p>
     * 
     * @return The date and time that the VLAN was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The date and time that the VLAN was modified.
     * </p>
     * 
     * @return The date and time that the VLAN was modified.
     */
    public final Instant modifiedAt() {
        return modifiedAt;
    }

    /**
     * <p>
     * The state of the VLAN.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vlanState} will
     * return {@link VlanState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #vlanStateAsString}.
     * </p>
     * 
     * @return The state of the VLAN.
     * @see VlanState
     */
    public final VlanState vlanState() {
        return VlanState.fromValue(vlanState);
    }

    /**
     * <p>
     * The state of the VLAN.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vlanState} will
     * return {@link VlanState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #vlanStateAsString}.
     * </p>
     * 
     * @return The state of the VLAN.
     * @see VlanState
     */
    public final String vlanStateAsString() {
        return vlanState;
    }

    /**
     * <p>
     * The state details of the VLAN.
     * </p>
     * 
     * @return The state details of the VLAN.
     */
    public final String stateDetails() {
        return stateDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vlanId());
        hashCode = 31 * hashCode + Objects.hashCode(cidr());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(functionName());
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(modifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(vlanStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Vlan)) {
            return false;
        }
        Vlan other = (Vlan) obj;
        return Objects.equals(vlanId(), other.vlanId()) && Objects.equals(cidr(), other.cidr())
                && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(functionName(), other.functionName()) && Objects.equals(subnetId(), other.subnetId())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(modifiedAt(), other.modifiedAt())
                && Objects.equals(vlanStateAsString(), other.vlanStateAsString())
                && Objects.equals(stateDetails(), other.stateDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Vlan").add("VlanId", vlanId()).add("Cidr", cidr()).add("AvailabilityZone", availabilityZone())
                .add("FunctionName", functionName()).add("SubnetId", subnetId()).add("CreatedAt", createdAt())
                .add("ModifiedAt", modifiedAt()).add("VlanState", vlanStateAsString()).add("StateDetails", stateDetails())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "vlanId":
            return Optional.ofNullable(clazz.cast(vlanId()));
        case "cidr":
            return Optional.ofNullable(clazz.cast(cidr()));
        case "availabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "functionName":
            return Optional.ofNullable(clazz.cast(functionName()));
        case "subnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "modifiedAt":
            return Optional.ofNullable(clazz.cast(modifiedAt()));
        case "vlanState":
            return Optional.ofNullable(clazz.cast(vlanStateAsString()));
        case "stateDetails":
            return Optional.ofNullable(clazz.cast(stateDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("vlanId", VLAN_ID_FIELD);
        map.put("cidr", CIDR_FIELD);
        map.put("availabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("functionName", FUNCTION_NAME_FIELD);
        map.put("subnetId", SUBNET_ID_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("modifiedAt", MODIFIED_AT_FIELD);
        map.put("vlanState", VLAN_STATE_FIELD);
        map.put("stateDetails", STATE_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Vlan, T> g) {
        return obj -> g.apply((Vlan) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Vlan> {
        /**
         * <p>
         * The unique ID of the VLAN.
         * </p>
         * 
         * @param vlanId
         *        The unique ID of the VLAN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vlanId(Integer vlanId);

        /**
         * <p>
         * The CIDR block of the VLAN. Amazon EVS VLAN subnets have a minimum CIDR block size of /28 and a maximum size
         * of /24.
         * </p>
         * 
         * @param cidr
         *        The CIDR block of the VLAN. Amazon EVS VLAN subnets have a minimum CIDR block size of /28 and a
         *        maximum size of /24.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidr(String cidr);

        /**
         * <p>
         * The availability zone of the VLAN.
         * </p>
         * 
         * @param availabilityZone
         *        The availability zone of the VLAN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The VMware VCF traffic type that is carried over the VLAN. For example, a VLAN with a
         * <code>functionName</code> of <code>hcx</code> is being used to carry VMware HCX traffic.
         * </p>
         * 
         * @param functionName
         *        The VMware VCF traffic type that is carried over the VLAN. For example, a VLAN with a
         *        <code>functionName</code> of <code>hcx</code> is being used to carry VMware HCX traffic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionName(String functionName);

        /**
         * <p>
         * The unique ID of the VLAN subnet.
         * </p>
         * 
         * @param subnetId
         *        The unique ID of the VLAN subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * The date and time that the VLAN was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time that the VLAN was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The date and time that the VLAN was modified.
         * </p>
         * 
         * @param modifiedAt
         *        The date and time that the VLAN was modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modifiedAt(Instant modifiedAt);

        /**
         * <p>
         * The state of the VLAN.
         * </p>
         * 
         * @param vlanState
         *        The state of the VLAN.
         * @see VlanState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VlanState
         */
        Builder vlanState(String vlanState);

        /**
         * <p>
         * The state of the VLAN.
         * </p>
         * 
         * @param vlanState
         *        The state of the VLAN.
         * @see VlanState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VlanState
         */
        Builder vlanState(VlanState vlanState);

        /**
         * <p>
         * The state details of the VLAN.
         * </p>
         * 
         * @param stateDetails
         *        The state details of the VLAN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateDetails(String stateDetails);
    }

    static final class BuilderImpl implements Builder {
        private Integer vlanId;

        private String cidr;

        private String availabilityZone;

        private String functionName;

        private String subnetId;

        private Instant createdAt;

        private Instant modifiedAt;

        private String vlanState;

        private String stateDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(Vlan model) {
            vlanId(model.vlanId);
            cidr(model.cidr);
            availabilityZone(model.availabilityZone);
            functionName(model.functionName);
            subnetId(model.subnetId);
            createdAt(model.createdAt);
            modifiedAt(model.modifiedAt);
            vlanState(model.vlanState);
            stateDetails(model.stateDetails);
        }

        public final Integer getVlanId() {
            return vlanId;
        }

        public final void setVlanId(Integer vlanId) {
            this.vlanId = vlanId;
        }

        @Override
        public final Builder vlanId(Integer vlanId) {
            this.vlanId = vlanId;
            return this;
        }

        public final String getCidr() {
            return cidr;
        }

        public final void setCidr(String cidr) {
            this.cidr = cidr;
        }

        @Override
        public final Builder cidr(String cidr) {
            this.cidr = cidr;
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getFunctionName() {
            return functionName;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getModifiedAt() {
            return modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public final String getVlanState() {
            return vlanState;
        }

        public final void setVlanState(String vlanState) {
            this.vlanState = vlanState;
        }

        @Override
        public final Builder vlanState(String vlanState) {
            this.vlanState = vlanState;
            return this;
        }

        @Override
        public final Builder vlanState(VlanState vlanState) {
            this.vlanState(vlanState == null ? null : vlanState.toString());
            return this;
        }

        public final String getStateDetails() {
            return stateDetails;
        }

        public final void setStateDetails(String stateDetails) {
            this.stateDetails = stateDetails;
        }

        @Override
        public final Builder stateDetails(String stateDetails) {
            this.stateDetails = stateDetails;
            return this;
        }

        @Override
        public Vlan build() {
            return new Vlan(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
