/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evs;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.evs.DefaultEvsClientBuilder;
import software.amazon.awssdk.services.evs.EvsClientBuilder;
import software.amazon.awssdk.services.evs.EvsServiceClientConfiguration;
import software.amazon.awssdk.services.evs.model.CreateEnvironmentHostRequest;
import software.amazon.awssdk.services.evs.model.CreateEnvironmentHostResponse;
import software.amazon.awssdk.services.evs.model.CreateEnvironmentRequest;
import software.amazon.awssdk.services.evs.model.CreateEnvironmentResponse;
import software.amazon.awssdk.services.evs.model.DeleteEnvironmentHostRequest;
import software.amazon.awssdk.services.evs.model.DeleteEnvironmentHostResponse;
import software.amazon.awssdk.services.evs.model.DeleteEnvironmentRequest;
import software.amazon.awssdk.services.evs.model.DeleteEnvironmentResponse;
import software.amazon.awssdk.services.evs.model.EvsException;
import software.amazon.awssdk.services.evs.model.GetEnvironmentRequest;
import software.amazon.awssdk.services.evs.model.GetEnvironmentResponse;
import software.amazon.awssdk.services.evs.model.ListEnvironmentHostsRequest;
import software.amazon.awssdk.services.evs.model.ListEnvironmentHostsResponse;
import software.amazon.awssdk.services.evs.model.ListEnvironmentVlansRequest;
import software.amazon.awssdk.services.evs.model.ListEnvironmentVlansResponse;
import software.amazon.awssdk.services.evs.model.ListEnvironmentsRequest;
import software.amazon.awssdk.services.evs.model.ListEnvironmentsResponse;
import software.amazon.awssdk.services.evs.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.evs.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.evs.model.ResourceNotFoundException;
import software.amazon.awssdk.services.evs.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.evs.model.TagPolicyException;
import software.amazon.awssdk.services.evs.model.TagResourceRequest;
import software.amazon.awssdk.services.evs.model.TagResourceResponse;
import software.amazon.awssdk.services.evs.model.ThrottlingException;
import software.amazon.awssdk.services.evs.model.TooManyTagsException;
import software.amazon.awssdk.services.evs.model.UntagResourceRequest;
import software.amazon.awssdk.services.evs.model.UntagResourceResponse;
import software.amazon.awssdk.services.evs.model.ValidationException;
import software.amazon.awssdk.services.evs.paginators.ListEnvironmentHostsIterable;
import software.amazon.awssdk.services.evs.paginators.ListEnvironmentVlansIterable;
import software.amazon.awssdk.services.evs.paginators.ListEnvironmentsIterable;

@SdkPublicApi
@ThreadSafe
public interface EvsClient
extends AwsClient {
    public static final String SERVICE_NAME = "evs";
    public static final String SERVICE_METADATA_ID = "evs";

    default public CreateEnvironmentResponse createEnvironment(CreateEnvironmentRequest createEnvironmentRequest) throws ValidationException, AwsServiceException, SdkClientException, EvsException {
        throw new UnsupportedOperationException();
    }

    default public CreateEnvironmentResponse createEnvironment(Consumer<CreateEnvironmentRequest.Builder> createEnvironmentRequest) throws ValidationException, AwsServiceException, SdkClientException, EvsException {
        return this.createEnvironment((CreateEnvironmentRequest)((Object)((CreateEnvironmentRequest.Builder)CreateEnvironmentRequest.builder().applyMutation(createEnvironmentRequest)).build()));
    }

    default public CreateEnvironmentHostResponse createEnvironmentHost(CreateEnvironmentHostRequest createEnvironmentHostRequest) throws ThrottlingException, ValidationException, AwsServiceException, SdkClientException, EvsException {
        throw new UnsupportedOperationException();
    }

    default public CreateEnvironmentHostResponse createEnvironmentHost(Consumer<CreateEnvironmentHostRequest.Builder> createEnvironmentHostRequest) throws ThrottlingException, ValidationException, AwsServiceException, SdkClientException, EvsException {
        return this.createEnvironmentHost((CreateEnvironmentHostRequest)((Object)((CreateEnvironmentHostRequest.Builder)CreateEnvironmentHostRequest.builder().applyMutation(createEnvironmentHostRequest)).build()));
    }

    default public DeleteEnvironmentResponse deleteEnvironment(DeleteEnvironmentRequest deleteEnvironmentRequest) throws ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, EvsException {
        throw new UnsupportedOperationException();
    }

    default public DeleteEnvironmentResponse deleteEnvironment(Consumer<DeleteEnvironmentRequest.Builder> deleteEnvironmentRequest) throws ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, EvsException {
        return this.deleteEnvironment((DeleteEnvironmentRequest)((Object)((DeleteEnvironmentRequest.Builder)DeleteEnvironmentRequest.builder().applyMutation(deleteEnvironmentRequest)).build()));
    }

    default public DeleteEnvironmentHostResponse deleteEnvironmentHost(DeleteEnvironmentHostRequest deleteEnvironmentHostRequest) throws ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, EvsException {
        throw new UnsupportedOperationException();
    }

    default public DeleteEnvironmentHostResponse deleteEnvironmentHost(Consumer<DeleteEnvironmentHostRequest.Builder> deleteEnvironmentHostRequest) throws ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, EvsException {
        return this.deleteEnvironmentHost((DeleteEnvironmentHostRequest)((Object)((DeleteEnvironmentHostRequest.Builder)DeleteEnvironmentHostRequest.builder().applyMutation(deleteEnvironmentHostRequest)).build()));
    }

    default public GetEnvironmentResponse getEnvironment(GetEnvironmentRequest getEnvironmentRequest) throws ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, EvsException {
        throw new UnsupportedOperationException();
    }

    default public GetEnvironmentResponse getEnvironment(Consumer<GetEnvironmentRequest.Builder> getEnvironmentRequest) throws ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, EvsException {
        return this.getEnvironment((GetEnvironmentRequest)((Object)((GetEnvironmentRequest.Builder)GetEnvironmentRequest.builder().applyMutation(getEnvironmentRequest)).build()));
    }

    default public ListEnvironmentHostsResponse listEnvironmentHosts(ListEnvironmentHostsRequest listEnvironmentHostsRequest) throws ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, EvsException {
        throw new UnsupportedOperationException();
    }

    default public ListEnvironmentHostsResponse listEnvironmentHosts(Consumer<ListEnvironmentHostsRequest.Builder> listEnvironmentHostsRequest) throws ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, EvsException {
        return this.listEnvironmentHosts((ListEnvironmentHostsRequest)((Object)((ListEnvironmentHostsRequest.Builder)ListEnvironmentHostsRequest.builder().applyMutation(listEnvironmentHostsRequest)).build()));
    }

    default public ListEnvironmentHostsIterable listEnvironmentHostsPaginator(ListEnvironmentHostsRequest listEnvironmentHostsRequest) throws ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, EvsException {
        return new ListEnvironmentHostsIterable(this, listEnvironmentHostsRequest);
    }

    default public ListEnvironmentHostsIterable listEnvironmentHostsPaginator(Consumer<ListEnvironmentHostsRequest.Builder> listEnvironmentHostsRequest) throws ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, EvsException {
        return this.listEnvironmentHostsPaginator((ListEnvironmentHostsRequest)((Object)((ListEnvironmentHostsRequest.Builder)ListEnvironmentHostsRequest.builder().applyMutation(listEnvironmentHostsRequest)).build()));
    }

    default public ListEnvironmentVlansResponse listEnvironmentVlans(ListEnvironmentVlansRequest listEnvironmentVlansRequest) throws ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, EvsException {
        throw new UnsupportedOperationException();
    }

    default public ListEnvironmentVlansResponse listEnvironmentVlans(Consumer<ListEnvironmentVlansRequest.Builder> listEnvironmentVlansRequest) throws ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, EvsException {
        return this.listEnvironmentVlans((ListEnvironmentVlansRequest)((Object)((ListEnvironmentVlansRequest.Builder)ListEnvironmentVlansRequest.builder().applyMutation(listEnvironmentVlansRequest)).build()));
    }

    default public ListEnvironmentVlansIterable listEnvironmentVlansPaginator(ListEnvironmentVlansRequest listEnvironmentVlansRequest) throws ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, EvsException {
        return new ListEnvironmentVlansIterable(this, listEnvironmentVlansRequest);
    }

    default public ListEnvironmentVlansIterable listEnvironmentVlansPaginator(Consumer<ListEnvironmentVlansRequest.Builder> listEnvironmentVlansRequest) throws ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, EvsException {
        return this.listEnvironmentVlansPaginator((ListEnvironmentVlansRequest)((Object)((ListEnvironmentVlansRequest.Builder)ListEnvironmentVlansRequest.builder().applyMutation(listEnvironmentVlansRequest)).build()));
    }

    default public ListEnvironmentsResponse listEnvironments(ListEnvironmentsRequest listEnvironmentsRequest) throws ValidationException, AwsServiceException, SdkClientException, EvsException {
        throw new UnsupportedOperationException();
    }

    default public ListEnvironmentsResponse listEnvironments(Consumer<ListEnvironmentsRequest.Builder> listEnvironmentsRequest) throws ValidationException, AwsServiceException, SdkClientException, EvsException {
        return this.listEnvironments((ListEnvironmentsRequest)((Object)((ListEnvironmentsRequest.Builder)ListEnvironmentsRequest.builder().applyMutation(listEnvironmentsRequest)).build()));
    }

    default public ListEnvironmentsIterable listEnvironmentsPaginator(ListEnvironmentsRequest listEnvironmentsRequest) throws ValidationException, AwsServiceException, SdkClientException, EvsException {
        return new ListEnvironmentsIterable(this, listEnvironmentsRequest);
    }

    default public ListEnvironmentsIterable listEnvironmentsPaginator(Consumer<ListEnvironmentsRequest.Builder> listEnvironmentsRequest) throws ValidationException, AwsServiceException, SdkClientException, EvsException {
        return this.listEnvironmentsPaginator((ListEnvironmentsRequest)((Object)((ListEnvironmentsRequest.Builder)ListEnvironmentsRequest.builder().applyMutation(listEnvironmentsRequest)).build()));
    }

    default public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, EvsException {
        throw new UnsupportedOperationException();
    }

    default public ListTagsForResourceResponse listTagsForResource(Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, EvsException {
        return this.listTagsForResource((ListTagsForResourceRequest)((Object)((ListTagsForResourceRequest.Builder)ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)).build()));
    }

    default public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ServiceQuotaExceededException, ResourceNotFoundException, TooManyTagsException, TagPolicyException, AwsServiceException, SdkClientException, EvsException {
        throw new UnsupportedOperationException();
    }

    default public TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws ServiceQuotaExceededException, ResourceNotFoundException, TooManyTagsException, TagPolicyException, AwsServiceException, SdkClientException, EvsException {
        return this.tagResource((TagResourceRequest)((Object)((TagResourceRequest.Builder)TagResourceRequest.builder().applyMutation(tagResourceRequest)).build()));
    }

    default public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException, TagPolicyException, AwsServiceException, SdkClientException, EvsException {
        throw new UnsupportedOperationException();
    }

    default public UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) throws ResourceNotFoundException, TagPolicyException, AwsServiceException, SdkClientException, EvsException {
        return this.untagResource((UntagResourceRequest)((Object)((UntagResourceRequest.Builder)UntagResourceRequest.builder().applyMutation(untagResourceRequest)).build()));
    }

    public static EvsClient create() {
        return (EvsClient)EvsClient.builder().build();
    }

    public static EvsClientBuilder builder() {
        return new DefaultEvsClientBuilder();
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)"evs");
    }

    default public EvsServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}

