/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.evs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The initial VLAN subnets for the environment. Amazon EVS VLAN subnets have a minimum CIDR block size of /28 and a
 * maximum size of /24. Amazon EVS VLAN subnet CIDR blocks must not overlap with other subnets in the VPC.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InitialVlans implements SdkPojo, Serializable, ToCopyableBuilder<InitialVlans.Builder, InitialVlans> {
    private static final SdkField<InitialVlanInfo> VMK_MANAGEMENT_FIELD = SdkField
            .<InitialVlanInfo> builder(MarshallingType.SDK_POJO).memberName("vmkManagement")
            .getter(getter(InitialVlans::vmkManagement)).setter(setter(Builder::vmkManagement))
            .constructor(InitialVlanInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vmkManagement").build()).build();

    private static final SdkField<InitialVlanInfo> VM_MANAGEMENT_FIELD = SdkField
            .<InitialVlanInfo> builder(MarshallingType.SDK_POJO).memberName("vmManagement")
            .getter(getter(InitialVlans::vmManagement)).setter(setter(Builder::vmManagement))
            .constructor(InitialVlanInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vmManagement").build()).build();

    private static final SdkField<InitialVlanInfo> V_MOTION_FIELD = SdkField.<InitialVlanInfo> builder(MarshallingType.SDK_POJO)
            .memberName("vMotion").getter(getter(InitialVlans::vMotion)).setter(setter(Builder::vMotion))
            .constructor(InitialVlanInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vMotion").build()).build();

    private static final SdkField<InitialVlanInfo> V_SAN_FIELD = SdkField.<InitialVlanInfo> builder(MarshallingType.SDK_POJO)
            .memberName("vSan").getter(getter(InitialVlans::vSan)).setter(setter(Builder::vSan))
            .constructor(InitialVlanInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vSan").build()).build();

    private static final SdkField<InitialVlanInfo> V_TEP_FIELD = SdkField.<InitialVlanInfo> builder(MarshallingType.SDK_POJO)
            .memberName("vTep").getter(getter(InitialVlans::vTep)).setter(setter(Builder::vTep))
            .constructor(InitialVlanInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vTep").build()).build();

    private static final SdkField<InitialVlanInfo> EDGE_V_TEP_FIELD = SdkField
            .<InitialVlanInfo> builder(MarshallingType.SDK_POJO).memberName("edgeVTep").getter(getter(InitialVlans::edgeVTep))
            .setter(setter(Builder::edgeVTep)).constructor(InitialVlanInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("edgeVTep").build()).build();

    private static final SdkField<InitialVlanInfo> NSX_UPLINK_FIELD = SdkField
            .<InitialVlanInfo> builder(MarshallingType.SDK_POJO).memberName("nsxUplink").getter(getter(InitialVlans::nsxUplink))
            .setter(setter(Builder::nsxUplink)).constructor(InitialVlanInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsxUplink").build()).build();

    private static final SdkField<InitialVlanInfo> HCX_FIELD = SdkField.<InitialVlanInfo> builder(MarshallingType.SDK_POJO)
            .memberName("hcx").getter(getter(InitialVlans::hcx)).setter(setter(Builder::hcx))
            .constructor(InitialVlanInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hcx").build()).build();

    private static final SdkField<InitialVlanInfo> EXPANSION_VLAN1_FIELD = SdkField
            .<InitialVlanInfo> builder(MarshallingType.SDK_POJO).memberName("expansionVlan1")
            .getter(getter(InitialVlans::expansionVlan1)).setter(setter(Builder::expansionVlan1))
            .constructor(InitialVlanInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expansionVlan1").build()).build();

    private static final SdkField<InitialVlanInfo> EXPANSION_VLAN2_FIELD = SdkField
            .<InitialVlanInfo> builder(MarshallingType.SDK_POJO).memberName("expansionVlan2")
            .getter(getter(InitialVlans::expansionVlan2)).setter(setter(Builder::expansionVlan2))
            .constructor(InitialVlanInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expansionVlan2").build()).build();

    private static final SdkField<Boolean> IS_HCX_PUBLIC_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isHcxPublic").getter(getter(InitialVlans::isHcxPublic)).setter(setter(Builder::isHcxPublic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isHcxPublic").build()).build();

    private static final SdkField<String> HCX_NETWORK_ACL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("hcxNetworkAclId").getter(getter(InitialVlans::hcxNetworkAclId)).setter(setter(Builder::hcxNetworkAclId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hcxNetworkAclId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VMK_MANAGEMENT_FIELD,
            VM_MANAGEMENT_FIELD, V_MOTION_FIELD, V_SAN_FIELD, V_TEP_FIELD, EDGE_V_TEP_FIELD, NSX_UPLINK_FIELD, HCX_FIELD,
            EXPANSION_VLAN1_FIELD, EXPANSION_VLAN2_FIELD, IS_HCX_PUBLIC_FIELD, HCX_NETWORK_ACL_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final InitialVlanInfo vmkManagement;

    private final InitialVlanInfo vmManagement;

    private final InitialVlanInfo vMotion;

    private final InitialVlanInfo vSan;

    private final InitialVlanInfo vTep;

    private final InitialVlanInfo edgeVTep;

    private final InitialVlanInfo nsxUplink;

    private final InitialVlanInfo hcx;

    private final InitialVlanInfo expansionVlan1;

    private final InitialVlanInfo expansionVlan2;

    private final Boolean isHcxPublic;

    private final String hcxNetworkAclId;

    private InitialVlans(BuilderImpl builder) {
        this.vmkManagement = builder.vmkManagement;
        this.vmManagement = builder.vmManagement;
        this.vMotion = builder.vMotion;
        this.vSan = builder.vSan;
        this.vTep = builder.vTep;
        this.edgeVTep = builder.edgeVTep;
        this.nsxUplink = builder.nsxUplink;
        this.hcx = builder.hcx;
        this.expansionVlan1 = builder.expansionVlan1;
        this.expansionVlan2 = builder.expansionVlan2;
        this.isHcxPublic = builder.isHcxPublic;
        this.hcxNetworkAclId = builder.hcxNetworkAclId;
    }

    /**
     * <p>
     * The host VMkernel management VLAN subnet. This VLAN subnet carries traffic for managing ESXi hosts and
     * communicating with VMware vCenter Server.
     * </p>
     * 
     * @return The host VMkernel management VLAN subnet. This VLAN subnet carries traffic for managing ESXi hosts and
     *         communicating with VMware vCenter Server.
     */
    public final InitialVlanInfo vmkManagement() {
        return vmkManagement;
    }

    /**
     * <p>
     * The VM management VLAN subnet. This VLAN subnet carries traffic for vSphere virtual machines.
     * </p>
     * 
     * @return The VM management VLAN subnet. This VLAN subnet carries traffic for vSphere virtual machines.
     */
    public final InitialVlanInfo vmManagement() {
        return vmManagement;
    }

    /**
     * <p>
     * The vMotion VLAN subnet. This VLAN subnet carries traffic for vSphere vMotion.
     * </p>
     * 
     * @return The vMotion VLAN subnet. This VLAN subnet carries traffic for vSphere vMotion.
     */
    public final InitialVlanInfo vMotion() {
        return vMotion;
    }

    /**
     * <p>
     * The vSAN VLAN subnet. This VLAN subnet carries the communication between ESXi hosts to implement a vSAN shared
     * storage pool.
     * </p>
     * 
     * @return The vSAN VLAN subnet. This VLAN subnet carries the communication between ESXi hosts to implement a vSAN
     *         shared storage pool.
     */
    public final InitialVlanInfo vSan() {
        return vSan;
    }

    /**
     * <p>
     * The VTEP VLAN subnet. This VLAN subnet handles internal network traffic between virtual machines within a VCF
     * instance.
     * </p>
     * 
     * @return The VTEP VLAN subnet. This VLAN subnet handles internal network traffic between virtual machines within a
     *         VCF instance.
     */
    public final InitialVlanInfo vTep() {
        return vTep;
    }

    /**
     * <p>
     * The edge VTEP VLAN subnet. This VLAN subnet manages traffic flowing between the internal network and external
     * networks, including internet access and other site connections.
     * </p>
     * 
     * @return The edge VTEP VLAN subnet. This VLAN subnet manages traffic flowing between the internal network and
     *         external networks, including internet access and other site connections.
     */
    public final InitialVlanInfo edgeVTep() {
        return edgeVTep;
    }

    /**
     * <p>
     * The NSX uplink VLAN subnet. This VLAN subnet allows connectivity to the NSX overlay network.
     * </p>
     * 
     * @return The NSX uplink VLAN subnet. This VLAN subnet allows connectivity to the NSX overlay network.
     */
    public final InitialVlanInfo nsxUplink() {
        return nsxUplink;
    }

    /**
     * <p>
     * The HCX VLAN subnet. This VLAN subnet allows the HCX Interconnnect (IX) and HCX Network Extension (NE) to reach
     * their peers and enable HCX Service Mesh creation.
     * </p>
     * <p>
     * If you plan to use a public HCX VLAN subnet, the following requirements must be met:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must have a /28 netmask and be allocated from the IPAM public pool. Required for HCX internet access
     * configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * The HCX public VLAN CIDR block must be added to the VPC as a secondary CIDR block.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must have at least three Elastic IP addresses to be allocated from the public IPAM pool for HCX components.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The HCX VLAN subnet. This VLAN subnet allows the HCX Interconnnect (IX) and HCX Network Extension (NE) to
     *         reach their peers and enable HCX Service Mesh creation.</p>
     *         <p>
     *         If you plan to use a public HCX VLAN subnet, the following requirements must be met:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must have a /28 netmask and be allocated from the IPAM public pool. Required for HCX internet access
     *         configuration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The HCX public VLAN CIDR block must be added to the VPC as a secondary CIDR block.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must have at least three Elastic IP addresses to be allocated from the public IPAM pool for HCX
     *         components.
     *         </p>
     *         </li>
     */
    public final InitialVlanInfo hcx() {
        return hcx;
    }

    /**
     * <p>
     * An additional VLAN subnet that can be used to extend VCF capabilities once configured. For example, you can
     * configure an expansion VLAN subnet to use NSX Federation for centralized management and synchronization of
     * multiple NSX deployments across different locations.
     * </p>
     * 
     * @return An additional VLAN subnet that can be used to extend VCF capabilities once configured. For example, you
     *         can configure an expansion VLAN subnet to use NSX Federation for centralized management and
     *         synchronization of multiple NSX deployments across different locations.
     */
    public final InitialVlanInfo expansionVlan1() {
        return expansionVlan1;
    }

    /**
     * <p>
     * An additional VLAN subnet that can be used to extend VCF capabilities once configured. For example, you can
     * configure an expansion VLAN subnet to use NSX Federation for centralized management and synchronization of
     * multiple NSX deployments across different locations.
     * </p>
     * 
     * @return An additional VLAN subnet that can be used to extend VCF capabilities once configured. For example, you
     *         can configure an expansion VLAN subnet to use NSX Federation for centralized management and
     *         synchronization of multiple NSX deployments across different locations.
     */
    public final InitialVlanInfo expansionVlan2() {
        return expansionVlan2;
    }

    /**
     * <p>
     * Determines if the HCX VLAN that Amazon EVS provisions is public or private.
     * </p>
     * 
     * @return Determines if the HCX VLAN that Amazon EVS provisions is public or private.
     */
    public final Boolean isHcxPublic() {
        return isHcxPublic;
    }

    /**
     * <p>
     * A unique ID for a network access control list that the HCX VLAN uses. Required when <code>isHcxPublic</code> is
     * set to <code>true</code>.
     * </p>
     * 
     * @return A unique ID for a network access control list that the HCX VLAN uses. Required when
     *         <code>isHcxPublic</code> is set to <code>true</code>.
     */
    public final String hcxNetworkAclId() {
        return hcxNetworkAclId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vmkManagement());
        hashCode = 31 * hashCode + Objects.hashCode(vmManagement());
        hashCode = 31 * hashCode + Objects.hashCode(vMotion());
        hashCode = 31 * hashCode + Objects.hashCode(vSan());
        hashCode = 31 * hashCode + Objects.hashCode(vTep());
        hashCode = 31 * hashCode + Objects.hashCode(edgeVTep());
        hashCode = 31 * hashCode + Objects.hashCode(nsxUplink());
        hashCode = 31 * hashCode + Objects.hashCode(hcx());
        hashCode = 31 * hashCode + Objects.hashCode(expansionVlan1());
        hashCode = 31 * hashCode + Objects.hashCode(expansionVlan2());
        hashCode = 31 * hashCode + Objects.hashCode(isHcxPublic());
        hashCode = 31 * hashCode + Objects.hashCode(hcxNetworkAclId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InitialVlans)) {
            return false;
        }
        InitialVlans other = (InitialVlans) obj;
        return Objects.equals(vmkManagement(), other.vmkManagement()) && Objects.equals(vmManagement(), other.vmManagement())
                && Objects.equals(vMotion(), other.vMotion()) && Objects.equals(vSan(), other.vSan())
                && Objects.equals(vTep(), other.vTep()) && Objects.equals(edgeVTep(), other.edgeVTep())
                && Objects.equals(nsxUplink(), other.nsxUplink()) && Objects.equals(hcx(), other.hcx())
                && Objects.equals(expansionVlan1(), other.expansionVlan1())
                && Objects.equals(expansionVlan2(), other.expansionVlan2()) && Objects.equals(isHcxPublic(), other.isHcxPublic())
                && Objects.equals(hcxNetworkAclId(), other.hcxNetworkAclId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InitialVlans").add("VmkManagement", vmkManagement()).add("VmManagement", vmManagement())
                .add("VMotion", vMotion()).add("VSan", vSan()).add("VTep", vTep()).add("EdgeVTep", edgeVTep())
                .add("NsxUplink", nsxUplink()).add("Hcx", hcx()).add("ExpansionVlan1", expansionVlan1())
                .add("ExpansionVlan2", expansionVlan2()).add("IsHcxPublic", isHcxPublic())
                .add("HcxNetworkAclId", hcxNetworkAclId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "vmkManagement":
            return Optional.ofNullable(clazz.cast(vmkManagement()));
        case "vmManagement":
            return Optional.ofNullable(clazz.cast(vmManagement()));
        case "vMotion":
            return Optional.ofNullable(clazz.cast(vMotion()));
        case "vSan":
            return Optional.ofNullable(clazz.cast(vSan()));
        case "vTep":
            return Optional.ofNullable(clazz.cast(vTep()));
        case "edgeVTep":
            return Optional.ofNullable(clazz.cast(edgeVTep()));
        case "nsxUplink":
            return Optional.ofNullable(clazz.cast(nsxUplink()));
        case "hcx":
            return Optional.ofNullable(clazz.cast(hcx()));
        case "expansionVlan1":
            return Optional.ofNullable(clazz.cast(expansionVlan1()));
        case "expansionVlan2":
            return Optional.ofNullable(clazz.cast(expansionVlan2()));
        case "isHcxPublic":
            return Optional.ofNullable(clazz.cast(isHcxPublic()));
        case "hcxNetworkAclId":
            return Optional.ofNullable(clazz.cast(hcxNetworkAclId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("vmkManagement", VMK_MANAGEMENT_FIELD);
        map.put("vmManagement", VM_MANAGEMENT_FIELD);
        map.put("vMotion", V_MOTION_FIELD);
        map.put("vSan", V_SAN_FIELD);
        map.put("vTep", V_TEP_FIELD);
        map.put("edgeVTep", EDGE_V_TEP_FIELD);
        map.put("nsxUplink", NSX_UPLINK_FIELD);
        map.put("hcx", HCX_FIELD);
        map.put("expansionVlan1", EXPANSION_VLAN1_FIELD);
        map.put("expansionVlan2", EXPANSION_VLAN2_FIELD);
        map.put("isHcxPublic", IS_HCX_PUBLIC_FIELD);
        map.put("hcxNetworkAclId", HCX_NETWORK_ACL_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InitialVlans, T> g) {
        return obj -> g.apply((InitialVlans) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InitialVlans> {
        /**
         * <p>
         * The host VMkernel management VLAN subnet. This VLAN subnet carries traffic for managing ESXi hosts and
         * communicating with VMware vCenter Server.
         * </p>
         * 
         * @param vmkManagement
         *        The host VMkernel management VLAN subnet. This VLAN subnet carries traffic for managing ESXi hosts and
         *        communicating with VMware vCenter Server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vmkManagement(InitialVlanInfo vmkManagement);

        /**
         * <p>
         * The host VMkernel management VLAN subnet. This VLAN subnet carries traffic for managing ESXi hosts and
         * communicating with VMware vCenter Server.
         * </p>
         * This is a convenience method that creates an instance of the {@link InitialVlanInfo.Builder} avoiding the
         * need to create one manually via {@link InitialVlanInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InitialVlanInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #vmkManagement(InitialVlanInfo)}.
         * 
         * @param vmkManagement
         *        a consumer that will call methods on {@link InitialVlanInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vmkManagement(InitialVlanInfo)
         */
        default Builder vmkManagement(Consumer<InitialVlanInfo.Builder> vmkManagement) {
            return vmkManagement(InitialVlanInfo.builder().applyMutation(vmkManagement).build());
        }

        /**
         * <p>
         * The VM management VLAN subnet. This VLAN subnet carries traffic for vSphere virtual machines.
         * </p>
         * 
         * @param vmManagement
         *        The VM management VLAN subnet. This VLAN subnet carries traffic for vSphere virtual machines.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vmManagement(InitialVlanInfo vmManagement);

        /**
         * <p>
         * The VM management VLAN subnet. This VLAN subnet carries traffic for vSphere virtual machines.
         * </p>
         * This is a convenience method that creates an instance of the {@link InitialVlanInfo.Builder} avoiding the
         * need to create one manually via {@link InitialVlanInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InitialVlanInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #vmManagement(InitialVlanInfo)}.
         * 
         * @param vmManagement
         *        a consumer that will call methods on {@link InitialVlanInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vmManagement(InitialVlanInfo)
         */
        default Builder vmManagement(Consumer<InitialVlanInfo.Builder> vmManagement) {
            return vmManagement(InitialVlanInfo.builder().applyMutation(vmManagement).build());
        }

        /**
         * <p>
         * The vMotion VLAN subnet. This VLAN subnet carries traffic for vSphere vMotion.
         * </p>
         * 
         * @param vMotion
         *        The vMotion VLAN subnet. This VLAN subnet carries traffic for vSphere vMotion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vMotion(InitialVlanInfo vMotion);

        /**
         * <p>
         * The vMotion VLAN subnet. This VLAN subnet carries traffic for vSphere vMotion.
         * </p>
         * This is a convenience method that creates an instance of the {@link InitialVlanInfo.Builder} avoiding the
         * need to create one manually via {@link InitialVlanInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InitialVlanInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #vMotion(InitialVlanInfo)}.
         * 
         * @param vMotion
         *        a consumer that will call methods on {@link InitialVlanInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vMotion(InitialVlanInfo)
         */
        default Builder vMotion(Consumer<InitialVlanInfo.Builder> vMotion) {
            return vMotion(InitialVlanInfo.builder().applyMutation(vMotion).build());
        }

        /**
         * <p>
         * The vSAN VLAN subnet. This VLAN subnet carries the communication between ESXi hosts to implement a vSAN
         * shared storage pool.
         * </p>
         * 
         * @param vSan
         *        The vSAN VLAN subnet. This VLAN subnet carries the communication between ESXi hosts to implement a
         *        vSAN shared storage pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vSan(InitialVlanInfo vSan);

        /**
         * <p>
         * The vSAN VLAN subnet. This VLAN subnet carries the communication between ESXi hosts to implement a vSAN
         * shared storage pool.
         * </p>
         * This is a convenience method that creates an instance of the {@link InitialVlanInfo.Builder} avoiding the
         * need to create one manually via {@link InitialVlanInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InitialVlanInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #vSan(InitialVlanInfo)}.
         * 
         * @param vSan
         *        a consumer that will call methods on {@link InitialVlanInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vSan(InitialVlanInfo)
         */
        default Builder vSan(Consumer<InitialVlanInfo.Builder> vSan) {
            return vSan(InitialVlanInfo.builder().applyMutation(vSan).build());
        }

        /**
         * <p>
         * The VTEP VLAN subnet. This VLAN subnet handles internal network traffic between virtual machines within a VCF
         * instance.
         * </p>
         * 
         * @param vTep
         *        The VTEP VLAN subnet. This VLAN subnet handles internal network traffic between virtual machines
         *        within a VCF instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vTep(InitialVlanInfo vTep);

        /**
         * <p>
         * The VTEP VLAN subnet. This VLAN subnet handles internal network traffic between virtual machines within a VCF
         * instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link InitialVlanInfo.Builder} avoiding the
         * need to create one manually via {@link InitialVlanInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InitialVlanInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #vTep(InitialVlanInfo)}.
         * 
         * @param vTep
         *        a consumer that will call methods on {@link InitialVlanInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vTep(InitialVlanInfo)
         */
        default Builder vTep(Consumer<InitialVlanInfo.Builder> vTep) {
            return vTep(InitialVlanInfo.builder().applyMutation(vTep).build());
        }

        /**
         * <p>
         * The edge VTEP VLAN subnet. This VLAN subnet manages traffic flowing between the internal network and external
         * networks, including internet access and other site connections.
         * </p>
         * 
         * @param edgeVTep
         *        The edge VTEP VLAN subnet. This VLAN subnet manages traffic flowing between the internal network and
         *        external networks, including internet access and other site connections.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edgeVTep(InitialVlanInfo edgeVTep);

        /**
         * <p>
         * The edge VTEP VLAN subnet. This VLAN subnet manages traffic flowing between the internal network and external
         * networks, including internet access and other site connections.
         * </p>
         * This is a convenience method that creates an instance of the {@link InitialVlanInfo.Builder} avoiding the
         * need to create one manually via {@link InitialVlanInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InitialVlanInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #edgeVTep(InitialVlanInfo)}.
         * 
         * @param edgeVTep
         *        a consumer that will call methods on {@link InitialVlanInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #edgeVTep(InitialVlanInfo)
         */
        default Builder edgeVTep(Consumer<InitialVlanInfo.Builder> edgeVTep) {
            return edgeVTep(InitialVlanInfo.builder().applyMutation(edgeVTep).build());
        }

        /**
         * <p>
         * The NSX uplink VLAN subnet. This VLAN subnet allows connectivity to the NSX overlay network.
         * </p>
         * 
         * @param nsxUplink
         *        The NSX uplink VLAN subnet. This VLAN subnet allows connectivity to the NSX overlay network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nsxUplink(InitialVlanInfo nsxUplink);

        /**
         * <p>
         * The NSX uplink VLAN subnet. This VLAN subnet allows connectivity to the NSX overlay network.
         * </p>
         * This is a convenience method that creates an instance of the {@link InitialVlanInfo.Builder} avoiding the
         * need to create one manually via {@link InitialVlanInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InitialVlanInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #nsxUplink(InitialVlanInfo)}.
         * 
         * @param nsxUplink
         *        a consumer that will call methods on {@link InitialVlanInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nsxUplink(InitialVlanInfo)
         */
        default Builder nsxUplink(Consumer<InitialVlanInfo.Builder> nsxUplink) {
            return nsxUplink(InitialVlanInfo.builder().applyMutation(nsxUplink).build());
        }

        /**
         * <p>
         * The HCX VLAN subnet. This VLAN subnet allows the HCX Interconnnect (IX) and HCX Network Extension (NE) to
         * reach their peers and enable HCX Service Mesh creation.
         * </p>
         * <p>
         * If you plan to use a public HCX VLAN subnet, the following requirements must be met:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must have a /28 netmask and be allocated from the IPAM public pool. Required for HCX internet access
         * configuration.
         * </p>
         * </li>
         * <li>
         * <p>
         * The HCX public VLAN CIDR block must be added to the VPC as a secondary CIDR block.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must have at least three Elastic IP addresses to be allocated from the public IPAM pool for HCX components.
         * </p>
         * </li>
         * </ul>
         * 
         * @param hcx
         *        The HCX VLAN subnet. This VLAN subnet allows the HCX Interconnnect (IX) and HCX Network Extension (NE)
         *        to reach their peers and enable HCX Service Mesh creation.</p>
         *        <p>
         *        If you plan to use a public HCX VLAN subnet, the following requirements must be met:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must have a /28 netmask and be allocated from the IPAM public pool. Required for HCX internet access
         *        configuration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The HCX public VLAN CIDR block must be added to the VPC as a secondary CIDR block.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must have at least three Elastic IP addresses to be allocated from the public IPAM pool for HCX
         *        components.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hcx(InitialVlanInfo hcx);

        /**
         * <p>
         * The HCX VLAN subnet. This VLAN subnet allows the HCX Interconnnect (IX) and HCX Network Extension (NE) to
         * reach their peers and enable HCX Service Mesh creation.
         * </p>
         * <p>
         * If you plan to use a public HCX VLAN subnet, the following requirements must be met:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must have a /28 netmask and be allocated from the IPAM public pool. Required for HCX internet access
         * configuration.
         * </p>
         * </li>
         * <li>
         * <p>
         * The HCX public VLAN CIDR block must be added to the VPC as a secondary CIDR block.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must have at least three Elastic IP addresses to be allocated from the public IPAM pool for HCX components.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link InitialVlanInfo.Builder} avoiding the
         * need to create one manually via {@link InitialVlanInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InitialVlanInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #hcx(InitialVlanInfo)}.
         * 
         * @param hcx
         *        a consumer that will call methods on {@link InitialVlanInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hcx(InitialVlanInfo)
         */
        default Builder hcx(Consumer<InitialVlanInfo.Builder> hcx) {
            return hcx(InitialVlanInfo.builder().applyMutation(hcx).build());
        }

        /**
         * <p>
         * An additional VLAN subnet that can be used to extend VCF capabilities once configured. For example, you can
         * configure an expansion VLAN subnet to use NSX Federation for centralized management and synchronization of
         * multiple NSX deployments across different locations.
         * </p>
         * 
         * @param expansionVlan1
         *        An additional VLAN subnet that can be used to extend VCF capabilities once configured. For example,
         *        you can configure an expansion VLAN subnet to use NSX Federation for centralized management and
         *        synchronization of multiple NSX deployments across different locations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expansionVlan1(InitialVlanInfo expansionVlan1);

        /**
         * <p>
         * An additional VLAN subnet that can be used to extend VCF capabilities once configured. For example, you can
         * configure an expansion VLAN subnet to use NSX Federation for centralized management and synchronization of
         * multiple NSX deployments across different locations.
         * </p>
         * This is a convenience method that creates an instance of the {@link InitialVlanInfo.Builder} avoiding the
         * need to create one manually via {@link InitialVlanInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InitialVlanInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #expansionVlan1(InitialVlanInfo)}.
         * 
         * @param expansionVlan1
         *        a consumer that will call methods on {@link InitialVlanInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #expansionVlan1(InitialVlanInfo)
         */
        default Builder expansionVlan1(Consumer<InitialVlanInfo.Builder> expansionVlan1) {
            return expansionVlan1(InitialVlanInfo.builder().applyMutation(expansionVlan1).build());
        }

        /**
         * <p>
         * An additional VLAN subnet that can be used to extend VCF capabilities once configured. For example, you can
         * configure an expansion VLAN subnet to use NSX Federation for centralized management and synchronization of
         * multiple NSX deployments across different locations.
         * </p>
         * 
         * @param expansionVlan2
         *        An additional VLAN subnet that can be used to extend VCF capabilities once configured. For example,
         *        you can configure an expansion VLAN subnet to use NSX Federation for centralized management and
         *        synchronization of multiple NSX deployments across different locations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expansionVlan2(InitialVlanInfo expansionVlan2);

        /**
         * <p>
         * An additional VLAN subnet that can be used to extend VCF capabilities once configured. For example, you can
         * configure an expansion VLAN subnet to use NSX Federation for centralized management and synchronization of
         * multiple NSX deployments across different locations.
         * </p>
         * This is a convenience method that creates an instance of the {@link InitialVlanInfo.Builder} avoiding the
         * need to create one manually via {@link InitialVlanInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InitialVlanInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #expansionVlan2(InitialVlanInfo)}.
         * 
         * @param expansionVlan2
         *        a consumer that will call methods on {@link InitialVlanInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #expansionVlan2(InitialVlanInfo)
         */
        default Builder expansionVlan2(Consumer<InitialVlanInfo.Builder> expansionVlan2) {
            return expansionVlan2(InitialVlanInfo.builder().applyMutation(expansionVlan2).build());
        }

        /**
         * <p>
         * Determines if the HCX VLAN that Amazon EVS provisions is public or private.
         * </p>
         * 
         * @param isHcxPublic
         *        Determines if the HCX VLAN that Amazon EVS provisions is public or private.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isHcxPublic(Boolean isHcxPublic);

        /**
         * <p>
         * A unique ID for a network access control list that the HCX VLAN uses. Required when <code>isHcxPublic</code>
         * is set to <code>true</code>.
         * </p>
         * 
         * @param hcxNetworkAclId
         *        A unique ID for a network access control list that the HCX VLAN uses. Required when
         *        <code>isHcxPublic</code> is set to <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hcxNetworkAclId(String hcxNetworkAclId);
    }

    static final class BuilderImpl implements Builder {
        private InitialVlanInfo vmkManagement;

        private InitialVlanInfo vmManagement;

        private InitialVlanInfo vMotion;

        private InitialVlanInfo vSan;

        private InitialVlanInfo vTep;

        private InitialVlanInfo edgeVTep;

        private InitialVlanInfo nsxUplink;

        private InitialVlanInfo hcx;

        private InitialVlanInfo expansionVlan1;

        private InitialVlanInfo expansionVlan2;

        private Boolean isHcxPublic;

        private String hcxNetworkAclId;

        private BuilderImpl() {
        }

        private BuilderImpl(InitialVlans model) {
            vmkManagement(model.vmkManagement);
            vmManagement(model.vmManagement);
            vMotion(model.vMotion);
            vSan(model.vSan);
            vTep(model.vTep);
            edgeVTep(model.edgeVTep);
            nsxUplink(model.nsxUplink);
            hcx(model.hcx);
            expansionVlan1(model.expansionVlan1);
            expansionVlan2(model.expansionVlan2);
            isHcxPublic(model.isHcxPublic);
            hcxNetworkAclId(model.hcxNetworkAclId);
        }

        public final InitialVlanInfo.Builder getVmkManagement() {
            return vmkManagement != null ? vmkManagement.toBuilder() : null;
        }

        public final void setVmkManagement(InitialVlanInfo.BuilderImpl vmkManagement) {
            this.vmkManagement = vmkManagement != null ? vmkManagement.build() : null;
        }

        @Override
        public final Builder vmkManagement(InitialVlanInfo vmkManagement) {
            this.vmkManagement = vmkManagement;
            return this;
        }

        public final InitialVlanInfo.Builder getVmManagement() {
            return vmManagement != null ? vmManagement.toBuilder() : null;
        }

        public final void setVmManagement(InitialVlanInfo.BuilderImpl vmManagement) {
            this.vmManagement = vmManagement != null ? vmManagement.build() : null;
        }

        @Override
        public final Builder vmManagement(InitialVlanInfo vmManagement) {
            this.vmManagement = vmManagement;
            return this;
        }

        public final InitialVlanInfo.Builder getVMotion() {
            return vMotion != null ? vMotion.toBuilder() : null;
        }

        public final void setVMotion(InitialVlanInfo.BuilderImpl vMotion) {
            this.vMotion = vMotion != null ? vMotion.build() : null;
        }

        @Override
        public final Builder vMotion(InitialVlanInfo vMotion) {
            this.vMotion = vMotion;
            return this;
        }

        public final InitialVlanInfo.Builder getVSan() {
            return vSan != null ? vSan.toBuilder() : null;
        }

        public final void setVSan(InitialVlanInfo.BuilderImpl vSan) {
            this.vSan = vSan != null ? vSan.build() : null;
        }

        @Override
        public final Builder vSan(InitialVlanInfo vSan) {
            this.vSan = vSan;
            return this;
        }

        public final InitialVlanInfo.Builder getVTep() {
            return vTep != null ? vTep.toBuilder() : null;
        }

        public final void setVTep(InitialVlanInfo.BuilderImpl vTep) {
            this.vTep = vTep != null ? vTep.build() : null;
        }

        @Override
        public final Builder vTep(InitialVlanInfo vTep) {
            this.vTep = vTep;
            return this;
        }

        public final InitialVlanInfo.Builder getEdgeVTep() {
            return edgeVTep != null ? edgeVTep.toBuilder() : null;
        }

        public final void setEdgeVTep(InitialVlanInfo.BuilderImpl edgeVTep) {
            this.edgeVTep = edgeVTep != null ? edgeVTep.build() : null;
        }

        @Override
        public final Builder edgeVTep(InitialVlanInfo edgeVTep) {
            this.edgeVTep = edgeVTep;
            return this;
        }

        public final InitialVlanInfo.Builder getNsxUplink() {
            return nsxUplink != null ? nsxUplink.toBuilder() : null;
        }

        public final void setNsxUplink(InitialVlanInfo.BuilderImpl nsxUplink) {
            this.nsxUplink = nsxUplink != null ? nsxUplink.build() : null;
        }

        @Override
        public final Builder nsxUplink(InitialVlanInfo nsxUplink) {
            this.nsxUplink = nsxUplink;
            return this;
        }

        public final InitialVlanInfo.Builder getHcx() {
            return hcx != null ? hcx.toBuilder() : null;
        }

        public final void setHcx(InitialVlanInfo.BuilderImpl hcx) {
            this.hcx = hcx != null ? hcx.build() : null;
        }

        @Override
        public final Builder hcx(InitialVlanInfo hcx) {
            this.hcx = hcx;
            return this;
        }

        public final InitialVlanInfo.Builder getExpansionVlan1() {
            return expansionVlan1 != null ? expansionVlan1.toBuilder() : null;
        }

        public final void setExpansionVlan1(InitialVlanInfo.BuilderImpl expansionVlan1) {
            this.expansionVlan1 = expansionVlan1 != null ? expansionVlan1.build() : null;
        }

        @Override
        public final Builder expansionVlan1(InitialVlanInfo expansionVlan1) {
            this.expansionVlan1 = expansionVlan1;
            return this;
        }

        public final InitialVlanInfo.Builder getExpansionVlan2() {
            return expansionVlan2 != null ? expansionVlan2.toBuilder() : null;
        }

        public final void setExpansionVlan2(InitialVlanInfo.BuilderImpl expansionVlan2) {
            this.expansionVlan2 = expansionVlan2 != null ? expansionVlan2.build() : null;
        }

        @Override
        public final Builder expansionVlan2(InitialVlanInfo expansionVlan2) {
            this.expansionVlan2 = expansionVlan2;
            return this;
        }

        public final Boolean getIsHcxPublic() {
            return isHcxPublic;
        }

        public final void setIsHcxPublic(Boolean isHcxPublic) {
            this.isHcxPublic = isHcxPublic;
        }

        @Override
        public final Builder isHcxPublic(Boolean isHcxPublic) {
            this.isHcxPublic = isHcxPublic;
            return this;
        }

        public final String getHcxNetworkAclId() {
            return hcxNetworkAclId;
        }

        public final void setHcxNetworkAclId(String hcxNetworkAclId) {
            this.hcxNetworkAclId = hcxNetworkAclId;
        }

        @Override
        public final Builder hcxNetworkAclId(String hcxNetworkAclId) {
            this.hcxNetworkAclId = hcxNetworkAclId;
            return this;
        }

        @Override
        public InitialVlans build() {
            return new InitialVlans(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
