/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.evs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The license information that Amazon EVS requires to create an environment. Amazon EVS requires two license keys: a
 * VCF solution key and a vSAN license key.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LicenseInfo implements SdkPojo, Serializable, ToCopyableBuilder<LicenseInfo.Builder, LicenseInfo> {
    private static final SdkField<String> SOLUTION_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("solutionKey").getter(getter(LicenseInfo::solutionKey)).setter(setter(Builder::solutionKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("solutionKey").build()).build();

    private static final SdkField<String> VSAN_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vsanKey").getter(getter(LicenseInfo::vsanKey)).setter(setter(Builder::vsanKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vsanKey").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOLUTION_KEY_FIELD,
            VSAN_KEY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String solutionKey;

    private final String vsanKey;

    private LicenseInfo(BuilderImpl builder) {
        this.solutionKey = builder.solutionKey;
        this.vsanKey = builder.vsanKey;
    }

    /**
     * <p>
     * The VCF solution key. This license unlocks VMware VCF product features, including vSphere, NSX, SDDC Manager, and
     * vCenter Server. The VCF solution key must cover a minimum of 256 cores.
     * </p>
     * 
     * @return The VCF solution key. This license unlocks VMware VCF product features, including vSphere, NSX, SDDC
     *         Manager, and vCenter Server. The VCF solution key must cover a minimum of 256 cores.
     */
    public final String solutionKey() {
        return solutionKey;
    }

    /**
     * <p>
     * The VSAN license key. This license unlocks vSAN features. The vSAN license key must provide at least 110 TiB of
     * vSAN capacity.
     * </p>
     * 
     * @return The VSAN license key. This license unlocks vSAN features. The vSAN license key must provide at least 110
     *         TiB of vSAN capacity.
     */
    public final String vsanKey() {
        return vsanKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(solutionKey());
        hashCode = 31 * hashCode + Objects.hashCode(vsanKey());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LicenseInfo)) {
            return false;
        }
        LicenseInfo other = (LicenseInfo) obj;
        return Objects.equals(solutionKey(), other.solutionKey()) && Objects.equals(vsanKey(), other.vsanKey());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LicenseInfo").add("SolutionKey", solutionKey()).add("VsanKey", vsanKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "solutionKey":
            return Optional.ofNullable(clazz.cast(solutionKey()));
        case "vsanKey":
            return Optional.ofNullable(clazz.cast(vsanKey()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("solutionKey", SOLUTION_KEY_FIELD);
        map.put("vsanKey", VSAN_KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LicenseInfo, T> g) {
        return obj -> g.apply((LicenseInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LicenseInfo> {
        /**
         * <p>
         * The VCF solution key. This license unlocks VMware VCF product features, including vSphere, NSX, SDDC Manager,
         * and vCenter Server. The VCF solution key must cover a minimum of 256 cores.
         * </p>
         * 
         * @param solutionKey
         *        The VCF solution key. This license unlocks VMware VCF product features, including vSphere, NSX, SDDC
         *        Manager, and vCenter Server. The VCF solution key must cover a minimum of 256 cores.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder solutionKey(String solutionKey);

        /**
         * <p>
         * The VSAN license key. This license unlocks vSAN features. The vSAN license key must provide at least 110 TiB
         * of vSAN capacity.
         * </p>
         * 
         * @param vsanKey
         *        The VSAN license key. This license unlocks vSAN features. The vSAN license key must provide at least
         *        110 TiB of vSAN capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vsanKey(String vsanKey);
    }

    static final class BuilderImpl implements Builder {
        private String solutionKey;

        private String vsanKey;

        private BuilderImpl() {
        }

        private BuilderImpl(LicenseInfo model) {
            solutionKey(model.solutionKey);
            vsanKey(model.vsanKey);
        }

        public final String getSolutionKey() {
            return solutionKey;
        }

        public final void setSolutionKey(String solutionKey) {
            this.solutionKey = solutionKey;
        }

        @Override
        public final Builder solutionKey(String solutionKey) {
            this.solutionKey = solutionKey;
            return this;
        }

        public final String getVsanKey() {
            return vsanKey;
        }

        public final void setVsanKey(String vsanKey) {
            this.vsanKey = vsanKey;
        }

        @Override
        public final Builder vsanKey(String vsanKey) {
            this.vsanKey = vsanKey;
            return this;
        }

        @Override
        public LicenseInfo build() {
            return new LicenseInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
