/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.evs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The DNS hostnames that Amazon EVS uses to install VMware vCenter Server, NSX, SDDC Manager, and Cloud Builder. Each
 * hostname must be unique, and resolve to a domain name that you've registered in your DNS service of choice. Hostnames
 * cannot be changed.
 * </p>
 * <p>
 * VMware VCF requires the deployment of two NSX Edge nodes, and three NSX Manager virtual machines.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VcfHostnames implements SdkPojo, Serializable, ToCopyableBuilder<VcfHostnames.Builder, VcfHostnames> {
    private static final SdkField<String> V_CENTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vCenter").getter(getter(VcfHostnames::vCenter)).setter(setter(Builder::vCenter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vCenter").build()).build();

    private static final SdkField<String> NSX_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("nsx")
            .getter(getter(VcfHostnames::nsx)).setter(setter(Builder::nsx))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsx").build()).build();

    private static final SdkField<String> NSX_MANAGER1_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nsxManager1").getter(getter(VcfHostnames::nsxManager1)).setter(setter(Builder::nsxManager1))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsxManager1").build()).build();

    private static final SdkField<String> NSX_MANAGER2_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nsxManager2").getter(getter(VcfHostnames::nsxManager2)).setter(setter(Builder::nsxManager2))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsxManager2").build()).build();

    private static final SdkField<String> NSX_MANAGER3_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nsxManager3").getter(getter(VcfHostnames::nsxManager3)).setter(setter(Builder::nsxManager3))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsxManager3").build()).build();

    private static final SdkField<String> NSX_EDGE1_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nsxEdge1").getter(getter(VcfHostnames::nsxEdge1)).setter(setter(Builder::nsxEdge1))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsxEdge1").build()).build();

    private static final SdkField<String> NSX_EDGE2_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nsxEdge2").getter(getter(VcfHostnames::nsxEdge2)).setter(setter(Builder::nsxEdge2))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsxEdge2").build()).build();

    private static final SdkField<String> SDDC_MANAGER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sddcManager").getter(getter(VcfHostnames::sddcManager)).setter(setter(Builder::sddcManager))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sddcManager").build()).build();

    private static final SdkField<String> CLOUD_BUILDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("cloudBuilder").getter(getter(VcfHostnames::cloudBuilder)).setter(setter(Builder::cloudBuilder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudBuilder").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(V_CENTER_FIELD, NSX_FIELD,
            NSX_MANAGER1_FIELD, NSX_MANAGER2_FIELD, NSX_MANAGER3_FIELD, NSX_EDGE1_FIELD, NSX_EDGE2_FIELD, SDDC_MANAGER_FIELD,
            CLOUD_BUILDER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String vCenter;

    private final String nsx;

    private final String nsxManager1;

    private final String nsxManager2;

    private final String nsxManager3;

    private final String nsxEdge1;

    private final String nsxEdge2;

    private final String sddcManager;

    private final String cloudBuilder;

    private VcfHostnames(BuilderImpl builder) {
        this.vCenter = builder.vCenter;
        this.nsx = builder.nsx;
        this.nsxManager1 = builder.nsxManager1;
        this.nsxManager2 = builder.nsxManager2;
        this.nsxManager3 = builder.nsxManager3;
        this.nsxEdge1 = builder.nsxEdge1;
        this.nsxEdge2 = builder.nsxEdge2;
        this.sddcManager = builder.sddcManager;
        this.cloudBuilder = builder.cloudBuilder;
    }

    /**
     * <p>
     * The VMware vCenter hostname.
     * </p>
     * 
     * @return The VMware vCenter hostname.
     */
    public final String vCenter() {
        return vCenter;
    }

    /**
     * <p>
     * The VMware NSX hostname.
     * </p>
     * 
     * @return The VMware NSX hostname.
     */
    public final String nsx() {
        return nsx;
    }

    /**
     * <p>
     * The hostname for the first VMware NSX Manager virtual machine (VM).
     * </p>
     * 
     * @return The hostname for the first VMware NSX Manager virtual machine (VM).
     */
    public final String nsxManager1() {
        return nsxManager1;
    }

    /**
     * <p>
     * The hostname for the second VMware NSX Manager virtual machine (VM).
     * </p>
     * 
     * @return The hostname for the second VMware NSX Manager virtual machine (VM).
     */
    public final String nsxManager2() {
        return nsxManager2;
    }

    /**
     * <p>
     * The hostname for the third VMware NSX Manager virtual machine (VM).
     * </p>
     * 
     * @return The hostname for the third VMware NSX Manager virtual machine (VM).
     */
    public final String nsxManager3() {
        return nsxManager3;
    }

    /**
     * <p>
     * The hostname for the first NSX Edge node.
     * </p>
     * 
     * @return The hostname for the first NSX Edge node.
     */
    public final String nsxEdge1() {
        return nsxEdge1;
    }

    /**
     * <p>
     * The hostname for the second NSX Edge node.
     * </p>
     * 
     * @return The hostname for the second NSX Edge node.
     */
    public final String nsxEdge2() {
        return nsxEdge2;
    }

    /**
     * <p>
     * The hostname for SDDC Manager.
     * </p>
     * 
     * @return The hostname for SDDC Manager.
     */
    public final String sddcManager() {
        return sddcManager;
    }

    /**
     * <p>
     * The hostname for VMware Cloud Builder.
     * </p>
     * 
     * @return The hostname for VMware Cloud Builder.
     */
    public final String cloudBuilder() {
        return cloudBuilder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vCenter());
        hashCode = 31 * hashCode + Objects.hashCode(nsx());
        hashCode = 31 * hashCode + Objects.hashCode(nsxManager1());
        hashCode = 31 * hashCode + Objects.hashCode(nsxManager2());
        hashCode = 31 * hashCode + Objects.hashCode(nsxManager3());
        hashCode = 31 * hashCode + Objects.hashCode(nsxEdge1());
        hashCode = 31 * hashCode + Objects.hashCode(nsxEdge2());
        hashCode = 31 * hashCode + Objects.hashCode(sddcManager());
        hashCode = 31 * hashCode + Objects.hashCode(cloudBuilder());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VcfHostnames)) {
            return false;
        }
        VcfHostnames other = (VcfHostnames) obj;
        return Objects.equals(vCenter(), other.vCenter()) && Objects.equals(nsx(), other.nsx())
                && Objects.equals(nsxManager1(), other.nsxManager1()) && Objects.equals(nsxManager2(), other.nsxManager2())
                && Objects.equals(nsxManager3(), other.nsxManager3()) && Objects.equals(nsxEdge1(), other.nsxEdge1())
                && Objects.equals(nsxEdge2(), other.nsxEdge2()) && Objects.equals(sddcManager(), other.sddcManager())
                && Objects.equals(cloudBuilder(), other.cloudBuilder());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VcfHostnames").add("VCenter", vCenter()).add("Nsx", nsx()).add("NsxManager1", nsxManager1())
                .add("NsxManager2", nsxManager2()).add("NsxManager3", nsxManager3()).add("NsxEdge1", nsxEdge1())
                .add("NsxEdge2", nsxEdge2()).add("SddcManager", sddcManager()).add("CloudBuilder", cloudBuilder()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "vCenter":
            return Optional.ofNullable(clazz.cast(vCenter()));
        case "nsx":
            return Optional.ofNullable(clazz.cast(nsx()));
        case "nsxManager1":
            return Optional.ofNullable(clazz.cast(nsxManager1()));
        case "nsxManager2":
            return Optional.ofNullable(clazz.cast(nsxManager2()));
        case "nsxManager3":
            return Optional.ofNullable(clazz.cast(nsxManager3()));
        case "nsxEdge1":
            return Optional.ofNullable(clazz.cast(nsxEdge1()));
        case "nsxEdge2":
            return Optional.ofNullable(clazz.cast(nsxEdge2()));
        case "sddcManager":
            return Optional.ofNullable(clazz.cast(sddcManager()));
        case "cloudBuilder":
            return Optional.ofNullable(clazz.cast(cloudBuilder()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("vCenter", V_CENTER_FIELD);
        map.put("nsx", NSX_FIELD);
        map.put("nsxManager1", NSX_MANAGER1_FIELD);
        map.put("nsxManager2", NSX_MANAGER2_FIELD);
        map.put("nsxManager3", NSX_MANAGER3_FIELD);
        map.put("nsxEdge1", NSX_EDGE1_FIELD);
        map.put("nsxEdge2", NSX_EDGE2_FIELD);
        map.put("sddcManager", SDDC_MANAGER_FIELD);
        map.put("cloudBuilder", CLOUD_BUILDER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VcfHostnames, T> g) {
        return obj -> g.apply((VcfHostnames) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VcfHostnames> {
        /**
         * <p>
         * The VMware vCenter hostname.
         * </p>
         * 
         * @param vCenter
         *        The VMware vCenter hostname.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vCenter(String vCenter);

        /**
         * <p>
         * The VMware NSX hostname.
         * </p>
         * 
         * @param nsx
         *        The VMware NSX hostname.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nsx(String nsx);

        /**
         * <p>
         * The hostname for the first VMware NSX Manager virtual machine (VM).
         * </p>
         * 
         * @param nsxManager1
         *        The hostname for the first VMware NSX Manager virtual machine (VM).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nsxManager1(String nsxManager1);

        /**
         * <p>
         * The hostname for the second VMware NSX Manager virtual machine (VM).
         * </p>
         * 
         * @param nsxManager2
         *        The hostname for the second VMware NSX Manager virtual machine (VM).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nsxManager2(String nsxManager2);

        /**
         * <p>
         * The hostname for the third VMware NSX Manager virtual machine (VM).
         * </p>
         * 
         * @param nsxManager3
         *        The hostname for the third VMware NSX Manager virtual machine (VM).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nsxManager3(String nsxManager3);

        /**
         * <p>
         * The hostname for the first NSX Edge node.
         * </p>
         * 
         * @param nsxEdge1
         *        The hostname for the first NSX Edge node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nsxEdge1(String nsxEdge1);

        /**
         * <p>
         * The hostname for the second NSX Edge node.
         * </p>
         * 
         * @param nsxEdge2
         *        The hostname for the second NSX Edge node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nsxEdge2(String nsxEdge2);

        /**
         * <p>
         * The hostname for SDDC Manager.
         * </p>
         * 
         * @param sddcManager
         *        The hostname for SDDC Manager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sddcManager(String sddcManager);

        /**
         * <p>
         * The hostname for VMware Cloud Builder.
         * </p>
         * 
         * @param cloudBuilder
         *        The hostname for VMware Cloud Builder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudBuilder(String cloudBuilder);
    }

    static final class BuilderImpl implements Builder {
        private String vCenter;

        private String nsx;

        private String nsxManager1;

        private String nsxManager2;

        private String nsxManager3;

        private String nsxEdge1;

        private String nsxEdge2;

        private String sddcManager;

        private String cloudBuilder;

        private BuilderImpl() {
        }

        private BuilderImpl(VcfHostnames model) {
            vCenter(model.vCenter);
            nsx(model.nsx);
            nsxManager1(model.nsxManager1);
            nsxManager2(model.nsxManager2);
            nsxManager3(model.nsxManager3);
            nsxEdge1(model.nsxEdge1);
            nsxEdge2(model.nsxEdge2);
            sddcManager(model.sddcManager);
            cloudBuilder(model.cloudBuilder);
        }

        public final String getVCenter() {
            return vCenter;
        }

        public final void setVCenter(String vCenter) {
            this.vCenter = vCenter;
        }

        @Override
        public final Builder vCenter(String vCenter) {
            this.vCenter = vCenter;
            return this;
        }

        public final String getNsx() {
            return nsx;
        }

        public final void setNsx(String nsx) {
            this.nsx = nsx;
        }

        @Override
        public final Builder nsx(String nsx) {
            this.nsx = nsx;
            return this;
        }

        public final String getNsxManager1() {
            return nsxManager1;
        }

        public final void setNsxManager1(String nsxManager1) {
            this.nsxManager1 = nsxManager1;
        }

        @Override
        public final Builder nsxManager1(String nsxManager1) {
            this.nsxManager1 = nsxManager1;
            return this;
        }

        public final String getNsxManager2() {
            return nsxManager2;
        }

        public final void setNsxManager2(String nsxManager2) {
            this.nsxManager2 = nsxManager2;
        }

        @Override
        public final Builder nsxManager2(String nsxManager2) {
            this.nsxManager2 = nsxManager2;
            return this;
        }

        public final String getNsxManager3() {
            return nsxManager3;
        }

        public final void setNsxManager3(String nsxManager3) {
            this.nsxManager3 = nsxManager3;
        }

        @Override
        public final Builder nsxManager3(String nsxManager3) {
            this.nsxManager3 = nsxManager3;
            return this;
        }

        public final String getNsxEdge1() {
            return nsxEdge1;
        }

        public final void setNsxEdge1(String nsxEdge1) {
            this.nsxEdge1 = nsxEdge1;
        }

        @Override
        public final Builder nsxEdge1(String nsxEdge1) {
            this.nsxEdge1 = nsxEdge1;
            return this;
        }

        public final String getNsxEdge2() {
            return nsxEdge2;
        }

        public final void setNsxEdge2(String nsxEdge2) {
            this.nsxEdge2 = nsxEdge2;
        }

        @Override
        public final Builder nsxEdge2(String nsxEdge2) {
            this.nsxEdge2 = nsxEdge2;
            return this;
        }

        public final String getSddcManager() {
            return sddcManager;
        }

        public final void setSddcManager(String sddcManager) {
            this.sddcManager = sddcManager;
        }

        @Override
        public final Builder sddcManager(String sddcManager) {
            this.sddcManager = sddcManager;
            return this;
        }

        public final String getCloudBuilder() {
            return cloudBuilder;
        }

        public final void setCloudBuilder(String cloudBuilder) {
            this.cloudBuilder = cloudBuilder;
        }

        @Override
        public final Builder cloudBuilder(String cloudBuilder) {
            this.cloudBuilder = cloudBuilder;
            return this;
        }

        @Override
        public VcfHostnames build() {
            return new VcfHostnames(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
