/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.evs.model.EvsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateEipToVlanRequest
extends EvsRequest
implements ToCopyableBuilder<Builder, AssociateEipToVlanRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(AssociateEipToVlanRequest.getter(AssociateEipToVlanRequest::clientToken)).setter(AssociateEipToVlanRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentId").getter(AssociateEipToVlanRequest.getter(AssociateEipToVlanRequest::environmentId)).setter(AssociateEipToVlanRequest.setter(Builder::environmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentId").build()}).build();
    private static final SdkField<String> VLAN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vlanName").getter(AssociateEipToVlanRequest.getter(AssociateEipToVlanRequest::vlanName)).setter(AssociateEipToVlanRequest.setter(Builder::vlanName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vlanName").build()}).build();
    private static final SdkField<String> ALLOCATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("allocationId").getter(AssociateEipToVlanRequest.getter(AssociateEipToVlanRequest::allocationId)).setter(AssociateEipToVlanRequest.setter(Builder::allocationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allocationId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, ENVIRONMENT_ID_FIELD, VLAN_NAME_FIELD, ALLOCATION_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AssociateEipToVlanRequest.memberNameToFieldInitializer();
    private final String clientToken;
    private final String environmentId;
    private final String vlanName;
    private final String allocationId;

    private AssociateEipToVlanRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.environmentId = builder.environmentId;
        this.vlanName = builder.vlanName;
        this.allocationId = builder.allocationId;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String environmentId() {
        return this.environmentId;
    }

    public final String vlanName() {
        return this.vlanName;
    }

    public final String allocationId() {
        return this.allocationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vlanName());
        hashCode = 31 * hashCode + Objects.hashCode(this.allocationId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateEipToVlanRequest)) {
            return false;
        }
        AssociateEipToVlanRequest other = (AssociateEipToVlanRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.environmentId(), other.environmentId()) && Objects.equals(this.vlanName(), other.vlanName()) && Objects.equals(this.allocationId(), other.allocationId());
    }

    public final String toString() {
        return ToString.builder((String)"AssociateEipToVlanRequest").add("ClientToken", (Object)this.clientToken()).add("EnvironmentId", (Object)this.environmentId()).add("VlanName", (Object)this.vlanName()).add("AllocationId", (Object)this.allocationId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "environmentId": {
                return Optional.ofNullable(clazz.cast(this.environmentId()));
            }
            case "vlanName": {
                return Optional.ofNullable(clazz.cast(this.vlanName()));
            }
            case "allocationId": {
                return Optional.ofNullable(clazz.cast(this.allocationId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("environmentId", ENVIRONMENT_ID_FIELD);
        map.put("vlanName", VLAN_NAME_FIELD);
        map.put("allocationId", ALLOCATION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateEipToVlanRequest, T> g) {
        return obj -> g.apply((AssociateEipToVlanRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EvsRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String environmentId;
        private String vlanName;
        private String allocationId;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateEipToVlanRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.environmentId(model.environmentId);
            this.vlanName(model.vlanName);
            this.allocationId(model.allocationId);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final String getVlanName() {
            return this.vlanName;
        }

        public final void setVlanName(String vlanName) {
            this.vlanName = vlanName;
        }

        @Override
        public final Builder vlanName(String vlanName) {
            this.vlanName = vlanName;
            return this;
        }

        public final String getAllocationId() {
            return this.allocationId;
        }

        public final void setAllocationId(String allocationId) {
            this.allocationId = allocationId;
        }

        @Override
        public final Builder allocationId(String allocationId) {
            this.allocationId = allocationId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateEipToVlanRequest build() {
            return new AssociateEipToVlanRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends EvsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateEipToVlanRequest> {
        public Builder clientToken(String var1);

        public Builder environmentId(String var1);

        public Builder vlanName(String var1);

        public Builder allocationId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

