/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.evs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents a host.
 * </p>
 * <note>
 * <p>
 * You cannot use <code>dedicatedHostId</code> and <code>placementGroupId</code> together in the same
 * <code>HostInfoForCreate</code>object. This results in a <code>ValidationException</code> response.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HostInfoForCreate implements SdkPojo, Serializable,
        ToCopyableBuilder<HostInfoForCreate.Builder, HostInfoForCreate> {
    private static final SdkField<String> HOST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("hostName").getter(getter(HostInfoForCreate::hostName)).setter(setter(Builder::hostName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostName").build()).build();

    private static final SdkField<String> KEY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("keyName").getter(getter(HostInfoForCreate::keyName)).setter(setter(Builder::keyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyName").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instanceType").getter(getter(HostInfoForCreate::instanceTypeAsString))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceType").build()).build();

    private static final SdkField<String> PLACEMENT_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("placementGroupId").getter(getter(HostInfoForCreate::placementGroupId))
            .setter(setter(Builder::placementGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("placementGroupId").build()).build();

    private static final SdkField<String> DEDICATED_HOST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dedicatedHostId").getter(getter(HostInfoForCreate::dedicatedHostId))
            .setter(setter(Builder::dedicatedHostId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dedicatedHostId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOST_NAME_FIELD,
            KEY_NAME_FIELD, INSTANCE_TYPE_FIELD, PLACEMENT_GROUP_ID_FIELD, DEDICATED_HOST_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String hostName;

    private final String keyName;

    private final String instanceType;

    private final String placementGroupId;

    private final String dedicatedHostId;

    private HostInfoForCreate(BuilderImpl builder) {
        this.hostName = builder.hostName;
        this.keyName = builder.keyName;
        this.instanceType = builder.instanceType;
        this.placementGroupId = builder.placementGroupId;
        this.dedicatedHostId = builder.dedicatedHostId;
    }

    /**
     * <p>
     * The DNS hostname of the host. DNS hostnames for hosts must be unique across Amazon EVS environments and within
     * VCF.
     * </p>
     * 
     * @return The DNS hostname of the host. DNS hostnames for hosts must be unique across Amazon EVS environments and
     *         within VCF.
     */
    public final String hostName() {
        return hostName;
    }

    /**
     * <p>
     * The name of the SSH key that is used to access the host.
     * </p>
     * 
     * @return The name of the SSH key that is used to access the host.
     */
    public final String keyName() {
        return keyName;
    }

    /**
     * <p>
     * The EC2 instance type that represents the host.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The EC2 instance type that represents the host.
     * @see InstanceType
     */
    public final InstanceType instanceType() {
        return InstanceType.fromValue(instanceType);
    }

    /**
     * <p>
     * The EC2 instance type that represents the host.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The EC2 instance type that represents the host.
     * @see InstanceType
     */
    public final String instanceTypeAsString() {
        return instanceType;
    }

    /**
     * <p>
     * The unique ID of the placement group where the host is placed.
     * </p>
     * 
     * @return The unique ID of the placement group where the host is placed.
     */
    public final String placementGroupId() {
        return placementGroupId;
    }

    /**
     * <p>
     * The unique ID of the Amazon EC2 Dedicated Host.
     * </p>
     * 
     * @return The unique ID of the Amazon EC2 Dedicated Host.
     */
    public final String dedicatedHostId() {
        return dedicatedHostId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hostName());
        hashCode = 31 * hashCode + Objects.hashCode(keyName());
        hashCode = 31 * hashCode + Objects.hashCode(instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(placementGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(dedicatedHostId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HostInfoForCreate)) {
            return false;
        }
        HostInfoForCreate other = (HostInfoForCreate) obj;
        return Objects.equals(hostName(), other.hostName()) && Objects.equals(keyName(), other.keyName())
                && Objects.equals(instanceTypeAsString(), other.instanceTypeAsString())
                && Objects.equals(placementGroupId(), other.placementGroupId())
                && Objects.equals(dedicatedHostId(), other.dedicatedHostId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HostInfoForCreate").add("HostName", hostName()).add("KeyName", keyName())
                .add("InstanceType", instanceTypeAsString()).add("PlacementGroupId", placementGroupId())
                .add("DedicatedHostId", dedicatedHostId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "hostName":
            return Optional.ofNullable(clazz.cast(hostName()));
        case "keyName":
            return Optional.ofNullable(clazz.cast(keyName()));
        case "instanceType":
            return Optional.ofNullable(clazz.cast(instanceTypeAsString()));
        case "placementGroupId":
            return Optional.ofNullable(clazz.cast(placementGroupId()));
        case "dedicatedHostId":
            return Optional.ofNullable(clazz.cast(dedicatedHostId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("hostName", HOST_NAME_FIELD);
        map.put("keyName", KEY_NAME_FIELD);
        map.put("instanceType", INSTANCE_TYPE_FIELD);
        map.put("placementGroupId", PLACEMENT_GROUP_ID_FIELD);
        map.put("dedicatedHostId", DEDICATED_HOST_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HostInfoForCreate, T> g) {
        return obj -> g.apply((HostInfoForCreate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HostInfoForCreate> {
        /**
         * <p>
         * The DNS hostname of the host. DNS hostnames for hosts must be unique across Amazon EVS environments and
         * within VCF.
         * </p>
         * 
         * @param hostName
         *        The DNS hostname of the host. DNS hostnames for hosts must be unique across Amazon EVS environments
         *        and within VCF.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostName(String hostName);

        /**
         * <p>
         * The name of the SSH key that is used to access the host.
         * </p>
         * 
         * @param keyName
         *        The name of the SSH key that is used to access the host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyName(String keyName);

        /**
         * <p>
         * The EC2 instance type that represents the host.
         * </p>
         * 
         * @param instanceType
         *        The EC2 instance type that represents the host.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The EC2 instance type that represents the host.
         * </p>
         * 
         * @param instanceType
         *        The EC2 instance type that represents the host.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(InstanceType instanceType);

        /**
         * <p>
         * The unique ID of the placement group where the host is placed.
         * </p>
         * 
         * @param placementGroupId
         *        The unique ID of the placement group where the host is placed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementGroupId(String placementGroupId);

        /**
         * <p>
         * The unique ID of the Amazon EC2 Dedicated Host.
         * </p>
         * 
         * @param dedicatedHostId
         *        The unique ID of the Amazon EC2 Dedicated Host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dedicatedHostId(String dedicatedHostId);
    }

    static final class BuilderImpl implements Builder {
        private String hostName;

        private String keyName;

        private String instanceType;

        private String placementGroupId;

        private String dedicatedHostId;

        private BuilderImpl() {
        }

        private BuilderImpl(HostInfoForCreate model) {
            hostName(model.hostName);
            keyName(model.keyName);
            instanceType(model.instanceType);
            placementGroupId(model.placementGroupId);
            dedicatedHostId(model.dedicatedHostId);
        }

        public final String getHostName() {
            return hostName;
        }

        public final void setHostName(String hostName) {
            this.hostName = hostName;
        }

        @Override
        public final Builder hostName(String hostName) {
            this.hostName = hostName;
            return this;
        }

        public final String getKeyName() {
            return keyName;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final String getPlacementGroupId() {
            return placementGroupId;
        }

        public final void setPlacementGroupId(String placementGroupId) {
            this.placementGroupId = placementGroupId;
        }

        @Override
        public final Builder placementGroupId(String placementGroupId) {
            this.placementGroupId = placementGroupId;
            return this;
        }

        public final String getDedicatedHostId() {
            return dedicatedHostId;
        }

        public final void setDedicatedHostId(String dedicatedHostId) {
            this.dedicatedHostId = dedicatedHostId;
        }

        @Override
        public final Builder dedicatedHostId(String dedicatedHostId) {
            this.dedicatedHostId = dedicatedHostId;
            return this;
        }

        @Override
        public HostInfoForCreate build() {
            return new HostInfoForCreate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
