/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspace;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.finspace.model.AccessDeniedException;
import software.amazon.awssdk.services.finspace.model.CreateEnvironmentRequest;
import software.amazon.awssdk.services.finspace.model.CreateEnvironmentResponse;
import software.amazon.awssdk.services.finspace.model.DeleteEnvironmentRequest;
import software.amazon.awssdk.services.finspace.model.DeleteEnvironmentResponse;
import software.amazon.awssdk.services.finspace.model.FinspaceException;
import software.amazon.awssdk.services.finspace.model.GetEnvironmentRequest;
import software.amazon.awssdk.services.finspace.model.GetEnvironmentResponse;
import software.amazon.awssdk.services.finspace.model.InternalServerException;
import software.amazon.awssdk.services.finspace.model.InvalidRequestException;
import software.amazon.awssdk.services.finspace.model.LimitExceededException;
import software.amazon.awssdk.services.finspace.model.ListEnvironmentsRequest;
import software.amazon.awssdk.services.finspace.model.ListEnvironmentsResponse;
import software.amazon.awssdk.services.finspace.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.finspace.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.finspace.model.ResourceNotFoundException;
import software.amazon.awssdk.services.finspace.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.finspace.model.TagResourceRequest;
import software.amazon.awssdk.services.finspace.model.TagResourceResponse;
import software.amazon.awssdk.services.finspace.model.ThrottlingException;
import software.amazon.awssdk.services.finspace.model.UntagResourceRequest;
import software.amazon.awssdk.services.finspace.model.UntagResourceResponse;
import software.amazon.awssdk.services.finspace.model.UpdateEnvironmentRequest;
import software.amazon.awssdk.services.finspace.model.UpdateEnvironmentResponse;
import software.amazon.awssdk.services.finspace.model.ValidationException;

/**
 * Service client for accessing finspace. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * The FinSpace management service provides the APIs for managing the FinSpace environments.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface FinspaceClient extends SdkClient {
    String SERVICE_NAME = "finspace";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "finspace";

    /**
     * Create a {@link FinspaceClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static FinspaceClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link FinspaceClient}.
     */
    static FinspaceClientBuilder builder() {
        return new DefaultFinspaceClientBuilder();
    }

    /**
     * <p>
     * Create a new FinSpace environment.
     * </p>
     *
     * @param createEnvironmentRequest
     * @return Result of the CreateEnvironment operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use Service Quotas to request a service quota increase.
     * @throws LimitExceededException
     *         A service limit or quota is exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.CreateEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/CreateEnvironment" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateEnvironmentResponse createEnvironment(CreateEnvironmentRequest createEnvironmentRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, ThrottlingException,
            ServiceQuotaExceededException, LimitExceededException, AwsServiceException, SdkClientException, FinspaceException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a new FinSpace environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEnvironmentRequest.Builder} avoiding the need
     * to create one manually via {@link CreateEnvironmentRequest#builder()}
     * </p>
     *
     * @param createEnvironmentRequest
     *        A {@link Consumer} that will call methods on {@link CreateEnvironmentRequest.Builder} to create a request.
     * @return Result of the CreateEnvironment operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use Service Quotas to request a service quota increase.
     * @throws LimitExceededException
     *         A service limit or quota is exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.CreateEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/CreateEnvironment" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateEnvironmentResponse createEnvironment(Consumer<CreateEnvironmentRequest.Builder> createEnvironmentRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, ThrottlingException,
            ServiceQuotaExceededException, LimitExceededException, AwsServiceException, SdkClientException, FinspaceException {
        return createEnvironment(CreateEnvironmentRequest.builder().applyMutation(createEnvironmentRequest).build());
    }

    /**
     * <p>
     * Delete an FinSpace environment.
     * </p>
     *
     * @param deleteEnvironmentRequest
     * @return Result of the DeleteEnvironment operation returned by the service.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.DeleteEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/DeleteEnvironment" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteEnvironmentResponse deleteEnvironment(DeleteEnvironmentRequest deleteEnvironmentRequest)
            throws ResourceNotFoundException, InternalServerException, AccessDeniedException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, FinspaceException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete an FinSpace environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEnvironmentRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteEnvironmentRequest#builder()}
     * </p>
     *
     * @param deleteEnvironmentRequest
     *        A {@link Consumer} that will call methods on {@link DeleteEnvironmentRequest.Builder} to create a request.
     * @return Result of the DeleteEnvironment operation returned by the service.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.DeleteEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/DeleteEnvironment" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteEnvironmentResponse deleteEnvironment(Consumer<DeleteEnvironmentRequest.Builder> deleteEnvironmentRequest)
            throws ResourceNotFoundException, InternalServerException, AccessDeniedException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, FinspaceException {
        return deleteEnvironment(DeleteEnvironmentRequest.builder().applyMutation(deleteEnvironmentRequest).build());
    }

    /**
     * <p>
     * Returns the FinSpace environment object.
     * </p>
     *
     * @param getEnvironmentRequest
     * @return Result of the GetEnvironment operation returned by the service.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.GetEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/GetEnvironment" target="_top">AWS API
     *      Documentation</a>
     */
    default GetEnvironmentResponse getEnvironment(GetEnvironmentRequest getEnvironmentRequest) throws ResourceNotFoundException,
            InternalServerException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            FinspaceException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the FinSpace environment object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEnvironmentRequest.Builder} avoiding the need to
     * create one manually via {@link GetEnvironmentRequest#builder()}
     * </p>
     *
     * @param getEnvironmentRequest
     *        A {@link Consumer} that will call methods on {@link GetEnvironmentRequest.Builder} to create a request.
     * @return Result of the GetEnvironment operation returned by the service.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.GetEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/GetEnvironment" target="_top">AWS API
     *      Documentation</a>
     */
    default GetEnvironmentResponse getEnvironment(Consumer<GetEnvironmentRequest.Builder> getEnvironmentRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, FinspaceException {
        return getEnvironment(GetEnvironmentRequest.builder().applyMutation(getEnvironmentRequest).build());
    }

    /**
     * <p>
     * A list of all of your FinSpace environments.
     * </p>
     *
     * @param listEnvironmentsRequest
     * @return Result of the ListEnvironments operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.ListEnvironments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/ListEnvironments" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEnvironmentsResponse listEnvironments(ListEnvironmentsRequest listEnvironmentsRequest)
            throws InternalServerException, ValidationException, AwsServiceException, SdkClientException, FinspaceException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A list of all of your FinSpace environments.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEnvironmentsRequest.Builder} avoiding the need
     * to create one manually via {@link ListEnvironmentsRequest#builder()}
     * </p>
     *
     * @param listEnvironmentsRequest
     *        A {@link Consumer} that will call methods on {@link ListEnvironmentsRequest.Builder} to create a request.
     * @return Result of the ListEnvironments operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.ListEnvironments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/ListEnvironments" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEnvironmentsResponse listEnvironments(Consumer<ListEnvironmentsRequest.Builder> listEnvironmentsRequest)
            throws InternalServerException, ValidationException, AwsServiceException, SdkClientException, FinspaceException {
        return listEnvironments(ListEnvironmentsRequest.builder().applyMutation(listEnvironmentsRequest).build());
    }

    /**
     * <p>
     * A list of all tags for a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws InvalidRequestException
     *         The request is invalid. Something is wrong with the input to the request.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InternalServerException, InvalidRequestException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, FinspaceException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A list of all tags for a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws InvalidRequestException
     *         The request is invalid. Something is wrong with the input to the request.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws InternalServerException,
            InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, FinspaceException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Adds metadata tags to a FinSpace resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws InvalidRequestException
     *         The request is invalid. Something is wrong with the input to the request.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalServerException,
            InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, FinspaceException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds metadata tags to a FinSpace resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws InvalidRequestException
     *         The request is invalid. Something is wrong with the input to the request.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws InternalServerException, InvalidRequestException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, FinspaceException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes metadata tags from a FinSpace resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws InvalidRequestException
     *         The request is invalid. Something is wrong with the input to the request.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalServerException,
            InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, FinspaceException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes metadata tags from a FinSpace resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws InvalidRequestException
     *         The request is invalid. Something is wrong with the input to the request.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws InternalServerException, InvalidRequestException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, FinspaceException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Update your FinSpace environment.
     * </p>
     *
     * @param updateEnvironmentRequest
     * @return Result of the UpdateEnvironment operation returned by the service.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.UpdateEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/UpdateEnvironment" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateEnvironmentResponse updateEnvironment(UpdateEnvironmentRequest updateEnvironmentRequest)
            throws ResourceNotFoundException, InternalServerException, AccessDeniedException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, FinspaceException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update your FinSpace environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEnvironmentRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateEnvironmentRequest#builder()}
     * </p>
     *
     * @param updateEnvironmentRequest
     *        A {@link Consumer} that will call methods on {@link UpdateEnvironmentRequest.Builder} to create a request.
     * @return Result of the UpdateEnvironment operation returned by the service.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.UpdateEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/UpdateEnvironment" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateEnvironmentResponse updateEnvironment(Consumer<UpdateEnvironmentRequest.Builder> updateEnvironmentRequest)
            throws ResourceNotFoundException, InternalServerException, AccessDeniedException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, FinspaceException {
        return updateEnvironment(UpdateEnvironmentRequest.builder().applyMutation(updateEnvironmentRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }
}
