/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspace.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateEnvironmentRequest extends FinspaceRequest implements
        ToCopyableBuilder<CreateEnvironmentRequest.Builder, CreateEnvironmentRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateEnvironmentRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateEnvironmentRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyId").getter(getter(CreateEnvironmentRequest::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateEnvironmentRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> FEDERATION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("federationMode").getter(getter(CreateEnvironmentRequest::federationModeAsString))
            .setter(setter(Builder::federationMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("federationMode").build()).build();

    private static final SdkField<FederationParameters> FEDERATION_PARAMETERS_FIELD = SdkField
            .<FederationParameters> builder(MarshallingType.SDK_POJO).memberName("federationParameters")
            .getter(getter(CreateEnvironmentRequest::federationParameters)).setter(setter(Builder::federationParameters))
            .constructor(FederationParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("federationParameters").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            KMS_KEY_ID_FIELD, TAGS_FIELD, FEDERATION_MODE_FIELD, FEDERATION_PARAMETERS_FIELD));

    private final String name;

    private final String description;

    private final String kmsKeyId;

    private final Map<String, String> tags;

    private final String federationMode;

    private final FederationParameters federationParameters;

    private CreateEnvironmentRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.kmsKeyId = builder.kmsKeyId;
        this.tags = builder.tags;
        this.federationMode = builder.federationMode;
        this.federationParameters = builder.federationParameters;
    }

    /**
     * <p>
     * The name of the FinSpace environment to be created.
     * </p>
     * 
     * @return The name of the FinSpace environment to be created.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the FinSpace environment to be created.
     * </p>
     * 
     * @return The description of the FinSpace environment to be created.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The KMS key id to encrypt your data in the FinSpace environment.
     * </p>
     * 
     * @return The KMS key id to encrypt your data in the FinSpace environment.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Add tags to your FinSpace environment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Add tags to your FinSpace environment.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * Authentication mode for the environment.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>FEDERATED</code> - Users access FinSpace through Single Sign On (SSO) via your Identity provider.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LOCAL</code> - Users access FinSpace via email and password managed within the FinSpace environment.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #federationMode}
     * will return {@link FederationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #federationModeAsString}.
     * </p>
     * 
     * @return Authentication mode for the environment.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>FEDERATED</code> - Users access FinSpace through Single Sign On (SSO) via your Identity provider.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LOCAL</code> - Users access FinSpace via email and password managed within the FinSpace
     *         environment.
     *         </p>
     *         </li>
     * @see FederationMode
     */
    public final FederationMode federationMode() {
        return FederationMode.fromValue(federationMode);
    }

    /**
     * <p>
     * Authentication mode for the environment.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>FEDERATED</code> - Users access FinSpace through Single Sign On (SSO) via your Identity provider.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LOCAL</code> - Users access FinSpace via email and password managed within the FinSpace environment.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #federationMode}
     * will return {@link FederationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #federationModeAsString}.
     * </p>
     * 
     * @return Authentication mode for the environment.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>FEDERATED</code> - Users access FinSpace through Single Sign On (SSO) via your Identity provider.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LOCAL</code> - Users access FinSpace via email and password managed within the FinSpace
     *         environment.
     *         </p>
     *         </li>
     * @see FederationMode
     */
    public final String federationModeAsString() {
        return federationMode;
    }

    /**
     * <p>
     * Configuration information when authentication mode is FEDERATED.
     * </p>
     * 
     * @return Configuration information when authentication mode is FEDERATED.
     */
    public final FederationParameters federationParameters() {
        return federationParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(federationModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(federationParameters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEnvironmentRequest)) {
            return false;
        }
        CreateEnvironmentRequest other = (CreateEnvironmentRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(kmsKeyId(), other.kmsKeyId()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags())
                && Objects.equals(federationModeAsString(), other.federationModeAsString())
                && Objects.equals(federationParameters(), other.federationParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateEnvironmentRequest").add("Name", name()).add("Description", description())
                .add("KmsKeyId", kmsKeyId()).add("Tags", hasTags() ? tags() : null)
                .add("FederationMode", federationModeAsString()).add("FederationParameters", federationParameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "kmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "federationMode":
            return Optional.ofNullable(clazz.cast(federationModeAsString()));
        case "federationParameters":
            return Optional.ofNullable(clazz.cast(federationParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateEnvironmentRequest, T> g) {
        return obj -> g.apply((CreateEnvironmentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FinspaceRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateEnvironmentRequest> {
        /**
         * <p>
         * The name of the FinSpace environment to be created.
         * </p>
         * 
         * @param name
         *        The name of the FinSpace environment to be created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the FinSpace environment to be created.
         * </p>
         * 
         * @param description
         *        The description of the FinSpace environment to be created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The KMS key id to encrypt your data in the FinSpace environment.
         * </p>
         * 
         * @param kmsKeyId
         *        The KMS key id to encrypt your data in the FinSpace environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * Add tags to your FinSpace environment.
         * </p>
         * 
         * @param tags
         *        Add tags to your FinSpace environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * Authentication mode for the environment.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>FEDERATED</code> - Users access FinSpace through Single Sign On (SSO) via your Identity provider.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LOCAL</code> - Users access FinSpace via email and password managed within the FinSpace environment.
         * </p>
         * </li>
         * </ul>
         * 
         * @param federationMode
         *        Authentication mode for the environment.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>FEDERATED</code> - Users access FinSpace through Single Sign On (SSO) via your Identity
         *        provider.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LOCAL</code> - Users access FinSpace via email and password managed within the FinSpace
         *        environment.
         *        </p>
         *        </li>
         * @see FederationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FederationMode
         */
        Builder federationMode(String federationMode);

        /**
         * <p>
         * Authentication mode for the environment.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>FEDERATED</code> - Users access FinSpace through Single Sign On (SSO) via your Identity provider.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LOCAL</code> - Users access FinSpace via email and password managed within the FinSpace environment.
         * </p>
         * </li>
         * </ul>
         * 
         * @param federationMode
         *        Authentication mode for the environment.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>FEDERATED</code> - Users access FinSpace through Single Sign On (SSO) via your Identity
         *        provider.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LOCAL</code> - Users access FinSpace via email and password managed within the FinSpace
         *        environment.
         *        </p>
         *        </li>
         * @see FederationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FederationMode
         */
        Builder federationMode(FederationMode federationMode);

        /**
         * <p>
         * Configuration information when authentication mode is FEDERATED.
         * </p>
         * 
         * @param federationParameters
         *        Configuration information when authentication mode is FEDERATED.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder federationParameters(FederationParameters federationParameters);

        /**
         * <p>
         * Configuration information when authentication mode is FEDERATED.
         * </p>
         * This is a convenience that creates an instance of the {@link FederationParameters.Builder} avoiding the need
         * to create one manually via {@link FederationParameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link FederationParameters.Builder#build()} is called immediately and
         * its result is passed to {@link #federationParameters(FederationParameters)}.
         * 
         * @param federationParameters
         *        a consumer that will call methods on {@link FederationParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #federationParameters(FederationParameters)
         */
        default Builder federationParameters(Consumer<FederationParameters.Builder> federationParameters) {
            return federationParameters(FederationParameters.builder().applyMutation(federationParameters).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FinspaceRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private String kmsKeyId;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String federationMode;

        private FederationParameters federationParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEnvironmentRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            kmsKeyId(model.kmsKeyId);
            tags(model.tags);
            federationMode(model.federationMode);
            federationParameters(model.federationParameters);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        public final String getFederationMode() {
            return federationMode;
        }

        @Override
        public final Builder federationMode(String federationMode) {
            this.federationMode = federationMode;
            return this;
        }

        @Override
        public final Builder federationMode(FederationMode federationMode) {
            this.federationMode(federationMode == null ? null : federationMode.toString());
            return this;
        }

        public final void setFederationMode(String federationMode) {
            this.federationMode = federationMode;
        }

        public final FederationParameters.Builder getFederationParameters() {
            return federationParameters != null ? federationParameters.toBuilder() : null;
        }

        @Override
        public final Builder federationParameters(FederationParameters federationParameters) {
            this.federationParameters = federationParameters;
            return this;
        }

        public final void setFederationParameters(FederationParameters.BuilderImpl federationParameters) {
            this.federationParameters = federationParameters != null ? federationParameters.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEnvironmentRequest build() {
            return new CreateEnvironmentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
