/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspace.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateKxDataviewResponse extends FinspaceResponse implements
        ToCopyableBuilder<CreateKxDataviewResponse.Builder, CreateKxDataviewResponse> {
    private static final SdkField<String> DATAVIEW_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataviewName").getter(getter(CreateKxDataviewResponse::dataviewName))
            .setter(setter(Builder::dataviewName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataviewName").build()).build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("databaseName").getter(getter(CreateKxDataviewResponse::databaseName))
            .setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("databaseName").build()).build();

    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentId").getter(getter(CreateKxDataviewResponse::environmentId))
            .setter(setter(Builder::environmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentId").build()).build();

    private static final SdkField<String> AZ_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("azMode")
            .getter(getter(CreateKxDataviewResponse::azModeAsString)).setter(setter(Builder::azMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("azMode").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("availabilityZoneId").getter(getter(CreateKxDataviewResponse::availabilityZoneId))
            .setter(setter(Builder::availabilityZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZoneId").build())
            .build();

    private static final SdkField<String> CHANGESET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("changesetId").getter(getter(CreateKxDataviewResponse::changesetId)).setter(setter(Builder::changesetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("changesetId").build()).build();

    private static final SdkField<List<KxDataviewSegmentConfiguration>> SEGMENT_CONFIGURATIONS_FIELD = SdkField
            .<List<KxDataviewSegmentConfiguration>> builder(MarshallingType.LIST)
            .memberName("segmentConfigurations")
            .getter(getter(CreateKxDataviewResponse::segmentConfigurations))
            .setter(setter(Builder::segmentConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<KxDataviewSegmentConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(KxDataviewSegmentConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateKxDataviewResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Boolean> AUTO_UPDATE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("autoUpdate").getter(getter(CreateKxDataviewResponse::autoUpdate)).setter(setter(Builder::autoUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoUpdate").build()).build();

    private static final SdkField<Boolean> READ_WRITE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("readWrite").getter(getter(CreateKxDataviewResponse::readWrite)).setter(setter(Builder::readWrite))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readWrite").build()).build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdTimestamp").getter(getter(CreateKxDataviewResponse::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTimestamp").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModifiedTimestamp").getter(getter(CreateKxDataviewResponse::lastModifiedTimestamp))
            .setter(setter(Builder::lastModifiedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTimestamp").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(CreateKxDataviewResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATAVIEW_NAME_FIELD,
            DATABASE_NAME_FIELD, ENVIRONMENT_ID_FIELD, AZ_MODE_FIELD, AVAILABILITY_ZONE_ID_FIELD, CHANGESET_ID_FIELD,
            SEGMENT_CONFIGURATIONS_FIELD, DESCRIPTION_FIELD, AUTO_UPDATE_FIELD, READ_WRITE_FIELD, CREATED_TIMESTAMP_FIELD,
            LAST_MODIFIED_TIMESTAMP_FIELD, STATUS_FIELD));

    private final String dataviewName;

    private final String databaseName;

    private final String environmentId;

    private final String azMode;

    private final String availabilityZoneId;

    private final String changesetId;

    private final List<KxDataviewSegmentConfiguration> segmentConfigurations;

    private final String description;

    private final Boolean autoUpdate;

    private final Boolean readWrite;

    private final Instant createdTimestamp;

    private final Instant lastModifiedTimestamp;

    private final String status;

    private CreateKxDataviewResponse(BuilderImpl builder) {
        super(builder);
        this.dataviewName = builder.dataviewName;
        this.databaseName = builder.databaseName;
        this.environmentId = builder.environmentId;
        this.azMode = builder.azMode;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.changesetId = builder.changesetId;
        this.segmentConfigurations = builder.segmentConfigurations;
        this.description = builder.description;
        this.autoUpdate = builder.autoUpdate;
        this.readWrite = builder.readWrite;
        this.createdTimestamp = builder.createdTimestamp;
        this.lastModifiedTimestamp = builder.lastModifiedTimestamp;
        this.status = builder.status;
    }

    /**
     * <p>
     * A unique identifier for the dataview.
     * </p>
     * 
     * @return A unique identifier for the dataview.
     */
    public final String dataviewName() {
        return dataviewName;
    }

    /**
     * <p>
     * The name of the database where you want to create a dataview.
     * </p>
     * 
     * @return The name of the database where you want to create a dataview.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * A unique identifier for the kdb environment, where you want to create the dataview.
     * </p>
     * 
     * @return A unique identifier for the kdb environment, where you want to create the dataview.
     */
    public final String environmentId() {
        return environmentId;
    }

    /**
     * <p>
     * The number of availability zones you want to assign per volume. Currently, FinSpace only supports
     * <code>SINGLE</code> for volumes. This places dataview in a single AZ.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #azMode} will
     * return {@link KxAzMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #azModeAsString}.
     * </p>
     * 
     * @return The number of availability zones you want to assign per volume. Currently, FinSpace only supports
     *         <code>SINGLE</code> for volumes. This places dataview in a single AZ.
     * @see KxAzMode
     */
    public final KxAzMode azMode() {
        return KxAzMode.fromValue(azMode);
    }

    /**
     * <p>
     * The number of availability zones you want to assign per volume. Currently, FinSpace only supports
     * <code>SINGLE</code> for volumes. This places dataview in a single AZ.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #azMode} will
     * return {@link KxAzMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #azModeAsString}.
     * </p>
     * 
     * @return The number of availability zones you want to assign per volume. Currently, FinSpace only supports
     *         <code>SINGLE</code> for volumes. This places dataview in a single AZ.
     * @see KxAzMode
     */
    public final String azModeAsString() {
        return azMode;
    }

    /**
     * <p>
     * The identifier of the availability zones.
     * </p>
     * 
     * @return The identifier of the availability zones.
     */
    public final String availabilityZoneId() {
        return availabilityZoneId;
    }

    /**
     * <p>
     * A unique identifier for the changeset.
     * </p>
     * 
     * @return A unique identifier for the changeset.
     */
    public final String changesetId() {
        return changesetId;
    }

    /**
     * For responses, this returns true if the service returned a value for the SegmentConfigurations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSegmentConfigurations() {
        return segmentConfigurations != null && !(segmentConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The configuration that contains the database path of the data that you want to place on each selected volume.
     * Each segment must have a unique database path for each volume. If you do not explicitly specify any database path
     * for a volume, they are accessible from the cluster through the default S3/object store segment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSegmentConfigurations} method.
     * </p>
     * 
     * @return The configuration that contains the database path of the data that you want to place on each selected
     *         volume. Each segment must have a unique database path for each volume. If you do not explicitly specify
     *         any database path for a volume, they are accessible from the cluster through the default S3/object store
     *         segment.
     */
    public final List<KxDataviewSegmentConfiguration> segmentConfigurations() {
        return segmentConfigurations;
    }

    /**
     * <p>
     * A description of the dataview.
     * </p>
     * 
     * @return A description of the dataview.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The option to select whether you want to apply all the future additions and corrections automatically to the
     * dataview when you ingest new changesets. The default value is false.
     * </p>
     * 
     * @return The option to select whether you want to apply all the future additions and corrections automatically to
     *         the dataview when you ingest new changesets. The default value is false.
     */
    public final Boolean autoUpdate() {
        return autoUpdate;
    }

    /**
     * <p>
     * Returns True if the dataview is created as writeable and False otherwise.
     * </p>
     * 
     * @return Returns True if the dataview is created as writeable and False otherwise.
     */
    public final Boolean readWrite() {
        return readWrite;
    }

    /**
     * <p>
     * The timestamp at which the dataview was created in FinSpace. The value is determined as epoch time in
     * milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
     * </p>
     * 
     * @return The timestamp at which the dataview was created in FinSpace. The value is determined as epoch time in
     *         milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as
     *         1635768000000.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    /**
     * <p>
     * The last time that the dataview was updated in FinSpace. The value is determined as epoch time in milliseconds.
     * For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
     * </p>
     * 
     * @return The last time that the dataview was updated in FinSpace. The value is determined as epoch time in
     *         milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as
     *         1635768000000.
     */
    public final Instant lastModifiedTimestamp() {
        return lastModifiedTimestamp;
    }

    /**
     * <p>
     * The status of dataview creation.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATING</code> – The dataview creation is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATING</code> – The dataview is in the process of being updated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code> – The dataview is active.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link KxDataviewStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of dataview creation.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATING</code> – The dataview creation is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATING</code> – The dataview is in the process of being updated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> – The dataview is active.
     *         </p>
     *         </li>
     * @see KxDataviewStatus
     */
    public final KxDataviewStatus status() {
        return KxDataviewStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of dataview creation.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATING</code> – The dataview creation is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATING</code> – The dataview is in the process of being updated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code> – The dataview is active.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link KxDataviewStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of dataview creation.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATING</code> – The dataview creation is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATING</code> – The dataview is in the process of being updated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> – The dataview is active.
     *         </p>
     *         </li>
     * @see KxDataviewStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dataviewName());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(azModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(changesetId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSegmentConfigurations() ? segmentConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(autoUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(readWrite());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateKxDataviewResponse)) {
            return false;
        }
        CreateKxDataviewResponse other = (CreateKxDataviewResponse) obj;
        return Objects.equals(dataviewName(), other.dataviewName()) && Objects.equals(databaseName(), other.databaseName())
                && Objects.equals(environmentId(), other.environmentId())
                && Objects.equals(azModeAsString(), other.azModeAsString())
                && Objects.equals(availabilityZoneId(), other.availabilityZoneId())
                && Objects.equals(changesetId(), other.changesetId())
                && hasSegmentConfigurations() == other.hasSegmentConfigurations()
                && Objects.equals(segmentConfigurations(), other.segmentConfigurations())
                && Objects.equals(description(), other.description()) && Objects.equals(autoUpdate(), other.autoUpdate())
                && Objects.equals(readWrite(), other.readWrite()) && Objects.equals(createdTimestamp(), other.createdTimestamp())
                && Objects.equals(lastModifiedTimestamp(), other.lastModifiedTimestamp())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateKxDataviewResponse").add("DataviewName", dataviewName())
                .add("DatabaseName", databaseName()).add("EnvironmentId", environmentId()).add("AzMode", azModeAsString())
                .add("AvailabilityZoneId", availabilityZoneId()).add("ChangesetId", changesetId())
                .add("SegmentConfigurations", hasSegmentConfigurations() ? segmentConfigurations() : null)
                .add("Description", description()).add("AutoUpdate", autoUpdate()).add("ReadWrite", readWrite())
                .add("CreatedTimestamp", createdTimestamp()).add("LastModifiedTimestamp", lastModifiedTimestamp())
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dataviewName":
            return Optional.ofNullable(clazz.cast(dataviewName()));
        case "databaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "environmentId":
            return Optional.ofNullable(clazz.cast(environmentId()));
        case "azMode":
            return Optional.ofNullable(clazz.cast(azModeAsString()));
        case "availabilityZoneId":
            return Optional.ofNullable(clazz.cast(availabilityZoneId()));
        case "changesetId":
            return Optional.ofNullable(clazz.cast(changesetId()));
        case "segmentConfigurations":
            return Optional.ofNullable(clazz.cast(segmentConfigurations()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "autoUpdate":
            return Optional.ofNullable(clazz.cast(autoUpdate()));
        case "readWrite":
            return Optional.ofNullable(clazz.cast(readWrite()));
        case "createdTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        case "lastModifiedTimestamp":
            return Optional.ofNullable(clazz.cast(lastModifiedTimestamp()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateKxDataviewResponse, T> g) {
        return obj -> g.apply((CreateKxDataviewResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FinspaceResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateKxDataviewResponse> {
        /**
         * <p>
         * A unique identifier for the dataview.
         * </p>
         * 
         * @param dataviewName
         *        A unique identifier for the dataview.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataviewName(String dataviewName);

        /**
         * <p>
         * The name of the database where you want to create a dataview.
         * </p>
         * 
         * @param databaseName
         *        The name of the database where you want to create a dataview.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * A unique identifier for the kdb environment, where you want to create the dataview.
         * </p>
         * 
         * @param environmentId
         *        A unique identifier for the kdb environment, where you want to create the dataview.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentId(String environmentId);

        /**
         * <p>
         * The number of availability zones you want to assign per volume. Currently, FinSpace only supports
         * <code>SINGLE</code> for volumes. This places dataview in a single AZ.
         * </p>
         * 
         * @param azMode
         *        The number of availability zones you want to assign per volume. Currently, FinSpace only supports
         *        <code>SINGLE</code> for volumes. This places dataview in a single AZ.
         * @see KxAzMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KxAzMode
         */
        Builder azMode(String azMode);

        /**
         * <p>
         * The number of availability zones you want to assign per volume. Currently, FinSpace only supports
         * <code>SINGLE</code> for volumes. This places dataview in a single AZ.
         * </p>
         * 
         * @param azMode
         *        The number of availability zones you want to assign per volume. Currently, FinSpace only supports
         *        <code>SINGLE</code> for volumes. This places dataview in a single AZ.
         * @see KxAzMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KxAzMode
         */
        Builder azMode(KxAzMode azMode);

        /**
         * <p>
         * The identifier of the availability zones.
         * </p>
         * 
         * @param availabilityZoneId
         *        The identifier of the availability zones.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZoneId(String availabilityZoneId);

        /**
         * <p>
         * A unique identifier for the changeset.
         * </p>
         * 
         * @param changesetId
         *        A unique identifier for the changeset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changesetId(String changesetId);

        /**
         * <p>
         * The configuration that contains the database path of the data that you want to place on each selected volume.
         * Each segment must have a unique database path for each volume. If you do not explicitly specify any database
         * path for a volume, they are accessible from the cluster through the default S3/object store segment.
         * </p>
         * 
         * @param segmentConfigurations
         *        The configuration that contains the database path of the data that you want to place on each selected
         *        volume. Each segment must have a unique database path for each volume. If you do not explicitly
         *        specify any database path for a volume, they are accessible from the cluster through the default
         *        S3/object store segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentConfigurations(Collection<KxDataviewSegmentConfiguration> segmentConfigurations);

        /**
         * <p>
         * The configuration that contains the database path of the data that you want to place on each selected volume.
         * Each segment must have a unique database path for each volume. If you do not explicitly specify any database
         * path for a volume, they are accessible from the cluster through the default S3/object store segment.
         * </p>
         * 
         * @param segmentConfigurations
         *        The configuration that contains the database path of the data that you want to place on each selected
         *        volume. Each segment must have a unique database path for each volume. If you do not explicitly
         *        specify any database path for a volume, they are accessible from the cluster through the default
         *        S3/object store segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentConfigurations(KxDataviewSegmentConfiguration... segmentConfigurations);

        /**
         * <p>
         * The configuration that contains the database path of the data that you want to place on each selected volume.
         * Each segment must have a unique database path for each volume. If you do not explicitly specify any database
         * path for a volume, they are accessible from the cluster through the default S3/object store segment.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.finspace.model.KxDataviewSegmentConfiguration.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.finspace.model.KxDataviewSegmentConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.finspace.model.KxDataviewSegmentConfiguration.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #segmentConfigurations(List<KxDataviewSegmentConfiguration>)}.
         * 
         * @param segmentConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.finspace.model.KxDataviewSegmentConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #segmentConfigurations(java.util.Collection<KxDataviewSegmentConfiguration>)
         */
        Builder segmentConfigurations(Consumer<KxDataviewSegmentConfiguration.Builder>... segmentConfigurations);

        /**
         * <p>
         * A description of the dataview.
         * </p>
         * 
         * @param description
         *        A description of the dataview.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The option to select whether you want to apply all the future additions and corrections automatically to the
         * dataview when you ingest new changesets. The default value is false.
         * </p>
         * 
         * @param autoUpdate
         *        The option to select whether you want to apply all the future additions and corrections automatically
         *        to the dataview when you ingest new changesets. The default value is false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoUpdate(Boolean autoUpdate);

        /**
         * <p>
         * Returns True if the dataview is created as writeable and False otherwise.
         * </p>
         * 
         * @param readWrite
         *        Returns True if the dataview is created as writeable and False otherwise.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readWrite(Boolean readWrite);

        /**
         * <p>
         * The timestamp at which the dataview was created in FinSpace. The value is determined as epoch time in
         * milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as
         * 1635768000000.
         * </p>
         * 
         * @param createdTimestamp
         *        The timestamp at which the dataview was created in FinSpace. The value is determined as epoch time in
         *        milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as
         *        1635768000000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);

        /**
         * <p>
         * The last time that the dataview was updated in FinSpace. The value is determined as epoch time in
         * milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as
         * 1635768000000.
         * </p>
         * 
         * @param lastModifiedTimestamp
         *        The last time that the dataview was updated in FinSpace. The value is determined as epoch time in
         *        milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as
         *        1635768000000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTimestamp(Instant lastModifiedTimestamp);

        /**
         * <p>
         * The status of dataview creation.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATING</code> – The dataview creation is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATING</code> – The dataview is in the process of being updated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code> – The dataview is active.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of dataview creation.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATING</code> – The dataview creation is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATING</code> – The dataview is in the process of being updated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> – The dataview is active.
         *        </p>
         *        </li>
         * @see KxDataviewStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KxDataviewStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of dataview creation.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATING</code> – The dataview creation is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATING</code> – The dataview is in the process of being updated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code> – The dataview is active.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of dataview creation.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATING</code> – The dataview creation is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATING</code> – The dataview is in the process of being updated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> – The dataview is active.
         *        </p>
         *        </li>
         * @see KxDataviewStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KxDataviewStatus
         */
        Builder status(KxDataviewStatus status);
    }

    static final class BuilderImpl extends FinspaceResponse.BuilderImpl implements Builder {
        private String dataviewName;

        private String databaseName;

        private String environmentId;

        private String azMode;

        private String availabilityZoneId;

        private String changesetId;

        private List<KxDataviewSegmentConfiguration> segmentConfigurations = DefaultSdkAutoConstructList.getInstance();

        private String description;

        private Boolean autoUpdate;

        private Boolean readWrite;

        private Instant createdTimestamp;

        private Instant lastModifiedTimestamp;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateKxDataviewResponse model) {
            super(model);
            dataviewName(model.dataviewName);
            databaseName(model.databaseName);
            environmentId(model.environmentId);
            azMode(model.azMode);
            availabilityZoneId(model.availabilityZoneId);
            changesetId(model.changesetId);
            segmentConfigurations(model.segmentConfigurations);
            description(model.description);
            autoUpdate(model.autoUpdate);
            readWrite(model.readWrite);
            createdTimestamp(model.createdTimestamp);
            lastModifiedTimestamp(model.lastModifiedTimestamp);
            status(model.status);
        }

        public final String getDataviewName() {
            return dataviewName;
        }

        public final void setDataviewName(String dataviewName) {
            this.dataviewName = dataviewName;
        }

        @Override
        public final Builder dataviewName(String dataviewName) {
            this.dataviewName = dataviewName;
            return this;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getEnvironmentId() {
            return environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final String getAzMode() {
            return azMode;
        }

        public final void setAzMode(String azMode) {
            this.azMode = azMode;
        }

        @Override
        public final Builder azMode(String azMode) {
            this.azMode = azMode;
            return this;
        }

        @Override
        public final Builder azMode(KxAzMode azMode) {
            this.azMode(azMode == null ? null : azMode.toString());
            return this;
        }

        public final String getAvailabilityZoneId() {
            return availabilityZoneId;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final String getChangesetId() {
            return changesetId;
        }

        public final void setChangesetId(String changesetId) {
            this.changesetId = changesetId;
        }

        @Override
        public final Builder changesetId(String changesetId) {
            this.changesetId = changesetId;
            return this;
        }

        public final List<KxDataviewSegmentConfiguration.Builder> getSegmentConfigurations() {
            List<KxDataviewSegmentConfiguration.Builder> result = KxDataviewSegmentConfigurationListCopier
                    .copyToBuilder(this.segmentConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSegmentConfigurations(Collection<KxDataviewSegmentConfiguration.BuilderImpl> segmentConfigurations) {
            this.segmentConfigurations = KxDataviewSegmentConfigurationListCopier.copyFromBuilder(segmentConfigurations);
        }

        @Override
        public final Builder segmentConfigurations(Collection<KxDataviewSegmentConfiguration> segmentConfigurations) {
            this.segmentConfigurations = KxDataviewSegmentConfigurationListCopier.copy(segmentConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder segmentConfigurations(KxDataviewSegmentConfiguration... segmentConfigurations) {
            segmentConfigurations(Arrays.asList(segmentConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder segmentConfigurations(Consumer<KxDataviewSegmentConfiguration.Builder>... segmentConfigurations) {
            segmentConfigurations(Stream.of(segmentConfigurations)
                    .map(c -> KxDataviewSegmentConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getAutoUpdate() {
            return autoUpdate;
        }

        public final void setAutoUpdate(Boolean autoUpdate) {
            this.autoUpdate = autoUpdate;
        }

        @Override
        public final Builder autoUpdate(Boolean autoUpdate) {
            this.autoUpdate = autoUpdate;
            return this;
        }

        public final Boolean getReadWrite() {
            return readWrite;
        }

        public final void setReadWrite(Boolean readWrite) {
            this.readWrite = readWrite;
        }

        @Override
        public final Builder readWrite(Boolean readWrite) {
            this.readWrite = readWrite;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getLastModifiedTimestamp() {
            return lastModifiedTimestamp;
        }

        public final void setLastModifiedTimestamp(Instant lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
        }

        @Override
        public final Builder lastModifiedTimestamp(Instant lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(KxDataviewStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public CreateKxDataviewResponse build() {
            return new CreateKxDataviewResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
