/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspace.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration that allows you to choose how you want to update code on a cluster. Depending on the option you
 * choose, you can reduce the time it takes to update the cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KxClusterCodeDeploymentConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<KxClusterCodeDeploymentConfiguration.Builder, KxClusterCodeDeploymentConfiguration> {
    private static final SdkField<String> DEPLOYMENT_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deploymentStrategy").getter(getter(KxClusterCodeDeploymentConfiguration::deploymentStrategyAsString))
            .setter(setter(Builder::deploymentStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentStrategy").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_STRATEGY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String deploymentStrategy;

    private KxClusterCodeDeploymentConfiguration(BuilderImpl builder) {
        this.deploymentStrategy = builder.deploymentStrategy;
    }

    /**
     * <p>
     * The type of deployment that you want on a cluster.
     * </p>
     * <ul>
     * <li>
     * <p>
     * ROLLING – This options updates the cluster by stopping the exiting q process and starting a new q process with
     * updated configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * NO_RESTART – This option updates the cluster without stopping the running q process. It is only available for
     * <code>GP</code> type cluster. This option is quicker as it reduces the turn around time to update configuration
     * on a cluster.
     * </p>
     * <p>
     * With this deployment mode, you cannot update the <code>initializationScript</code> and
     * <code>commandLineArguments</code> parameters.
     * </p>
     * </li>
     * <li>
     * <p>
     * FORCE – This option updates the cluster by immediately stopping all the running processes before starting up new
     * ones with the updated configuration.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deploymentStrategy} will return {@link KxClusterCodeDeploymentStrategy#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #deploymentStrategyAsString}.
     * </p>
     * 
     * @return The type of deployment that you want on a cluster. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         ROLLING – This options updates the cluster by stopping the exiting q process and starting a new q process
     *         with updated configuration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NO_RESTART – This option updates the cluster without stopping the running q process. It is only available
     *         for <code>GP</code> type cluster. This option is quicker as it reduces the turn around time to update
     *         configuration on a cluster.
     *         </p>
     *         <p>
     *         With this deployment mode, you cannot update the <code>initializationScript</code> and
     *         <code>commandLineArguments</code> parameters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FORCE – This option updates the cluster by immediately stopping all the running processes before starting
     *         up new ones with the updated configuration.
     *         </p>
     *         </li>
     * @see KxClusterCodeDeploymentStrategy
     */
    public final KxClusterCodeDeploymentStrategy deploymentStrategy() {
        return KxClusterCodeDeploymentStrategy.fromValue(deploymentStrategy);
    }

    /**
     * <p>
     * The type of deployment that you want on a cluster.
     * </p>
     * <ul>
     * <li>
     * <p>
     * ROLLING – This options updates the cluster by stopping the exiting q process and starting a new q process with
     * updated configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * NO_RESTART – This option updates the cluster without stopping the running q process. It is only available for
     * <code>GP</code> type cluster. This option is quicker as it reduces the turn around time to update configuration
     * on a cluster.
     * </p>
     * <p>
     * With this deployment mode, you cannot update the <code>initializationScript</code> and
     * <code>commandLineArguments</code> parameters.
     * </p>
     * </li>
     * <li>
     * <p>
     * FORCE – This option updates the cluster by immediately stopping all the running processes before starting up new
     * ones with the updated configuration.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deploymentStrategy} will return {@link KxClusterCodeDeploymentStrategy#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #deploymentStrategyAsString}.
     * </p>
     * 
     * @return The type of deployment that you want on a cluster. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         ROLLING – This options updates the cluster by stopping the exiting q process and starting a new q process
     *         with updated configuration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NO_RESTART – This option updates the cluster without stopping the running q process. It is only available
     *         for <code>GP</code> type cluster. This option is quicker as it reduces the turn around time to update
     *         configuration on a cluster.
     *         </p>
     *         <p>
     *         With this deployment mode, you cannot update the <code>initializationScript</code> and
     *         <code>commandLineArguments</code> parameters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FORCE – This option updates the cluster by immediately stopping all the running processes before starting
     *         up new ones with the updated configuration.
     *         </p>
     *         </li>
     * @see KxClusterCodeDeploymentStrategy
     */
    public final String deploymentStrategyAsString() {
        return deploymentStrategy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deploymentStrategyAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KxClusterCodeDeploymentConfiguration)) {
            return false;
        }
        KxClusterCodeDeploymentConfiguration other = (KxClusterCodeDeploymentConfiguration) obj;
        return Objects.equals(deploymentStrategyAsString(), other.deploymentStrategyAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KxClusterCodeDeploymentConfiguration").add("DeploymentStrategy", deploymentStrategyAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deploymentStrategy":
            return Optional.ofNullable(clazz.cast(deploymentStrategyAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KxClusterCodeDeploymentConfiguration, T> g) {
        return obj -> g.apply((KxClusterCodeDeploymentConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KxClusterCodeDeploymentConfiguration> {
        /**
         * <p>
         * The type of deployment that you want on a cluster.
         * </p>
         * <ul>
         * <li>
         * <p>
         * ROLLING – This options updates the cluster by stopping the exiting q process and starting a new q process
         * with updated configuration.
         * </p>
         * </li>
         * <li>
         * <p>
         * NO_RESTART – This option updates the cluster without stopping the running q process. It is only available for
         * <code>GP</code> type cluster. This option is quicker as it reduces the turn around time to update
         * configuration on a cluster.
         * </p>
         * <p>
         * With this deployment mode, you cannot update the <code>initializationScript</code> and
         * <code>commandLineArguments</code> parameters.
         * </p>
         * </li>
         * <li>
         * <p>
         * FORCE – This option updates the cluster by immediately stopping all the running processes before starting up
         * new ones with the updated configuration.
         * </p>
         * </li>
         * </ul>
         * 
         * @param deploymentStrategy
         *        The type of deployment that you want on a cluster. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        ROLLING – This options updates the cluster by stopping the exiting q process and starting a new q
         *        process with updated configuration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        NO_RESTART – This option updates the cluster without stopping the running q process. It is only
         *        available for <code>GP</code> type cluster. This option is quicker as it reduces the turn around time
         *        to update configuration on a cluster.
         *        </p>
         *        <p>
         *        With this deployment mode, you cannot update the <code>initializationScript</code> and
         *        <code>commandLineArguments</code> parameters.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FORCE – This option updates the cluster by immediately stopping all the running processes before
         *        starting up new ones with the updated configuration.
         *        </p>
         *        </li>
         * @see KxClusterCodeDeploymentStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KxClusterCodeDeploymentStrategy
         */
        Builder deploymentStrategy(String deploymentStrategy);

        /**
         * <p>
         * The type of deployment that you want on a cluster.
         * </p>
         * <ul>
         * <li>
         * <p>
         * ROLLING – This options updates the cluster by stopping the exiting q process and starting a new q process
         * with updated configuration.
         * </p>
         * </li>
         * <li>
         * <p>
         * NO_RESTART – This option updates the cluster without stopping the running q process. It is only available for
         * <code>GP</code> type cluster. This option is quicker as it reduces the turn around time to update
         * configuration on a cluster.
         * </p>
         * <p>
         * With this deployment mode, you cannot update the <code>initializationScript</code> and
         * <code>commandLineArguments</code> parameters.
         * </p>
         * </li>
         * <li>
         * <p>
         * FORCE – This option updates the cluster by immediately stopping all the running processes before starting up
         * new ones with the updated configuration.
         * </p>
         * </li>
         * </ul>
         * 
         * @param deploymentStrategy
         *        The type of deployment that you want on a cluster. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        ROLLING – This options updates the cluster by stopping the exiting q process and starting a new q
         *        process with updated configuration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        NO_RESTART – This option updates the cluster without stopping the running q process. It is only
         *        available for <code>GP</code> type cluster. This option is quicker as it reduces the turn around time
         *        to update configuration on a cluster.
         *        </p>
         *        <p>
         *        With this deployment mode, you cannot update the <code>initializationScript</code> and
         *        <code>commandLineArguments</code> parameters.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FORCE – This option updates the cluster by immediately stopping all the running processes before
         *        starting up new ones with the updated configuration.
         *        </p>
         *        </li>
         * @see KxClusterCodeDeploymentStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KxClusterCodeDeploymentStrategy
         */
        Builder deploymentStrategy(KxClusterCodeDeploymentStrategy deploymentStrategy);
    }

    static final class BuilderImpl implements Builder {
        private String deploymentStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(KxClusterCodeDeploymentConfiguration model) {
            deploymentStrategy(model.deploymentStrategy);
        }

        public final String getDeploymentStrategy() {
            return deploymentStrategy;
        }

        public final void setDeploymentStrategy(String deploymentStrategy) {
            this.deploymentStrategy = deploymentStrategy;
        }

        @Override
        public final Builder deploymentStrategy(String deploymentStrategy) {
            this.deploymentStrategy = deploymentStrategy;
            return this;
        }

        @Override
        public final Builder deploymentStrategy(KxClusterCodeDeploymentStrategy deploymentStrategy) {
            this.deploymentStrategy(deploymentStrategy == null ? null : deploymentStrategy.toString());
            return this;
        }

        @Override
        public KxClusterCodeDeploymentConfiguration build() {
            return new KxClusterCodeDeploymentConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
