/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspace.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The active version of the dataview that is currently in use by this cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KxDataviewActiveVersion implements SdkPojo, Serializable,
        ToCopyableBuilder<KxDataviewActiveVersion.Builder, KxDataviewActiveVersion> {
    private static final SdkField<String> CHANGESET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("changesetId").getter(getter(KxDataviewActiveVersion::changesetId)).setter(setter(Builder::changesetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("changesetId").build()).build();

    private static final SdkField<List<KxDataviewSegmentConfiguration>> SEGMENT_CONFIGURATIONS_FIELD = SdkField
            .<List<KxDataviewSegmentConfiguration>> builder(MarshallingType.LIST)
            .memberName("segmentConfigurations")
            .getter(getter(KxDataviewActiveVersion::segmentConfigurations))
            .setter(setter(Builder::segmentConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<KxDataviewSegmentConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(KxDataviewSegmentConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ATTACHED_CLUSTERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("attachedClusters")
            .getter(getter(KxDataviewActiveVersion::attachedClusters))
            .setter(setter(Builder::attachedClusters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachedClusters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdTimestamp").getter(getter(KxDataviewActiveVersion::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTimestamp").build()).build();

    private static final SdkField<String> VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("versionId").getter(getter(KxDataviewActiveVersion::versionId)).setter(setter(Builder::versionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANGESET_ID_FIELD,
            SEGMENT_CONFIGURATIONS_FIELD, ATTACHED_CLUSTERS_FIELD, CREATED_TIMESTAMP_FIELD, VERSION_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String changesetId;

    private final List<KxDataviewSegmentConfiguration> segmentConfigurations;

    private final List<String> attachedClusters;

    private final Instant createdTimestamp;

    private final String versionId;

    private KxDataviewActiveVersion(BuilderImpl builder) {
        this.changesetId = builder.changesetId;
        this.segmentConfigurations = builder.segmentConfigurations;
        this.attachedClusters = builder.attachedClusters;
        this.createdTimestamp = builder.createdTimestamp;
        this.versionId = builder.versionId;
    }

    /**
     * <p>
     * A unique identifier for the changeset.
     * </p>
     * 
     * @return A unique identifier for the changeset.
     */
    public final String changesetId() {
        return changesetId;
    }

    /**
     * For responses, this returns true if the service returned a value for the SegmentConfigurations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSegmentConfigurations() {
        return segmentConfigurations != null && !(segmentConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The configuration that contains the database path of the data that you want to place on each selected volume.
     * Each segment must have a unique database path for each volume. If you do not explicitly specify any database path
     * for a volume, they are accessible from the cluster through the default S3/object store segment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSegmentConfigurations} method.
     * </p>
     * 
     * @return The configuration that contains the database path of the data that you want to place on each selected
     *         volume. Each segment must have a unique database path for each volume. If you do not explicitly specify
     *         any database path for a volume, they are accessible from the cluster through the default S3/object store
     *         segment.
     */
    public final List<KxDataviewSegmentConfiguration> segmentConfigurations() {
        return segmentConfigurations;
    }

    /**
     * For responses, this returns true if the service returned a value for the AttachedClusters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAttachedClusters() {
        return attachedClusters != null && !(attachedClusters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of clusters that are currently using this dataview.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttachedClusters} method.
     * </p>
     * 
     * @return The list of clusters that are currently using this dataview.
     */
    public final List<String> attachedClusters() {
        return attachedClusters;
    }

    /**
     * <p>
     * The timestamp at which the dataview version was active. The value is determined as epoch time in milliseconds.
     * For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
     * </p>
     * 
     * @return The timestamp at which the dataview version was active. The value is determined as epoch time in
     *         milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as
     *         1635768000000.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    /**
     * <p>
     * A unique identifier of the active version.
     * </p>
     * 
     * @return A unique identifier of the active version.
     */
    public final String versionId() {
        return versionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(changesetId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSegmentConfigurations() ? segmentConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAttachedClusters() ? attachedClusters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(versionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KxDataviewActiveVersion)) {
            return false;
        }
        KxDataviewActiveVersion other = (KxDataviewActiveVersion) obj;
        return Objects.equals(changesetId(), other.changesetId())
                && hasSegmentConfigurations() == other.hasSegmentConfigurations()
                && Objects.equals(segmentConfigurations(), other.segmentConfigurations())
                && hasAttachedClusters() == other.hasAttachedClusters()
                && Objects.equals(attachedClusters(), other.attachedClusters())
                && Objects.equals(createdTimestamp(), other.createdTimestamp()) && Objects.equals(versionId(), other.versionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KxDataviewActiveVersion").add("ChangesetId", changesetId())
                .add("SegmentConfigurations", hasSegmentConfigurations() ? segmentConfigurations() : null)
                .add("AttachedClusters", hasAttachedClusters() ? attachedClusters() : null)
                .add("CreatedTimestamp", createdTimestamp()).add("VersionId", versionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "changesetId":
            return Optional.ofNullable(clazz.cast(changesetId()));
        case "segmentConfigurations":
            return Optional.ofNullable(clazz.cast(segmentConfigurations()));
        case "attachedClusters":
            return Optional.ofNullable(clazz.cast(attachedClusters()));
        case "createdTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        case "versionId":
            return Optional.ofNullable(clazz.cast(versionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KxDataviewActiveVersion, T> g) {
        return obj -> g.apply((KxDataviewActiveVersion) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KxDataviewActiveVersion> {
        /**
         * <p>
         * A unique identifier for the changeset.
         * </p>
         * 
         * @param changesetId
         *        A unique identifier for the changeset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changesetId(String changesetId);

        /**
         * <p>
         * The configuration that contains the database path of the data that you want to place on each selected volume.
         * Each segment must have a unique database path for each volume. If you do not explicitly specify any database
         * path for a volume, they are accessible from the cluster through the default S3/object store segment.
         * </p>
         * 
         * @param segmentConfigurations
         *        The configuration that contains the database path of the data that you want to place on each selected
         *        volume. Each segment must have a unique database path for each volume. If you do not explicitly
         *        specify any database path for a volume, they are accessible from the cluster through the default
         *        S3/object store segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentConfigurations(Collection<KxDataviewSegmentConfiguration> segmentConfigurations);

        /**
         * <p>
         * The configuration that contains the database path of the data that you want to place on each selected volume.
         * Each segment must have a unique database path for each volume. If you do not explicitly specify any database
         * path for a volume, they are accessible from the cluster through the default S3/object store segment.
         * </p>
         * 
         * @param segmentConfigurations
         *        The configuration that contains the database path of the data that you want to place on each selected
         *        volume. Each segment must have a unique database path for each volume. If you do not explicitly
         *        specify any database path for a volume, they are accessible from the cluster through the default
         *        S3/object store segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentConfigurations(KxDataviewSegmentConfiguration... segmentConfigurations);

        /**
         * <p>
         * The configuration that contains the database path of the data that you want to place on each selected volume.
         * Each segment must have a unique database path for each volume. If you do not explicitly specify any database
         * path for a volume, they are accessible from the cluster through the default S3/object store segment.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.finspace.model.KxDataviewSegmentConfiguration.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.finspace.model.KxDataviewSegmentConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.finspace.model.KxDataviewSegmentConfiguration.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #segmentConfigurations(List<KxDataviewSegmentConfiguration>)}.
         * 
         * @param segmentConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.finspace.model.KxDataviewSegmentConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #segmentConfigurations(java.util.Collection<KxDataviewSegmentConfiguration>)
         */
        Builder segmentConfigurations(Consumer<KxDataviewSegmentConfiguration.Builder>... segmentConfigurations);

        /**
         * <p>
         * The list of clusters that are currently using this dataview.
         * </p>
         * 
         * @param attachedClusters
         *        The list of clusters that are currently using this dataview.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachedClusters(Collection<String> attachedClusters);

        /**
         * <p>
         * The list of clusters that are currently using this dataview.
         * </p>
         * 
         * @param attachedClusters
         *        The list of clusters that are currently using this dataview.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachedClusters(String... attachedClusters);

        /**
         * <p>
         * The timestamp at which the dataview version was active. The value is determined as epoch time in
         * milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as
         * 1635768000000.
         * </p>
         * 
         * @param createdTimestamp
         *        The timestamp at which the dataview version was active. The value is determined as epoch time in
         *        milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as
         *        1635768000000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);

        /**
         * <p>
         * A unique identifier of the active version.
         * </p>
         * 
         * @param versionId
         *        A unique identifier of the active version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionId(String versionId);
    }

    static final class BuilderImpl implements Builder {
        private String changesetId;

        private List<KxDataviewSegmentConfiguration> segmentConfigurations = DefaultSdkAutoConstructList.getInstance();

        private List<String> attachedClusters = DefaultSdkAutoConstructList.getInstance();

        private Instant createdTimestamp;

        private String versionId;

        private BuilderImpl() {
        }

        private BuilderImpl(KxDataviewActiveVersion model) {
            changesetId(model.changesetId);
            segmentConfigurations(model.segmentConfigurations);
            attachedClusters(model.attachedClusters);
            createdTimestamp(model.createdTimestamp);
            versionId(model.versionId);
        }

        public final String getChangesetId() {
            return changesetId;
        }

        public final void setChangesetId(String changesetId) {
            this.changesetId = changesetId;
        }

        @Override
        public final Builder changesetId(String changesetId) {
            this.changesetId = changesetId;
            return this;
        }

        public final List<KxDataviewSegmentConfiguration.Builder> getSegmentConfigurations() {
            List<KxDataviewSegmentConfiguration.Builder> result = KxDataviewSegmentConfigurationListCopier
                    .copyToBuilder(this.segmentConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSegmentConfigurations(Collection<KxDataviewSegmentConfiguration.BuilderImpl> segmentConfigurations) {
            this.segmentConfigurations = KxDataviewSegmentConfigurationListCopier.copyFromBuilder(segmentConfigurations);
        }

        @Override
        public final Builder segmentConfigurations(Collection<KxDataviewSegmentConfiguration> segmentConfigurations) {
            this.segmentConfigurations = KxDataviewSegmentConfigurationListCopier.copy(segmentConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder segmentConfigurations(KxDataviewSegmentConfiguration... segmentConfigurations) {
            segmentConfigurations(Arrays.asList(segmentConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder segmentConfigurations(Consumer<KxDataviewSegmentConfiguration.Builder>... segmentConfigurations) {
            segmentConfigurations(Stream.of(segmentConfigurations)
                    .map(c -> KxDataviewSegmentConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getAttachedClusters() {
            if (attachedClusters instanceof SdkAutoConstructList) {
                return null;
            }
            return attachedClusters;
        }

        public final void setAttachedClusters(Collection<String> attachedClusters) {
            this.attachedClusters = AttachedClusterListCopier.copy(attachedClusters);
        }

        @Override
        public final Builder attachedClusters(Collection<String> attachedClusters) {
            this.attachedClusters = AttachedClusterListCopier.copy(attachedClusters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachedClusters(String... attachedClusters) {
            attachedClusters(Arrays.asList(attachedClusters));
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final String getVersionId() {
            return versionId;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        @Override
        public KxDataviewActiveVersion build() {
            return new KxDataviewActiveVersion(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
