/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspace.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The structure containing the size and type of the network attached storage (NAS_1) file system volume.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KxNAS1Configuration implements SdkPojo, Serializable,
        ToCopyableBuilder<KxNAS1Configuration.Builder, KxNAS1Configuration> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(KxNAS1Configuration::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<Integer> SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("size")
            .getter(getter(KxNAS1Configuration::size)).setter(setter(Builder::size))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("size").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, SIZE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final Integer size;

    private KxNAS1Configuration(BuilderImpl builder) {
        this.type = builder.type;
        this.size = builder.size;
    }

    /**
     * <p>
     * The type of the network attached storage.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link KxNAS1Type#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the network attached storage.
     * @see KxNAS1Type
     */
    public final KxNAS1Type type() {
        return KxNAS1Type.fromValue(type);
    }

    /**
     * <p>
     * The type of the network attached storage.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link KxNAS1Type#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the network attached storage.
     * @see KxNAS1Type
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The size of the network attached storage. For storage type <code>SSD_1000</code> and <code>SSD_250</code> you can
     * select the minimum size as 1200 GB or increments of 2400 GB. For storage type <code>HDD_12</code> you can select
     * the minimum size as 6000 GB or increments of 6000 GB.
     * </p>
     * 
     * @return The size of the network attached storage. For storage type <code>SSD_1000</code> and <code>SSD_250</code>
     *         you can select the minimum size as 1200 GB or increments of 2400 GB. For storage type <code>HDD_12</code>
     *         you can select the minimum size as 6000 GB or increments of 6000 GB.
     */
    public final Integer size() {
        return size;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(size());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KxNAS1Configuration)) {
            return false;
        }
        KxNAS1Configuration other = (KxNAS1Configuration) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(size(), other.size());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KxNAS1Configuration").add("Type", typeAsString()).add("Size", size()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "size":
            return Optional.ofNullable(clazz.cast(size()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KxNAS1Configuration, T> g) {
        return obj -> g.apply((KxNAS1Configuration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KxNAS1Configuration> {
        /**
         * <p>
         * The type of the network attached storage.
         * </p>
         * 
         * @param type
         *        The type of the network attached storage.
         * @see KxNAS1Type
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KxNAS1Type
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the network attached storage.
         * </p>
         * 
         * @param type
         *        The type of the network attached storage.
         * @see KxNAS1Type
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KxNAS1Type
         */
        Builder type(KxNAS1Type type);

        /**
         * <p>
         * The size of the network attached storage. For storage type <code>SSD_1000</code> and <code>SSD_250</code> you
         * can select the minimum size as 1200 GB or increments of 2400 GB. For storage type <code>HDD_12</code> you can
         * select the minimum size as 6000 GB or increments of 6000 GB.
         * </p>
         * 
         * @param size
         *        The size of the network attached storage. For storage type <code>SSD_1000</code> and
         *        <code>SSD_250</code> you can select the minimum size as 1200 GB or increments of 2400 GB. For storage
         *        type <code>HDD_12</code> you can select the minimum size as 6000 GB or increments of 6000 GB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder size(Integer size);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private Integer size;

        private BuilderImpl() {
        }

        private BuilderImpl(KxNAS1Configuration model) {
            type(model.type);
            size(model.size);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(KxNAS1Type type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Integer getSize() {
            return size;
        }

        public final void setSize(Integer size) {
            this.size = size;
        }

        @Override
        public final Builder size(Integer size) {
            this.size = size;
            return this;
        }

        @Override
        public KxNAS1Configuration build() {
            return new KxNAS1Configuration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
