/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspace.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.finspace.FinspaceAsyncClient;
import software.amazon.awssdk.services.finspace.internal.UserAgentUtils;
import software.amazon.awssdk.services.finspace.model.ListKxScalingGroupsRequest;
import software.amazon.awssdk.services.finspace.model.ListKxScalingGroupsResponse;

public class ListKxScalingGroupsPublisher
implements SdkPublisher<ListKxScalingGroupsResponse> {
    private final FinspaceAsyncClient client;
    private final ListKxScalingGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListKxScalingGroupsPublisher(FinspaceAsyncClient client, ListKxScalingGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListKxScalingGroupsPublisher(FinspaceAsyncClient client, ListKxScalingGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListKxScalingGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListKxScalingGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListKxScalingGroupsResponseFetcher
    implements AsyncPageFetcher<ListKxScalingGroupsResponse> {
        private ListKxScalingGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListKxScalingGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListKxScalingGroupsResponse> nextPage(ListKxScalingGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListKxScalingGroupsPublisher.this.client.listKxScalingGroups(ListKxScalingGroupsPublisher.this.firstRequest);
            }
            return ListKxScalingGroupsPublisher.this.client.listKxScalingGroups((ListKxScalingGroupsRequest)((Object)ListKxScalingGroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

