/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspace.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetKxDataviewRequest extends FinspaceRequest implements
        ToCopyableBuilder<GetKxDataviewRequest.Builder, GetKxDataviewRequest> {
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentId").getter(getter(GetKxDataviewRequest::environmentId))
            .setter(setter(Builder::environmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("environmentId").build()).build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("databaseName").getter(getter(GetKxDataviewRequest::databaseName)).setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("databaseName").build()).build();

    private static final SdkField<String> DATAVIEW_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataviewName").getter(getter(GetKxDataviewRequest::dataviewName)).setter(setter(Builder::dataviewName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("dataviewName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENT_ID_FIELD,
            DATABASE_NAME_FIELD, DATAVIEW_NAME_FIELD));

    private final String environmentId;

    private final String databaseName;

    private final String dataviewName;

    private GetKxDataviewRequest(BuilderImpl builder) {
        super(builder);
        this.environmentId = builder.environmentId;
        this.databaseName = builder.databaseName;
        this.dataviewName = builder.dataviewName;
    }

    /**
     * <p>
     * A unique identifier for the kdb environment, from where you want to retrieve the dataview details.
     * </p>
     * 
     * @return A unique identifier for the kdb environment, from where you want to retrieve the dataview details.
     */
    public final String environmentId() {
        return environmentId;
    }

    /**
     * <p>
     * The name of the database where you created the dataview.
     * </p>
     * 
     * @return The name of the database where you created the dataview.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * A unique identifier for the dataview.
     * </p>
     * 
     * @return A unique identifier for the dataview.
     */
    public final String dataviewName() {
        return dataviewName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(dataviewName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetKxDataviewRequest)) {
            return false;
        }
        GetKxDataviewRequest other = (GetKxDataviewRequest) obj;
        return Objects.equals(environmentId(), other.environmentId()) && Objects.equals(databaseName(), other.databaseName())
                && Objects.equals(dataviewName(), other.dataviewName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetKxDataviewRequest").add("EnvironmentId", environmentId()).add("DatabaseName", databaseName())
                .add("DataviewName", dataviewName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "environmentId":
            return Optional.ofNullable(clazz.cast(environmentId()));
        case "databaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "dataviewName":
            return Optional.ofNullable(clazz.cast(dataviewName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetKxDataviewRequest, T> g) {
        return obj -> g.apply((GetKxDataviewRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FinspaceRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetKxDataviewRequest> {
        /**
         * <p>
         * A unique identifier for the kdb environment, from where you want to retrieve the dataview details.
         * </p>
         * 
         * @param environmentId
         *        A unique identifier for the kdb environment, from where you want to retrieve the dataview details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentId(String environmentId);

        /**
         * <p>
         * The name of the database where you created the dataview.
         * </p>
         * 
         * @param databaseName
         *        The name of the database where you created the dataview.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * A unique identifier for the dataview.
         * </p>
         * 
         * @param dataviewName
         *        A unique identifier for the dataview.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataviewName(String dataviewName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FinspaceRequest.BuilderImpl implements Builder {
        private String environmentId;

        private String databaseName;

        private String dataviewName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetKxDataviewRequest model) {
            super(model);
            environmentId(model.environmentId);
            databaseName(model.databaseName);
            dataviewName(model.dataviewName);
        }

        public final String getEnvironmentId() {
            return environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getDataviewName() {
            return dataviewName;
        }

        public final void setDataviewName(String dataviewName) {
            this.dataviewName = dataviewName;
        }

        @Override
        public final Builder dataviewName(String dataviewName) {
            this.dataviewName = dataviewName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetKxDataviewRequest build() {
            return new GetKxDataviewRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
