/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspace.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the ICMP protocol that consists of the ICMP type and code.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IcmpTypeCode implements SdkPojo, Serializable, ToCopyableBuilder<IcmpTypeCode.Builder, IcmpTypeCode> {
    private static final SdkField<Integer> TYPE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("type")
            .getter(getter(IcmpTypeCode::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<Integer> CODE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("code")
            .getter(getter(IcmpTypeCode::code)).setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("code").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, CODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer type;

    private final Integer code;

    private IcmpTypeCode(BuilderImpl builder) {
        this.type = builder.type;
        this.code = builder.code;
    }

    /**
     * <p>
     * The ICMP type. A value of <i>-1</i> means all types.
     * </p>
     * 
     * @return The ICMP type. A value of <i>-1</i> means all types.
     */
    public final Integer type() {
        return type;
    }

    /**
     * <p>
     * The ICMP code. A value of <i>-1</i> means all codes for the specified ICMP type.
     * </p>
     * 
     * @return The ICMP code. A value of <i>-1</i> means all codes for the specified ICMP type.
     */
    public final Integer code() {
        return code;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(code());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IcmpTypeCode)) {
            return false;
        }
        IcmpTypeCode other = (IcmpTypeCode) obj;
        return Objects.equals(type(), other.type()) && Objects.equals(code(), other.code());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IcmpTypeCode").add("Type", type()).add("Code", code()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(type()));
        case "code":
            return Optional.ofNullable(clazz.cast(code()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IcmpTypeCode, T> g) {
        return obj -> g.apply((IcmpTypeCode) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IcmpTypeCode> {
        /**
         * <p>
         * The ICMP type. A value of <i>-1</i> means all types.
         * </p>
         * 
         * @param type
         *        The ICMP type. A value of <i>-1</i> means all types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(Integer type);

        /**
         * <p>
         * The ICMP code. A value of <i>-1</i> means all codes for the specified ICMP type.
         * </p>
         * 
         * @param code
         *        The ICMP code. A value of <i>-1</i> means all codes for the specified ICMP type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(Integer code);
    }

    static final class BuilderImpl implements Builder {
        private Integer type;

        private Integer code;

        private BuilderImpl() {
        }

        private BuilderImpl(IcmpTypeCode model) {
            type(model.type);
            code(model.code);
        }

        public final Integer getType() {
            return type;
        }

        public final void setType(Integer type) {
            this.type = type;
        }

        @Override
        public final Builder type(Integer type) {
            this.type = type;
            return this;
        }

        public final Integer getCode() {
            return code;
        }

        public final void setCode(Integer code) {
            this.code = code;
        }

        @Override
        public final Builder code(Integer code) {
            this.code = code;
            return this;
        }

        @Override
        public IcmpTypeCode build() {
            return new IcmpTypeCode(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
