/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspace.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum KxClusterType {
    HDB("HDB"),
    RDB("RDB"),
    GATEWAY("GATEWAY"),
    GP("GP"),
    TICKERPLANT("TICKERPLANT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, KxClusterType> VALUE_MAP;
    private final String value;

    private KxClusterType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static KxClusterType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<KxClusterType> knownValues() {
        EnumSet<KxClusterType> knownValues = EnumSet.allOf(KxClusterType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(KxClusterType.class, KxClusterType::toString);
    }
}

