/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspace.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateKxDataviewRequest extends FinspaceRequest implements
        ToCopyableBuilder<CreateKxDataviewRequest.Builder, CreateKxDataviewRequest> {
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentId").getter(getter(CreateKxDataviewRequest::environmentId))
            .setter(setter(Builder::environmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("environmentId").build()).build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("databaseName").getter(getter(CreateKxDataviewRequest::databaseName))
            .setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("databaseName").build()).build();

    private static final SdkField<String> DATAVIEW_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataviewName").getter(getter(CreateKxDataviewRequest::dataviewName))
            .setter(setter(Builder::dataviewName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataviewName").build()).build();

    private static final SdkField<String> AZ_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("azMode")
            .getter(getter(CreateKxDataviewRequest::azModeAsString)).setter(setter(Builder::azMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("azMode").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("availabilityZoneId").getter(getter(CreateKxDataviewRequest::availabilityZoneId))
            .setter(setter(Builder::availabilityZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZoneId").build())
            .build();

    private static final SdkField<String> CHANGESET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("changesetId").getter(getter(CreateKxDataviewRequest::changesetId)).setter(setter(Builder::changesetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("changesetId").build()).build();

    private static final SdkField<List<KxDataviewSegmentConfiguration>> SEGMENT_CONFIGURATIONS_FIELD = SdkField
            .<List<KxDataviewSegmentConfiguration>> builder(MarshallingType.LIST)
            .memberName("segmentConfigurations")
            .getter(getter(CreateKxDataviewRequest::segmentConfigurations))
            .setter(setter(Builder::segmentConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<KxDataviewSegmentConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(KxDataviewSegmentConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> AUTO_UPDATE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("autoUpdate").getter(getter(CreateKxDataviewRequest::autoUpdate)).setter(setter(Builder::autoUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoUpdate").build()).build();

    private static final SdkField<Boolean> READ_WRITE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("readWrite").getter(getter(CreateKxDataviewRequest::readWrite)).setter(setter(Builder::readWrite))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readWrite").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateKxDataviewRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateKxDataviewRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateKxDataviewRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(ENVIRONMENT_ID_FIELD, DATABASE_NAME_FIELD, DATAVIEW_NAME_FIELD, AZ_MODE_FIELD,
                    AVAILABILITY_ZONE_ID_FIELD, CHANGESET_ID_FIELD, SEGMENT_CONFIGURATIONS_FIELD, AUTO_UPDATE_FIELD,
                    READ_WRITE_FIELD, DESCRIPTION_FIELD, TAGS_FIELD, CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String environmentId;

    private final String databaseName;

    private final String dataviewName;

    private final String azMode;

    private final String availabilityZoneId;

    private final String changesetId;

    private final List<KxDataviewSegmentConfiguration> segmentConfigurations;

    private final Boolean autoUpdate;

    private final Boolean readWrite;

    private final String description;

    private final Map<String, String> tags;

    private final String clientToken;

    private CreateKxDataviewRequest(BuilderImpl builder) {
        super(builder);
        this.environmentId = builder.environmentId;
        this.databaseName = builder.databaseName;
        this.dataviewName = builder.dataviewName;
        this.azMode = builder.azMode;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.changesetId = builder.changesetId;
        this.segmentConfigurations = builder.segmentConfigurations;
        this.autoUpdate = builder.autoUpdate;
        this.readWrite = builder.readWrite;
        this.description = builder.description;
        this.tags = builder.tags;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * A unique identifier for the kdb environment, where you want to create the dataview.
     * </p>
     * 
     * @return A unique identifier for the kdb environment, where you want to create the dataview.
     */
    public final String environmentId() {
        return environmentId;
    }

    /**
     * <p>
     * The name of the database where you want to create a dataview.
     * </p>
     * 
     * @return The name of the database where you want to create a dataview.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * A unique identifier for the dataview.
     * </p>
     * 
     * @return A unique identifier for the dataview.
     */
    public final String dataviewName() {
        return dataviewName;
    }

    /**
     * <p>
     * The number of availability zones you want to assign per volume. Currently, FinSpace only supports
     * <code>SINGLE</code> for volumes. This places dataview in a single AZ.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #azMode} will
     * return {@link KxAzMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #azModeAsString}.
     * </p>
     * 
     * @return The number of availability zones you want to assign per volume. Currently, FinSpace only supports
     *         <code>SINGLE</code> for volumes. This places dataview in a single AZ.
     * @see KxAzMode
     */
    public final KxAzMode azMode() {
        return KxAzMode.fromValue(azMode);
    }

    /**
     * <p>
     * The number of availability zones you want to assign per volume. Currently, FinSpace only supports
     * <code>SINGLE</code> for volumes. This places dataview in a single AZ.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #azMode} will
     * return {@link KxAzMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #azModeAsString}.
     * </p>
     * 
     * @return The number of availability zones you want to assign per volume. Currently, FinSpace only supports
     *         <code>SINGLE</code> for volumes. This places dataview in a single AZ.
     * @see KxAzMode
     */
    public final String azModeAsString() {
        return azMode;
    }

    /**
     * <p>
     * The identifier of the availability zones.
     * </p>
     * 
     * @return The identifier of the availability zones.
     */
    public final String availabilityZoneId() {
        return availabilityZoneId;
    }

    /**
     * <p>
     * A unique identifier of the changeset that you want to use to ingest data.
     * </p>
     * 
     * @return A unique identifier of the changeset that you want to use to ingest data.
     */
    public final String changesetId() {
        return changesetId;
    }

    /**
     * For responses, this returns true if the service returned a value for the SegmentConfigurations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSegmentConfigurations() {
        return segmentConfigurations != null && !(segmentConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The configuration that contains the database path of the data that you want to place on each selected volume.
     * Each segment must have a unique database path for each volume. If you do not explicitly specify any database path
     * for a volume, they are accessible from the cluster through the default S3/object store segment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSegmentConfigurations} method.
     * </p>
     * 
     * @return The configuration that contains the database path of the data that you want to place on each selected
     *         volume. Each segment must have a unique database path for each volume. If you do not explicitly specify
     *         any database path for a volume, they are accessible from the cluster through the default S3/object store
     *         segment.
     */
    public final List<KxDataviewSegmentConfiguration> segmentConfigurations() {
        return segmentConfigurations;
    }

    /**
     * <p>
     * The option to specify whether you want to apply all the future additions and corrections automatically to the
     * dataview, when you ingest new changesets. The default value is false.
     * </p>
     * 
     * @return The option to specify whether you want to apply all the future additions and corrections automatically to
     *         the dataview, when you ingest new changesets. The default value is false.
     */
    public final Boolean autoUpdate() {
        return autoUpdate;
    }

    /**
     * <p>
     * The option to specify whether you want to make the dataview writable to perform database maintenance. The
     * following are some considerations related to writable dataviews.&#x2028;&#x2028;
     * </p>
     * <ul>
     * <li>
     * <p>
     * You cannot create partial writable dataviews. When you create writeable dataviews you must provide the entire
     * database path.
     * </p>
     * </li>
     * <li>
     * <p>
     * You cannot perform updates on a writeable dataview. Hence, <code>autoUpdate</code> must be set as <b>False</b> if
     * <code>readWrite</code> is <b>True</b> for a dataview.
     * </p>
     * </li>
     * <li>
     * <p>
     * You must also use a unique volume for creating a writeable dataview. So, if you choose a volume that is already
     * in use by another dataview, the dataview creation fails.
     * </p>
     * </li>
     * <li>
     * <p>
     * Once you create a dataview as writeable, you cannot change it to read-only. So, you cannot update the
     * <code>readWrite</code> parameter later.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The option to specify whether you want to make the dataview writable to perform database maintenance. The
     *         following are some considerations related to writable dataviews.&#x2028;&#x2028;</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You cannot create partial writable dataviews. When you create writeable dataviews you must provide the
     *         entire database path.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You cannot perform updates on a writeable dataview. Hence, <code>autoUpdate</code> must be set as
     *         <b>False</b> if <code>readWrite</code> is <b>True</b> for a dataview.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You must also use a unique volume for creating a writeable dataview. So, if you choose a volume that is
     *         already in use by another dataview, the dataview creation fails.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Once you create a dataview as writeable, you cannot change it to read-only. So, you cannot update the
     *         <code>readWrite</code> parameter later.
     *         </p>
     *         </li>
     */
    public final Boolean readWrite() {
        return readWrite;
    }

    /**
     * <p>
     * A description of the dataview.
     * </p>
     * 
     * @return A description of the dataview.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of key-value pairs to label the dataview. You can add up to 50 tags to a dataview.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of key-value pairs to label the dataview. You can add up to 50 tags to a dataview.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * A token that ensures idempotency. This token expires in 10 minutes.
     * </p>
     * 
     * @return A token that ensures idempotency. This token expires in 10 minutes.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(dataviewName());
        hashCode = 31 * hashCode + Objects.hashCode(azModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(changesetId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSegmentConfigurations() ? segmentConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(autoUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(readWrite());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateKxDataviewRequest)) {
            return false;
        }
        CreateKxDataviewRequest other = (CreateKxDataviewRequest) obj;
        return Objects.equals(environmentId(), other.environmentId()) && Objects.equals(databaseName(), other.databaseName())
                && Objects.equals(dataviewName(), other.dataviewName())
                && Objects.equals(azModeAsString(), other.azModeAsString())
                && Objects.equals(availabilityZoneId(), other.availabilityZoneId())
                && Objects.equals(changesetId(), other.changesetId())
                && hasSegmentConfigurations() == other.hasSegmentConfigurations()
                && Objects.equals(segmentConfigurations(), other.segmentConfigurations())
                && Objects.equals(autoUpdate(), other.autoUpdate()) && Objects.equals(readWrite(), other.readWrite())
                && Objects.equals(description(), other.description()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateKxDataviewRequest").add("EnvironmentId", environmentId())
                .add("DatabaseName", databaseName()).add("DataviewName", dataviewName()).add("AzMode", azModeAsString())
                .add("AvailabilityZoneId", availabilityZoneId()).add("ChangesetId", changesetId())
                .add("SegmentConfigurations", hasSegmentConfigurations() ? segmentConfigurations() : null)
                .add("AutoUpdate", autoUpdate()).add("ReadWrite", readWrite()).add("Description", description())
                .add("Tags", hasTags() ? tags() : null).add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "environmentId":
            return Optional.ofNullable(clazz.cast(environmentId()));
        case "databaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "dataviewName":
            return Optional.ofNullable(clazz.cast(dataviewName()));
        case "azMode":
            return Optional.ofNullable(clazz.cast(azModeAsString()));
        case "availabilityZoneId":
            return Optional.ofNullable(clazz.cast(availabilityZoneId()));
        case "changesetId":
            return Optional.ofNullable(clazz.cast(changesetId()));
        case "segmentConfigurations":
            return Optional.ofNullable(clazz.cast(segmentConfigurations()));
        case "autoUpdate":
            return Optional.ofNullable(clazz.cast(autoUpdate()));
        case "readWrite":
            return Optional.ofNullable(clazz.cast(readWrite()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("environmentId", ENVIRONMENT_ID_FIELD);
        map.put("databaseName", DATABASE_NAME_FIELD);
        map.put("dataviewName", DATAVIEW_NAME_FIELD);
        map.put("azMode", AZ_MODE_FIELD);
        map.put("availabilityZoneId", AVAILABILITY_ZONE_ID_FIELD);
        map.put("changesetId", CHANGESET_ID_FIELD);
        map.put("segmentConfigurations", SEGMENT_CONFIGURATIONS_FIELD);
        map.put("autoUpdate", AUTO_UPDATE_FIELD);
        map.put("readWrite", READ_WRITE_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateKxDataviewRequest, T> g) {
        return obj -> g.apply((CreateKxDataviewRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FinspaceRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateKxDataviewRequest> {
        /**
         * <p>
         * A unique identifier for the kdb environment, where you want to create the dataview.
         * </p>
         * 
         * @param environmentId
         *        A unique identifier for the kdb environment, where you want to create the dataview.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentId(String environmentId);

        /**
         * <p>
         * The name of the database where you want to create a dataview.
         * </p>
         * 
         * @param databaseName
         *        The name of the database where you want to create a dataview.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * A unique identifier for the dataview.
         * </p>
         * 
         * @param dataviewName
         *        A unique identifier for the dataview.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataviewName(String dataviewName);

        /**
         * <p>
         * The number of availability zones you want to assign per volume. Currently, FinSpace only supports
         * <code>SINGLE</code> for volumes. This places dataview in a single AZ.
         * </p>
         * 
         * @param azMode
         *        The number of availability zones you want to assign per volume. Currently, FinSpace only supports
         *        <code>SINGLE</code> for volumes. This places dataview in a single AZ.
         * @see KxAzMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KxAzMode
         */
        Builder azMode(String azMode);

        /**
         * <p>
         * The number of availability zones you want to assign per volume. Currently, FinSpace only supports
         * <code>SINGLE</code> for volumes. This places dataview in a single AZ.
         * </p>
         * 
         * @param azMode
         *        The number of availability zones you want to assign per volume. Currently, FinSpace only supports
         *        <code>SINGLE</code> for volumes. This places dataview in a single AZ.
         * @see KxAzMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KxAzMode
         */
        Builder azMode(KxAzMode azMode);

        /**
         * <p>
         * The identifier of the availability zones.
         * </p>
         * 
         * @param availabilityZoneId
         *        The identifier of the availability zones.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZoneId(String availabilityZoneId);

        /**
         * <p>
         * A unique identifier of the changeset that you want to use to ingest data.
         * </p>
         * 
         * @param changesetId
         *        A unique identifier of the changeset that you want to use to ingest data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changesetId(String changesetId);

        /**
         * <p>
         * The configuration that contains the database path of the data that you want to place on each selected volume.
         * Each segment must have a unique database path for each volume. If you do not explicitly specify any database
         * path for a volume, they are accessible from the cluster through the default S3/object store segment.
         * </p>
         * 
         * @param segmentConfigurations
         *        The configuration that contains the database path of the data that you want to place on each selected
         *        volume. Each segment must have a unique database path for each volume. If you do not explicitly
         *        specify any database path for a volume, they are accessible from the cluster through the default
         *        S3/object store segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentConfigurations(Collection<KxDataviewSegmentConfiguration> segmentConfigurations);

        /**
         * <p>
         * The configuration that contains the database path of the data that you want to place on each selected volume.
         * Each segment must have a unique database path for each volume. If you do not explicitly specify any database
         * path for a volume, they are accessible from the cluster through the default S3/object store segment.
         * </p>
         * 
         * @param segmentConfigurations
         *        The configuration that contains the database path of the data that you want to place on each selected
         *        volume. Each segment must have a unique database path for each volume. If you do not explicitly
         *        specify any database path for a volume, they are accessible from the cluster through the default
         *        S3/object store segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentConfigurations(KxDataviewSegmentConfiguration... segmentConfigurations);

        /**
         * <p>
         * The configuration that contains the database path of the data that you want to place on each selected volume.
         * Each segment must have a unique database path for each volume. If you do not explicitly specify any database
         * path for a volume, they are accessible from the cluster through the default S3/object store segment.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.finspace.model.KxDataviewSegmentConfiguration.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.finspace.model.KxDataviewSegmentConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.finspace.model.KxDataviewSegmentConfiguration.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #segmentConfigurations(List<KxDataviewSegmentConfiguration>)}.
         * 
         * @param segmentConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.finspace.model.KxDataviewSegmentConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #segmentConfigurations(java.util.Collection<KxDataviewSegmentConfiguration>)
         */
        Builder segmentConfigurations(Consumer<KxDataviewSegmentConfiguration.Builder>... segmentConfigurations);

        /**
         * <p>
         * The option to specify whether you want to apply all the future additions and corrections automatically to the
         * dataview, when you ingest new changesets. The default value is false.
         * </p>
         * 
         * @param autoUpdate
         *        The option to specify whether you want to apply all the future additions and corrections automatically
         *        to the dataview, when you ingest new changesets. The default value is false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoUpdate(Boolean autoUpdate);

        /**
         * <p>
         * The option to specify whether you want to make the dataview writable to perform database maintenance. The
         * following are some considerations related to writable dataviews.&#x2028;&#x2028;
         * </p>
         * <ul>
         * <li>
         * <p>
         * You cannot create partial writable dataviews. When you create writeable dataviews you must provide the entire
         * database path.
         * </p>
         * </li>
         * <li>
         * <p>
         * You cannot perform updates on a writeable dataview. Hence, <code>autoUpdate</code> must be set as
         * <b>False</b> if <code>readWrite</code> is <b>True</b> for a dataview.
         * </p>
         * </li>
         * <li>
         * <p>
         * You must also use a unique volume for creating a writeable dataview. So, if you choose a volume that is
         * already in use by another dataview, the dataview creation fails.
         * </p>
         * </li>
         * <li>
         * <p>
         * Once you create a dataview as writeable, you cannot change it to read-only. So, you cannot update the
         * <code>readWrite</code> parameter later.
         * </p>
         * </li>
         * </ul>
         * 
         * @param readWrite
         *        The option to specify whether you want to make the dataview writable to perform database maintenance.
         *        The following are some considerations related to writable dataviews.&#x2028;&#x2028;</p>
         *        <ul>
         *        <li>
         *        <p>
         *        You cannot create partial writable dataviews. When you create writeable dataviews you must provide the
         *        entire database path.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        You cannot perform updates on a writeable dataview. Hence, <code>autoUpdate</code> must be set as
         *        <b>False</b> if <code>readWrite</code> is <b>True</b> for a dataview.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        You must also use a unique volume for creating a writeable dataview. So, if you choose a volume that
         *        is already in use by another dataview, the dataview creation fails.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Once you create a dataview as writeable, you cannot change it to read-only. So, you cannot update the
         *        <code>readWrite</code> parameter later.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readWrite(Boolean readWrite);

        /**
         * <p>
         * A description of the dataview.
         * </p>
         * 
         * @param description
         *        A description of the dataview.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A list of key-value pairs to label the dataview. You can add up to 50 tags to a dataview.
         * </p>
         * 
         * @param tags
         *        A list of key-value pairs to label the dataview. You can add up to 50 tags to a dataview.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * A token that ensures idempotency. This token expires in 10 minutes.
         * </p>
         * 
         * @param clientToken
         *        A token that ensures idempotency. This token expires in 10 minutes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FinspaceRequest.BuilderImpl implements Builder {
        private String environmentId;

        private String databaseName;

        private String dataviewName;

        private String azMode;

        private String availabilityZoneId;

        private String changesetId;

        private List<KxDataviewSegmentConfiguration> segmentConfigurations = DefaultSdkAutoConstructList.getInstance();

        private Boolean autoUpdate;

        private Boolean readWrite;

        private String description;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateKxDataviewRequest model) {
            super(model);
            environmentId(model.environmentId);
            databaseName(model.databaseName);
            dataviewName(model.dataviewName);
            azMode(model.azMode);
            availabilityZoneId(model.availabilityZoneId);
            changesetId(model.changesetId);
            segmentConfigurations(model.segmentConfigurations);
            autoUpdate(model.autoUpdate);
            readWrite(model.readWrite);
            description(model.description);
            tags(model.tags);
            clientToken(model.clientToken);
        }

        public final String getEnvironmentId() {
            return environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getDataviewName() {
            return dataviewName;
        }

        public final void setDataviewName(String dataviewName) {
            this.dataviewName = dataviewName;
        }

        @Override
        public final Builder dataviewName(String dataviewName) {
            this.dataviewName = dataviewName;
            return this;
        }

        public final String getAzMode() {
            return azMode;
        }

        public final void setAzMode(String azMode) {
            this.azMode = azMode;
        }

        @Override
        public final Builder azMode(String azMode) {
            this.azMode = azMode;
            return this;
        }

        @Override
        public final Builder azMode(KxAzMode azMode) {
            this.azMode(azMode == null ? null : azMode.toString());
            return this;
        }

        public final String getAvailabilityZoneId() {
            return availabilityZoneId;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final String getChangesetId() {
            return changesetId;
        }

        public final void setChangesetId(String changesetId) {
            this.changesetId = changesetId;
        }

        @Override
        public final Builder changesetId(String changesetId) {
            this.changesetId = changesetId;
            return this;
        }

        public final List<KxDataviewSegmentConfiguration.Builder> getSegmentConfigurations() {
            List<KxDataviewSegmentConfiguration.Builder> result = KxDataviewSegmentConfigurationListCopier
                    .copyToBuilder(this.segmentConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSegmentConfigurations(Collection<KxDataviewSegmentConfiguration.BuilderImpl> segmentConfigurations) {
            this.segmentConfigurations = KxDataviewSegmentConfigurationListCopier.copyFromBuilder(segmentConfigurations);
        }

        @Override
        public final Builder segmentConfigurations(Collection<KxDataviewSegmentConfiguration> segmentConfigurations) {
            this.segmentConfigurations = KxDataviewSegmentConfigurationListCopier.copy(segmentConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder segmentConfigurations(KxDataviewSegmentConfiguration... segmentConfigurations) {
            segmentConfigurations(Arrays.asList(segmentConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder segmentConfigurations(Consumer<KxDataviewSegmentConfiguration.Builder>... segmentConfigurations) {
            segmentConfigurations(Stream.of(segmentConfigurations)
                    .map(c -> KxDataviewSegmentConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getAutoUpdate() {
            return autoUpdate;
        }

        public final void setAutoUpdate(Boolean autoUpdate) {
            this.autoUpdate = autoUpdate;
        }

        @Override
        public final Builder autoUpdate(Boolean autoUpdate) {
            this.autoUpdate = autoUpdate;
            return this;
        }

        public final Boolean getReadWrite() {
            return readWrite;
        }

        public final void setReadWrite(Boolean readWrite) {
            this.readWrite = readWrite;
        }

        @Override
        public final Builder readWrite(Boolean readWrite) {
            this.readWrite = readWrite;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateKxDataviewRequest build() {
            return new CreateKxDataviewRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
