/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspace.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents an FinSpace environment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Environment implements SdkPojo, Serializable, ToCopyableBuilder<Environment.Builder, Environment> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(Environment::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentId").getter(getter(Environment::environmentId)).setter(setter(Builder::environmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentId").build()).build();

    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("awsAccountId").getter(getter(Environment::awsAccountId)).setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsAccountId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(Environment::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> ENVIRONMENT_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentUrl").getter(getter(Environment::environmentUrl)).setter(setter(Builder::environmentUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentUrl").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(Environment::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ENVIRONMENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentArn").getter(getter(Environment::environmentArn)).setter(setter(Builder::environmentArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentArn").build()).build();

    private static final SdkField<String> SAGE_MAKER_STUDIO_DOMAIN_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sageMakerStudioDomainUrl").getter(getter(Environment::sageMakerStudioDomainUrl))
            .setter(setter(Builder::sageMakerStudioDomainUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sageMakerStudioDomainUrl").build())
            .build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyId").getter(getter(Environment::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()).build();

    private static final SdkField<String> DEDICATED_SERVICE_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dedicatedServiceAccountId").getter(getter(Environment::dedicatedServiceAccountId))
            .setter(setter(Builder::dedicatedServiceAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dedicatedServiceAccountId").build())
            .build();

    private static final SdkField<String> FEDERATION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("federationMode").getter(getter(Environment::federationModeAsString))
            .setter(setter(Builder::federationMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("federationMode").build()).build();

    private static final SdkField<FederationParameters> FEDERATION_PARAMETERS_FIELD = SdkField
            .<FederationParameters> builder(MarshallingType.SDK_POJO).memberName("federationParameters")
            .getter(getter(Environment::federationParameters)).setter(setter(Builder::federationParameters))
            .constructor(FederationParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("federationParameters").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            ENVIRONMENT_ID_FIELD, AWS_ACCOUNT_ID_FIELD, STATUS_FIELD, ENVIRONMENT_URL_FIELD, DESCRIPTION_FIELD,
            ENVIRONMENT_ARN_FIELD, SAGE_MAKER_STUDIO_DOMAIN_URL_FIELD, KMS_KEY_ID_FIELD, DEDICATED_SERVICE_ACCOUNT_ID_FIELD,
            FEDERATION_MODE_FIELD, FEDERATION_PARAMETERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String environmentId;

    private final String awsAccountId;

    private final String status;

    private final String environmentUrl;

    private final String description;

    private final String environmentArn;

    private final String sageMakerStudioDomainUrl;

    private final String kmsKeyId;

    private final String dedicatedServiceAccountId;

    private final String federationMode;

    private final FederationParameters federationParameters;

    private Environment(BuilderImpl builder) {
        this.name = builder.name;
        this.environmentId = builder.environmentId;
        this.awsAccountId = builder.awsAccountId;
        this.status = builder.status;
        this.environmentUrl = builder.environmentUrl;
        this.description = builder.description;
        this.environmentArn = builder.environmentArn;
        this.sageMakerStudioDomainUrl = builder.sageMakerStudioDomainUrl;
        this.kmsKeyId = builder.kmsKeyId;
        this.dedicatedServiceAccountId = builder.dedicatedServiceAccountId;
        this.federationMode = builder.federationMode;
        this.federationParameters = builder.federationParameters;
    }

    /**
     * <p>
     * The name of the FinSpace environment.
     * </p>
     * 
     * @return The name of the FinSpace environment.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The identifier of the FinSpace environment.
     * </p>
     * 
     * @return The identifier of the FinSpace environment.
     */
    public final String environmentId() {
        return environmentId;
    }

    /**
     * <p>
     * The ID of the AWS account in which the FinSpace environment is created.
     * </p>
     * 
     * @return The ID of the AWS account in which the FinSpace environment is created.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The current status of creation of the FinSpace environment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EnvironmentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of creation of the FinSpace environment.
     * @see EnvironmentStatus
     */
    public final EnvironmentStatus status() {
        return EnvironmentStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of creation of the FinSpace environment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EnvironmentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of creation of the FinSpace environment.
     * @see EnvironmentStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The sign-in URL for the web application of your FinSpace environment.
     * </p>
     * 
     * @return The sign-in URL for the web application of your FinSpace environment.
     */
    public final String environmentUrl() {
        return environmentUrl;
    }

    /**
     * <p>
     * The description of the FinSpace environment.
     * </p>
     * 
     * @return The description of the FinSpace environment.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of your FinSpace environment.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of your FinSpace environment.
     */
    public final String environmentArn() {
        return environmentArn;
    }

    /**
     * <p>
     * The URL of the integrated FinSpace notebook environment in your web application.
     * </p>
     * 
     * @return The URL of the integrated FinSpace notebook environment in your web application.
     */
    public final String sageMakerStudioDomainUrl() {
        return sageMakerStudioDomainUrl;
    }

    /**
     * <p>
     * The KMS key id used to encrypt in the FinSpace environment.
     * </p>
     * 
     * @return The KMS key id used to encrypt in the FinSpace environment.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The AWS account ID of the dedicated service account associated with your FinSpace environment.
     * </p>
     * 
     * @return The AWS account ID of the dedicated service account associated with your FinSpace environment.
     */
    public final String dedicatedServiceAccountId() {
        return dedicatedServiceAccountId;
    }

    /**
     * <p>
     * The authentication mode for the environment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #federationMode}
     * will return {@link FederationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #federationModeAsString}.
     * </p>
     * 
     * @return The authentication mode for the environment.
     * @see FederationMode
     */
    public final FederationMode federationMode() {
        return FederationMode.fromValue(federationMode);
    }

    /**
     * <p>
     * The authentication mode for the environment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #federationMode}
     * will return {@link FederationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #federationModeAsString}.
     * </p>
     * 
     * @return The authentication mode for the environment.
     * @see FederationMode
     */
    public final String federationModeAsString() {
        return federationMode;
    }

    /**
     * <p>
     * Configuration information when authentication mode is FEDERATED.
     * </p>
     * 
     * @return Configuration information when authentication mode is FEDERATED.
     */
    public final FederationParameters federationParameters() {
        return federationParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(environmentUrl());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(environmentArn());
        hashCode = 31 * hashCode + Objects.hashCode(sageMakerStudioDomainUrl());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(dedicatedServiceAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(federationModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(federationParameters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Environment)) {
            return false;
        }
        Environment other = (Environment) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(environmentId(), other.environmentId())
                && Objects.equals(awsAccountId(), other.awsAccountId())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(environmentUrl(), other.environmentUrl()) && Objects.equals(description(), other.description())
                && Objects.equals(environmentArn(), other.environmentArn())
                && Objects.equals(sageMakerStudioDomainUrl(), other.sageMakerStudioDomainUrl())
                && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(dedicatedServiceAccountId(), other.dedicatedServiceAccountId())
                && Objects.equals(federationModeAsString(), other.federationModeAsString())
                && Objects.equals(federationParameters(), other.federationParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Environment").add("Name", name()).add("EnvironmentId", environmentId())
                .add("AwsAccountId", awsAccountId()).add("Status", statusAsString()).add("EnvironmentUrl", environmentUrl())
                .add("Description", description()).add("EnvironmentArn", environmentArn())
                .add("SageMakerStudioDomainUrl", sageMakerStudioDomainUrl()).add("KmsKeyId", kmsKeyId())
                .add("DedicatedServiceAccountId", dedicatedServiceAccountId()).add("FederationMode", federationModeAsString())
                .add("FederationParameters", federationParameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "environmentId":
            return Optional.ofNullable(clazz.cast(environmentId()));
        case "awsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "environmentUrl":
            return Optional.ofNullable(clazz.cast(environmentUrl()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "environmentArn":
            return Optional.ofNullable(clazz.cast(environmentArn()));
        case "sageMakerStudioDomainUrl":
            return Optional.ofNullable(clazz.cast(sageMakerStudioDomainUrl()));
        case "kmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "dedicatedServiceAccountId":
            return Optional.ofNullable(clazz.cast(dedicatedServiceAccountId()));
        case "federationMode":
            return Optional.ofNullable(clazz.cast(federationModeAsString()));
        case "federationParameters":
            return Optional.ofNullable(clazz.cast(federationParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("environmentId", ENVIRONMENT_ID_FIELD);
        map.put("awsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("environmentUrl", ENVIRONMENT_URL_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("environmentArn", ENVIRONMENT_ARN_FIELD);
        map.put("sageMakerStudioDomainUrl", SAGE_MAKER_STUDIO_DOMAIN_URL_FIELD);
        map.put("kmsKeyId", KMS_KEY_ID_FIELD);
        map.put("dedicatedServiceAccountId", DEDICATED_SERVICE_ACCOUNT_ID_FIELD);
        map.put("federationMode", FEDERATION_MODE_FIELD);
        map.put("federationParameters", FEDERATION_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Environment, T> g) {
        return obj -> g.apply((Environment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Environment> {
        /**
         * <p>
         * The name of the FinSpace environment.
         * </p>
         * 
         * @param name
         *        The name of the FinSpace environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The identifier of the FinSpace environment.
         * </p>
         * 
         * @param environmentId
         *        The identifier of the FinSpace environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentId(String environmentId);

        /**
         * <p>
         * The ID of the AWS account in which the FinSpace environment is created.
         * </p>
         * 
         * @param awsAccountId
         *        The ID of the AWS account in which the FinSpace environment is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The current status of creation of the FinSpace environment.
         * </p>
         * 
         * @param status
         *        The current status of creation of the FinSpace environment.
         * @see EnvironmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnvironmentStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of creation of the FinSpace environment.
         * </p>
         * 
         * @param status
         *        The current status of creation of the FinSpace environment.
         * @see EnvironmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnvironmentStatus
         */
        Builder status(EnvironmentStatus status);

        /**
         * <p>
         * The sign-in URL for the web application of your FinSpace environment.
         * </p>
         * 
         * @param environmentUrl
         *        The sign-in URL for the web application of your FinSpace environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentUrl(String environmentUrl);

        /**
         * <p>
         * The description of the FinSpace environment.
         * </p>
         * 
         * @param description
         *        The description of the FinSpace environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of your FinSpace environment.
         * </p>
         * 
         * @param environmentArn
         *        The Amazon Resource Name (ARN) of your FinSpace environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentArn(String environmentArn);

        /**
         * <p>
         * The URL of the integrated FinSpace notebook environment in your web application.
         * </p>
         * 
         * @param sageMakerStudioDomainUrl
         *        The URL of the integrated FinSpace notebook environment in your web application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sageMakerStudioDomainUrl(String sageMakerStudioDomainUrl);

        /**
         * <p>
         * The KMS key id used to encrypt in the FinSpace environment.
         * </p>
         * 
         * @param kmsKeyId
         *        The KMS key id used to encrypt in the FinSpace environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The AWS account ID of the dedicated service account associated with your FinSpace environment.
         * </p>
         * 
         * @param dedicatedServiceAccountId
         *        The AWS account ID of the dedicated service account associated with your FinSpace environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dedicatedServiceAccountId(String dedicatedServiceAccountId);

        /**
         * <p>
         * The authentication mode for the environment.
         * </p>
         * 
         * @param federationMode
         *        The authentication mode for the environment.
         * @see FederationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FederationMode
         */
        Builder federationMode(String federationMode);

        /**
         * <p>
         * The authentication mode for the environment.
         * </p>
         * 
         * @param federationMode
         *        The authentication mode for the environment.
         * @see FederationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FederationMode
         */
        Builder federationMode(FederationMode federationMode);

        /**
         * <p>
         * Configuration information when authentication mode is FEDERATED.
         * </p>
         * 
         * @param federationParameters
         *        Configuration information when authentication mode is FEDERATED.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder federationParameters(FederationParameters federationParameters);

        /**
         * <p>
         * Configuration information when authentication mode is FEDERATED.
         * </p>
         * This is a convenience method that creates an instance of the {@link FederationParameters.Builder} avoiding
         * the need to create one manually via {@link FederationParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FederationParameters.Builder#build()} is called immediately and
         * its result is passed to {@link #federationParameters(FederationParameters)}.
         * 
         * @param federationParameters
         *        a consumer that will call methods on {@link FederationParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #federationParameters(FederationParameters)
         */
        default Builder federationParameters(Consumer<FederationParameters.Builder> federationParameters) {
            return federationParameters(FederationParameters.builder().applyMutation(federationParameters).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String environmentId;

        private String awsAccountId;

        private String status;

        private String environmentUrl;

        private String description;

        private String environmentArn;

        private String sageMakerStudioDomainUrl;

        private String kmsKeyId;

        private String dedicatedServiceAccountId;

        private String federationMode;

        private FederationParameters federationParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(Environment model) {
            name(model.name);
            environmentId(model.environmentId);
            awsAccountId(model.awsAccountId);
            status(model.status);
            environmentUrl(model.environmentUrl);
            description(model.description);
            environmentArn(model.environmentArn);
            sageMakerStudioDomainUrl(model.sageMakerStudioDomainUrl);
            kmsKeyId(model.kmsKeyId);
            dedicatedServiceAccountId(model.dedicatedServiceAccountId);
            federationMode(model.federationMode);
            federationParameters(model.federationParameters);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getEnvironmentId() {
            return environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EnvironmentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getEnvironmentUrl() {
            return environmentUrl;
        }

        public final void setEnvironmentUrl(String environmentUrl) {
            this.environmentUrl = environmentUrl;
        }

        @Override
        public final Builder environmentUrl(String environmentUrl) {
            this.environmentUrl = environmentUrl;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEnvironmentArn() {
            return environmentArn;
        }

        public final void setEnvironmentArn(String environmentArn) {
            this.environmentArn = environmentArn;
        }

        @Override
        public final Builder environmentArn(String environmentArn) {
            this.environmentArn = environmentArn;
            return this;
        }

        public final String getSageMakerStudioDomainUrl() {
            return sageMakerStudioDomainUrl;
        }

        public final void setSageMakerStudioDomainUrl(String sageMakerStudioDomainUrl) {
            this.sageMakerStudioDomainUrl = sageMakerStudioDomainUrl;
        }

        @Override
        public final Builder sageMakerStudioDomainUrl(String sageMakerStudioDomainUrl) {
            this.sageMakerStudioDomainUrl = sageMakerStudioDomainUrl;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getDedicatedServiceAccountId() {
            return dedicatedServiceAccountId;
        }

        public final void setDedicatedServiceAccountId(String dedicatedServiceAccountId) {
            this.dedicatedServiceAccountId = dedicatedServiceAccountId;
        }

        @Override
        public final Builder dedicatedServiceAccountId(String dedicatedServiceAccountId) {
            this.dedicatedServiceAccountId = dedicatedServiceAccountId;
            return this;
        }

        public final String getFederationMode() {
            return federationMode;
        }

        public final void setFederationMode(String federationMode) {
            this.federationMode = federationMode;
        }

        @Override
        public final Builder federationMode(String federationMode) {
            this.federationMode = federationMode;
            return this;
        }

        @Override
        public final Builder federationMode(FederationMode federationMode) {
            this.federationMode(federationMode == null ? null : federationMode.toString());
            return this;
        }

        public final FederationParameters.Builder getFederationParameters() {
            return federationParameters != null ? federationParameters.toBuilder() : null;
        }

        public final void setFederationParameters(FederationParameters.BuilderImpl federationParameters) {
            this.federationParameters = federationParameters != null ? federationParameters.build() : null;
        }

        @Override
        public final Builder federationParameters(FederationParameters federationParameters) {
            this.federationParameters = federationParameters;
            return this;
        }

        @Override
        public Environment build() {
            return new Environment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
