/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspace.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetKxChangesetResponse extends FinspaceResponse implements
        ToCopyableBuilder<GetKxChangesetResponse.Builder, GetKxChangesetResponse> {
    private static final SdkField<String> CHANGESET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("changesetId").getter(getter(GetKxChangesetResponse::changesetId)).setter(setter(Builder::changesetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("changesetId").build()).build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("databaseName").getter(getter(GetKxChangesetResponse::databaseName))
            .setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("databaseName").build()).build();

    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentId").getter(getter(GetKxChangesetResponse::environmentId))
            .setter(setter(Builder::environmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentId").build()).build();

    private static final SdkField<List<ChangeRequest>> CHANGE_REQUESTS_FIELD = SdkField
            .<List<ChangeRequest>> builder(MarshallingType.LIST)
            .memberName("changeRequests")
            .getter(getter(GetKxChangesetResponse::changeRequests))
            .setter(setter(Builder::changeRequests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("changeRequests").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ChangeRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(ChangeRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdTimestamp").getter(getter(GetKxChangesetResponse::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTimestamp").build()).build();

    private static final SdkField<Instant> ACTIVE_FROM_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("activeFromTimestamp").getter(getter(GetKxChangesetResponse::activeFromTimestamp))
            .setter(setter(Builder::activeFromTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeFromTimestamp").build())
            .build();

    private static final SdkField<Instant> LAST_MODIFIED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModifiedTimestamp").getter(getter(GetKxChangesetResponse::lastModifiedTimestamp))
            .setter(setter(Builder::lastModifiedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTimestamp").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetKxChangesetResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<ErrorInfo> ERROR_INFO_FIELD = SdkField.<ErrorInfo> builder(MarshallingType.SDK_POJO)
            .memberName("errorInfo").getter(getter(GetKxChangesetResponse::errorInfo)).setter(setter(Builder::errorInfo))
            .constructor(ErrorInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorInfo").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANGESET_ID_FIELD,
            DATABASE_NAME_FIELD, ENVIRONMENT_ID_FIELD, CHANGE_REQUESTS_FIELD, CREATED_TIMESTAMP_FIELD,
            ACTIVE_FROM_TIMESTAMP_FIELD, LAST_MODIFIED_TIMESTAMP_FIELD, STATUS_FIELD, ERROR_INFO_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String changesetId;

    private final String databaseName;

    private final String environmentId;

    private final List<ChangeRequest> changeRequests;

    private final Instant createdTimestamp;

    private final Instant activeFromTimestamp;

    private final Instant lastModifiedTimestamp;

    private final String status;

    private final ErrorInfo errorInfo;

    private GetKxChangesetResponse(BuilderImpl builder) {
        super(builder);
        this.changesetId = builder.changesetId;
        this.databaseName = builder.databaseName;
        this.environmentId = builder.environmentId;
        this.changeRequests = builder.changeRequests;
        this.createdTimestamp = builder.createdTimestamp;
        this.activeFromTimestamp = builder.activeFromTimestamp;
        this.lastModifiedTimestamp = builder.lastModifiedTimestamp;
        this.status = builder.status;
        this.errorInfo = builder.errorInfo;
    }

    /**
     * <p>
     * A unique identifier for the changeset.
     * </p>
     * 
     * @return A unique identifier for the changeset.
     */
    public final String changesetId() {
        return changesetId;
    }

    /**
     * <p>
     * The name of the kdb database.
     * </p>
     * 
     * @return The name of the kdb database.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * A unique identifier for the kdb environment.
     * </p>
     * 
     * @return A unique identifier for the kdb environment.
     */
    public final String environmentId() {
        return environmentId;
    }

    /**
     * For responses, this returns true if the service returned a value for the ChangeRequests property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasChangeRequests() {
        return changeRequests != null && !(changeRequests instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of change request objects that are run in order.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChangeRequests} method.
     * </p>
     * 
     * @return A list of change request objects that are run in order.
     */
    public final List<ChangeRequest> changeRequests() {
        return changeRequests;
    }

    /**
     * <p>
     * The timestamp at which the changeset was created in FinSpace. The value is determined as epoch time in
     * milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
     * </p>
     * 
     * @return The timestamp at which the changeset was created in FinSpace. The value is determined as epoch time in
     *         milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as
     *         1635768000000.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    /**
     * <p>
     * Beginning time from which the changeset is active. The value is determined as epoch time in milliseconds. For
     * example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
     * </p>
     * 
     * @return Beginning time from which the changeset is active. The value is determined as epoch time in milliseconds.
     *         For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
     */
    public final Instant activeFromTimestamp() {
        return activeFromTimestamp;
    }

    /**
     * <p>
     * The timestamp at which the changeset was updated in FinSpace. The value is determined as epoch time in
     * milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
     * </p>
     * 
     * @return The timestamp at which the changeset was updated in FinSpace. The value is determined as epoch time in
     *         milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as
     *         1635768000000.
     */
    public final Instant lastModifiedTimestamp() {
        return lastModifiedTimestamp;
    }

    /**
     * <p>
     * Status of the changeset creation process.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Pending – Changeset creation is pending.
     * </p>
     * </li>
     * <li>
     * <p>
     * Processing – Changeset creation is running.
     * </p>
     * </li>
     * <li>
     * <p>
     * Failed – Changeset creation has failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * Complete – Changeset creation has succeeded.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ChangesetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the changeset creation process.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Pending – Changeset creation is pending.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Processing – Changeset creation is running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Failed – Changeset creation has failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Complete – Changeset creation has succeeded.
     *         </p>
     *         </li>
     * @see ChangesetStatus
     */
    public final ChangesetStatus status() {
        return ChangesetStatus.fromValue(status);
    }

    /**
     * <p>
     * Status of the changeset creation process.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Pending – Changeset creation is pending.
     * </p>
     * </li>
     * <li>
     * <p>
     * Processing – Changeset creation is running.
     * </p>
     * </li>
     * <li>
     * <p>
     * Failed – Changeset creation has failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * Complete – Changeset creation has succeeded.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ChangesetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the changeset creation process.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Pending – Changeset creation is pending.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Processing – Changeset creation is running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Failed – Changeset creation has failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Complete – Changeset creation has succeeded.
     *         </p>
     *         </li>
     * @see ChangesetStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Provides details in the event of a failed flow, including the error type and the related error message.
     * </p>
     * 
     * @return Provides details in the event of a failed flow, including the error type and the related error message.
     */
    public final ErrorInfo errorInfo() {
        return errorInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(changesetId());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(hasChangeRequests() ? changeRequests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(activeFromTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorInfo());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetKxChangesetResponse)) {
            return false;
        }
        GetKxChangesetResponse other = (GetKxChangesetResponse) obj;
        return Objects.equals(changesetId(), other.changesetId()) && Objects.equals(databaseName(), other.databaseName())
                && Objects.equals(environmentId(), other.environmentId()) && hasChangeRequests() == other.hasChangeRequests()
                && Objects.equals(changeRequests(), other.changeRequests())
                && Objects.equals(createdTimestamp(), other.createdTimestamp())
                && Objects.equals(activeFromTimestamp(), other.activeFromTimestamp())
                && Objects.equals(lastModifiedTimestamp(), other.lastModifiedTimestamp())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(errorInfo(), other.errorInfo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetKxChangesetResponse").add("ChangesetId", changesetId()).add("DatabaseName", databaseName())
                .add("EnvironmentId", environmentId()).add("ChangeRequests", hasChangeRequests() ? changeRequests() : null)
                .add("CreatedTimestamp", createdTimestamp()).add("ActiveFromTimestamp", activeFromTimestamp())
                .add("LastModifiedTimestamp", lastModifiedTimestamp()).add("Status", statusAsString())
                .add("ErrorInfo", errorInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "changesetId":
            return Optional.ofNullable(clazz.cast(changesetId()));
        case "databaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "environmentId":
            return Optional.ofNullable(clazz.cast(environmentId()));
        case "changeRequests":
            return Optional.ofNullable(clazz.cast(changeRequests()));
        case "createdTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        case "activeFromTimestamp":
            return Optional.ofNullable(clazz.cast(activeFromTimestamp()));
        case "lastModifiedTimestamp":
            return Optional.ofNullable(clazz.cast(lastModifiedTimestamp()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "errorInfo":
            return Optional.ofNullable(clazz.cast(errorInfo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("changesetId", CHANGESET_ID_FIELD);
        map.put("databaseName", DATABASE_NAME_FIELD);
        map.put("environmentId", ENVIRONMENT_ID_FIELD);
        map.put("changeRequests", CHANGE_REQUESTS_FIELD);
        map.put("createdTimestamp", CREATED_TIMESTAMP_FIELD);
        map.put("activeFromTimestamp", ACTIVE_FROM_TIMESTAMP_FIELD);
        map.put("lastModifiedTimestamp", LAST_MODIFIED_TIMESTAMP_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("errorInfo", ERROR_INFO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetKxChangesetResponse, T> g) {
        return obj -> g.apply((GetKxChangesetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FinspaceResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetKxChangesetResponse> {
        /**
         * <p>
         * A unique identifier for the changeset.
         * </p>
         * 
         * @param changesetId
         *        A unique identifier for the changeset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changesetId(String changesetId);

        /**
         * <p>
         * The name of the kdb database.
         * </p>
         * 
         * @param databaseName
         *        The name of the kdb database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * A unique identifier for the kdb environment.
         * </p>
         * 
         * @param environmentId
         *        A unique identifier for the kdb environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentId(String environmentId);

        /**
         * <p>
         * A list of change request objects that are run in order.
         * </p>
         * 
         * @param changeRequests
         *        A list of change request objects that are run in order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeRequests(Collection<ChangeRequest> changeRequests);

        /**
         * <p>
         * A list of change request objects that are run in order.
         * </p>
         * 
         * @param changeRequests
         *        A list of change request objects that are run in order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeRequests(ChangeRequest... changeRequests);

        /**
         * <p>
         * A list of change request objects that are run in order.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.finspace.model.ChangeRequest.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.finspace.model.ChangeRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.finspace.model.ChangeRequest.Builder#build()} is called immediately
         * and its result is passed to {@link #changeRequests(List<ChangeRequest>)}.
         * 
         * @param changeRequests
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.finspace.model.ChangeRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #changeRequests(java.util.Collection<ChangeRequest>)
         */
        Builder changeRequests(Consumer<ChangeRequest.Builder>... changeRequests);

        /**
         * <p>
         * The timestamp at which the changeset was created in FinSpace. The value is determined as epoch time in
         * milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as
         * 1635768000000.
         * </p>
         * 
         * @param createdTimestamp
         *        The timestamp at which the changeset was created in FinSpace. The value is determined as epoch time in
         *        milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as
         *        1635768000000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);

        /**
         * <p>
         * Beginning time from which the changeset is active. The value is determined as epoch time in milliseconds. For
         * example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
         * </p>
         * 
         * @param activeFromTimestamp
         *        Beginning time from which the changeset is active. The value is determined as epoch time in
         *        milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as
         *        1635768000000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeFromTimestamp(Instant activeFromTimestamp);

        /**
         * <p>
         * The timestamp at which the changeset was updated in FinSpace. The value is determined as epoch time in
         * milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as
         * 1635768000000.
         * </p>
         * 
         * @param lastModifiedTimestamp
         *        The timestamp at which the changeset was updated in FinSpace. The value is determined as epoch time in
         *        milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as
         *        1635768000000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTimestamp(Instant lastModifiedTimestamp);

        /**
         * <p>
         * Status of the changeset creation process.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Pending – Changeset creation is pending.
         * </p>
         * </li>
         * <li>
         * <p>
         * Processing – Changeset creation is running.
         * </p>
         * </li>
         * <li>
         * <p>
         * Failed – Changeset creation has failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * Complete – Changeset creation has succeeded.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        Status of the changeset creation process.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Pending – Changeset creation is pending.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Processing – Changeset creation is running.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Failed – Changeset creation has failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Complete – Changeset creation has succeeded.
         *        </p>
         *        </li>
         * @see ChangesetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangesetStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Status of the changeset creation process.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Pending – Changeset creation is pending.
         * </p>
         * </li>
         * <li>
         * <p>
         * Processing – Changeset creation is running.
         * </p>
         * </li>
         * <li>
         * <p>
         * Failed – Changeset creation has failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * Complete – Changeset creation has succeeded.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        Status of the changeset creation process.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Pending – Changeset creation is pending.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Processing – Changeset creation is running.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Failed – Changeset creation has failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Complete – Changeset creation has succeeded.
         *        </p>
         *        </li>
         * @see ChangesetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangesetStatus
         */
        Builder status(ChangesetStatus status);

        /**
         * <p>
         * Provides details in the event of a failed flow, including the error type and the related error message.
         * </p>
         * 
         * @param errorInfo
         *        Provides details in the event of a failed flow, including the error type and the related error
         *        message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorInfo(ErrorInfo errorInfo);

        /**
         * <p>
         * Provides details in the event of a failed flow, including the error type and the related error message.
         * </p>
         * This is a convenience method that creates an instance of the {@link ErrorInfo.Builder} avoiding the need to
         * create one manually via {@link ErrorInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ErrorInfo.Builder#build()} is called immediately and its result
         * is passed to {@link #errorInfo(ErrorInfo)}.
         * 
         * @param errorInfo
         *        a consumer that will call methods on {@link ErrorInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorInfo(ErrorInfo)
         */
        default Builder errorInfo(Consumer<ErrorInfo.Builder> errorInfo) {
            return errorInfo(ErrorInfo.builder().applyMutation(errorInfo).build());
        }
    }

    static final class BuilderImpl extends FinspaceResponse.BuilderImpl implements Builder {
        private String changesetId;

        private String databaseName;

        private String environmentId;

        private List<ChangeRequest> changeRequests = DefaultSdkAutoConstructList.getInstance();

        private Instant createdTimestamp;

        private Instant activeFromTimestamp;

        private Instant lastModifiedTimestamp;

        private String status;

        private ErrorInfo errorInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(GetKxChangesetResponse model) {
            super(model);
            changesetId(model.changesetId);
            databaseName(model.databaseName);
            environmentId(model.environmentId);
            changeRequests(model.changeRequests);
            createdTimestamp(model.createdTimestamp);
            activeFromTimestamp(model.activeFromTimestamp);
            lastModifiedTimestamp(model.lastModifiedTimestamp);
            status(model.status);
            errorInfo(model.errorInfo);
        }

        public final String getChangesetId() {
            return changesetId;
        }

        public final void setChangesetId(String changesetId) {
            this.changesetId = changesetId;
        }

        @Override
        public final Builder changesetId(String changesetId) {
            this.changesetId = changesetId;
            return this;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getEnvironmentId() {
            return environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final List<ChangeRequest.Builder> getChangeRequests() {
            List<ChangeRequest.Builder> result = ChangeRequestsCopier.copyToBuilder(this.changeRequests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChangeRequests(Collection<ChangeRequest.BuilderImpl> changeRequests) {
            this.changeRequests = ChangeRequestsCopier.copyFromBuilder(changeRequests);
        }

        @Override
        public final Builder changeRequests(Collection<ChangeRequest> changeRequests) {
            this.changeRequests = ChangeRequestsCopier.copy(changeRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder changeRequests(ChangeRequest... changeRequests) {
            changeRequests(Arrays.asList(changeRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder changeRequests(Consumer<ChangeRequest.Builder>... changeRequests) {
            changeRequests(Stream.of(changeRequests).map(c -> ChangeRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getActiveFromTimestamp() {
            return activeFromTimestamp;
        }

        public final void setActiveFromTimestamp(Instant activeFromTimestamp) {
            this.activeFromTimestamp = activeFromTimestamp;
        }

        @Override
        public final Builder activeFromTimestamp(Instant activeFromTimestamp) {
            this.activeFromTimestamp = activeFromTimestamp;
            return this;
        }

        public final Instant getLastModifiedTimestamp() {
            return lastModifiedTimestamp;
        }

        public final void setLastModifiedTimestamp(Instant lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
        }

        @Override
        public final Builder lastModifiedTimestamp(Instant lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ChangesetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final ErrorInfo.Builder getErrorInfo() {
            return errorInfo != null ? errorInfo.toBuilder() : null;
        }

        public final void setErrorInfo(ErrorInfo.BuilderImpl errorInfo) {
            this.errorInfo = errorInfo != null ? errorInfo.build() : null;
        }

        @Override
        public final Builder errorInfo(ErrorInfo errorInfo) {
            this.errorInfo = errorInfo;
            return this;
        }

        @Override
        public GetKxChangesetResponse build() {
            return new GetKxChangesetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
