/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspace.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetKxClusterResponse extends FinspaceResponse implements
        ToCopyableBuilder<GetKxClusterResponse.Builder, GetKxClusterResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetKxClusterResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusReason").getter(getter(GetKxClusterResponse::statusReason)).setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()).build();

    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterName").getter(getter(GetKxClusterResponse::clusterName)).setter(setter(Builder::clusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterName").build()).build();

    private static final SdkField<String> CLUSTER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterType").getter(getter(GetKxClusterResponse::clusterTypeAsString))
            .setter(setter(Builder::clusterType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterType").build()).build();

    private static final SdkField<TickerplantLogConfiguration> TICKERPLANT_LOG_CONFIGURATION_FIELD = SdkField
            .<TickerplantLogConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("tickerplantLogConfiguration")
            .getter(getter(GetKxClusterResponse::tickerplantLogConfiguration))
            .setter(setter(Builder::tickerplantLogConfiguration))
            .constructor(TickerplantLogConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tickerplantLogConfiguration")
                    .build()).build();

    private static final SdkField<List<Volume>> VOLUMES_FIELD = SdkField
            .<List<Volume>> builder(MarshallingType.LIST)
            .memberName("volumes")
            .getter(getter(GetKxClusterResponse::volumes))
            .setter(setter(Builder::volumes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Volume> builder(MarshallingType.SDK_POJO)
                                            .constructor(Volume::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<KxDatabaseConfiguration>> DATABASES_FIELD = SdkField
            .<List<KxDatabaseConfiguration>> builder(MarshallingType.LIST)
            .memberName("databases")
            .getter(getter(GetKxClusterResponse::databases))
            .setter(setter(Builder::databases))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("databases").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<KxDatabaseConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(KxDatabaseConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<KxCacheStorageConfiguration>> CACHE_STORAGE_CONFIGURATIONS_FIELD = SdkField
            .<List<KxCacheStorageConfiguration>> builder(MarshallingType.LIST)
            .memberName("cacheStorageConfigurations")
            .getter(getter(GetKxClusterResponse::cacheStorageConfigurations))
            .setter(setter(Builder::cacheStorageConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheStorageConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<KxCacheStorageConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(KxCacheStorageConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AutoScalingConfiguration> AUTO_SCALING_CONFIGURATION_FIELD = SdkField
            .<AutoScalingConfiguration> builder(MarshallingType.SDK_POJO).memberName("autoScalingConfiguration")
            .getter(getter(GetKxClusterResponse::autoScalingConfiguration)).setter(setter(Builder::autoScalingConfiguration))
            .constructor(AutoScalingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoScalingConfiguration").build())
            .build();

    private static final SdkField<String> CLUSTER_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterDescription").getter(getter(GetKxClusterResponse::clusterDescription))
            .setter(setter(Builder::clusterDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterDescription").build())
            .build();

    private static final SdkField<CapacityConfiguration> CAPACITY_CONFIGURATION_FIELD = SdkField
            .<CapacityConfiguration> builder(MarshallingType.SDK_POJO).memberName("capacityConfiguration")
            .getter(getter(GetKxClusterResponse::capacityConfiguration)).setter(setter(Builder::capacityConfiguration))
            .constructor(CapacityConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacityConfiguration").build())
            .build();

    private static final SdkField<String> RELEASE_LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("releaseLabel").getter(getter(GetKxClusterResponse::releaseLabel)).setter(setter(Builder::releaseLabel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("releaseLabel").build()).build();

    private static final SdkField<VpcConfiguration> VPC_CONFIGURATION_FIELD = SdkField
            .<VpcConfiguration> builder(MarshallingType.SDK_POJO).memberName("vpcConfiguration")
            .getter(getter(GetKxClusterResponse::vpcConfiguration)).setter(setter(Builder::vpcConfiguration))
            .constructor(VpcConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConfiguration").build()).build();

    private static final SdkField<String> INITIALIZATION_SCRIPT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("initializationScript").getter(getter(GetKxClusterResponse::initializationScript))
            .setter(setter(Builder::initializationScript))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initializationScript").build())
            .build();

    private static final SdkField<List<KxCommandLineArgument>> COMMAND_LINE_ARGUMENTS_FIELD = SdkField
            .<List<KxCommandLineArgument>> builder(MarshallingType.LIST)
            .memberName("commandLineArguments")
            .getter(getter(GetKxClusterResponse::commandLineArguments))
            .setter(setter(Builder::commandLineArguments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commandLineArguments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<KxCommandLineArgument> builder(MarshallingType.SDK_POJO)
                                            .constructor(KxCommandLineArgument::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<CodeConfiguration> CODE_FIELD = SdkField.<CodeConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("code").getter(getter(GetKxClusterResponse::code)).setter(setter(Builder::code))
            .constructor(CodeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("code").build()).build();

    private static final SdkField<String> EXECUTION_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionRole").getter(getter(GetKxClusterResponse::executionRole))
            .setter(setter(Builder::executionRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRole").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModifiedTimestamp").getter(getter(GetKxClusterResponse::lastModifiedTimestamp))
            .setter(setter(Builder::lastModifiedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTimestamp").build())
            .build();

    private static final SdkField<KxSavedownStorageConfiguration> SAVEDOWN_STORAGE_CONFIGURATION_FIELD = SdkField
            .<KxSavedownStorageConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("savedownStorageConfiguration")
            .getter(getter(GetKxClusterResponse::savedownStorageConfiguration))
            .setter(setter(Builder::savedownStorageConfiguration))
            .constructor(KxSavedownStorageConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savedownStorageConfiguration")
                    .build()).build();

    private static final SdkField<String> AZ_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("azMode")
            .getter(getter(GetKxClusterResponse::azModeAsString)).setter(setter(Builder::azMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("azMode").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("availabilityZoneId").getter(getter(GetKxClusterResponse::availabilityZoneId))
            .setter(setter(Builder::availabilityZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZoneId").build())
            .build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdTimestamp").getter(getter(GetKxClusterResponse::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTimestamp").build()).build();

    private static final SdkField<KxScalingGroupConfiguration> SCALING_GROUP_CONFIGURATION_FIELD = SdkField
            .<KxScalingGroupConfiguration> builder(MarshallingType.SDK_POJO).memberName("scalingGroupConfiguration")
            .getter(getter(GetKxClusterResponse::scalingGroupConfiguration)).setter(setter(Builder::scalingGroupConfiguration))
            .constructor(KxScalingGroupConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scalingGroupConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            STATUS_REASON_FIELD, CLUSTER_NAME_FIELD, CLUSTER_TYPE_FIELD, TICKERPLANT_LOG_CONFIGURATION_FIELD, VOLUMES_FIELD,
            DATABASES_FIELD, CACHE_STORAGE_CONFIGURATIONS_FIELD, AUTO_SCALING_CONFIGURATION_FIELD, CLUSTER_DESCRIPTION_FIELD,
            CAPACITY_CONFIGURATION_FIELD, RELEASE_LABEL_FIELD, VPC_CONFIGURATION_FIELD, INITIALIZATION_SCRIPT_FIELD,
            COMMAND_LINE_ARGUMENTS_FIELD, CODE_FIELD, EXECUTION_ROLE_FIELD, LAST_MODIFIED_TIMESTAMP_FIELD,
            SAVEDOWN_STORAGE_CONFIGURATION_FIELD, AZ_MODE_FIELD, AVAILABILITY_ZONE_ID_FIELD, CREATED_TIMESTAMP_FIELD,
            SCALING_GROUP_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String status;

    private final String statusReason;

    private final String clusterName;

    private final String clusterType;

    private final TickerplantLogConfiguration tickerplantLogConfiguration;

    private final List<Volume> volumes;

    private final List<KxDatabaseConfiguration> databases;

    private final List<KxCacheStorageConfiguration> cacheStorageConfigurations;

    private final AutoScalingConfiguration autoScalingConfiguration;

    private final String clusterDescription;

    private final CapacityConfiguration capacityConfiguration;

    private final String releaseLabel;

    private final VpcConfiguration vpcConfiguration;

    private final String initializationScript;

    private final List<KxCommandLineArgument> commandLineArguments;

    private final CodeConfiguration code;

    private final String executionRole;

    private final Instant lastModifiedTimestamp;

    private final KxSavedownStorageConfiguration savedownStorageConfiguration;

    private final String azMode;

    private final String availabilityZoneId;

    private final Instant createdTimestamp;

    private final KxScalingGroupConfiguration scalingGroupConfiguration;

    private GetKxClusterResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.clusterName = builder.clusterName;
        this.clusterType = builder.clusterType;
        this.tickerplantLogConfiguration = builder.tickerplantLogConfiguration;
        this.volumes = builder.volumes;
        this.databases = builder.databases;
        this.cacheStorageConfigurations = builder.cacheStorageConfigurations;
        this.autoScalingConfiguration = builder.autoScalingConfiguration;
        this.clusterDescription = builder.clusterDescription;
        this.capacityConfiguration = builder.capacityConfiguration;
        this.releaseLabel = builder.releaseLabel;
        this.vpcConfiguration = builder.vpcConfiguration;
        this.initializationScript = builder.initializationScript;
        this.commandLineArguments = builder.commandLineArguments;
        this.code = builder.code;
        this.executionRole = builder.executionRole;
        this.lastModifiedTimestamp = builder.lastModifiedTimestamp;
        this.savedownStorageConfiguration = builder.savedownStorageConfiguration;
        this.azMode = builder.azMode;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.createdTimestamp = builder.createdTimestamp;
        this.scalingGroupConfiguration = builder.scalingGroupConfiguration;
    }

    /**
     * <p>
     * The status of cluster creation.
     * </p>
     * <ul>
     * <li>
     * <p>
     * PENDING – The cluster is pending creation.
     * </p>
     * </li>
     * <li>
     * <p>
     * CREATING – The cluster creation process is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * CREATE_FAILED – The cluster creation process has failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * RUNNING – The cluster creation process is running.
     * </p>
     * </li>
     * <li>
     * <p>
     * UPDATING – The cluster is in the process of being updated.
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETING – The cluster is in the process of being deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETED – The cluster has been deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETE_FAILED – The cluster failed to delete.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link KxClusterStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of cluster creation.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         PENDING – The cluster is pending creation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CREATING – The cluster creation process is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CREATE_FAILED – The cluster creation process has failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RUNNING – The cluster creation process is running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UPDATING – The cluster is in the process of being updated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETING – The cluster is in the process of being deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETED – The cluster has been deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETE_FAILED – The cluster failed to delete.
     *         </p>
     *         </li>
     * @see KxClusterStatus
     */
    public final KxClusterStatus status() {
        return KxClusterStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of cluster creation.
     * </p>
     * <ul>
     * <li>
     * <p>
     * PENDING – The cluster is pending creation.
     * </p>
     * </li>
     * <li>
     * <p>
     * CREATING – The cluster creation process is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * CREATE_FAILED – The cluster creation process has failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * RUNNING – The cluster creation process is running.
     * </p>
     * </li>
     * <li>
     * <p>
     * UPDATING – The cluster is in the process of being updated.
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETING – The cluster is in the process of being deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETED – The cluster has been deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETE_FAILED – The cluster failed to delete.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link KxClusterStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of cluster creation.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         PENDING – The cluster is pending creation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CREATING – The cluster creation process is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CREATE_FAILED – The cluster creation process has failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RUNNING – The cluster creation process is running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UPDATING – The cluster is in the process of being updated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETING – The cluster is in the process of being deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETED – The cluster has been deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETE_FAILED – The cluster failed to delete.
     *         </p>
     *         </li>
     * @see KxClusterStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The error message when a failed state occurs.
     * </p>
     * 
     * @return The error message when a failed state occurs.
     */
    public final String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * A unique name for the cluster.
     * </p>
     * 
     * @return A unique name for the cluster.
     */
    public final String clusterName() {
        return clusterName;
    }

    /**
     * <p>
     * Specifies the type of KDB database that is being created. The following types are available:
     * </p>
     * <ul>
     * <li>
     * <p>
     * HDB – A Historical Database. The data is only accessible with read-only permissions from one of the FinSpace
     * managed kdb databases mounted to the cluster.
     * </p>
     * </li>
     * <li>
     * <p>
     * RDB – A Realtime Database. This type of database captures all the data from a ticker plant and stores it in
     * memory until the end of day, after which it writes all of its data to a disk and reloads the HDB. This cluster
     * type requires local storage for temporary storage of data during the savedown process. If you specify this field
     * in your request, you must provide the <code>savedownStorageConfiguration</code> parameter.
     * </p>
     * </li>
     * <li>
     * <p>
     * GATEWAY – A gateway cluster allows you to access data across processes in kdb systems. It allows you to create
     * your own routing logic using the initialization scripts and custom code. This type of cluster does not require a
     * writable local storage.
     * </p>
     * </li>
     * <li>
     * <p>
     * GP – A general purpose cluster allows you to quickly iterate on code during development by granting greater
     * access to system commands and enabling a fast reload of custom code. This cluster type can optionally mount
     * databases including cache and savedown storage. For this cluster type, the node count is fixed at 1. It does not
     * support autoscaling and supports only <code>SINGLE</code> AZ mode.
     * </p>
     * </li>
     * <li>
     * <p>
     * Tickerplant – A tickerplant cluster allows you to subscribe to feed handlers based on IAM permissions. It can
     * publish to RDBs, other Tickerplants, and real-time subscribers (RTS). Tickerplants can persist messages to log,
     * which is readable by any RDB environment. It supports only single-node that is only one kdb process.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #clusterType} will
     * return {@link KxClusterType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #clusterTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of KDB database that is being created. The following types are available: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         HDB – A Historical Database. The data is only accessible with read-only permissions from one of the
     *         FinSpace managed kdb databases mounted to the cluster.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RDB – A Realtime Database. This type of database captures all the data from a ticker plant and stores it
     *         in memory until the end of day, after which it writes all of its data to a disk and reloads the HDB. This
     *         cluster type requires local storage for temporary storage of data during the savedown process. If you
     *         specify this field in your request, you must provide the <code>savedownStorageConfiguration</code>
     *         parameter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         GATEWAY – A gateway cluster allows you to access data across processes in kdb systems. It allows you to
     *         create your own routing logic using the initialization scripts and custom code. This type of cluster does
     *         not require a writable local storage.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         GP – A general purpose cluster allows you to quickly iterate on code during development by granting
     *         greater access to system commands and enabling a fast reload of custom code. This cluster type can
     *         optionally mount databases including cache and savedown storage. For this cluster type, the node count is
     *         fixed at 1. It does not support autoscaling and supports only <code>SINGLE</code> AZ mode.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Tickerplant – A tickerplant cluster allows you to subscribe to feed handlers based on IAM permissions. It
     *         can publish to RDBs, other Tickerplants, and real-time subscribers (RTS). Tickerplants can persist
     *         messages to log, which is readable by any RDB environment. It supports only single-node that is only one
     *         kdb process.
     *         </p>
     *         </li>
     * @see KxClusterType
     */
    public final KxClusterType clusterType() {
        return KxClusterType.fromValue(clusterType);
    }

    /**
     * <p>
     * Specifies the type of KDB database that is being created. The following types are available:
     * </p>
     * <ul>
     * <li>
     * <p>
     * HDB – A Historical Database. The data is only accessible with read-only permissions from one of the FinSpace
     * managed kdb databases mounted to the cluster.
     * </p>
     * </li>
     * <li>
     * <p>
     * RDB – A Realtime Database. This type of database captures all the data from a ticker plant and stores it in
     * memory until the end of day, after which it writes all of its data to a disk and reloads the HDB. This cluster
     * type requires local storage for temporary storage of data during the savedown process. If you specify this field
     * in your request, you must provide the <code>savedownStorageConfiguration</code> parameter.
     * </p>
     * </li>
     * <li>
     * <p>
     * GATEWAY – A gateway cluster allows you to access data across processes in kdb systems. It allows you to create
     * your own routing logic using the initialization scripts and custom code. This type of cluster does not require a
     * writable local storage.
     * </p>
     * </li>
     * <li>
     * <p>
     * GP – A general purpose cluster allows you to quickly iterate on code during development by granting greater
     * access to system commands and enabling a fast reload of custom code. This cluster type can optionally mount
     * databases including cache and savedown storage. For this cluster type, the node count is fixed at 1. It does not
     * support autoscaling and supports only <code>SINGLE</code> AZ mode.
     * </p>
     * </li>
     * <li>
     * <p>
     * Tickerplant – A tickerplant cluster allows you to subscribe to feed handlers based on IAM permissions. It can
     * publish to RDBs, other Tickerplants, and real-time subscribers (RTS). Tickerplants can persist messages to log,
     * which is readable by any RDB environment. It supports only single-node that is only one kdb process.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #clusterType} will
     * return {@link KxClusterType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #clusterTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of KDB database that is being created. The following types are available: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         HDB – A Historical Database. The data is only accessible with read-only permissions from one of the
     *         FinSpace managed kdb databases mounted to the cluster.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RDB – A Realtime Database. This type of database captures all the data from a ticker plant and stores it
     *         in memory until the end of day, after which it writes all of its data to a disk and reloads the HDB. This
     *         cluster type requires local storage for temporary storage of data during the savedown process. If you
     *         specify this field in your request, you must provide the <code>savedownStorageConfiguration</code>
     *         parameter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         GATEWAY – A gateway cluster allows you to access data across processes in kdb systems. It allows you to
     *         create your own routing logic using the initialization scripts and custom code. This type of cluster does
     *         not require a writable local storage.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         GP – A general purpose cluster allows you to quickly iterate on code during development by granting
     *         greater access to system commands and enabling a fast reload of custom code. This cluster type can
     *         optionally mount databases including cache and savedown storage. For this cluster type, the node count is
     *         fixed at 1. It does not support autoscaling and supports only <code>SINGLE</code> AZ mode.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Tickerplant – A tickerplant cluster allows you to subscribe to feed handlers based on IAM permissions. It
     *         can publish to RDBs, other Tickerplants, and real-time subscribers (RTS). Tickerplants can persist
     *         messages to log, which is readable by any RDB environment. It supports only single-node that is only one
     *         kdb process.
     *         </p>
     *         </li>
     * @see KxClusterType
     */
    public final String clusterTypeAsString() {
        return clusterType;
    }

    /**
     * Returns the value of the TickerplantLogConfiguration property for this object.
     * 
     * @return The value of the TickerplantLogConfiguration property for this object.
     */
    public final TickerplantLogConfiguration tickerplantLogConfiguration() {
        return tickerplantLogConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the Volumes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasVolumes() {
        return volumes != null && !(volumes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of volumes attached to the cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVolumes} method.
     * </p>
     * 
     * @return A list of volumes attached to the cluster.
     */
    public final List<Volume> volumes() {
        return volumes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Databases property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDatabases() {
        return databases != null && !(databases instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of databases mounted on the cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDatabases} method.
     * </p>
     * 
     * @return A list of databases mounted on the cluster.
     */
    public final List<KxDatabaseConfiguration> databases() {
        return databases;
    }

    /**
     * For responses, this returns true if the service returned a value for the CacheStorageConfigurations property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCacheStorageConfigurations() {
        return cacheStorageConfigurations != null && !(cacheStorageConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The configurations for a read only cache storage associated with a cluster. This cache will be stored as an FSx
     * Lustre that reads from the S3 store.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCacheStorageConfigurations} method.
     * </p>
     * 
     * @return The configurations for a read only cache storage associated with a cluster. This cache will be stored as
     *         an FSx Lustre that reads from the S3 store.
     */
    public final List<KxCacheStorageConfiguration> cacheStorageConfigurations() {
        return cacheStorageConfigurations;
    }

    /**
     * <p>
     * The configuration based on which FinSpace will scale in or scale out nodes in your cluster.
     * </p>
     * 
     * @return The configuration based on which FinSpace will scale in or scale out nodes in your cluster.
     */
    public final AutoScalingConfiguration autoScalingConfiguration() {
        return autoScalingConfiguration;
    }

    /**
     * <p>
     * A description of the cluster.
     * </p>
     * 
     * @return A description of the cluster.
     */
    public final String clusterDescription() {
        return clusterDescription;
    }

    /**
     * <p>
     * A structure for the metadata of a cluster. It includes information like the CPUs needed, memory of instances, and
     * number of instances.
     * </p>
     * 
     * @return A structure for the metadata of a cluster. It includes information like the CPUs needed, memory of
     *         instances, and number of instances.
     */
    public final CapacityConfiguration capacityConfiguration() {
        return capacityConfiguration;
    }

    /**
     * <p>
     * The version of FinSpace managed kdb to run.
     * </p>
     * 
     * @return The version of FinSpace managed kdb to run.
     */
    public final String releaseLabel() {
        return releaseLabel;
    }

    /**
     * <p>
     * Configuration details about the network where the Privatelink endpoint of the cluster resides.
     * </p>
     * 
     * @return Configuration details about the network where the Privatelink endpoint of the cluster resides.
     */
    public final VpcConfiguration vpcConfiguration() {
        return vpcConfiguration;
    }

    /**
     * <p>
     * Specifies a Q program that will be run at launch of a cluster. It is a relative path within <i>.zip</i> file that
     * contains the custom code, which will be loaded on the cluster. It must include the file name itself. For example,
     * <code>somedir/init.q</code>.
     * </p>
     * 
     * @return Specifies a Q program that will be run at launch of a cluster. It is a relative path within <i>.zip</i>
     *         file that contains the custom code, which will be loaded on the cluster. It must include the file name
     *         itself. For example, <code>somedir/init.q</code>.
     */
    public final String initializationScript() {
        return initializationScript;
    }

    /**
     * For responses, this returns true if the service returned a value for the CommandLineArguments property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCommandLineArguments() {
        return commandLineArguments != null && !(commandLineArguments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Defines key-value pairs to make them available inside the cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCommandLineArguments} method.
     * </p>
     * 
     * @return Defines key-value pairs to make them available inside the cluster.
     */
    public final List<KxCommandLineArgument> commandLineArguments() {
        return commandLineArguments;
    }

    /**
     * <p>
     * The details of the custom code that you want to use inside a cluster when analyzing a data. It consists of the S3
     * source bucket, location, S3 object version, and the relative path from where the custom code is loaded into the
     * cluster.
     * </p>
     * 
     * @return The details of the custom code that you want to use inside a cluster when analyzing a data. It consists
     *         of the S3 source bucket, location, S3 object version, and the relative path from where the custom code is
     *         loaded into the cluster.
     */
    public final CodeConfiguration code() {
        return code;
    }

    /**
     * <p>
     * An IAM role that defines a set of permissions associated with a cluster. These permissions are assumed when a
     * cluster attempts to access another cluster.
     * </p>
     * 
     * @return An IAM role that defines a set of permissions associated with a cluster. These permissions are assumed
     *         when a cluster attempts to access another cluster.
     */
    public final String executionRole() {
        return executionRole;
    }

    /**
     * <p>
     * The last time that the cluster was modified. The value is determined as epoch time in milliseconds. For example,
     * the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
     * </p>
     * 
     * @return The last time that the cluster was modified. The value is determined as epoch time in milliseconds. For
     *         example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
     */
    public final Instant lastModifiedTimestamp() {
        return lastModifiedTimestamp;
    }

    /**
     * <p>
     * The size and type of the temporary storage that is used to hold data during the savedown process. This parameter
     * is required when you choose <code>clusterType</code> as RDB. All the data written to this storage space is lost
     * when the cluster node is restarted.
     * </p>
     * 
     * @return The size and type of the temporary storage that is used to hold data during the savedown process. This
     *         parameter is required when you choose <code>clusterType</code> as RDB. All the data written to this
     *         storage space is lost when the cluster node is restarted.
     */
    public final KxSavedownStorageConfiguration savedownStorageConfiguration() {
        return savedownStorageConfiguration;
    }

    /**
     * <p>
     * The number of availability zones you want to assign per cluster. This can be one of the following
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SINGLE</code> – Assigns one availability zone per cluster.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MULTI</code> – Assigns all the availability zones per cluster.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #azMode} will
     * return {@link KxAzMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #azModeAsString}.
     * </p>
     * 
     * @return The number of availability zones you want to assign per cluster. This can be one of the following </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SINGLE</code> – Assigns one availability zone per cluster.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MULTI</code> – Assigns all the availability zones per cluster.
     *         </p>
     *         </li>
     * @see KxAzMode
     */
    public final KxAzMode azMode() {
        return KxAzMode.fromValue(azMode);
    }

    /**
     * <p>
     * The number of availability zones you want to assign per cluster. This can be one of the following
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SINGLE</code> – Assigns one availability zone per cluster.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MULTI</code> – Assigns all the availability zones per cluster.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #azMode} will
     * return {@link KxAzMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #azModeAsString}.
     * </p>
     * 
     * @return The number of availability zones you want to assign per cluster. This can be one of the following </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SINGLE</code> – Assigns one availability zone per cluster.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MULTI</code> – Assigns all the availability zones per cluster.
     *         </p>
     *         </li>
     * @see KxAzMode
     */
    public final String azModeAsString() {
        return azMode;
    }

    /**
     * <p>
     * The availability zone identifiers for the requested regions.
     * </p>
     * 
     * @return The availability zone identifiers for the requested regions.
     */
    public final String availabilityZoneId() {
        return availabilityZoneId;
    }

    /**
     * <p>
     * The timestamp at which the cluster was created in FinSpace. The value is determined as epoch time in
     * milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
     * </p>
     * 
     * @return The timestamp at which the cluster was created in FinSpace. The value is determined as epoch time in
     *         milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as
     *         1635768000000.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    /**
     * Returns the value of the ScalingGroupConfiguration property for this object.
     * 
     * @return The value of the ScalingGroupConfiguration property for this object.
     */
    public final KxScalingGroupConfiguration scalingGroupConfiguration() {
        return scalingGroupConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(clusterTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(tickerplantLogConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasVolumes() ? volumes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDatabases() ? databases() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCacheStorageConfigurations() ? cacheStorageConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(clusterDescription());
        hashCode = 31 * hashCode + Objects.hashCode(capacityConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(releaseLabel());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(initializationScript());
        hashCode = 31 * hashCode + Objects.hashCode(hasCommandLineArguments() ? commandLineArguments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(code());
        hashCode = 31 * hashCode + Objects.hashCode(executionRole());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(savedownStorageConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(azModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(scalingGroupConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetKxClusterResponse)) {
            return false;
        }
        GetKxClusterResponse other = (GetKxClusterResponse) obj;
        return Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(statusReason(), other.statusReason())
                && Objects.equals(clusterName(), other.clusterName())
                && Objects.equals(clusterTypeAsString(), other.clusterTypeAsString())
                && Objects.equals(tickerplantLogConfiguration(), other.tickerplantLogConfiguration())
                && hasVolumes() == other.hasVolumes() && Objects.equals(volumes(), other.volumes())
                && hasDatabases() == other.hasDatabases() && Objects.equals(databases(), other.databases())
                && hasCacheStorageConfigurations() == other.hasCacheStorageConfigurations()
                && Objects.equals(cacheStorageConfigurations(), other.cacheStorageConfigurations())
                && Objects.equals(autoScalingConfiguration(), other.autoScalingConfiguration())
                && Objects.equals(clusterDescription(), other.clusterDescription())
                && Objects.equals(capacityConfiguration(), other.capacityConfiguration())
                && Objects.equals(releaseLabel(), other.releaseLabel())
                && Objects.equals(vpcConfiguration(), other.vpcConfiguration())
                && Objects.equals(initializationScript(), other.initializationScript())
                && hasCommandLineArguments() == other.hasCommandLineArguments()
                && Objects.equals(commandLineArguments(), other.commandLineArguments()) && Objects.equals(code(), other.code())
                && Objects.equals(executionRole(), other.executionRole())
                && Objects.equals(lastModifiedTimestamp(), other.lastModifiedTimestamp())
                && Objects.equals(savedownStorageConfiguration(), other.savedownStorageConfiguration())
                && Objects.equals(azModeAsString(), other.azModeAsString())
                && Objects.equals(availabilityZoneId(), other.availabilityZoneId())
                && Objects.equals(createdTimestamp(), other.createdTimestamp())
                && Objects.equals(scalingGroupConfiguration(), other.scalingGroupConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetKxClusterResponse").add("Status", statusAsString()).add("StatusReason", statusReason())
                .add("ClusterName", clusterName()).add("ClusterType", clusterTypeAsString())
                .add("TickerplantLogConfiguration", tickerplantLogConfiguration())
                .add("Volumes", hasVolumes() ? volumes() : null).add("Databases", hasDatabases() ? databases() : null)
                .add("CacheStorageConfigurations", hasCacheStorageConfigurations() ? cacheStorageConfigurations() : null)
                .add("AutoScalingConfiguration", autoScalingConfiguration()).add("ClusterDescription", clusterDescription())
                .add("CapacityConfiguration", capacityConfiguration()).add("ReleaseLabel", releaseLabel())
                .add("VpcConfiguration", vpcConfiguration()).add("InitializationScript", initializationScript())
                .add("CommandLineArguments", hasCommandLineArguments() ? commandLineArguments() : null).add("Code", code())
                .add("ExecutionRole", executionRole()).add("LastModifiedTimestamp", lastModifiedTimestamp())
                .add("SavedownStorageConfiguration", savedownStorageConfiguration()).add("AzMode", azModeAsString())
                .add("AvailabilityZoneId", availabilityZoneId()).add("CreatedTimestamp", createdTimestamp())
                .add("ScalingGroupConfiguration", scalingGroupConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "clusterName":
            return Optional.ofNullable(clazz.cast(clusterName()));
        case "clusterType":
            return Optional.ofNullable(clazz.cast(clusterTypeAsString()));
        case "tickerplantLogConfiguration":
            return Optional.ofNullable(clazz.cast(tickerplantLogConfiguration()));
        case "volumes":
            return Optional.ofNullable(clazz.cast(volumes()));
        case "databases":
            return Optional.ofNullable(clazz.cast(databases()));
        case "cacheStorageConfigurations":
            return Optional.ofNullable(clazz.cast(cacheStorageConfigurations()));
        case "autoScalingConfiguration":
            return Optional.ofNullable(clazz.cast(autoScalingConfiguration()));
        case "clusterDescription":
            return Optional.ofNullable(clazz.cast(clusterDescription()));
        case "capacityConfiguration":
            return Optional.ofNullable(clazz.cast(capacityConfiguration()));
        case "releaseLabel":
            return Optional.ofNullable(clazz.cast(releaseLabel()));
        case "vpcConfiguration":
            return Optional.ofNullable(clazz.cast(vpcConfiguration()));
        case "initializationScript":
            return Optional.ofNullable(clazz.cast(initializationScript()));
        case "commandLineArguments":
            return Optional.ofNullable(clazz.cast(commandLineArguments()));
        case "code":
            return Optional.ofNullable(clazz.cast(code()));
        case "executionRole":
            return Optional.ofNullable(clazz.cast(executionRole()));
        case "lastModifiedTimestamp":
            return Optional.ofNullable(clazz.cast(lastModifiedTimestamp()));
        case "savedownStorageConfiguration":
            return Optional.ofNullable(clazz.cast(savedownStorageConfiguration()));
        case "azMode":
            return Optional.ofNullable(clazz.cast(azModeAsString()));
        case "availabilityZoneId":
            return Optional.ofNullable(clazz.cast(availabilityZoneId()));
        case "createdTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        case "scalingGroupConfiguration":
            return Optional.ofNullable(clazz.cast(scalingGroupConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("status", STATUS_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        map.put("clusterName", CLUSTER_NAME_FIELD);
        map.put("clusterType", CLUSTER_TYPE_FIELD);
        map.put("tickerplantLogConfiguration", TICKERPLANT_LOG_CONFIGURATION_FIELD);
        map.put("volumes", VOLUMES_FIELD);
        map.put("databases", DATABASES_FIELD);
        map.put("cacheStorageConfigurations", CACHE_STORAGE_CONFIGURATIONS_FIELD);
        map.put("autoScalingConfiguration", AUTO_SCALING_CONFIGURATION_FIELD);
        map.put("clusterDescription", CLUSTER_DESCRIPTION_FIELD);
        map.put("capacityConfiguration", CAPACITY_CONFIGURATION_FIELD);
        map.put("releaseLabel", RELEASE_LABEL_FIELD);
        map.put("vpcConfiguration", VPC_CONFIGURATION_FIELD);
        map.put("initializationScript", INITIALIZATION_SCRIPT_FIELD);
        map.put("commandLineArguments", COMMAND_LINE_ARGUMENTS_FIELD);
        map.put("code", CODE_FIELD);
        map.put("executionRole", EXECUTION_ROLE_FIELD);
        map.put("lastModifiedTimestamp", LAST_MODIFIED_TIMESTAMP_FIELD);
        map.put("savedownStorageConfiguration", SAVEDOWN_STORAGE_CONFIGURATION_FIELD);
        map.put("azMode", AZ_MODE_FIELD);
        map.put("availabilityZoneId", AVAILABILITY_ZONE_ID_FIELD);
        map.put("createdTimestamp", CREATED_TIMESTAMP_FIELD);
        map.put("scalingGroupConfiguration", SCALING_GROUP_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetKxClusterResponse, T> g) {
        return obj -> g.apply((GetKxClusterResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FinspaceResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetKxClusterResponse> {
        /**
         * <p>
         * The status of cluster creation.
         * </p>
         * <ul>
         * <li>
         * <p>
         * PENDING – The cluster is pending creation.
         * </p>
         * </li>
         * <li>
         * <p>
         * CREATING – The cluster creation process is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * CREATE_FAILED – The cluster creation process has failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * RUNNING – The cluster creation process is running.
         * </p>
         * </li>
         * <li>
         * <p>
         * UPDATING – The cluster is in the process of being updated.
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETING – The cluster is in the process of being deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETED – The cluster has been deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETE_FAILED – The cluster failed to delete.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of cluster creation.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        PENDING – The cluster is pending creation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CREATING – The cluster creation process is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CREATE_FAILED – The cluster creation process has failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RUNNING – The cluster creation process is running.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UPDATING – The cluster is in the process of being updated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETING – The cluster is in the process of being deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETED – The cluster has been deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETE_FAILED – The cluster failed to delete.
         *        </p>
         *        </li>
         * @see KxClusterStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KxClusterStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of cluster creation.
         * </p>
         * <ul>
         * <li>
         * <p>
         * PENDING – The cluster is pending creation.
         * </p>
         * </li>
         * <li>
         * <p>
         * CREATING – The cluster creation process is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * CREATE_FAILED – The cluster creation process has failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * RUNNING – The cluster creation process is running.
         * </p>
         * </li>
         * <li>
         * <p>
         * UPDATING – The cluster is in the process of being updated.
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETING – The cluster is in the process of being deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETED – The cluster has been deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETE_FAILED – The cluster failed to delete.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of cluster creation.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        PENDING – The cluster is pending creation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CREATING – The cluster creation process is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CREATE_FAILED – The cluster creation process has failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RUNNING – The cluster creation process is running.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UPDATING – The cluster is in the process of being updated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETING – The cluster is in the process of being deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETED – The cluster has been deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETE_FAILED – The cluster failed to delete.
         *        </p>
         *        </li>
         * @see KxClusterStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KxClusterStatus
         */
        Builder status(KxClusterStatus status);

        /**
         * <p>
         * The error message when a failed state occurs.
         * </p>
         * 
         * @param statusReason
         *        The error message when a failed state occurs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * A unique name for the cluster.
         * </p>
         * 
         * @param clusterName
         *        A unique name for the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterName(String clusterName);

        /**
         * <p>
         * Specifies the type of KDB database that is being created. The following types are available:
         * </p>
         * <ul>
         * <li>
         * <p>
         * HDB – A Historical Database. The data is only accessible with read-only permissions from one of the FinSpace
         * managed kdb databases mounted to the cluster.
         * </p>
         * </li>
         * <li>
         * <p>
         * RDB – A Realtime Database. This type of database captures all the data from a ticker plant and stores it in
         * memory until the end of day, after which it writes all of its data to a disk and reloads the HDB. This
         * cluster type requires local storage for temporary storage of data during the savedown process. If you specify
         * this field in your request, you must provide the <code>savedownStorageConfiguration</code> parameter.
         * </p>
         * </li>
         * <li>
         * <p>
         * GATEWAY – A gateway cluster allows you to access data across processes in kdb systems. It allows you to
         * create your own routing logic using the initialization scripts and custom code. This type of cluster does not
         * require a writable local storage.
         * </p>
         * </li>
         * <li>
         * <p>
         * GP – A general purpose cluster allows you to quickly iterate on code during development by granting greater
         * access to system commands and enabling a fast reload of custom code. This cluster type can optionally mount
         * databases including cache and savedown storage. For this cluster type, the node count is fixed at 1. It does
         * not support autoscaling and supports only <code>SINGLE</code> AZ mode.
         * </p>
         * </li>
         * <li>
         * <p>
         * Tickerplant – A tickerplant cluster allows you to subscribe to feed handlers based on IAM permissions. It can
         * publish to RDBs, other Tickerplants, and real-time subscribers (RTS). Tickerplants can persist messages to
         * log, which is readable by any RDB environment. It supports only single-node that is only one kdb process.
         * </p>
         * </li>
         * </ul>
         * 
         * @param clusterType
         *        Specifies the type of KDB database that is being created. The following types are available: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        HDB – A Historical Database. The data is only accessible with read-only permissions from one of the
         *        FinSpace managed kdb databases mounted to the cluster.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RDB – A Realtime Database. This type of database captures all the data from a ticker plant and stores
         *        it in memory until the end of day, after which it writes all of its data to a disk and reloads the
         *        HDB. This cluster type requires local storage for temporary storage of data during the savedown
         *        process. If you specify this field in your request, you must provide the
         *        <code>savedownStorageConfiguration</code> parameter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        GATEWAY – A gateway cluster allows you to access data across processes in kdb systems. It allows you
         *        to create your own routing logic using the initialization scripts and custom code. This type of
         *        cluster does not require a writable local storage.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        GP – A general purpose cluster allows you to quickly iterate on code during development by granting
         *        greater access to system commands and enabling a fast reload of custom code. This cluster type can
         *        optionally mount databases including cache and savedown storage. For this cluster type, the node count
         *        is fixed at 1. It does not support autoscaling and supports only <code>SINGLE</code> AZ mode.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Tickerplant – A tickerplant cluster allows you to subscribe to feed handlers based on IAM permissions.
         *        It can publish to RDBs, other Tickerplants, and real-time subscribers (RTS). Tickerplants can persist
         *        messages to log, which is readable by any RDB environment. It supports only single-node that is only
         *        one kdb process.
         *        </p>
         *        </li>
         * @see KxClusterType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KxClusterType
         */
        Builder clusterType(String clusterType);

        /**
         * <p>
         * Specifies the type of KDB database that is being created. The following types are available:
         * </p>
         * <ul>
         * <li>
         * <p>
         * HDB – A Historical Database. The data is only accessible with read-only permissions from one of the FinSpace
         * managed kdb databases mounted to the cluster.
         * </p>
         * </li>
         * <li>
         * <p>
         * RDB – A Realtime Database. This type of database captures all the data from a ticker plant and stores it in
         * memory until the end of day, after which it writes all of its data to a disk and reloads the HDB. This
         * cluster type requires local storage for temporary storage of data during the savedown process. If you specify
         * this field in your request, you must provide the <code>savedownStorageConfiguration</code> parameter.
         * </p>
         * </li>
         * <li>
         * <p>
         * GATEWAY – A gateway cluster allows you to access data across processes in kdb systems. It allows you to
         * create your own routing logic using the initialization scripts and custom code. This type of cluster does not
         * require a writable local storage.
         * </p>
         * </li>
         * <li>
         * <p>
         * GP – A general purpose cluster allows you to quickly iterate on code during development by granting greater
         * access to system commands and enabling a fast reload of custom code. This cluster type can optionally mount
         * databases including cache and savedown storage. For this cluster type, the node count is fixed at 1. It does
         * not support autoscaling and supports only <code>SINGLE</code> AZ mode.
         * </p>
         * </li>
         * <li>
         * <p>
         * Tickerplant – A tickerplant cluster allows you to subscribe to feed handlers based on IAM permissions. It can
         * publish to RDBs, other Tickerplants, and real-time subscribers (RTS). Tickerplants can persist messages to
         * log, which is readable by any RDB environment. It supports only single-node that is only one kdb process.
         * </p>
         * </li>
         * </ul>
         * 
         * @param clusterType
         *        Specifies the type of KDB database that is being created. The following types are available: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        HDB – A Historical Database. The data is only accessible with read-only permissions from one of the
         *        FinSpace managed kdb databases mounted to the cluster.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RDB – A Realtime Database. This type of database captures all the data from a ticker plant and stores
         *        it in memory until the end of day, after which it writes all of its data to a disk and reloads the
         *        HDB. This cluster type requires local storage for temporary storage of data during the savedown
         *        process. If you specify this field in your request, you must provide the
         *        <code>savedownStorageConfiguration</code> parameter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        GATEWAY – A gateway cluster allows you to access data across processes in kdb systems. It allows you
         *        to create your own routing logic using the initialization scripts and custom code. This type of
         *        cluster does not require a writable local storage.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        GP – A general purpose cluster allows you to quickly iterate on code during development by granting
         *        greater access to system commands and enabling a fast reload of custom code. This cluster type can
         *        optionally mount databases including cache and savedown storage. For this cluster type, the node count
         *        is fixed at 1. It does not support autoscaling and supports only <code>SINGLE</code> AZ mode.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Tickerplant – A tickerplant cluster allows you to subscribe to feed handlers based on IAM permissions.
         *        It can publish to RDBs, other Tickerplants, and real-time subscribers (RTS). Tickerplants can persist
         *        messages to log, which is readable by any RDB environment. It supports only single-node that is only
         *        one kdb process.
         *        </p>
         *        </li>
         * @see KxClusterType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KxClusterType
         */
        Builder clusterType(KxClusterType clusterType);

        /**
         * Sets the value of the TickerplantLogConfiguration property for this object.
         *
         * @param tickerplantLogConfiguration
         *        The new value for the TickerplantLogConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tickerplantLogConfiguration(TickerplantLogConfiguration tickerplantLogConfiguration);

        /**
         * Sets the value of the TickerplantLogConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link TickerplantLogConfiguration.Builder}
         * avoiding the need to create one manually via {@link TickerplantLogConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TickerplantLogConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #tickerplantLogConfiguration(TickerplantLogConfiguration)}.
         * 
         * @param tickerplantLogConfiguration
         *        a consumer that will call methods on {@link TickerplantLogConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tickerplantLogConfiguration(TickerplantLogConfiguration)
         */
        default Builder tickerplantLogConfiguration(Consumer<TickerplantLogConfiguration.Builder> tickerplantLogConfiguration) {
            return tickerplantLogConfiguration(TickerplantLogConfiguration.builder().applyMutation(tickerplantLogConfiguration)
                    .build());
        }

        /**
         * <p>
         * A list of volumes attached to the cluster.
         * </p>
         * 
         * @param volumes
         *        A list of volumes attached to the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumes(Collection<Volume> volumes);

        /**
         * <p>
         * A list of volumes attached to the cluster.
         * </p>
         * 
         * @param volumes
         *        A list of volumes attached to the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumes(Volume... volumes);

        /**
         * <p>
         * A list of volumes attached to the cluster.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.finspace.model.Volume.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.finspace.model.Volume#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.finspace.model.Volume.Builder#build()} is called immediately and its
         * result is passed to {@link #volumes(List<Volume>)}.
         * 
         * @param volumes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.finspace.model.Volume.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #volumes(java.util.Collection<Volume>)
         */
        Builder volumes(Consumer<Volume.Builder>... volumes);

        /**
         * <p>
         * A list of databases mounted on the cluster.
         * </p>
         * 
         * @param databases
         *        A list of databases mounted on the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databases(Collection<KxDatabaseConfiguration> databases);

        /**
         * <p>
         * A list of databases mounted on the cluster.
         * </p>
         * 
         * @param databases
         *        A list of databases mounted on the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databases(KxDatabaseConfiguration... databases);

        /**
         * <p>
         * A list of databases mounted on the cluster.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.finspace.model.KxDatabaseConfiguration.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.finspace.model.KxDatabaseConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.finspace.model.KxDatabaseConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #databases(List<KxDatabaseConfiguration>)}.
         * 
         * @param databases
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.finspace.model.KxDatabaseConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #databases(java.util.Collection<KxDatabaseConfiguration>)
         */
        Builder databases(Consumer<KxDatabaseConfiguration.Builder>... databases);

        /**
         * <p>
         * The configurations for a read only cache storage associated with a cluster. This cache will be stored as an
         * FSx Lustre that reads from the S3 store.
         * </p>
         * 
         * @param cacheStorageConfigurations
         *        The configurations for a read only cache storage associated with a cluster. This cache will be stored
         *        as an FSx Lustre that reads from the S3 store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheStorageConfigurations(Collection<KxCacheStorageConfiguration> cacheStorageConfigurations);

        /**
         * <p>
         * The configurations for a read only cache storage associated with a cluster. This cache will be stored as an
         * FSx Lustre that reads from the S3 store.
         * </p>
         * 
         * @param cacheStorageConfigurations
         *        The configurations for a read only cache storage associated with a cluster. This cache will be stored
         *        as an FSx Lustre that reads from the S3 store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheStorageConfigurations(KxCacheStorageConfiguration... cacheStorageConfigurations);

        /**
         * <p>
         * The configurations for a read only cache storage associated with a cluster. This cache will be stored as an
         * FSx Lustre that reads from the S3 store.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.finspace.model.KxCacheStorageConfiguration.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.finspace.model.KxCacheStorageConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.finspace.model.KxCacheStorageConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #cacheStorageConfigurations(List<KxCacheStorageConfiguration>)}.
         * 
         * @param cacheStorageConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.finspace.model.KxCacheStorageConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cacheStorageConfigurations(java.util.Collection<KxCacheStorageConfiguration>)
         */
        Builder cacheStorageConfigurations(Consumer<KxCacheStorageConfiguration.Builder>... cacheStorageConfigurations);

        /**
         * <p>
         * The configuration based on which FinSpace will scale in or scale out nodes in your cluster.
         * </p>
         * 
         * @param autoScalingConfiguration
         *        The configuration based on which FinSpace will scale in or scale out nodes in your cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingConfiguration(AutoScalingConfiguration autoScalingConfiguration);

        /**
         * <p>
         * The configuration based on which FinSpace will scale in or scale out nodes in your cluster.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutoScalingConfiguration.Builder}
         * avoiding the need to create one manually via {@link AutoScalingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutoScalingConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #autoScalingConfiguration(AutoScalingConfiguration)}.
         * 
         * @param autoScalingConfiguration
         *        a consumer that will call methods on {@link AutoScalingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoScalingConfiguration(AutoScalingConfiguration)
         */
        default Builder autoScalingConfiguration(Consumer<AutoScalingConfiguration.Builder> autoScalingConfiguration) {
            return autoScalingConfiguration(AutoScalingConfiguration.builder().applyMutation(autoScalingConfiguration).build());
        }

        /**
         * <p>
         * A description of the cluster.
         * </p>
         * 
         * @param clusterDescription
         *        A description of the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterDescription(String clusterDescription);

        /**
         * <p>
         * A structure for the metadata of a cluster. It includes information like the CPUs needed, memory of instances,
         * and number of instances.
         * </p>
         * 
         * @param capacityConfiguration
         *        A structure for the metadata of a cluster. It includes information like the CPUs needed, memory of
         *        instances, and number of instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityConfiguration(CapacityConfiguration capacityConfiguration);

        /**
         * <p>
         * A structure for the metadata of a cluster. It includes information like the CPUs needed, memory of instances,
         * and number of instances.
         * </p>
         * This is a convenience method that creates an instance of the {@link CapacityConfiguration.Builder} avoiding
         * the need to create one manually via {@link CapacityConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CapacityConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #capacityConfiguration(CapacityConfiguration)}.
         * 
         * @param capacityConfiguration
         *        a consumer that will call methods on {@link CapacityConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capacityConfiguration(CapacityConfiguration)
         */
        default Builder capacityConfiguration(Consumer<CapacityConfiguration.Builder> capacityConfiguration) {
            return capacityConfiguration(CapacityConfiguration.builder().applyMutation(capacityConfiguration).build());
        }

        /**
         * <p>
         * The version of FinSpace managed kdb to run.
         * </p>
         * 
         * @param releaseLabel
         *        The version of FinSpace managed kdb to run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder releaseLabel(String releaseLabel);

        /**
         * <p>
         * Configuration details about the network where the Privatelink endpoint of the cluster resides.
         * </p>
         * 
         * @param vpcConfiguration
         *        Configuration details about the network where the Privatelink endpoint of the cluster resides.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfiguration(VpcConfiguration vpcConfiguration);

        /**
         * <p>
         * Configuration details about the network where the Privatelink endpoint of the cluster resides.
         * </p>
         * This is a convenience method that creates an instance of the {@link VpcConfiguration.Builder} avoiding the
         * need to create one manually via {@link VpcConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #vpcConfiguration(VpcConfiguration)}.
         * 
         * @param vpcConfiguration
         *        a consumer that will call methods on {@link VpcConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfiguration(VpcConfiguration)
         */
        default Builder vpcConfiguration(Consumer<VpcConfiguration.Builder> vpcConfiguration) {
            return vpcConfiguration(VpcConfiguration.builder().applyMutation(vpcConfiguration).build());
        }

        /**
         * <p>
         * Specifies a Q program that will be run at launch of a cluster. It is a relative path within <i>.zip</i> file
         * that contains the custom code, which will be loaded on the cluster. It must include the file name itself. For
         * example, <code>somedir/init.q</code>.
         * </p>
         * 
         * @param initializationScript
         *        Specifies a Q program that will be run at launch of a cluster. It is a relative path within
         *        <i>.zip</i> file that contains the custom code, which will be loaded on the cluster. It must include
         *        the file name itself. For example, <code>somedir/init.q</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initializationScript(String initializationScript);

        /**
         * <p>
         * Defines key-value pairs to make them available inside the cluster.
         * </p>
         * 
         * @param commandLineArguments
         *        Defines key-value pairs to make them available inside the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commandLineArguments(Collection<KxCommandLineArgument> commandLineArguments);

        /**
         * <p>
         * Defines key-value pairs to make them available inside the cluster.
         * </p>
         * 
         * @param commandLineArguments
         *        Defines key-value pairs to make them available inside the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commandLineArguments(KxCommandLineArgument... commandLineArguments);

        /**
         * <p>
         * Defines key-value pairs to make them available inside the cluster.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.finspace.model.KxCommandLineArgument.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.finspace.model.KxCommandLineArgument#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.finspace.model.KxCommandLineArgument.Builder#build()} is called
         * immediately and its result is passed to {@link #commandLineArguments(List<KxCommandLineArgument>)}.
         * 
         * @param commandLineArguments
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.finspace.model.KxCommandLineArgument.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #commandLineArguments(java.util.Collection<KxCommandLineArgument>)
         */
        Builder commandLineArguments(Consumer<KxCommandLineArgument.Builder>... commandLineArguments);

        /**
         * <p>
         * The details of the custom code that you want to use inside a cluster when analyzing a data. It consists of
         * the S3 source bucket, location, S3 object version, and the relative path from where the custom code is loaded
         * into the cluster.
         * </p>
         * 
         * @param code
         *        The details of the custom code that you want to use inside a cluster when analyzing a data. It
         *        consists of the S3 source bucket, location, S3 object version, and the relative path from where the
         *        custom code is loaded into the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(CodeConfiguration code);

        /**
         * <p>
         * The details of the custom code that you want to use inside a cluster when analyzing a data. It consists of
         * the S3 source bucket, location, S3 object version, and the relative path from where the custom code is loaded
         * into the cluster.
         * </p>
         * This is a convenience method that creates an instance of the {@link CodeConfiguration.Builder} avoiding the
         * need to create one manually via {@link CodeConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CodeConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #code(CodeConfiguration)}.
         * 
         * @param code
         *        a consumer that will call methods on {@link CodeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #code(CodeConfiguration)
         */
        default Builder code(Consumer<CodeConfiguration.Builder> code) {
            return code(CodeConfiguration.builder().applyMutation(code).build());
        }

        /**
         * <p>
         * An IAM role that defines a set of permissions associated with a cluster. These permissions are assumed when a
         * cluster attempts to access another cluster.
         * </p>
         * 
         * @param executionRole
         *        An IAM role that defines a set of permissions associated with a cluster. These permissions are assumed
         *        when a cluster attempts to access another cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRole(String executionRole);

        /**
         * <p>
         * The last time that the cluster was modified. The value is determined as epoch time in milliseconds. For
         * example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
         * </p>
         * 
         * @param lastModifiedTimestamp
         *        The last time that the cluster was modified. The value is determined as epoch time in milliseconds.
         *        For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTimestamp(Instant lastModifiedTimestamp);

        /**
         * <p>
         * The size and type of the temporary storage that is used to hold data during the savedown process. This
         * parameter is required when you choose <code>clusterType</code> as RDB. All the data written to this storage
         * space is lost when the cluster node is restarted.
         * </p>
         * 
         * @param savedownStorageConfiguration
         *        The size and type of the temporary storage that is used to hold data during the savedown process. This
         *        parameter is required when you choose <code>clusterType</code> as RDB. All the data written to this
         *        storage space is lost when the cluster node is restarted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savedownStorageConfiguration(KxSavedownStorageConfiguration savedownStorageConfiguration);

        /**
         * <p>
         * The size and type of the temporary storage that is used to hold data during the savedown process. This
         * parameter is required when you choose <code>clusterType</code> as RDB. All the data written to this storage
         * space is lost when the cluster node is restarted.
         * </p>
         * This is a convenience method that creates an instance of the {@link KxSavedownStorageConfiguration.Builder}
         * avoiding the need to create one manually via {@link KxSavedownStorageConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KxSavedownStorageConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #savedownStorageConfiguration(KxSavedownStorageConfiguration)}.
         * 
         * @param savedownStorageConfiguration
         *        a consumer that will call methods on {@link KxSavedownStorageConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #savedownStorageConfiguration(KxSavedownStorageConfiguration)
         */
        default Builder savedownStorageConfiguration(Consumer<KxSavedownStorageConfiguration.Builder> savedownStorageConfiguration) {
            return savedownStorageConfiguration(KxSavedownStorageConfiguration.builder()
                    .applyMutation(savedownStorageConfiguration).build());
        }

        /**
         * <p>
         * The number of availability zones you want to assign per cluster. This can be one of the following
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SINGLE</code> – Assigns one availability zone per cluster.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MULTI</code> – Assigns all the availability zones per cluster.
         * </p>
         * </li>
         * </ul>
         * 
         * @param azMode
         *        The number of availability zones you want to assign per cluster. This can be one of the following </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SINGLE</code> – Assigns one availability zone per cluster.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MULTI</code> – Assigns all the availability zones per cluster.
         *        </p>
         *        </li>
         * @see KxAzMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KxAzMode
         */
        Builder azMode(String azMode);

        /**
         * <p>
         * The number of availability zones you want to assign per cluster. This can be one of the following
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SINGLE</code> – Assigns one availability zone per cluster.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MULTI</code> – Assigns all the availability zones per cluster.
         * </p>
         * </li>
         * </ul>
         * 
         * @param azMode
         *        The number of availability zones you want to assign per cluster. This can be one of the following </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SINGLE</code> – Assigns one availability zone per cluster.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MULTI</code> – Assigns all the availability zones per cluster.
         *        </p>
         *        </li>
         * @see KxAzMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KxAzMode
         */
        Builder azMode(KxAzMode azMode);

        /**
         * <p>
         * The availability zone identifiers for the requested regions.
         * </p>
         * 
         * @param availabilityZoneId
         *        The availability zone identifiers for the requested regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZoneId(String availabilityZoneId);

        /**
         * <p>
         * The timestamp at which the cluster was created in FinSpace. The value is determined as epoch time in
         * milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as
         * 1635768000000.
         * </p>
         * 
         * @param createdTimestamp
         *        The timestamp at which the cluster was created in FinSpace. The value is determined as epoch time in
         *        milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as
         *        1635768000000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);

        /**
         * Sets the value of the ScalingGroupConfiguration property for this object.
         *
         * @param scalingGroupConfiguration
         *        The new value for the ScalingGroupConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingGroupConfiguration(KxScalingGroupConfiguration scalingGroupConfiguration);

        /**
         * Sets the value of the ScalingGroupConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link KxScalingGroupConfiguration.Builder}
         * avoiding the need to create one manually via {@link KxScalingGroupConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KxScalingGroupConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #scalingGroupConfiguration(KxScalingGroupConfiguration)}.
         * 
         * @param scalingGroupConfiguration
         *        a consumer that will call methods on {@link KxScalingGroupConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scalingGroupConfiguration(KxScalingGroupConfiguration)
         */
        default Builder scalingGroupConfiguration(Consumer<KxScalingGroupConfiguration.Builder> scalingGroupConfiguration) {
            return scalingGroupConfiguration(KxScalingGroupConfiguration.builder().applyMutation(scalingGroupConfiguration)
                    .build());
        }
    }

    static final class BuilderImpl extends FinspaceResponse.BuilderImpl implements Builder {
        private String status;

        private String statusReason;

        private String clusterName;

        private String clusterType;

        private TickerplantLogConfiguration tickerplantLogConfiguration;

        private List<Volume> volumes = DefaultSdkAutoConstructList.getInstance();

        private List<KxDatabaseConfiguration> databases = DefaultSdkAutoConstructList.getInstance();

        private List<KxCacheStorageConfiguration> cacheStorageConfigurations = DefaultSdkAutoConstructList.getInstance();

        private AutoScalingConfiguration autoScalingConfiguration;

        private String clusterDescription;

        private CapacityConfiguration capacityConfiguration;

        private String releaseLabel;

        private VpcConfiguration vpcConfiguration;

        private String initializationScript;

        private List<KxCommandLineArgument> commandLineArguments = DefaultSdkAutoConstructList.getInstance();

        private CodeConfiguration code;

        private String executionRole;

        private Instant lastModifiedTimestamp;

        private KxSavedownStorageConfiguration savedownStorageConfiguration;

        private String azMode;

        private String availabilityZoneId;

        private Instant createdTimestamp;

        private KxScalingGroupConfiguration scalingGroupConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetKxClusterResponse model) {
            super(model);
            status(model.status);
            statusReason(model.statusReason);
            clusterName(model.clusterName);
            clusterType(model.clusterType);
            tickerplantLogConfiguration(model.tickerplantLogConfiguration);
            volumes(model.volumes);
            databases(model.databases);
            cacheStorageConfigurations(model.cacheStorageConfigurations);
            autoScalingConfiguration(model.autoScalingConfiguration);
            clusterDescription(model.clusterDescription);
            capacityConfiguration(model.capacityConfiguration);
            releaseLabel(model.releaseLabel);
            vpcConfiguration(model.vpcConfiguration);
            initializationScript(model.initializationScript);
            commandLineArguments(model.commandLineArguments);
            code(model.code);
            executionRole(model.executionRole);
            lastModifiedTimestamp(model.lastModifiedTimestamp);
            savedownStorageConfiguration(model.savedownStorageConfiguration);
            azMode(model.azMode);
            availabilityZoneId(model.availabilityZoneId);
            createdTimestamp(model.createdTimestamp);
            scalingGroupConfiguration(model.scalingGroupConfiguration);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(KxClusterStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final String getClusterName() {
            return clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getClusterType() {
            return clusterType;
        }

        public final void setClusterType(String clusterType) {
            this.clusterType = clusterType;
        }

        @Override
        public final Builder clusterType(String clusterType) {
            this.clusterType = clusterType;
            return this;
        }

        @Override
        public final Builder clusterType(KxClusterType clusterType) {
            this.clusterType(clusterType == null ? null : clusterType.toString());
            return this;
        }

        public final TickerplantLogConfiguration.Builder getTickerplantLogConfiguration() {
            return tickerplantLogConfiguration != null ? tickerplantLogConfiguration.toBuilder() : null;
        }

        public final void setTickerplantLogConfiguration(TickerplantLogConfiguration.BuilderImpl tickerplantLogConfiguration) {
            this.tickerplantLogConfiguration = tickerplantLogConfiguration != null ? tickerplantLogConfiguration.build() : null;
        }

        @Override
        public final Builder tickerplantLogConfiguration(TickerplantLogConfiguration tickerplantLogConfiguration) {
            this.tickerplantLogConfiguration = tickerplantLogConfiguration;
            return this;
        }

        public final List<Volume.Builder> getVolumes() {
            List<Volume.Builder> result = VolumesCopier.copyToBuilder(this.volumes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVolumes(Collection<Volume.BuilderImpl> volumes) {
            this.volumes = VolumesCopier.copyFromBuilder(volumes);
        }

        @Override
        public final Builder volumes(Collection<Volume> volumes) {
            this.volumes = VolumesCopier.copy(volumes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumes(Volume... volumes) {
            volumes(Arrays.asList(volumes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumes(Consumer<Volume.Builder>... volumes) {
            volumes(Stream.of(volumes).map(c -> Volume.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<KxDatabaseConfiguration.Builder> getDatabases() {
            List<KxDatabaseConfiguration.Builder> result = KxDatabaseConfigurationsCopier.copyToBuilder(this.databases);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDatabases(Collection<KxDatabaseConfiguration.BuilderImpl> databases) {
            this.databases = KxDatabaseConfigurationsCopier.copyFromBuilder(databases);
        }

        @Override
        public final Builder databases(Collection<KxDatabaseConfiguration> databases) {
            this.databases = KxDatabaseConfigurationsCopier.copy(databases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder databases(KxDatabaseConfiguration... databases) {
            databases(Arrays.asList(databases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder databases(Consumer<KxDatabaseConfiguration.Builder>... databases) {
            databases(Stream.of(databases).map(c -> KxDatabaseConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<KxCacheStorageConfiguration.Builder> getCacheStorageConfigurations() {
            List<KxCacheStorageConfiguration.Builder> result = KxCacheStorageConfigurationsCopier
                    .copyToBuilder(this.cacheStorageConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCacheStorageConfigurations(
                Collection<KxCacheStorageConfiguration.BuilderImpl> cacheStorageConfigurations) {
            this.cacheStorageConfigurations = KxCacheStorageConfigurationsCopier.copyFromBuilder(cacheStorageConfigurations);
        }

        @Override
        public final Builder cacheStorageConfigurations(Collection<KxCacheStorageConfiguration> cacheStorageConfigurations) {
            this.cacheStorageConfigurations = KxCacheStorageConfigurationsCopier.copy(cacheStorageConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheStorageConfigurations(KxCacheStorageConfiguration... cacheStorageConfigurations) {
            cacheStorageConfigurations(Arrays.asList(cacheStorageConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheStorageConfigurations(
                Consumer<KxCacheStorageConfiguration.Builder>... cacheStorageConfigurations) {
            cacheStorageConfigurations(Stream.of(cacheStorageConfigurations)
                    .map(c -> KxCacheStorageConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final AutoScalingConfiguration.Builder getAutoScalingConfiguration() {
            return autoScalingConfiguration != null ? autoScalingConfiguration.toBuilder() : null;
        }

        public final void setAutoScalingConfiguration(AutoScalingConfiguration.BuilderImpl autoScalingConfiguration) {
            this.autoScalingConfiguration = autoScalingConfiguration != null ? autoScalingConfiguration.build() : null;
        }

        @Override
        public final Builder autoScalingConfiguration(AutoScalingConfiguration autoScalingConfiguration) {
            this.autoScalingConfiguration = autoScalingConfiguration;
            return this;
        }

        public final String getClusterDescription() {
            return clusterDescription;
        }

        public final void setClusterDescription(String clusterDescription) {
            this.clusterDescription = clusterDescription;
        }

        @Override
        public final Builder clusterDescription(String clusterDescription) {
            this.clusterDescription = clusterDescription;
            return this;
        }

        public final CapacityConfiguration.Builder getCapacityConfiguration() {
            return capacityConfiguration != null ? capacityConfiguration.toBuilder() : null;
        }

        public final void setCapacityConfiguration(CapacityConfiguration.BuilderImpl capacityConfiguration) {
            this.capacityConfiguration = capacityConfiguration != null ? capacityConfiguration.build() : null;
        }

        @Override
        public final Builder capacityConfiguration(CapacityConfiguration capacityConfiguration) {
            this.capacityConfiguration = capacityConfiguration;
            return this;
        }

        public final String getReleaseLabel() {
            return releaseLabel;
        }

        public final void setReleaseLabel(String releaseLabel) {
            this.releaseLabel = releaseLabel;
        }

        @Override
        public final Builder releaseLabel(String releaseLabel) {
            this.releaseLabel = releaseLabel;
            return this;
        }

        public final VpcConfiguration.Builder getVpcConfiguration() {
            return vpcConfiguration != null ? vpcConfiguration.toBuilder() : null;
        }

        public final void setVpcConfiguration(VpcConfiguration.BuilderImpl vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration != null ? vpcConfiguration.build() : null;
        }

        @Override
        public final Builder vpcConfiguration(VpcConfiguration vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration;
            return this;
        }

        public final String getInitializationScript() {
            return initializationScript;
        }

        public final void setInitializationScript(String initializationScript) {
            this.initializationScript = initializationScript;
        }

        @Override
        public final Builder initializationScript(String initializationScript) {
            this.initializationScript = initializationScript;
            return this;
        }

        public final List<KxCommandLineArgument.Builder> getCommandLineArguments() {
            List<KxCommandLineArgument.Builder> result = KxCommandLineArgumentsCopier.copyToBuilder(this.commandLineArguments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCommandLineArguments(Collection<KxCommandLineArgument.BuilderImpl> commandLineArguments) {
            this.commandLineArguments = KxCommandLineArgumentsCopier.copyFromBuilder(commandLineArguments);
        }

        @Override
        public final Builder commandLineArguments(Collection<KxCommandLineArgument> commandLineArguments) {
            this.commandLineArguments = KxCommandLineArgumentsCopier.copy(commandLineArguments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commandLineArguments(KxCommandLineArgument... commandLineArguments) {
            commandLineArguments(Arrays.asList(commandLineArguments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commandLineArguments(Consumer<KxCommandLineArgument.Builder>... commandLineArguments) {
            commandLineArguments(Stream.of(commandLineArguments)
                    .map(c -> KxCommandLineArgument.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final CodeConfiguration.Builder getCode() {
            return code != null ? code.toBuilder() : null;
        }

        public final void setCode(CodeConfiguration.BuilderImpl code) {
            this.code = code != null ? code.build() : null;
        }

        @Override
        public final Builder code(CodeConfiguration code) {
            this.code = code;
            return this;
        }

        public final String getExecutionRole() {
            return executionRole;
        }

        public final void setExecutionRole(String executionRole) {
            this.executionRole = executionRole;
        }

        @Override
        public final Builder executionRole(String executionRole) {
            this.executionRole = executionRole;
            return this;
        }

        public final Instant getLastModifiedTimestamp() {
            return lastModifiedTimestamp;
        }

        public final void setLastModifiedTimestamp(Instant lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
        }

        @Override
        public final Builder lastModifiedTimestamp(Instant lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
            return this;
        }

        public final KxSavedownStorageConfiguration.Builder getSavedownStorageConfiguration() {
            return savedownStorageConfiguration != null ? savedownStorageConfiguration.toBuilder() : null;
        }

        public final void setSavedownStorageConfiguration(KxSavedownStorageConfiguration.BuilderImpl savedownStorageConfiguration) {
            this.savedownStorageConfiguration = savedownStorageConfiguration != null ? savedownStorageConfiguration.build()
                    : null;
        }

        @Override
        public final Builder savedownStorageConfiguration(KxSavedownStorageConfiguration savedownStorageConfiguration) {
            this.savedownStorageConfiguration = savedownStorageConfiguration;
            return this;
        }

        public final String getAzMode() {
            return azMode;
        }

        public final void setAzMode(String azMode) {
            this.azMode = azMode;
        }

        @Override
        public final Builder azMode(String azMode) {
            this.azMode = azMode;
            return this;
        }

        @Override
        public final Builder azMode(KxAzMode azMode) {
            this.azMode(azMode == null ? null : azMode.toString());
            return this;
        }

        public final String getAvailabilityZoneId() {
            return availabilityZoneId;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final KxScalingGroupConfiguration.Builder getScalingGroupConfiguration() {
            return scalingGroupConfiguration != null ? scalingGroupConfiguration.toBuilder() : null;
        }

        public final void setScalingGroupConfiguration(KxScalingGroupConfiguration.BuilderImpl scalingGroupConfiguration) {
            this.scalingGroupConfiguration = scalingGroupConfiguration != null ? scalingGroupConfiguration.build() : null;
        }

        @Override
        public final Builder scalingGroupConfiguration(KxScalingGroupConfiguration scalingGroupConfiguration) {
            this.scalingGroupConfiguration = scalingGroupConfiguration;
            return this;
        }

        @Override
        public GetKxClusterResponse build() {
            return new GetKxClusterResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
