/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspace.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetKxScalingGroupResponse extends FinspaceResponse implements
        ToCopyableBuilder<GetKxScalingGroupResponse.Builder, GetKxScalingGroupResponse> {
    private static final SdkField<String> SCALING_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scalingGroupName").getter(getter(GetKxScalingGroupResponse::scalingGroupName))
            .setter(setter(Builder::scalingGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scalingGroupName").build()).build();

    private static final SdkField<String> SCALING_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scalingGroupArn").getter(getter(GetKxScalingGroupResponse::scalingGroupArn))
            .setter(setter(Builder::scalingGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scalingGroupArn").build()).build();

    private static final SdkField<String> HOST_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("hostType").getter(getter(GetKxScalingGroupResponse::hostType)).setter(setter(Builder::hostType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostType").build()).build();

    private static final SdkField<List<String>> CLUSTERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("clusters")
            .getter(getter(GetKxScalingGroupResponse::clusters))
            .setter(setter(Builder::clusters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("availabilityZoneId").getter(getter(GetKxScalingGroupResponse::availabilityZoneId))
            .setter(setter(Builder::availabilityZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZoneId").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetKxScalingGroupResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusReason").getter(getter(GetKxScalingGroupResponse::statusReason))
            .setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModifiedTimestamp").getter(getter(GetKxScalingGroupResponse::lastModifiedTimestamp))
            .setter(setter(Builder::lastModifiedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTimestamp").build())
            .build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdTimestamp").getter(getter(GetKxScalingGroupResponse::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTimestamp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCALING_GROUP_NAME_FIELD,
            SCALING_GROUP_ARN_FIELD, HOST_TYPE_FIELD, CLUSTERS_FIELD, AVAILABILITY_ZONE_ID_FIELD, STATUS_FIELD,
            STATUS_REASON_FIELD, LAST_MODIFIED_TIMESTAMP_FIELD, CREATED_TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String scalingGroupName;

    private final String scalingGroupArn;

    private final String hostType;

    private final List<String> clusters;

    private final String availabilityZoneId;

    private final String status;

    private final String statusReason;

    private final Instant lastModifiedTimestamp;

    private final Instant createdTimestamp;

    private GetKxScalingGroupResponse(BuilderImpl builder) {
        super(builder);
        this.scalingGroupName = builder.scalingGroupName;
        this.scalingGroupArn = builder.scalingGroupArn;
        this.hostType = builder.hostType;
        this.clusters = builder.clusters;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.lastModifiedTimestamp = builder.lastModifiedTimestamp;
        this.createdTimestamp = builder.createdTimestamp;
    }

    /**
     * <p>
     * A unique identifier for the kdb scaling group.
     * </p>
     * 
     * @return A unique identifier for the kdb scaling group.
     */
    public final String scalingGroupName() {
        return scalingGroupName;
    }

    /**
     * <p>
     * The ARN identifier for the scaling group.
     * </p>
     * 
     * @return The ARN identifier for the scaling group.
     */
    public final String scalingGroupArn() {
        return scalingGroupArn;
    }

    /**
     * <p>
     * The memory and CPU capabilities of the scaling group host on which FinSpace Managed kdb clusters will be placed.
     * </p>
     * <p>
     * It can have one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>kx.sg.large</code> – The host type with a configuration of 16 GiB memory and 2 vCPUs.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>kx.sg.xlarge</code> – The host type with a configuration of 32 GiB memory and 4 vCPUs.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>kx.sg.2xlarge</code> – The host type with a configuration of 64 GiB memory and 8 vCPUs.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>kx.sg.4xlarge</code> – The host type with a configuration of 108 GiB memory and 16 vCPUs.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>kx.sg.8xlarge</code> – The host type with a configuration of 216 GiB memory and 32 vCPUs.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>kx.sg.16xlarge</code> – The host type with a configuration of 432 GiB memory and 64 vCPUs.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>kx.sg.32xlarge</code> – The host type with a configuration of 864 GiB memory and 128 vCPUs.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>kx.sg1.16xlarge</code> – The host type with a configuration of 1949 GiB memory and 64 vCPUs.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>kx.sg1.24xlarge</code> – The host type with a configuration of 2948 GiB memory and 96 vCPUs.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The memory and CPU capabilities of the scaling group host on which FinSpace Managed kdb clusters will be
     *         placed.</p>
     *         <p>
     *         It can have one of the following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>kx.sg.large</code> – The host type with a configuration of 16 GiB memory and 2 vCPUs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>kx.sg.xlarge</code> – The host type with a configuration of 32 GiB memory and 4 vCPUs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>kx.sg.2xlarge</code> – The host type with a configuration of 64 GiB memory and 8 vCPUs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>kx.sg.4xlarge</code> – The host type with a configuration of 108 GiB memory and 16 vCPUs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>kx.sg.8xlarge</code> – The host type with a configuration of 216 GiB memory and 32 vCPUs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>kx.sg.16xlarge</code> – The host type with a configuration of 432 GiB memory and 64 vCPUs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>kx.sg.32xlarge</code> – The host type with a configuration of 864 GiB memory and 128 vCPUs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>kx.sg1.16xlarge</code> – The host type with a configuration of 1949 GiB memory and 64 vCPUs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>kx.sg1.24xlarge</code> – The host type with a configuration of 2948 GiB memory and 96 vCPUs.
     *         </p>
     *         </li>
     */
    public final String hostType() {
        return hostType;
    }

    /**
     * For responses, this returns true if the service returned a value for the Clusters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasClusters() {
        return clusters != null && !(clusters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of Managed kdb clusters that are currently active in the given scaling group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasClusters} method.
     * </p>
     * 
     * @return The list of Managed kdb clusters that are currently active in the given scaling group.
     */
    public final List<String> clusters() {
        return clusters;
    }

    /**
     * <p>
     * The identifier of the availability zones.
     * </p>
     * 
     * @return The identifier of the availability zones.
     */
    public final String availabilityZoneId() {
        return availabilityZoneId;
    }

    /**
     * <p>
     * The status of scaling group.
     * </p>
     * <ul>
     * <li>
     * <p>
     * CREATING – The scaling group creation is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * CREATE_FAILED – The scaling group creation has failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * ACTIVE – The scaling group is active.
     * </p>
     * </li>
     * <li>
     * <p>
     * UPDATING – The scaling group is in the process of being updated.
     * </p>
     * </li>
     * <li>
     * <p>
     * UPDATE_FAILED – The update action failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETING – The scaling group is in the process of being deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETE_FAILED – The system failed to delete the scaling group.
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETED – The scaling group is successfully deleted.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link KxScalingGroupStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of scaling group.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         CREATING – The scaling group creation is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CREATE_FAILED – The scaling group creation has failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACTIVE – The scaling group is active.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UPDATING – The scaling group is in the process of being updated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UPDATE_FAILED – The update action failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETING – The scaling group is in the process of being deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETE_FAILED – The system failed to delete the scaling group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETED – The scaling group is successfully deleted.
     *         </p>
     *         </li>
     * @see KxScalingGroupStatus
     */
    public final KxScalingGroupStatus status() {
        return KxScalingGroupStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of scaling group.
     * </p>
     * <ul>
     * <li>
     * <p>
     * CREATING – The scaling group creation is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * CREATE_FAILED – The scaling group creation has failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * ACTIVE – The scaling group is active.
     * </p>
     * </li>
     * <li>
     * <p>
     * UPDATING – The scaling group is in the process of being updated.
     * </p>
     * </li>
     * <li>
     * <p>
     * UPDATE_FAILED – The update action failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETING – The scaling group is in the process of being deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETE_FAILED – The system failed to delete the scaling group.
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETED – The scaling group is successfully deleted.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link KxScalingGroupStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of scaling group.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         CREATING – The scaling group creation is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CREATE_FAILED – The scaling group creation has failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACTIVE – The scaling group is active.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UPDATING – The scaling group is in the process of being updated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UPDATE_FAILED – The update action failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETING – The scaling group is in the process of being deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETE_FAILED – The system failed to delete the scaling group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETED – The scaling group is successfully deleted.
     *         </p>
     *         </li>
     * @see KxScalingGroupStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The error message when a failed state occurs.
     * </p>
     * 
     * @return The error message when a failed state occurs.
     */
    public final String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * The last time that the scaling group was updated in FinSpace. The value is determined as epoch time in
     * milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
     * </p>
     * 
     * @return The last time that the scaling group was updated in FinSpace. The value is determined as epoch time in
     *         milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as
     *         1635768000000.
     */
    public final Instant lastModifiedTimestamp() {
        return lastModifiedTimestamp;
    }

    /**
     * <p>
     * The timestamp at which the scaling group was created in FinSpace. The value is determined as epoch time in
     * milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
     * </p>
     * 
     * @return The timestamp at which the scaling group was created in FinSpace. The value is determined as epoch time
     *         in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as
     *         1635768000000.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(scalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(scalingGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(hostType());
        hashCode = 31 * hashCode + Objects.hashCode(hasClusters() ? clusters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetKxScalingGroupResponse)) {
            return false;
        }
        GetKxScalingGroupResponse other = (GetKxScalingGroupResponse) obj;
        return Objects.equals(scalingGroupName(), other.scalingGroupName())
                && Objects.equals(scalingGroupArn(), other.scalingGroupArn()) && Objects.equals(hostType(), other.hostType())
                && hasClusters() == other.hasClusters() && Objects.equals(clusters(), other.clusters())
                && Objects.equals(availabilityZoneId(), other.availabilityZoneId())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReason(), other.statusReason())
                && Objects.equals(lastModifiedTimestamp(), other.lastModifiedTimestamp())
                && Objects.equals(createdTimestamp(), other.createdTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetKxScalingGroupResponse").add("ScalingGroupName", scalingGroupName())
                .add("ScalingGroupArn", scalingGroupArn()).add("HostType", hostType())
                .add("Clusters", hasClusters() ? clusters() : null).add("AvailabilityZoneId", availabilityZoneId())
                .add("Status", statusAsString()).add("StatusReason", statusReason())
                .add("LastModifiedTimestamp", lastModifiedTimestamp()).add("CreatedTimestamp", createdTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "scalingGroupName":
            return Optional.ofNullable(clazz.cast(scalingGroupName()));
        case "scalingGroupArn":
            return Optional.ofNullable(clazz.cast(scalingGroupArn()));
        case "hostType":
            return Optional.ofNullable(clazz.cast(hostType()));
        case "clusters":
            return Optional.ofNullable(clazz.cast(clusters()));
        case "availabilityZoneId":
            return Optional.ofNullable(clazz.cast(availabilityZoneId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "lastModifiedTimestamp":
            return Optional.ofNullable(clazz.cast(lastModifiedTimestamp()));
        case "createdTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("scalingGroupName", SCALING_GROUP_NAME_FIELD);
        map.put("scalingGroupArn", SCALING_GROUP_ARN_FIELD);
        map.put("hostType", HOST_TYPE_FIELD);
        map.put("clusters", CLUSTERS_FIELD);
        map.put("availabilityZoneId", AVAILABILITY_ZONE_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        map.put("lastModifiedTimestamp", LAST_MODIFIED_TIMESTAMP_FIELD);
        map.put("createdTimestamp", CREATED_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetKxScalingGroupResponse, T> g) {
        return obj -> g.apply((GetKxScalingGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FinspaceResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetKxScalingGroupResponse> {
        /**
         * <p>
         * A unique identifier for the kdb scaling group.
         * </p>
         * 
         * @param scalingGroupName
         *        A unique identifier for the kdb scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingGroupName(String scalingGroupName);

        /**
         * <p>
         * The ARN identifier for the scaling group.
         * </p>
         * 
         * @param scalingGroupArn
         *        The ARN identifier for the scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingGroupArn(String scalingGroupArn);

        /**
         * <p>
         * The memory and CPU capabilities of the scaling group host on which FinSpace Managed kdb clusters will be
         * placed.
         * </p>
         * <p>
         * It can have one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>kx.sg.large</code> – The host type with a configuration of 16 GiB memory and 2 vCPUs.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>kx.sg.xlarge</code> – The host type with a configuration of 32 GiB memory and 4 vCPUs.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>kx.sg.2xlarge</code> – The host type with a configuration of 64 GiB memory and 8 vCPUs.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>kx.sg.4xlarge</code> – The host type with a configuration of 108 GiB memory and 16 vCPUs.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>kx.sg.8xlarge</code> – The host type with a configuration of 216 GiB memory and 32 vCPUs.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>kx.sg.16xlarge</code> – The host type with a configuration of 432 GiB memory and 64 vCPUs.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>kx.sg.32xlarge</code> – The host type with a configuration of 864 GiB memory and 128 vCPUs.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>kx.sg1.16xlarge</code> – The host type with a configuration of 1949 GiB memory and 64 vCPUs.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>kx.sg1.24xlarge</code> – The host type with a configuration of 2948 GiB memory and 96 vCPUs.
         * </p>
         * </li>
         * </ul>
         * 
         * @param hostType
         *        The memory and CPU capabilities of the scaling group host on which FinSpace Managed kdb clusters will
         *        be placed.</p>
         *        <p>
         *        It can have one of the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>kx.sg.large</code> – The host type with a configuration of 16 GiB memory and 2 vCPUs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>kx.sg.xlarge</code> – The host type with a configuration of 32 GiB memory and 4 vCPUs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>kx.sg.2xlarge</code> – The host type with a configuration of 64 GiB memory and 8 vCPUs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>kx.sg.4xlarge</code> – The host type with a configuration of 108 GiB memory and 16 vCPUs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>kx.sg.8xlarge</code> – The host type with a configuration of 216 GiB memory and 32 vCPUs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>kx.sg.16xlarge</code> – The host type with a configuration of 432 GiB memory and 64 vCPUs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>kx.sg.32xlarge</code> – The host type with a configuration of 864 GiB memory and 128 vCPUs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>kx.sg1.16xlarge</code> – The host type with a configuration of 1949 GiB memory and 64 vCPUs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>kx.sg1.24xlarge</code> – The host type with a configuration of 2948 GiB memory and 96 vCPUs.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostType(String hostType);

        /**
         * <p>
         * The list of Managed kdb clusters that are currently active in the given scaling group.
         * </p>
         * 
         * @param clusters
         *        The list of Managed kdb clusters that are currently active in the given scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusters(Collection<String> clusters);

        /**
         * <p>
         * The list of Managed kdb clusters that are currently active in the given scaling group.
         * </p>
         * 
         * @param clusters
         *        The list of Managed kdb clusters that are currently active in the given scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusters(String... clusters);

        /**
         * <p>
         * The identifier of the availability zones.
         * </p>
         * 
         * @param availabilityZoneId
         *        The identifier of the availability zones.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZoneId(String availabilityZoneId);

        /**
         * <p>
         * The status of scaling group.
         * </p>
         * <ul>
         * <li>
         * <p>
         * CREATING – The scaling group creation is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * CREATE_FAILED – The scaling group creation has failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * ACTIVE – The scaling group is active.
         * </p>
         * </li>
         * <li>
         * <p>
         * UPDATING – The scaling group is in the process of being updated.
         * </p>
         * </li>
         * <li>
         * <p>
         * UPDATE_FAILED – The update action failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETING – The scaling group is in the process of being deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETE_FAILED – The system failed to delete the scaling group.
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETED – The scaling group is successfully deleted.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of scaling group.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        CREATING – The scaling group creation is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CREATE_FAILED – The scaling group creation has failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ACTIVE – The scaling group is active.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UPDATING – The scaling group is in the process of being updated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UPDATE_FAILED – The update action failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETING – The scaling group is in the process of being deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETE_FAILED – The system failed to delete the scaling group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETED – The scaling group is successfully deleted.
         *        </p>
         *        </li>
         * @see KxScalingGroupStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KxScalingGroupStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of scaling group.
         * </p>
         * <ul>
         * <li>
         * <p>
         * CREATING – The scaling group creation is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * CREATE_FAILED – The scaling group creation has failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * ACTIVE – The scaling group is active.
         * </p>
         * </li>
         * <li>
         * <p>
         * UPDATING – The scaling group is in the process of being updated.
         * </p>
         * </li>
         * <li>
         * <p>
         * UPDATE_FAILED – The update action failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETING – The scaling group is in the process of being deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETE_FAILED – The system failed to delete the scaling group.
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETED – The scaling group is successfully deleted.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of scaling group.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        CREATING – The scaling group creation is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CREATE_FAILED – The scaling group creation has failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ACTIVE – The scaling group is active.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UPDATING – The scaling group is in the process of being updated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UPDATE_FAILED – The update action failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETING – The scaling group is in the process of being deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETE_FAILED – The system failed to delete the scaling group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETED – The scaling group is successfully deleted.
         *        </p>
         *        </li>
         * @see KxScalingGroupStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KxScalingGroupStatus
         */
        Builder status(KxScalingGroupStatus status);

        /**
         * <p>
         * The error message when a failed state occurs.
         * </p>
         * 
         * @param statusReason
         *        The error message when a failed state occurs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * The last time that the scaling group was updated in FinSpace. The value is determined as epoch time in
         * milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as
         * 1635768000000.
         * </p>
         * 
         * @param lastModifiedTimestamp
         *        The last time that the scaling group was updated in FinSpace. The value is determined as epoch time in
         *        milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as
         *        1635768000000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTimestamp(Instant lastModifiedTimestamp);

        /**
         * <p>
         * The timestamp at which the scaling group was created in FinSpace. The value is determined as epoch time in
         * milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as
         * 1635768000000.
         * </p>
         * 
         * @param createdTimestamp
         *        The timestamp at which the scaling group was created in FinSpace. The value is determined as epoch
         *        time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified
         *        as 1635768000000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);
    }

    static final class BuilderImpl extends FinspaceResponse.BuilderImpl implements Builder {
        private String scalingGroupName;

        private String scalingGroupArn;

        private String hostType;

        private List<String> clusters = DefaultSdkAutoConstructList.getInstance();

        private String availabilityZoneId;

        private String status;

        private String statusReason;

        private Instant lastModifiedTimestamp;

        private Instant createdTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(GetKxScalingGroupResponse model) {
            super(model);
            scalingGroupName(model.scalingGroupName);
            scalingGroupArn(model.scalingGroupArn);
            hostType(model.hostType);
            clusters(model.clusters);
            availabilityZoneId(model.availabilityZoneId);
            status(model.status);
            statusReason(model.statusReason);
            lastModifiedTimestamp(model.lastModifiedTimestamp);
            createdTimestamp(model.createdTimestamp);
        }

        public final String getScalingGroupName() {
            return scalingGroupName;
        }

        public final void setScalingGroupName(String scalingGroupName) {
            this.scalingGroupName = scalingGroupName;
        }

        @Override
        public final Builder scalingGroupName(String scalingGroupName) {
            this.scalingGroupName = scalingGroupName;
            return this;
        }

        public final String getScalingGroupArn() {
            return scalingGroupArn;
        }

        public final void setScalingGroupArn(String scalingGroupArn) {
            this.scalingGroupArn = scalingGroupArn;
        }

        @Override
        public final Builder scalingGroupArn(String scalingGroupArn) {
            this.scalingGroupArn = scalingGroupArn;
            return this;
        }

        public final String getHostType() {
            return hostType;
        }

        public final void setHostType(String hostType) {
            this.hostType = hostType;
        }

        @Override
        public final Builder hostType(String hostType) {
            this.hostType = hostType;
            return this;
        }

        public final Collection<String> getClusters() {
            if (clusters instanceof SdkAutoConstructList) {
                return null;
            }
            return clusters;
        }

        public final void setClusters(Collection<String> clusters) {
            this.clusters = KxClusterNameListCopier.copy(clusters);
        }

        @Override
        public final Builder clusters(Collection<String> clusters) {
            this.clusters = KxClusterNameListCopier.copy(clusters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusters(String... clusters) {
            clusters(Arrays.asList(clusters));
            return this;
        }

        public final String getAvailabilityZoneId() {
            return availabilityZoneId;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(KxScalingGroupStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final Instant getLastModifiedTimestamp() {
            return lastModifiedTimestamp;
        }

        public final void setLastModifiedTimestamp(Instant lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
        }

        @Override
        public final Builder lastModifiedTimestamp(Instant lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        @Override
        public GetKxScalingGroupResponse build() {
            return new GetKxScalingGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
