/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspace.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The structure that stores the capacity configuration details of a scaling group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KxScalingGroupConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<KxScalingGroupConfiguration.Builder, KxScalingGroupConfiguration> {
    private static final SdkField<String> SCALING_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scalingGroupName").getter(getter(KxScalingGroupConfiguration::scalingGroupName))
            .setter(setter(Builder::scalingGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scalingGroupName").build()).build();

    private static final SdkField<Integer> MEMORY_LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("memoryLimit").getter(getter(KxScalingGroupConfiguration::memoryLimit))
            .setter(setter(Builder::memoryLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memoryLimit").build()).build();

    private static final SdkField<Integer> MEMORY_RESERVATION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("memoryReservation").getter(getter(KxScalingGroupConfiguration::memoryReservation))
            .setter(setter(Builder::memoryReservation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memoryReservation").build()).build();

    private static final SdkField<Integer> NODE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("nodeCount").getter(getter(KxScalingGroupConfiguration::nodeCount)).setter(setter(Builder::nodeCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeCount").build()).build();

    private static final SdkField<Double> CPU_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("cpu")
            .getter(getter(KxScalingGroupConfiguration::cpu)).setter(setter(Builder::cpu))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpu").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCALING_GROUP_NAME_FIELD,
            MEMORY_LIMIT_FIELD, MEMORY_RESERVATION_FIELD, NODE_COUNT_FIELD, CPU_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String scalingGroupName;

    private final Integer memoryLimit;

    private final Integer memoryReservation;

    private final Integer nodeCount;

    private final Double cpu;

    private KxScalingGroupConfiguration(BuilderImpl builder) {
        this.scalingGroupName = builder.scalingGroupName;
        this.memoryLimit = builder.memoryLimit;
        this.memoryReservation = builder.memoryReservation;
        this.nodeCount = builder.nodeCount;
        this.cpu = builder.cpu;
    }

    /**
     * <p>
     * A unique identifier for the kdb scaling group.
     * </p>
     * 
     * @return A unique identifier for the kdb scaling group.
     */
    public final String scalingGroupName() {
        return scalingGroupName;
    }

    /**
     * <p>
     * An optional hard limit on the amount of memory a kdb cluster can use.
     * </p>
     * 
     * @return An optional hard limit on the amount of memory a kdb cluster can use.
     */
    public final Integer memoryLimit() {
        return memoryLimit;
    }

    /**
     * <p>
     * A reservation of the minimum amount of memory that should be available on the scaling group for a kdb cluster to
     * be successfully placed in a scaling group.
     * </p>
     * 
     * @return A reservation of the minimum amount of memory that should be available on the scaling group for a kdb
     *         cluster to be successfully placed in a scaling group.
     */
    public final Integer memoryReservation() {
        return memoryReservation;
    }

    /**
     * <p>
     * The number of kdb cluster nodes.
     * </p>
     * 
     * @return The number of kdb cluster nodes.
     */
    public final Integer nodeCount() {
        return nodeCount;
    }

    /**
     * <p>
     * The number of vCPUs that you want to reserve for each node of this kdb cluster on the scaling group host.
     * </p>
     * 
     * @return The number of vCPUs that you want to reserve for each node of this kdb cluster on the scaling group host.
     */
    public final Double cpu() {
        return cpu;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(memoryLimit());
        hashCode = 31 * hashCode + Objects.hashCode(memoryReservation());
        hashCode = 31 * hashCode + Objects.hashCode(nodeCount());
        hashCode = 31 * hashCode + Objects.hashCode(cpu());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KxScalingGroupConfiguration)) {
            return false;
        }
        KxScalingGroupConfiguration other = (KxScalingGroupConfiguration) obj;
        return Objects.equals(scalingGroupName(), other.scalingGroupName()) && Objects.equals(memoryLimit(), other.memoryLimit())
                && Objects.equals(memoryReservation(), other.memoryReservation())
                && Objects.equals(nodeCount(), other.nodeCount()) && Objects.equals(cpu(), other.cpu());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KxScalingGroupConfiguration").add("ScalingGroupName", scalingGroupName())
                .add("MemoryLimit", memoryLimit()).add("MemoryReservation", memoryReservation()).add("NodeCount", nodeCount())
                .add("Cpu", cpu()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "scalingGroupName":
            return Optional.ofNullable(clazz.cast(scalingGroupName()));
        case "memoryLimit":
            return Optional.ofNullable(clazz.cast(memoryLimit()));
        case "memoryReservation":
            return Optional.ofNullable(clazz.cast(memoryReservation()));
        case "nodeCount":
            return Optional.ofNullable(clazz.cast(nodeCount()));
        case "cpu":
            return Optional.ofNullable(clazz.cast(cpu()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("scalingGroupName", SCALING_GROUP_NAME_FIELD);
        map.put("memoryLimit", MEMORY_LIMIT_FIELD);
        map.put("memoryReservation", MEMORY_RESERVATION_FIELD);
        map.put("nodeCount", NODE_COUNT_FIELD);
        map.put("cpu", CPU_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KxScalingGroupConfiguration, T> g) {
        return obj -> g.apply((KxScalingGroupConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KxScalingGroupConfiguration> {
        /**
         * <p>
         * A unique identifier for the kdb scaling group.
         * </p>
         * 
         * @param scalingGroupName
         *        A unique identifier for the kdb scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingGroupName(String scalingGroupName);

        /**
         * <p>
         * An optional hard limit on the amount of memory a kdb cluster can use.
         * </p>
         * 
         * @param memoryLimit
         *        An optional hard limit on the amount of memory a kdb cluster can use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memoryLimit(Integer memoryLimit);

        /**
         * <p>
         * A reservation of the minimum amount of memory that should be available on the scaling group for a kdb cluster
         * to be successfully placed in a scaling group.
         * </p>
         * 
         * @param memoryReservation
         *        A reservation of the minimum amount of memory that should be available on the scaling group for a kdb
         *        cluster to be successfully placed in a scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memoryReservation(Integer memoryReservation);

        /**
         * <p>
         * The number of kdb cluster nodes.
         * </p>
         * 
         * @param nodeCount
         *        The number of kdb cluster nodes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeCount(Integer nodeCount);

        /**
         * <p>
         * The number of vCPUs that you want to reserve for each node of this kdb cluster on the scaling group host.
         * </p>
         * 
         * @param cpu
         *        The number of vCPUs that you want to reserve for each node of this kdb cluster on the scaling group
         *        host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpu(Double cpu);
    }

    static final class BuilderImpl implements Builder {
        private String scalingGroupName;

        private Integer memoryLimit;

        private Integer memoryReservation;

        private Integer nodeCount;

        private Double cpu;

        private BuilderImpl() {
        }

        private BuilderImpl(KxScalingGroupConfiguration model) {
            scalingGroupName(model.scalingGroupName);
            memoryLimit(model.memoryLimit);
            memoryReservation(model.memoryReservation);
            nodeCount(model.nodeCount);
            cpu(model.cpu);
        }

        public final String getScalingGroupName() {
            return scalingGroupName;
        }

        public final void setScalingGroupName(String scalingGroupName) {
            this.scalingGroupName = scalingGroupName;
        }

        @Override
        public final Builder scalingGroupName(String scalingGroupName) {
            this.scalingGroupName = scalingGroupName;
            return this;
        }

        public final Integer getMemoryLimit() {
            return memoryLimit;
        }

        public final void setMemoryLimit(Integer memoryLimit) {
            this.memoryLimit = memoryLimit;
        }

        @Override
        public final Builder memoryLimit(Integer memoryLimit) {
            this.memoryLimit = memoryLimit;
            return this;
        }

        public final Integer getMemoryReservation() {
            return memoryReservation;
        }

        public final void setMemoryReservation(Integer memoryReservation) {
            this.memoryReservation = memoryReservation;
        }

        @Override
        public final Builder memoryReservation(Integer memoryReservation) {
            this.memoryReservation = memoryReservation;
            return this;
        }

        public final Integer getNodeCount() {
            return nodeCount;
        }

        public final void setNodeCount(Integer nodeCount) {
            this.nodeCount = nodeCount;
        }

        @Override
        public final Builder nodeCount(Integer nodeCount) {
            this.nodeCount = nodeCount;
            return this;
        }

        public final Double getCpu() {
            return cpu;
        }

        public final void setCpu(Double cpu) {
            this.cpu = cpu;
        }

        @Override
        public final Builder cpu(Double cpu) {
            this.cpu = cpu;
            return this;
        }

        @Override
        public KxScalingGroupConfiguration build() {
            return new KxScalingGroupConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
