/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspace.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListKxDataviewsResponse extends FinspaceResponse implements
        ToCopyableBuilder<ListKxDataviewsResponse.Builder, ListKxDataviewsResponse> {
    private static final SdkField<List<KxDataviewListEntry>> KX_DATAVIEWS_FIELD = SdkField
            .<List<KxDataviewListEntry>> builder(MarshallingType.LIST)
            .memberName("kxDataviews")
            .getter(getter(ListKxDataviewsResponse::kxDataviews))
            .setter(setter(Builder::kxDataviews))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kxDataviews").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<KxDataviewListEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(KxDataviewListEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListKxDataviewsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KX_DATAVIEWS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<KxDataviewListEntry> kxDataviews;

    private final String nextToken;

    private ListKxDataviewsResponse(BuilderImpl builder) {
        super(builder);
        this.kxDataviews = builder.kxDataviews;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the KxDataviews property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasKxDataviews() {
        return kxDataviews != null && !(kxDataviews instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of kdb dataviews that are currently active for the given database.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasKxDataviews} method.
     * </p>
     * 
     * @return The list of kdb dataviews that are currently active for the given database.
     */
    public final List<KxDataviewListEntry> kxDataviews() {
        return kxDataviews;
    }

    /**
     * <p>
     * A token that indicates where a results page should begin.
     * </p>
     * 
     * @return A token that indicates where a results page should begin.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasKxDataviews() ? kxDataviews() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListKxDataviewsResponse)) {
            return false;
        }
        ListKxDataviewsResponse other = (ListKxDataviewsResponse) obj;
        return hasKxDataviews() == other.hasKxDataviews() && Objects.equals(kxDataviews(), other.kxDataviews())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListKxDataviewsResponse").add("KxDataviews", hasKxDataviews() ? kxDataviews() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "kxDataviews":
            return Optional.ofNullable(clazz.cast(kxDataviews()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("kxDataviews", KX_DATAVIEWS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListKxDataviewsResponse, T> g) {
        return obj -> g.apply((ListKxDataviewsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FinspaceResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListKxDataviewsResponse> {
        /**
         * <p>
         * The list of kdb dataviews that are currently active for the given database.
         * </p>
         * 
         * @param kxDataviews
         *        The list of kdb dataviews that are currently active for the given database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kxDataviews(Collection<KxDataviewListEntry> kxDataviews);

        /**
         * <p>
         * The list of kdb dataviews that are currently active for the given database.
         * </p>
         * 
         * @param kxDataviews
         *        The list of kdb dataviews that are currently active for the given database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kxDataviews(KxDataviewListEntry... kxDataviews);

        /**
         * <p>
         * The list of kdb dataviews that are currently active for the given database.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.finspace.model.KxDataviewListEntry.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.finspace.model.KxDataviewListEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.finspace.model.KxDataviewListEntry.Builder#build()} is called
         * immediately and its result is passed to {@link #kxDataviews(List<KxDataviewListEntry>)}.
         * 
         * @param kxDataviews
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.finspace.model.KxDataviewListEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kxDataviews(java.util.Collection<KxDataviewListEntry>)
         */
        Builder kxDataviews(Consumer<KxDataviewListEntry.Builder>... kxDataviews);

        /**
         * <p>
         * A token that indicates where a results page should begin.
         * </p>
         * 
         * @param nextToken
         *        A token that indicates where a results page should begin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends FinspaceResponse.BuilderImpl implements Builder {
        private List<KxDataviewListEntry> kxDataviews = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListKxDataviewsResponse model) {
            super(model);
            kxDataviews(model.kxDataviews);
            nextToken(model.nextToken);
        }

        public final List<KxDataviewListEntry.Builder> getKxDataviews() {
            List<KxDataviewListEntry.Builder> result = KxDataviewsCopier.copyToBuilder(this.kxDataviews);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setKxDataviews(Collection<KxDataviewListEntry.BuilderImpl> kxDataviews) {
            this.kxDataviews = KxDataviewsCopier.copyFromBuilder(kxDataviews);
        }

        @Override
        public final Builder kxDataviews(Collection<KxDataviewListEntry> kxDataviews) {
            this.kxDataviews = KxDataviewsCopier.copy(kxDataviews);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder kxDataviews(KxDataviewListEntry... kxDataviews) {
            kxDataviews(Arrays.asList(kxDataviews));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder kxDataviews(Consumer<KxDataviewListEntry.Builder>... kxDataviews) {
            kxDataviews(Stream.of(kxDataviews).map(c -> KxDataviewListEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListKxDataviewsResponse build() {
            return new ListKxDataviewsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
