/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspace.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The network access control list (ACL) is an optional layer of security for your VPC that acts as a firewall for
 * controlling traffic in and out of one or more subnets. The entry is a set of numbered ingress and egress rules that
 * determine whether a packet should be allowed in or out of a subnet associated with the ACL. We process the entries in
 * the ACL according to the rule numbers, in ascending order.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkACLEntry implements SdkPojo, Serializable, ToCopyableBuilder<NetworkACLEntry.Builder, NetworkACLEntry> {
    private static final SdkField<Integer> RULE_NUMBER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ruleNumber").getter(getter(NetworkACLEntry::ruleNumber)).setter(setter(Builder::ruleNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleNumber").build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("protocol").getter(getter(NetworkACLEntry::protocol)).setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()).build();

    private static final SdkField<String> RULE_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ruleAction").getter(getter(NetworkACLEntry::ruleActionAsString)).setter(setter(Builder::ruleAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleAction").build()).build();

    private static final SdkField<PortRange> PORT_RANGE_FIELD = SdkField.<PortRange> builder(MarshallingType.SDK_POJO)
            .memberName("portRange").getter(getter(NetworkACLEntry::portRange)).setter(setter(Builder::portRange))
            .constructor(PortRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portRange").build()).build();

    private static final SdkField<IcmpTypeCode> ICMP_TYPE_CODE_FIELD = SdkField.<IcmpTypeCode> builder(MarshallingType.SDK_POJO)
            .memberName("icmpTypeCode").getter(getter(NetworkACLEntry::icmpTypeCode)).setter(setter(Builder::icmpTypeCode))
            .constructor(IcmpTypeCode::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("icmpTypeCode").build()).build();

    private static final SdkField<String> CIDR_BLOCK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("cidrBlock").getter(getter(NetworkACLEntry::cidrBlock)).setter(setter(Builder::cidrBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cidrBlock").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_NUMBER_FIELD,
            PROTOCOL_FIELD, RULE_ACTION_FIELD, PORT_RANGE_FIELD, ICMP_TYPE_CODE_FIELD, CIDR_BLOCK_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer ruleNumber;

    private final String protocol;

    private final String ruleAction;

    private final PortRange portRange;

    private final IcmpTypeCode icmpTypeCode;

    private final String cidrBlock;

    private NetworkACLEntry(BuilderImpl builder) {
        this.ruleNumber = builder.ruleNumber;
        this.protocol = builder.protocol;
        this.ruleAction = builder.ruleAction;
        this.portRange = builder.portRange;
        this.icmpTypeCode = builder.icmpTypeCode;
        this.cidrBlock = builder.cidrBlock;
    }

    /**
     * <p>
     * The rule number for the entry. For example <i>100</i>. All the network ACL entries are processed in ascending
     * order by rule number.
     * </p>
     * 
     * @return The rule number for the entry. For example <i>100</i>. All the network ACL entries are processed in
     *         ascending order by rule number.
     */
    public final Integer ruleNumber() {
        return ruleNumber;
    }

    /**
     * <p>
     * The protocol number. A value of <i>-1</i> means all the protocols.
     * </p>
     * 
     * @return The protocol number. A value of <i>-1</i> means all the protocols.
     */
    public final String protocol() {
        return protocol;
    }

    /**
     * <p>
     * Indicates whether to allow or deny the traffic that matches the rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ruleAction} will
     * return {@link RuleAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ruleActionAsString}.
     * </p>
     * 
     * @return Indicates whether to allow or deny the traffic that matches the rule.
     * @see RuleAction
     */
    public final RuleAction ruleAction() {
        return RuleAction.fromValue(ruleAction);
    }

    /**
     * <p>
     * Indicates whether to allow or deny the traffic that matches the rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ruleAction} will
     * return {@link RuleAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ruleActionAsString}.
     * </p>
     * 
     * @return Indicates whether to allow or deny the traffic that matches the rule.
     * @see RuleAction
     */
    public final String ruleActionAsString() {
        return ruleAction;
    }

    /**
     * <p>
     * The range of ports the rule applies to.
     * </p>
     * 
     * @return The range of ports the rule applies to.
     */
    public final PortRange portRange() {
        return portRange;
    }

    /**
     * <p>
     * Defines the ICMP protocol that consists of the ICMP type and code.
     * </p>
     * 
     * @return Defines the ICMP protocol that consists of the ICMP type and code.
     */
    public final IcmpTypeCode icmpTypeCode() {
        return icmpTypeCode;
    }

    /**
     * <p>
     * The IPv4 network range to allow or deny, in CIDR notation. For example, <code>172.16.0.0/24</code>. We modify the
     * specified CIDR block to its canonical form. For example, if you specify <code>100.68.0.18/18</code>, we modify it
     * to <code>100.68.0.0/18</code>.
     * </p>
     * 
     * @return The IPv4 network range to allow or deny, in CIDR notation. For example, <code>172.16.0.0/24</code>. We
     *         modify the specified CIDR block to its canonical form. For example, if you specify
     *         <code>100.68.0.18/18</code>, we modify it to <code>100.68.0.0/18</code>.
     */
    public final String cidrBlock() {
        return cidrBlock;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ruleNumber());
        hashCode = 31 * hashCode + Objects.hashCode(protocol());
        hashCode = 31 * hashCode + Objects.hashCode(ruleActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(portRange());
        hashCode = 31 * hashCode + Objects.hashCode(icmpTypeCode());
        hashCode = 31 * hashCode + Objects.hashCode(cidrBlock());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkACLEntry)) {
            return false;
        }
        NetworkACLEntry other = (NetworkACLEntry) obj;
        return Objects.equals(ruleNumber(), other.ruleNumber()) && Objects.equals(protocol(), other.protocol())
                && Objects.equals(ruleActionAsString(), other.ruleActionAsString())
                && Objects.equals(portRange(), other.portRange()) && Objects.equals(icmpTypeCode(), other.icmpTypeCode())
                && Objects.equals(cidrBlock(), other.cidrBlock());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NetworkACLEntry").add("RuleNumber", ruleNumber()).add("Protocol", protocol())
                .add("RuleAction", ruleActionAsString()).add("PortRange", portRange()).add("IcmpTypeCode", icmpTypeCode())
                .add("CidrBlock", cidrBlock()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ruleNumber":
            return Optional.ofNullable(clazz.cast(ruleNumber()));
        case "protocol":
            return Optional.ofNullable(clazz.cast(protocol()));
        case "ruleAction":
            return Optional.ofNullable(clazz.cast(ruleActionAsString()));
        case "portRange":
            return Optional.ofNullable(clazz.cast(portRange()));
        case "icmpTypeCode":
            return Optional.ofNullable(clazz.cast(icmpTypeCode()));
        case "cidrBlock":
            return Optional.ofNullable(clazz.cast(cidrBlock()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ruleNumber", RULE_NUMBER_FIELD);
        map.put("protocol", PROTOCOL_FIELD);
        map.put("ruleAction", RULE_ACTION_FIELD);
        map.put("portRange", PORT_RANGE_FIELD);
        map.put("icmpTypeCode", ICMP_TYPE_CODE_FIELD);
        map.put("cidrBlock", CIDR_BLOCK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NetworkACLEntry, T> g) {
        return obj -> g.apply((NetworkACLEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkACLEntry> {
        /**
         * <p>
         * The rule number for the entry. For example <i>100</i>. All the network ACL entries are processed in ascending
         * order by rule number.
         * </p>
         * 
         * @param ruleNumber
         *        The rule number for the entry. For example <i>100</i>. All the network ACL entries are processed in
         *        ascending order by rule number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleNumber(Integer ruleNumber);

        /**
         * <p>
         * The protocol number. A value of <i>-1</i> means all the protocols.
         * </p>
         * 
         * @param protocol
         *        The protocol number. A value of <i>-1</i> means all the protocols.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * Indicates whether to allow or deny the traffic that matches the rule.
         * </p>
         * 
         * @param ruleAction
         *        Indicates whether to allow or deny the traffic that matches the rule.
         * @see RuleAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleAction
         */
        Builder ruleAction(String ruleAction);

        /**
         * <p>
         * Indicates whether to allow or deny the traffic that matches the rule.
         * </p>
         * 
         * @param ruleAction
         *        Indicates whether to allow or deny the traffic that matches the rule.
         * @see RuleAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleAction
         */
        Builder ruleAction(RuleAction ruleAction);

        /**
         * <p>
         * The range of ports the rule applies to.
         * </p>
         * 
         * @param portRange
         *        The range of ports the rule applies to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portRange(PortRange portRange);

        /**
         * <p>
         * The range of ports the rule applies to.
         * </p>
         * This is a convenience method that creates an instance of the {@link PortRange.Builder} avoiding the need to
         * create one manually via {@link PortRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PortRange.Builder#build()} is called immediately and its result
         * is passed to {@link #portRange(PortRange)}.
         * 
         * @param portRange
         *        a consumer that will call methods on {@link PortRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #portRange(PortRange)
         */
        default Builder portRange(Consumer<PortRange.Builder> portRange) {
            return portRange(PortRange.builder().applyMutation(portRange).build());
        }

        /**
         * <p>
         * Defines the ICMP protocol that consists of the ICMP type and code.
         * </p>
         * 
         * @param icmpTypeCode
         *        Defines the ICMP protocol that consists of the ICMP type and code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder icmpTypeCode(IcmpTypeCode icmpTypeCode);

        /**
         * <p>
         * Defines the ICMP protocol that consists of the ICMP type and code.
         * </p>
         * This is a convenience method that creates an instance of the {@link IcmpTypeCode.Builder} avoiding the need
         * to create one manually via {@link IcmpTypeCode#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IcmpTypeCode.Builder#build()} is called immediately and its
         * result is passed to {@link #icmpTypeCode(IcmpTypeCode)}.
         * 
         * @param icmpTypeCode
         *        a consumer that will call methods on {@link IcmpTypeCode.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #icmpTypeCode(IcmpTypeCode)
         */
        default Builder icmpTypeCode(Consumer<IcmpTypeCode.Builder> icmpTypeCode) {
            return icmpTypeCode(IcmpTypeCode.builder().applyMutation(icmpTypeCode).build());
        }

        /**
         * <p>
         * The IPv4 network range to allow or deny, in CIDR notation. For example, <code>172.16.0.0/24</code>. We modify
         * the specified CIDR block to its canonical form. For example, if you specify <code>100.68.0.18/18</code>, we
         * modify it to <code>100.68.0.0/18</code>.
         * </p>
         * 
         * @param cidrBlock
         *        The IPv4 network range to allow or deny, in CIDR notation. For example, <code>172.16.0.0/24</code>. We
         *        modify the specified CIDR block to its canonical form. For example, if you specify
         *        <code>100.68.0.18/18</code>, we modify it to <code>100.68.0.0/18</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrBlock(String cidrBlock);
    }

    static final class BuilderImpl implements Builder {
        private Integer ruleNumber;

        private String protocol;

        private String ruleAction;

        private PortRange portRange;

        private IcmpTypeCode icmpTypeCode;

        private String cidrBlock;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkACLEntry model) {
            ruleNumber(model.ruleNumber);
            protocol(model.protocol);
            ruleAction(model.ruleAction);
            portRange(model.portRange);
            icmpTypeCode(model.icmpTypeCode);
            cidrBlock(model.cidrBlock);
        }

        public final Integer getRuleNumber() {
            return ruleNumber;
        }

        public final void setRuleNumber(Integer ruleNumber) {
            this.ruleNumber = ruleNumber;
        }

        @Override
        public final Builder ruleNumber(Integer ruleNumber) {
            this.ruleNumber = ruleNumber;
            return this;
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public final String getRuleAction() {
            return ruleAction;
        }

        public final void setRuleAction(String ruleAction) {
            this.ruleAction = ruleAction;
        }

        @Override
        public final Builder ruleAction(String ruleAction) {
            this.ruleAction = ruleAction;
            return this;
        }

        @Override
        public final Builder ruleAction(RuleAction ruleAction) {
            this.ruleAction(ruleAction == null ? null : ruleAction.toString());
            return this;
        }

        public final PortRange.Builder getPortRange() {
            return portRange != null ? portRange.toBuilder() : null;
        }

        public final void setPortRange(PortRange.BuilderImpl portRange) {
            this.portRange = portRange != null ? portRange.build() : null;
        }

        @Override
        public final Builder portRange(PortRange portRange) {
            this.portRange = portRange;
            return this;
        }

        public final IcmpTypeCode.Builder getIcmpTypeCode() {
            return icmpTypeCode != null ? icmpTypeCode.toBuilder() : null;
        }

        public final void setIcmpTypeCode(IcmpTypeCode.BuilderImpl icmpTypeCode) {
            this.icmpTypeCode = icmpTypeCode != null ? icmpTypeCode.build() : null;
        }

        @Override
        public final Builder icmpTypeCode(IcmpTypeCode icmpTypeCode) {
            this.icmpTypeCode = icmpTypeCode;
            return this;
        }

        public final String getCidrBlock() {
            return cidrBlock;
        }

        public final void setCidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
        }

        @Override
        public final Builder cidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
            return this;
        }

        @Override
        public NetworkACLEntry build() {
            return new NetworkACLEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
