/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspace.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateKxEnvironmentNetworkRequest extends FinspaceRequest implements
        ToCopyableBuilder<UpdateKxEnvironmentNetworkRequest.Builder, UpdateKxEnvironmentNetworkRequest> {
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentId").getter(getter(UpdateKxEnvironmentNetworkRequest::environmentId))
            .setter(setter(Builder::environmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("environmentId").build()).build();

    private static final SdkField<TransitGatewayConfiguration> TRANSIT_GATEWAY_CONFIGURATION_FIELD = SdkField
            .<TransitGatewayConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("transitGatewayConfiguration")
            .getter(getter(UpdateKxEnvironmentNetworkRequest::transitGatewayConfiguration))
            .setter(setter(Builder::transitGatewayConfiguration))
            .constructor(TransitGatewayConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transitGatewayConfiguration")
                    .build()).build();

    private static final SdkField<List<CustomDNSServer>> CUSTOM_DNS_CONFIGURATION_FIELD = SdkField
            .<List<CustomDNSServer>> builder(MarshallingType.LIST)
            .memberName("customDNSConfiguration")
            .getter(getter(UpdateKxEnvironmentNetworkRequest::customDNSConfiguration))
            .setter(setter(Builder::customDNSConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customDNSConfiguration").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CustomDNSServer> builder(MarshallingType.SDK_POJO)
                                            .constructor(CustomDNSServer::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdateKxEnvironmentNetworkRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENT_ID_FIELD,
            TRANSIT_GATEWAY_CONFIGURATION_FIELD, CUSTOM_DNS_CONFIGURATION_FIELD, CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String environmentId;

    private final TransitGatewayConfiguration transitGatewayConfiguration;

    private final List<CustomDNSServer> customDNSConfiguration;

    private final String clientToken;

    private UpdateKxEnvironmentNetworkRequest(BuilderImpl builder) {
        super(builder);
        this.environmentId = builder.environmentId;
        this.transitGatewayConfiguration = builder.transitGatewayConfiguration;
        this.customDNSConfiguration = builder.customDNSConfiguration;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * A unique identifier for the kdb environment.
     * </p>
     * 
     * @return A unique identifier for the kdb environment.
     */
    public final String environmentId() {
        return environmentId;
    }

    /**
     * <p>
     * Specifies the transit gateway and network configuration to connect the kdb environment to an internal network.
     * </p>
     * 
     * @return Specifies the transit gateway and network configuration to connect the kdb environment to an internal
     *         network.
     */
    public final TransitGatewayConfiguration transitGatewayConfiguration() {
        return transitGatewayConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the CustomDNSConfiguration property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCustomDNSConfiguration() {
        return customDNSConfiguration != null && !(customDNSConfiguration instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of DNS server name and server IP. This is used to set up Route-53 outbound resolvers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCustomDNSConfiguration} method.
     * </p>
     * 
     * @return A list of DNS server name and server IP. This is used to set up Route-53 outbound resolvers.
     */
    public final List<CustomDNSServer> customDNSConfiguration() {
        return customDNSConfiguration;
    }

    /**
     * <p>
     * A token that ensures idempotency. This token expires in 10 minutes.
     * </p>
     * 
     * @return A token that ensures idempotency. This token expires in 10 minutes.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomDNSConfiguration() ? customDNSConfiguration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateKxEnvironmentNetworkRequest)) {
            return false;
        }
        UpdateKxEnvironmentNetworkRequest other = (UpdateKxEnvironmentNetworkRequest) obj;
        return Objects.equals(environmentId(), other.environmentId())
                && Objects.equals(transitGatewayConfiguration(), other.transitGatewayConfiguration())
                && hasCustomDNSConfiguration() == other.hasCustomDNSConfiguration()
                && Objects.equals(customDNSConfiguration(), other.customDNSConfiguration())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateKxEnvironmentNetworkRequest").add("EnvironmentId", environmentId())
                .add("TransitGatewayConfiguration", transitGatewayConfiguration())
                .add("CustomDNSConfiguration", hasCustomDNSConfiguration() ? customDNSConfiguration() : null)
                .add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "environmentId":
            return Optional.ofNullable(clazz.cast(environmentId()));
        case "transitGatewayConfiguration":
            return Optional.ofNullable(clazz.cast(transitGatewayConfiguration()));
        case "customDNSConfiguration":
            return Optional.ofNullable(clazz.cast(customDNSConfiguration()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("environmentId", ENVIRONMENT_ID_FIELD);
        map.put("transitGatewayConfiguration", TRANSIT_GATEWAY_CONFIGURATION_FIELD);
        map.put("customDNSConfiguration", CUSTOM_DNS_CONFIGURATION_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateKxEnvironmentNetworkRequest, T> g) {
        return obj -> g.apply((UpdateKxEnvironmentNetworkRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FinspaceRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateKxEnvironmentNetworkRequest> {
        /**
         * <p>
         * A unique identifier for the kdb environment.
         * </p>
         * 
         * @param environmentId
         *        A unique identifier for the kdb environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentId(String environmentId);

        /**
         * <p>
         * Specifies the transit gateway and network configuration to connect the kdb environment to an internal
         * network.
         * </p>
         * 
         * @param transitGatewayConfiguration
         *        Specifies the transit gateway and network configuration to connect the kdb environment to an internal
         *        network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayConfiguration(TransitGatewayConfiguration transitGatewayConfiguration);

        /**
         * <p>
         * Specifies the transit gateway and network configuration to connect the kdb environment to an internal
         * network.
         * </p>
         * This is a convenience method that creates an instance of the {@link TransitGatewayConfiguration.Builder}
         * avoiding the need to create one manually via {@link TransitGatewayConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TransitGatewayConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #transitGatewayConfiguration(TransitGatewayConfiguration)}.
         * 
         * @param transitGatewayConfiguration
         *        a consumer that will call methods on {@link TransitGatewayConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transitGatewayConfiguration(TransitGatewayConfiguration)
         */
        default Builder transitGatewayConfiguration(Consumer<TransitGatewayConfiguration.Builder> transitGatewayConfiguration) {
            return transitGatewayConfiguration(TransitGatewayConfiguration.builder().applyMutation(transitGatewayConfiguration)
                    .build());
        }

        /**
         * <p>
         * A list of DNS server name and server IP. This is used to set up Route-53 outbound resolvers.
         * </p>
         * 
         * @param customDNSConfiguration
         *        A list of DNS server name and server IP. This is used to set up Route-53 outbound resolvers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customDNSConfiguration(Collection<CustomDNSServer> customDNSConfiguration);

        /**
         * <p>
         * A list of DNS server name and server IP. This is used to set up Route-53 outbound resolvers.
         * </p>
         * 
         * @param customDNSConfiguration
         *        A list of DNS server name and server IP. This is used to set up Route-53 outbound resolvers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customDNSConfiguration(CustomDNSServer... customDNSConfiguration);

        /**
         * <p>
         * A list of DNS server name and server IP. This is used to set up Route-53 outbound resolvers.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.finspace.model.CustomDNSServer.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.finspace.model.CustomDNSServer#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.finspace.model.CustomDNSServer.Builder#build()} is called immediately
         * and its result is passed to {@link #customDNSConfiguration(List<CustomDNSServer>)}.
         * 
         * @param customDNSConfiguration
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.finspace.model.CustomDNSServer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customDNSConfiguration(java.util.Collection<CustomDNSServer>)
         */
        Builder customDNSConfiguration(Consumer<CustomDNSServer.Builder>... customDNSConfiguration);

        /**
         * <p>
         * A token that ensures idempotency. This token expires in 10 minutes.
         * </p>
         * 
         * @param clientToken
         *        A token that ensures idempotency. This token expires in 10 minutes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FinspaceRequest.BuilderImpl implements Builder {
        private String environmentId;

        private TransitGatewayConfiguration transitGatewayConfiguration;

        private List<CustomDNSServer> customDNSConfiguration = DefaultSdkAutoConstructList.getInstance();

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateKxEnvironmentNetworkRequest model) {
            super(model);
            environmentId(model.environmentId);
            transitGatewayConfiguration(model.transitGatewayConfiguration);
            customDNSConfiguration(model.customDNSConfiguration);
            clientToken(model.clientToken);
        }

        public final String getEnvironmentId() {
            return environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final TransitGatewayConfiguration.Builder getTransitGatewayConfiguration() {
            return transitGatewayConfiguration != null ? transitGatewayConfiguration.toBuilder() : null;
        }

        public final void setTransitGatewayConfiguration(TransitGatewayConfiguration.BuilderImpl transitGatewayConfiguration) {
            this.transitGatewayConfiguration = transitGatewayConfiguration != null ? transitGatewayConfiguration.build() : null;
        }

        @Override
        public final Builder transitGatewayConfiguration(TransitGatewayConfiguration transitGatewayConfiguration) {
            this.transitGatewayConfiguration = transitGatewayConfiguration;
            return this;
        }

        public final List<CustomDNSServer.Builder> getCustomDNSConfiguration() {
            List<CustomDNSServer.Builder> result = CustomDNSConfigurationCopier.copyToBuilder(this.customDNSConfiguration);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomDNSConfiguration(Collection<CustomDNSServer.BuilderImpl> customDNSConfiguration) {
            this.customDNSConfiguration = CustomDNSConfigurationCopier.copyFromBuilder(customDNSConfiguration);
        }

        @Override
        public final Builder customDNSConfiguration(Collection<CustomDNSServer> customDNSConfiguration) {
            this.customDNSConfiguration = CustomDNSConfigurationCopier.copy(customDNSConfiguration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customDNSConfiguration(CustomDNSServer... customDNSConfiguration) {
            customDNSConfiguration(Arrays.asList(customDNSConfiguration));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customDNSConfiguration(Consumer<CustomDNSServer.Builder>... customDNSConfiguration) {
            customDNSConfiguration(Stream.of(customDNSConfiguration).map(c -> CustomDNSServer.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateKxEnvironmentNetworkRequest build() {
            return new UpdateKxEnvironmentNetworkRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
