/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspace.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration based on which FinSpace will scale in or scale out nodes in your cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoScalingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AutoScalingConfiguration.Builder, AutoScalingConfiguration> {
    private static final SdkField<Integer> MIN_NODE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("minNodeCount").getter(getter(AutoScalingConfiguration::minNodeCount))
            .setter(setter(Builder::minNodeCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minNodeCount").build()).build();

    private static final SdkField<Integer> MAX_NODE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxNodeCount").getter(getter(AutoScalingConfiguration::maxNodeCount))
            .setter(setter(Builder::maxNodeCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxNodeCount").build()).build();

    private static final SdkField<String> AUTO_SCALING_METRIC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("autoScalingMetric").getter(getter(AutoScalingConfiguration::autoScalingMetricAsString))
            .setter(setter(Builder::autoScalingMetric))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoScalingMetric").build()).build();

    private static final SdkField<Double> METRIC_TARGET_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("metricTarget").getter(getter(AutoScalingConfiguration::metricTarget))
            .setter(setter(Builder::metricTarget))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricTarget").build()).build();

    private static final SdkField<Double> SCALE_IN_COOLDOWN_SECONDS_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("scaleInCooldownSeconds").getter(getter(AutoScalingConfiguration::scaleInCooldownSeconds))
            .setter(setter(Builder::scaleInCooldownSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scaleInCooldownSeconds").build())
            .build();

    private static final SdkField<Double> SCALE_OUT_COOLDOWN_SECONDS_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("scaleOutCooldownSeconds").getter(getter(AutoScalingConfiguration::scaleOutCooldownSeconds))
            .setter(setter(Builder::scaleOutCooldownSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scaleOutCooldownSeconds").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIN_NODE_COUNT_FIELD,
            MAX_NODE_COUNT_FIELD, AUTO_SCALING_METRIC_FIELD, METRIC_TARGET_FIELD, SCALE_IN_COOLDOWN_SECONDS_FIELD,
            SCALE_OUT_COOLDOWN_SECONDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer minNodeCount;

    private final Integer maxNodeCount;

    private final String autoScalingMetric;

    private final Double metricTarget;

    private final Double scaleInCooldownSeconds;

    private final Double scaleOutCooldownSeconds;

    private AutoScalingConfiguration(BuilderImpl builder) {
        this.minNodeCount = builder.minNodeCount;
        this.maxNodeCount = builder.maxNodeCount;
        this.autoScalingMetric = builder.autoScalingMetric;
        this.metricTarget = builder.metricTarget;
        this.scaleInCooldownSeconds = builder.scaleInCooldownSeconds;
        this.scaleOutCooldownSeconds = builder.scaleOutCooldownSeconds;
    }

    /**
     * <p>
     * The lowest number of nodes to scale. This value must be at least 1 and less than the <code>maxNodeCount</code>.
     * If the nodes in a cluster belong to multiple availability zones, then <code>minNodeCount</code> must be at least
     * 3.
     * </p>
     * 
     * @return The lowest number of nodes to scale. This value must be at least 1 and less than the
     *         <code>maxNodeCount</code>. If the nodes in a cluster belong to multiple availability zones, then
     *         <code>minNodeCount</code> must be at least 3.
     */
    public final Integer minNodeCount() {
        return minNodeCount;
    }

    /**
     * <p>
     * The highest number of nodes to scale. This value cannot be greater than 5.
     * </p>
     * 
     * @return The highest number of nodes to scale. This value cannot be greater than 5.
     */
    public final Integer maxNodeCount() {
        return maxNodeCount;
    }

    /**
     * <p>
     * The metric your cluster will track in order to scale in and out. For example,
     * <code>CPU_UTILIZATION_PERCENTAGE</code> is the average CPU usage across all the nodes in a cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autoScalingMetric}
     * will return {@link AutoScalingMetric#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #autoScalingMetricAsString}.
     * </p>
     * 
     * @return The metric your cluster will track in order to scale in and out. For example,
     *         <code>CPU_UTILIZATION_PERCENTAGE</code> is the average CPU usage across all the nodes in a cluster.
     * @see AutoScalingMetric
     */
    public final AutoScalingMetric autoScalingMetric() {
        return AutoScalingMetric.fromValue(autoScalingMetric);
    }

    /**
     * <p>
     * The metric your cluster will track in order to scale in and out. For example,
     * <code>CPU_UTILIZATION_PERCENTAGE</code> is the average CPU usage across all the nodes in a cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autoScalingMetric}
     * will return {@link AutoScalingMetric#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #autoScalingMetricAsString}.
     * </p>
     * 
     * @return The metric your cluster will track in order to scale in and out. For example,
     *         <code>CPU_UTILIZATION_PERCENTAGE</code> is the average CPU usage across all the nodes in a cluster.
     * @see AutoScalingMetric
     */
    public final String autoScalingMetricAsString() {
        return autoScalingMetric;
    }

    /**
     * <p>
     * The desired value of the chosen <code>autoScalingMetric</code>. When the metric drops below this value, the
     * cluster will scale in. When the metric goes above this value, the cluster will scale out. You can set the target
     * value between 1 and 100 percent.
     * </p>
     * 
     * @return The desired value of the chosen <code>autoScalingMetric</code>. When the metric drops below this value,
     *         the cluster will scale in. When the metric goes above this value, the cluster will scale out. You can set
     *         the target value between 1 and 100 percent.
     */
    public final Double metricTarget() {
        return metricTarget;
    }

    /**
     * <p>
     * The duration in seconds that FinSpace will wait after a scale in event before initiating another scaling event.
     * </p>
     * 
     * @return The duration in seconds that FinSpace will wait after a scale in event before initiating another scaling
     *         event.
     */
    public final Double scaleInCooldownSeconds() {
        return scaleInCooldownSeconds;
    }

    /**
     * <p>
     * The duration in seconds that FinSpace will wait after a scale out event before initiating another scaling event.
     * </p>
     * 
     * @return The duration in seconds that FinSpace will wait after a scale out event before initiating another scaling
     *         event.
     */
    public final Double scaleOutCooldownSeconds() {
        return scaleOutCooldownSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(minNodeCount());
        hashCode = 31 * hashCode + Objects.hashCode(maxNodeCount());
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingMetricAsString());
        hashCode = 31 * hashCode + Objects.hashCode(metricTarget());
        hashCode = 31 * hashCode + Objects.hashCode(scaleInCooldownSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(scaleOutCooldownSeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScalingConfiguration)) {
            return false;
        }
        AutoScalingConfiguration other = (AutoScalingConfiguration) obj;
        return Objects.equals(minNodeCount(), other.minNodeCount()) && Objects.equals(maxNodeCount(), other.maxNodeCount())
                && Objects.equals(autoScalingMetricAsString(), other.autoScalingMetricAsString())
                && Objects.equals(metricTarget(), other.metricTarget())
                && Objects.equals(scaleInCooldownSeconds(), other.scaleInCooldownSeconds())
                && Objects.equals(scaleOutCooldownSeconds(), other.scaleOutCooldownSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutoScalingConfiguration").add("MinNodeCount", minNodeCount())
                .add("MaxNodeCount", maxNodeCount()).add("AutoScalingMetric", autoScalingMetricAsString())
                .add("MetricTarget", metricTarget()).add("ScaleInCooldownSeconds", scaleInCooldownSeconds())
                .add("ScaleOutCooldownSeconds", scaleOutCooldownSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "minNodeCount":
            return Optional.ofNullable(clazz.cast(minNodeCount()));
        case "maxNodeCount":
            return Optional.ofNullable(clazz.cast(maxNodeCount()));
        case "autoScalingMetric":
            return Optional.ofNullable(clazz.cast(autoScalingMetricAsString()));
        case "metricTarget":
            return Optional.ofNullable(clazz.cast(metricTarget()));
        case "scaleInCooldownSeconds":
            return Optional.ofNullable(clazz.cast(scaleInCooldownSeconds()));
        case "scaleOutCooldownSeconds":
            return Optional.ofNullable(clazz.cast(scaleOutCooldownSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("minNodeCount", MIN_NODE_COUNT_FIELD);
        map.put("maxNodeCount", MAX_NODE_COUNT_FIELD);
        map.put("autoScalingMetric", AUTO_SCALING_METRIC_FIELD);
        map.put("metricTarget", METRIC_TARGET_FIELD);
        map.put("scaleInCooldownSeconds", SCALE_IN_COOLDOWN_SECONDS_FIELD);
        map.put("scaleOutCooldownSeconds", SCALE_OUT_COOLDOWN_SECONDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutoScalingConfiguration, T> g) {
        return obj -> g.apply((AutoScalingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutoScalingConfiguration> {
        /**
         * <p>
         * The lowest number of nodes to scale. This value must be at least 1 and less than the
         * <code>maxNodeCount</code>. If the nodes in a cluster belong to multiple availability zones, then
         * <code>minNodeCount</code> must be at least 3.
         * </p>
         * 
         * @param minNodeCount
         *        The lowest number of nodes to scale. This value must be at least 1 and less than the
         *        <code>maxNodeCount</code>. If the nodes in a cluster belong to multiple availability zones, then
         *        <code>minNodeCount</code> must be at least 3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minNodeCount(Integer minNodeCount);

        /**
         * <p>
         * The highest number of nodes to scale. This value cannot be greater than 5.
         * </p>
         * 
         * @param maxNodeCount
         *        The highest number of nodes to scale. This value cannot be greater than 5.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxNodeCount(Integer maxNodeCount);

        /**
         * <p>
         * The metric your cluster will track in order to scale in and out. For example,
         * <code>CPU_UTILIZATION_PERCENTAGE</code> is the average CPU usage across all the nodes in a cluster.
         * </p>
         * 
         * @param autoScalingMetric
         *        The metric your cluster will track in order to scale in and out. For example,
         *        <code>CPU_UTILIZATION_PERCENTAGE</code> is the average CPU usage across all the nodes in a cluster.
         * @see AutoScalingMetric
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoScalingMetric
         */
        Builder autoScalingMetric(String autoScalingMetric);

        /**
         * <p>
         * The metric your cluster will track in order to scale in and out. For example,
         * <code>CPU_UTILIZATION_PERCENTAGE</code> is the average CPU usage across all the nodes in a cluster.
         * </p>
         * 
         * @param autoScalingMetric
         *        The metric your cluster will track in order to scale in and out. For example,
         *        <code>CPU_UTILIZATION_PERCENTAGE</code> is the average CPU usage across all the nodes in a cluster.
         * @see AutoScalingMetric
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoScalingMetric
         */
        Builder autoScalingMetric(AutoScalingMetric autoScalingMetric);

        /**
         * <p>
         * The desired value of the chosen <code>autoScalingMetric</code>. When the metric drops below this value, the
         * cluster will scale in. When the metric goes above this value, the cluster will scale out. You can set the
         * target value between 1 and 100 percent.
         * </p>
         * 
         * @param metricTarget
         *        The desired value of the chosen <code>autoScalingMetric</code>. When the metric drops below this
         *        value, the cluster will scale in. When the metric goes above this value, the cluster will scale out.
         *        You can set the target value between 1 and 100 percent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricTarget(Double metricTarget);

        /**
         * <p>
         * The duration in seconds that FinSpace will wait after a scale in event before initiating another scaling
         * event.
         * </p>
         * 
         * @param scaleInCooldownSeconds
         *        The duration in seconds that FinSpace will wait after a scale in event before initiating another
         *        scaling event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scaleInCooldownSeconds(Double scaleInCooldownSeconds);

        /**
         * <p>
         * The duration in seconds that FinSpace will wait after a scale out event before initiating another scaling
         * event.
         * </p>
         * 
         * @param scaleOutCooldownSeconds
         *        The duration in seconds that FinSpace will wait after a scale out event before initiating another
         *        scaling event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scaleOutCooldownSeconds(Double scaleOutCooldownSeconds);
    }

    static final class BuilderImpl implements Builder {
        private Integer minNodeCount;

        private Integer maxNodeCount;

        private String autoScalingMetric;

        private Double metricTarget;

        private Double scaleInCooldownSeconds;

        private Double scaleOutCooldownSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoScalingConfiguration model) {
            minNodeCount(model.minNodeCount);
            maxNodeCount(model.maxNodeCount);
            autoScalingMetric(model.autoScalingMetric);
            metricTarget(model.metricTarget);
            scaleInCooldownSeconds(model.scaleInCooldownSeconds);
            scaleOutCooldownSeconds(model.scaleOutCooldownSeconds);
        }

        public final Integer getMinNodeCount() {
            return minNodeCount;
        }

        public final void setMinNodeCount(Integer minNodeCount) {
            this.minNodeCount = minNodeCount;
        }

        @Override
        public final Builder minNodeCount(Integer minNodeCount) {
            this.minNodeCount = minNodeCount;
            return this;
        }

        public final Integer getMaxNodeCount() {
            return maxNodeCount;
        }

        public final void setMaxNodeCount(Integer maxNodeCount) {
            this.maxNodeCount = maxNodeCount;
        }

        @Override
        public final Builder maxNodeCount(Integer maxNodeCount) {
            this.maxNodeCount = maxNodeCount;
            return this;
        }

        public final String getAutoScalingMetric() {
            return autoScalingMetric;
        }

        public final void setAutoScalingMetric(String autoScalingMetric) {
            this.autoScalingMetric = autoScalingMetric;
        }

        @Override
        public final Builder autoScalingMetric(String autoScalingMetric) {
            this.autoScalingMetric = autoScalingMetric;
            return this;
        }

        @Override
        public final Builder autoScalingMetric(AutoScalingMetric autoScalingMetric) {
            this.autoScalingMetric(autoScalingMetric == null ? null : autoScalingMetric.toString());
            return this;
        }

        public final Double getMetricTarget() {
            return metricTarget;
        }

        public final void setMetricTarget(Double metricTarget) {
            this.metricTarget = metricTarget;
        }

        @Override
        public final Builder metricTarget(Double metricTarget) {
            this.metricTarget = metricTarget;
            return this;
        }

        public final Double getScaleInCooldownSeconds() {
            return scaleInCooldownSeconds;
        }

        public final void setScaleInCooldownSeconds(Double scaleInCooldownSeconds) {
            this.scaleInCooldownSeconds = scaleInCooldownSeconds;
        }

        @Override
        public final Builder scaleInCooldownSeconds(Double scaleInCooldownSeconds) {
            this.scaleInCooldownSeconds = scaleInCooldownSeconds;
            return this;
        }

        public final Double getScaleOutCooldownSeconds() {
            return scaleOutCooldownSeconds;
        }

        public final void setScaleOutCooldownSeconds(Double scaleOutCooldownSeconds) {
            this.scaleOutCooldownSeconds = scaleOutCooldownSeconds;
        }

        @Override
        public final Builder scaleOutCooldownSeconds(Double scaleOutCooldownSeconds) {
            this.scaleOutCooldownSeconds = scaleOutCooldownSeconds;
            return this;
        }

        @Override
        public AutoScalingConfiguration build() {
            return new AutoScalingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
