/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspace.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of DNS server name and server IP. This is used to set up Route-53 outbound resolvers.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomDNSServer implements SdkPojo, Serializable, ToCopyableBuilder<CustomDNSServer.Builder, CustomDNSServer> {
    private static final SdkField<String> CUSTOM_DNS_SERVER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customDNSServerName").getter(getter(CustomDNSServer::customDNSServerName))
            .setter(setter(Builder::customDNSServerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customDNSServerName").build())
            .build();

    private static final SdkField<String> CUSTOM_DNS_SERVER_IP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customDNSServerIP").getter(getter(CustomDNSServer::customDNSServerIP))
            .setter(setter(Builder::customDNSServerIP))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customDNSServerIP").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_DNS_SERVER_NAME_FIELD,
            CUSTOM_DNS_SERVER_IP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String customDNSServerName;

    private final String customDNSServerIP;

    private CustomDNSServer(BuilderImpl builder) {
        this.customDNSServerName = builder.customDNSServerName;
        this.customDNSServerIP = builder.customDNSServerIP;
    }

    /**
     * <p>
     * The name of the DNS server.
     * </p>
     * 
     * @return The name of the DNS server.
     */
    public final String customDNSServerName() {
        return customDNSServerName;
    }

    /**
     * <p>
     * The IP address of the DNS server.
     * </p>
     * 
     * @return The IP address of the DNS server.
     */
    public final String customDNSServerIP() {
        return customDNSServerIP;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(customDNSServerName());
        hashCode = 31 * hashCode + Objects.hashCode(customDNSServerIP());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomDNSServer)) {
            return false;
        }
        CustomDNSServer other = (CustomDNSServer) obj;
        return Objects.equals(customDNSServerName(), other.customDNSServerName())
                && Objects.equals(customDNSServerIP(), other.customDNSServerIP());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomDNSServer").add("CustomDNSServerName", customDNSServerName())
                .add("CustomDNSServerIP", customDNSServerIP()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "customDNSServerName":
            return Optional.ofNullable(clazz.cast(customDNSServerName()));
        case "customDNSServerIP":
            return Optional.ofNullable(clazz.cast(customDNSServerIP()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("customDNSServerName", CUSTOM_DNS_SERVER_NAME_FIELD);
        map.put("customDNSServerIP", CUSTOM_DNS_SERVER_IP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomDNSServer, T> g) {
        return obj -> g.apply((CustomDNSServer) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomDNSServer> {
        /**
         * <p>
         * The name of the DNS server.
         * </p>
         * 
         * @param customDNSServerName
         *        The name of the DNS server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customDNSServerName(String customDNSServerName);

        /**
         * <p>
         * The IP address of the DNS server.
         * </p>
         * 
         * @param customDNSServerIP
         *        The IP address of the DNS server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customDNSServerIP(String customDNSServerIP);
    }

    static final class BuilderImpl implements Builder {
        private String customDNSServerName;

        private String customDNSServerIP;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomDNSServer model) {
            customDNSServerName(model.customDNSServerName);
            customDNSServerIP(model.customDNSServerIP);
        }

        public final String getCustomDNSServerName() {
            return customDNSServerName;
        }

        public final void setCustomDNSServerName(String customDNSServerName) {
            this.customDNSServerName = customDNSServerName;
        }

        @Override
        public final Builder customDNSServerName(String customDNSServerName) {
            this.customDNSServerName = customDNSServerName;
            return this;
        }

        public final String getCustomDNSServerIP() {
            return customDNSServerIP;
        }

        public final void setCustomDNSServerIP(String customDNSServerIP) {
            this.customDNSServerIP = customDNSServerIP;
        }

        @Override
        public final Builder customDNSServerIP(String customDNSServerIP) {
            this.customDNSServerIP = customDNSServerIP;
            return this;
        }

        @Override
        public CustomDNSServer build() {
            return new CustomDNSServer(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
